/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.network.message;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.Validate;
import top.ribs.scguns.client.network.ClientPlayHandler;
import top.ribs.scguns.common.CustomGun;
import top.ribs.scguns.common.CustomGunLoader;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.NetworkGunManager;

public class S2CMessageUpdateGuns
extends PlayMessage<S2CMessageUpdateGuns> {
    private ImmutableMap<ResourceLocation, Gun> registeredGuns;
    private ImmutableMap<ResourceLocation, CustomGun> customGuns;

    public void encode(S2CMessageUpdateGuns message, FriendlyByteBuf buffer) {
        Validate.notNull((Object)((Object)NetworkGunManager.get()));
        Validate.notNull((Object)((Object)CustomGunLoader.get()));
        NetworkGunManager.get().writeRegisteredGuns(buffer);
        CustomGunLoader.get().writeCustomGuns(buffer);
    }

    public S2CMessageUpdateGuns decode(FriendlyByteBuf buffer) {
        S2CMessageUpdateGuns message = new S2CMessageUpdateGuns();
        message.registeredGuns = NetworkGunManager.readRegisteredGuns(buffer);
        message.customGuns = CustomGunLoader.readCustomGuns(buffer);
        return message;
    }

    public void handle(S2CMessageUpdateGuns message, MessageContext context) {
        context.execute(() -> ClientPlayHandler.handleUpdateGuns(message));
        context.setHandled(true);
    }

    public ImmutableMap<ResourceLocation, Gun> getRegisteredGuns() {
        return this.registeredGuns;
    }

    public ImmutableMap<ResourceLocation, CustomGun> getCustomGuns() {
        return this.customGuns;
    }
}

