/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.util;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitTargetTrackerHandler;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.item.exosuit.TargetTrackerModuleItem;

public class ExoSuitRecoilHelper {
    public static float getTotalRecoilAngleReduction(Player player) {
        float totalReduction = 0.0f;
        for (ItemStack armorStack : player.m_6168_()) {
            if (!(armorStack.m_41720_() instanceof ExoSuitItem)) continue;
            totalReduction += ExoSuitRecoilHelper.getRecoilAngleReductionFromPiece(armorStack);
        }
        return Math.min(totalReduction, 0.8f);
    }

    public static float getTotalRecoilKickReduction(Player player) {
        float totalReduction = 0.0f;
        for (ItemStack armorStack : player.m_6168_()) {
            if (!(armorStack.m_41720_() instanceof ExoSuitItem)) continue;
            totalReduction += ExoSuitRecoilHelper.getRecoilKickReductionFromPiece(armorStack);
        }
        return Math.min(totalReduction, 0.8f);
    }

    private static float getRecoilAngleReductionFromPiece(ItemStack armorStack) {
        float totalReduction = 0.0f;
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(armorStack, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null) continue;
            totalReduction += upgrade.getEffects().getRecoilAngleReduction();
        }
        return totalReduction;
    }

    private static float getRecoilKickReductionFromPiece(ItemStack armorStack) {
        float totalReduction = 0.0f;
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(armorStack, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null) continue;
            totalReduction += upgrade.getEffects().getRecoilKickReduction();
        }
        return totalReduction;
    }

    public static float getModifiedRecoilAngle(Player player, float baseRecoilAngle) {
        float reduction = ExoSuitRecoilHelper.getTotalRecoilAngleReduction(player);
        return baseRecoilAngle * (1.0f - reduction);
    }

    public static float getTotalSpreadReduction(Player player) {
        float totalReduction = 0.0f;
        for (ItemStack armorStack : player.m_6168_()) {
            if (!(armorStack.m_41720_() instanceof ExoSuitItem)) continue;
            float pieceReduction = ExoSuitRecoilHelper.getSpreadReductionFromPiece(armorStack, player);
            totalReduction += pieceReduction;
        }
        return Math.min(totalReduction, 0.8f);
    }

    private static float getSpreadReductionFromPiece(ItemStack armorStack, Player player) {
        float totalReduction = 0.0f;
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(armorStack, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null) continue;
            float spreadReduction = upgrade.getEffects().getSpreadReduction();
            if (upgradeItem.m_41720_() instanceof TargetTrackerModuleItem) {
                boolean isEnabled = ExoSuitTargetTrackerHandler.isTargetTrackerActive(player);
                if (!isEnabled) continue;
                totalReduction += spreadReduction;
                continue;
            }
            if (!(spreadReduction > 0.0f)) continue;
            totalReduction += spreadReduction;
        }
        return totalReduction;
    }

    public static float getModifiedSpread(Player player, float baseSpread) {
        float reduction = ExoSuitRecoilHelper.getTotalSpreadReduction(player);
        return baseSpread * (1.0f - reduction);
    }
}

