/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.util;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.interfaces.IGunModifier;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.attachment.IAttachment;
import top.ribs.scguns.item.attachment.impl.Attachment;
import top.ribs.scguns.util.ExoSuitRecoilHelper;
import top.ribs.scguns.util.GunEnchantmentHelper;

public class GunModifierHelper {
    private static final IGunModifier[] EMPTY = new IGunModifier[0];

    public static double getModifiedMouseSensitivity(ItemStack weapon, double baseSensitivity) {
        double sensitivity = baseSensitivity;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                sensitivity = modifier.modifyMouseSensitivity(sensitivity);
            }
        }
        return Math.max(sensitivity, 0.01);
    }

    public static IGunModifier[] getModifiers(ItemStack weapon, IAttachment.Type type) {
        Item item;
        ItemStack stack = Gun.getAttachment(type, weapon);
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof IAttachment) {
            IAttachment attachment = (IAttachment)item;
            return ((Attachment)attachment.getProperties()).getModifiers();
        }
        return EMPTY;
    }

    public static int getModifiedProjectileLife(ItemStack weapon, int life) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                life = modifier.modifyProjectileLife(life);
            }
        }
        return life;
    }

    public static double getModifiedProjectileGravity(ItemStack weapon, double gravity) {
        IGunModifier[] modifiers;
        int i;
        for (i = 0; i < IAttachment.Type.values().length; ++i) {
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                gravity = modifier.modifyProjectileGravity(gravity);
            }
        }
        for (i = 0; i < IAttachment.Type.values().length; ++i) {
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                gravity += modifier.additionalProjectileGravity();
            }
        }
        return gravity;
    }

    public static float getModifiedSpread(ItemStack weapon, float spread) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                spread = modifier.modifyProjectileSpread(spread);
            }
        }
        return spread;
    }

    public static float getModifiedSpread(Player player, ItemStack weapon, float spread) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                spread = modifier.modifyProjectileSpread(spread);
            }
        }
        spread = GunEnchantmentHelper.getHotBarrelSpread(player, weapon, spread);
        spread = ExoSuitRecoilHelper.getModifiedSpread(player, spread);
        return spread;
    }

    public static double getModifiedProjectileSpeed(ItemStack weapon, double speed) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                speed = modifier.modifyProjectileSpeed(speed);
            }
        }
        return speed;
    }

    public static float getFireSoundVolume(ItemStack weapon) {
        float volume = 1.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                volume = modifier.modifyFireSoundVolume(volume);
            }
        }
        return Mth.m_14036_((float)volume, (float)0.0f, (float)16.0f);
    }

    public static double getMuzzleFlashScale(ItemStack weapon, double scale) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                scale = modifier.modifyMuzzleFlashScale(scale);
            }
        }
        return scale;
    }

    public static float getRecoilModifier(ItemStack weapon) {
        float recoilReduction = 1.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                recoilReduction *= Mth.m_14036_((float)modifier.recoilModifier(), (float)0.0f, (float)1.0f);
            }
        }
        return 1.0f - recoilReduction;
    }

    public static float getRecoilModifier(Player player, ItemStack weapon) {
        float baseModifier = GunModifierHelper.getRecoilModifier(weapon);
        float enchantmentIncrease = GunEnchantmentHelper.getRecoilModifier(player, weapon) - 1.0f;
        return baseModifier + enchantmentIncrease;
    }

    public static float getKickReduction(ItemStack weapon) {
        float kickReduction = 1.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                kickReduction *= Mth.m_14036_((float)modifier.kickModifier(), (float)0.0f, (float)1.0f);
            }
        }
        return 1.0f - kickReduction;
    }

    public static float getKickReduction(Player player, ItemStack weapon) {
        float baseModifier = GunModifierHelper.getKickReduction(weapon);
        float enchantmentIncrease = GunEnchantmentHelper.getKickModifier(player, weapon) - 1.0f;
        return baseModifier + enchantmentIncrease;
    }

    public static boolean isSilencedFire(ItemStack weapon) {
        GunItem gunItem;
        Gun gun;
        Item item = weapon.m_41720_();
        if (item instanceof GunItem && (gun = (gunItem = (GunItem)item).getModifiedGun(weapon)).getGeneral().isSilenced()) {
            return true;
        }
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                if (!modifier.silencedFire()) continue;
                return true;
            }
        }
        return false;
    }

    public static double getModifiedFireSoundRadius(ItemStack weapon, double radius) {
        double minRadius = radius;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                double newRadius = modifier.modifyFireSoundRadius(radius);
                if (!(newRadius < minRadius)) continue;
                minRadius = newRadius;
            }
        }
        return Mth.m_14008_((double)minRadius, (double)0.0, (double)Double.MAX_VALUE);
    }

    public static float getAdditionalDamage(ItemStack weapon, boolean meleeOnly) {
        float additionalDamage = 0.0f;
        for (IAttachment.Type type : IAttachment.Type.values()) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, type)) {
                if (!meleeOnly && !modifier.isMeleeOnly()) continue;
                additionalDamage += modifier.additionalDamage();
            }
        }
        return additionalDamage;
    }

    public static float getModifiedProjectileDamage(ItemStack weapon, float damage) {
        float finalDamage = damage;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                if (!modifier.isMeleeOnly()) continue;
                finalDamage = modifier.modifyProjectileDamage(finalDamage);
            }
        }
        return finalDamage;
    }

    public static float getModifiedDamage(ItemStack weapon, Gun modifiedGun, float damage) {
        IGunModifier[] modifiers;
        int i;
        float finalDamage = damage;
        for (i = 0; i < IAttachment.Type.values().length; ++i) {
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                if (!modifier.isMeleeOnly()) continue;
                finalDamage = modifier.modifyProjectileDamage(finalDamage);
            }
        }
        for (i = 0; i < IAttachment.Type.values().length; ++i) {
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                if (!modifier.isMeleeOnly()) continue;
                finalDamage += modifier.additionalDamage();
            }
        }
        return finalDamage;
    }

    public static double getModifiedAimDownSightSpeed(ItemStack weapon, double speed) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                speed = modifier.modifyAimDownSightSpeed(speed);
            }
        }
        return Mth.m_14008_((double)speed, (double)0.01, (double)Double.MAX_VALUE);
    }

    public static int getModifiedRate(ItemStack weapon, int rate) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            IAttachment.Type type = IAttachment.Type.values()[i];
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, type)) {
                rate = modifier.modifyFireRate(rate);
            }
        }
        return Mth.m_14045_((int)rate, (int)0, (int)Integer.MAX_VALUE);
    }

    public static float getCriticalChance(ItemStack weapon) {
        float chance = 0.0f;
        Item item = weapon.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            chance += gunItem.getModifiedGun(weapon).getGeneral().getCriticalChance();
        }
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                chance += modifier.criticalChance();
            }
        }
        return Mth.m_14036_((float)(chance += GunEnchantmentHelper.getPuncturingChance(weapon)), (float)0.0f, (float)1.0f);
    }

    public static int getModifiedAmmoCapacity(ItemStack weapon, Gun modifiedGun) {
        int baseCapacity = modifiedGun.getReloads().getMaxAmmo();
        for (IGunModifier modifier : GunModifierHelper.getModifiers(weapon, IAttachment.Type.MAGAZINE)) {
            baseCapacity = modifier.modifyAmmoCapacity(baseCapacity);
        }
        return baseCapacity;
    }

    public static double getModifiedReloadSpeed(ItemStack weapon, double reloadSpeed) {
        for (IGunModifier modifier : GunModifierHelper.getModifiers(weapon, IAttachment.Type.MAGAZINE)) {
            reloadSpeed = modifier.modifyReloadSpeed(reloadSpeed);
        }
        return reloadSpeed;
    }

    public static double getModifiedDrawSpeed(ItemStack weapon, double speed) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                speed = modifier.modifyDrawSpeed(speed);
            }
        }
        return Mth.m_14008_((double)speed, (double)0.01, (double)Double.MAX_VALUE);
    }

    public static float getModifiedDamageFalloffStart(ItemStack weapon, float range) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                range = modifier.modifyDamageFalloffStart(range);
            }
        }
        return Math.max(range, 0.0f);
    }

    public static float getModifiedDamageFalloffEnd(ItemStack weapon, float range) {
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                range = modifier.modifyDamageFalloffEnd(range);
            }
        }
        return Math.max(range, 0.0f);
    }
}

