/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.util;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.ribs.scguns.common.Turret;
import top.ribs.scguns.common.TurretManager;

public class TurretTooltipHelper {
    public static void addTurretTooltip(ResourceLocation turretId, ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        Turret turret = TurretManager.getTurret(turretId);
        if (turret == null) {
            return;
        }
        Turret.Targeting targeting = turret.getTargeting();
        Turret.Combat combat = turret.getCombat();
        Turret.Ammunition ammunition = turret.getAmmunition();
        tooltip.add((Component)Component.m_237115_((String)"info.scguns.turret.range").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.format("%.1f", targeting.getRange())).m_130940_(ChatFormatting.WHITE)));
        double shotsPerSecond = 20.0 / (double)combat.getCooldown();
        tooltip.add((Component)Component.m_237115_((String)"info.scguns.turret.fire_rate").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.format("%.2f", shotsPerSecond)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237115_((String)"info.scguns.turret.shots_per_second").m_130940_(ChatFormatting.WHITE)));
        if (combat.getPelletCount() > 1) {
            tooltip.add((Component)Component.m_237115_((String)"info.scguns.turret.pellets").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(combat.getPelletCount())).m_130940_(ChatFormatting.WHITE)));
        }
        if (combat.getSpreadAngle() > 0.0f) {
            tooltip.add((Component)Component.m_237115_((String)"info.scguns.turret.spread").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.format("%.1f", Float.valueOf(combat.getSpreadAngle()))).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237115_((String)"info.scguns.turret.degrees").m_130940_(ChatFormatting.WHITE)));
        }
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"info.scguns.turret.accepted_ammo").m_130940_(ChatFormatting.GRAY));
            for (Turret.Ammunition.AmmoType ammoType : ammunition.getAcceptedAmmo()) {
                Item ammoItem = ammoType.getItem();
                if (ammoItem == null) continue;
                double damage = ammoType.getDamage();
                tooltip.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)ammoItem.m_5524_()).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237115_((String)"info.scguns.damage").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)(": " + String.format("%.1f", damage))).m_130940_(ChatFormatting.WHITE)));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"info.scguns.turret.shift_ammo").m_130940_(ChatFormatting.GRAY));
        }
    }
}

