/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import top.ribs.scguns.block.ChargedAmethystRelayBlock;
import top.ribs.scguns.init.ModBlockEntities;

public class ChargedAmethystRelayBlockEntity
extends BlockEntity {
    private NoteBlockInstrument tunedInstrument = NoteBlockInstrument.HARP;
    private boolean isActive = false;
    private int activationTimer = 0;
    private static final int ACTIVATION_DURATION = 20;

    public ChargedAmethystRelayBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CHARGED_AMETHYST_RELAY.get(), pos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ChargedAmethystRelayBlockEntity relay) {
        NoteBlockInstrument stateInstrument;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        if (relay.isActive && relay.activationTimer > 0) {
            --relay.activationTimer;
            if (relay.activationTimer <= 0) {
                relay.isActive = false;
                relay.m_6596_();
            }
        }
        if ((stateInstrument = (NoteBlockInstrument)state.m_61143_(ChargedAmethystRelayBlock.INSTRUMENT)) != relay.tunedInstrument) {
            relay.tunedInstrument = stateInstrument;
            relay.m_6596_();
        }
    }

    public void onInstrumentTuned(NoteBlockInstrument instrument) {
        this.tunedInstrument = instrument;
        this.m_6596_();
    }

    public void activateFromInstrument() {
        if (!this.isActive) {
            this.isActive = true;
            this.activationTimer = 20;
            assert (this.f_58857_ != null);
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_144243_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.m_6596_();
        }
    }

    public void deactivate() {
        if (this.isActive) {
            this.isActive = false;
            this.activationTimer = 0;
            this.m_6596_();
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tunedInstrument = NoteBlockInstrument.valueOf((String)tag.m_128461_("TunedInstrument"));
        this.isActive = tag.m_128471_("IsActive");
        this.activationTimer = tag.m_128451_("ActivationTimer");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("TunedInstrument", this.tunedInstrument.name());
        tag.m_128379_("IsActive", this.isActive);
        tag.m_128405_("ActivationTimer", this.activationTimer);
    }

    public boolean isActive() {
        return this.isActive;
    }
}

