/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.blockentity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.block.LightningBattery;
import top.ribs.scguns.client.screen.LightningBatteryMenu;
import top.ribs.scguns.client.screen.LightningBatteryRecipe;
import top.ribs.scguns.init.ModBlockEntities;
import top.ribs.scguns.item.AirCanisterItem;

public class LightningBatteryBlockEntity
extends BlockEntity
implements MenuProvider,
ICapabilityProvider {
    private static final int MAX_ENERGY = 32000;
    public final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            LightningBatteryBlockEntity.this.m_6596_();
            if (!LightningBatteryBlockEntity.this.f_58857_.m_5776_()) {
                LightningBatteryBlockEntity.this.f_58857_.m_7260_(LightningBatteryBlockEntity.this.m_58899_(), LightningBatteryBlockEntity.this.m_58900_(), LightningBatteryBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final EnergyStorage energyStorage = new EnergyStorage(32000){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = super.receiveEnergy(maxReceive, simulate);
            if (!simulate && received > 0) {
                LightningBatteryBlockEntity.this.m_6596_();
                LightningBatteryBlockEntity.this.sync();
                LightningBatteryBlockEntity.this.updateBlockState();
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = super.extractEnergy(maxExtract, simulate);
            if (!simulate && extracted > 0) {
                LightningBatteryBlockEntity.this.m_6596_();
                LightningBatteryBlockEntity.this.sync();
                LightningBatteryBlockEntity.this.updateBlockState();
            }
            return extracted;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    };
    private final LazyOptional<IEnergyStorage> internalEnergy = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<IEnergyStorage> externalEnergy = LazyOptional.of(() -> new EnergyStorage(this.energyStorage.getMaxEnergyStored()){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return LightningBatteryBlockEntity.this.energyStorage.receiveEnergy(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return LightningBatteryBlockEntity.this.energyStorage.extractEnergy(maxExtract, simulate);
        }

        public int getEnergyStored() {
            return LightningBatteryBlockEntity.this.energyStorage.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return LightningBatteryBlockEntity.this.energyStorage.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    });
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    private int processingTime;
    private int processingTimeTotal;

    public LightningBatteryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.LIGHTNING_BATTERY.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.lightning_battery");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new LightningBatteryMenu(id, inv, this, new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> LightningBatteryBlockEntity.this.processingTime;
                    case 1 -> LightningBatteryBlockEntity.this.processingTimeTotal;
                    case 2 -> LightningBatteryBlockEntity.this.energyStorage.getEnergyStored();
                    case 3 -> LightningBatteryBlockEntity.this.energyStorage.getMaxEnergyStored();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        LightningBatteryBlockEntity.this.processingTime = value;
                        break;
                    }
                    case 1: {
                        LightningBatteryBlockEntity.this.processingTimeTotal = value;
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        });
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (side == Direction.DOWN) {
                return LazyOptional.of(() -> new OutputItemHandler(this.itemHandler)).cast();
            }
            return LazyOptional.of(() -> new InputItemHandler(this.itemHandler)).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            if (side == null) {
                return this.internalEnergy.cast();
            }
            return this.externalEnergy.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("Energy", this.energyStorage.serializeNBT());
        tag.m_128405_("ProcessingTime", this.processingTime);
        tag.m_128405_("ProcessingTimeTotal", this.processingTimeTotal);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.energyStorage.deserializeNBT(tag.m_128423_("Energy"));
        this.processingTime = tag.m_128451_("ProcessingTime");
        this.processingTimeTotal = tag.m_128451_("ProcessingTimeTotal");
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    private void sync() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergy() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public void setEnergyStored(int i) {
        this.energyStorage.receiveEnergy(i, false);
        this.updateBlockState();
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        boolean wasProcessing = this.isProcessing();
        ItemStack inputStack = this.itemHandler.getStackInSlot(0);
        ItemStack outputStack = this.itemHandler.getStackInSlot(1);
        if (!inputStack.m_41619_()) {
            LazyOptional itemEnergyCap = inputStack.getCapability(ForgeCapabilities.ENERGY);
            if (itemEnergyCap.isPresent()) {
                itemEnergyCap.ifPresent(itemEnergy -> {
                    if (inputStack.m_41720_() instanceof AirCanisterItem) {
                        this.chargeAirCanister(inputStack, outputStack);
                    } else {
                        int energyToTransfer = Math.min(this.energyStorage.extractEnergy(100, true), itemEnergy.receiveEnergy(100, true));
                        if (energyToTransfer > 0) {
                            this.energyStorage.extractEnergy(energyToTransfer, false);
                            itemEnergy.receiveEnergy(energyToTransfer, false);
                            this.m_6596_();
                            this.sync();
                        }
                        if (itemEnergy.getEnergyStored() >= itemEnergy.getMaxEnergyStored() && outputStack.m_41619_()) {
                            this.itemHandler.setStackInSlot(1, inputStack.m_41777_());
                            this.itemHandler.extractItem(0, 1, false);
                        }
                    }
                });
            } else {
                LightningBatteryRecipe recipe = this.getRecipe(inputStack);
                if (recipe != null) {
                    ItemStack recipeOutput = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
                    if (outputStack.m_41619_() || outputStack.m_150930_(recipeOutput.m_41720_()) && outputStack.m_41613_() + recipeOutput.m_41613_() <= outputStack.m_41741_()) {
                        if (this.hasEnoughEnergy(recipe.getEnergyUse())) {
                            ++this.processingTime;
                            this.processingTimeTotal = recipe.getProcessingTime();
                            if (this.processingTime >= this.processingTimeTotal) {
                                this.consumeEnergy(recipe.getEnergyUse());
                                inputStack.m_41774_(1);
                                if (outputStack.m_41619_()) {
                                    this.itemHandler.setStackInSlot(1, recipeOutput.m_41777_());
                                } else {
                                    outputStack.m_41769_(recipeOutput.m_41613_());
                                }
                                this.processingTime = 0;
                            }
                        } else {
                            this.processingTime = 0;
                        }
                    } else {
                        this.processingTime = 0;
                    }
                } else {
                    this.processingTime = 0;
                }
            }
        } else {
            this.processingTime = 0;
        }
        if (wasProcessing != this.isProcessing()) {
            this.m_6596_();
            this.sync();
        } else {
            this.m_6596_();
        }
        this.updateBlockState();
        for (Direction direction : Direction.values()) {
            BlockEntity adjacentEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (adjacentEntity == null) continue;
            adjacentEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(handler -> {
                if (handler.canReceive()) {
                    int extracted = this.energyStorage.extractEnergy(50, true);
                    int accepted = handler.receiveEnergy(extracted, false);
                    this.energyStorage.extractEnergy(accepted, false);
                    this.m_6596_();
                    this.sync();
                }
            });
        }
    }

    private void chargeAirCanister(ItemStack inputStack, ItemStack outputStack) {
        LazyOptional airStorage = inputStack.getCapability(ForgeCapabilities.ENERGY);
        airStorage.ifPresent(airCap -> {
            int energyCostPerAir = 5;
            int airPerTick = 5;
            int energyCostPerTick = airPerTick * energyCostPerAir;
            if (this.energyStorage.getEnergyStored() >= energyCostPerTick && airCap.getEnergyStored() < airCap.getMaxEnergyStored()) {
                int airAdded;
                int maxAirToAdd = Math.min(airPerTick, airCap.getMaxEnergyStored() - airCap.getEnergyStored());
                int actualEnergyCost = maxAirToAdd * energyCostPerAir;
                if (this.energyStorage.getEnergyStored() >= actualEnergyCost && (airAdded = airCap.receiveEnergy(maxAirToAdd, false)) > 0) {
                    int actualCost = airAdded * energyCostPerAir;
                    this.energyStorage.extractEnergy(actualCost, false);
                    this.m_6596_();
                    this.sync();
                }
            }
            if (airCap.getEnergyStored() >= airCap.getMaxEnergyStored() && outputStack.m_41619_()) {
                this.itemHandler.setStackInSlot(1, inputStack.m_41777_());
                this.itemHandler.extractItem(0, 1, false);
            }
        });
    }

    private LightningBatteryRecipe getRecipe(ItemStack inputStack) {
        if (this.f_58857_ == null) {
            return null;
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)LightningBatteryRecipe.Type.INSTANCE, (Container)new SimpleContainer(new ItemStack[]{inputStack}), this.f_58857_).orElse(null);
    }

    public boolean isProcessing() {
        return this.processingTime > 0 && this.processingTime < this.processingTimeTotal;
    }

    private boolean hasEnoughEnergy(int energyUse) {
        return this.energyStorage.getEnergyStored() >= energyUse;
    }

    private void consumeEnergy(int amount) {
        this.energyStorage.extractEnergy(amount, false);
    }

    private void updateBlockState() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            int energyStored = this.getEnergy();
            boolean isCharged = energyStored > 0;
            LightningBattery.ChargeLevel chargeLevel = LightningBatteryBlockEntity.calculateChargeLevel(energyStored);
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)((BlockState)state.m_61124_((Property)LightningBattery.CHARGED, (Comparable)Boolean.valueOf(isCharged))).m_61124_(LightningBattery.CHARGE_LEVEL, (Comparable)((Object)chargeLevel)), 3);
        }
    }

    public static LightningBattery.ChargeLevel calculateChargeLevel(int energyStored) {
        if (energyStored > 24000) {
            return LightningBattery.ChargeLevel.HIGH;
        }
        if (energyStored > 12000) {
            return LightningBattery.ChargeLevel.MID;
        }
        if (energyStored > 0) {
            return LightningBattery.ChargeLevel.LOW;
        }
        return LightningBattery.ChargeLevel.NONE;
    }

    private static class InputItemHandler
    implements IItemHandlerModifiable {
        private final ItemStackHandler itemHandler;

        public InputItemHandler(ItemStackHandler itemHandler) {
            this.itemHandler = itemHandler;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.itemHandler.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.itemHandler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.itemHandler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 0) {
                return this.itemHandler.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot == 0;
        }
    }

    private static class OutputItemHandler
    implements IItemHandlerModifiable {
        private final ItemStackHandler itemHandler;

        public OutputItemHandler(ItemStackHandler itemHandler) {
            this.itemHandler = itemHandler;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.itemHandler.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.itemHandler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.itemHandler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 1) {
                return this.itemHandler.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    }
}

