/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.handler;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.joml.Matrix4f;
import top.ribs.scguns.Config;
import top.ribs.scguns.client.GunModel;
import top.ribs.scguns.client.GunRenderType;
import top.ribs.scguns.client.SwayType;
import top.ribs.scguns.client.handler.AimingHandler;
import top.ribs.scguns.client.handler.BeamHandler;
import top.ribs.scguns.client.handler.DualWieldShotTracker;
import top.ribs.scguns.client.handler.MeleeAttackHandler;
import top.ribs.scguns.client.handler.RecoilHandler;
import top.ribs.scguns.client.handler.ReloadHandler;
import top.ribs.scguns.client.render.gun.IOverrideModel;
import top.ribs.scguns.client.render.gun.ModelOverrides;
import top.ribs.scguns.client.util.PropertyHelper;
import top.ribs.scguns.client.util.RenderUtil;
import top.ribs.scguns.common.GripType;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.ReloadType;
import top.ribs.scguns.common.properties.SightAnimation;
import top.ribs.scguns.event.GunFireEvent;
import top.ribs.scguns.init.ModItems;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.item.GrenadeItem;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.animated.AnimatedDualWieldGunItem;
import top.ribs.scguns.item.animated.AnimatedGunItem;
import top.ribs.scguns.item.attachment.IAttachment;
import top.ribs.scguns.item.attachment.impl.Scope;
import top.ribs.scguns.util.GunEnchantmentHelper;
import top.ribs.scguns.util.GunModifierHelper;

public class GunRenderingHandler {
    protected static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private final Map<Integer, Integer> entityShotCount = new HashMap<Integer, Integer>();
    public static final Map<Integer, Vec3> entityIdToFlashPosition = new HashMap<Integer, Vec3>();
    public static final Map<Integer, Boolean> entityIdToUseEnchantedTexture = new HashMap<Integer, Boolean>();
    private static GunRenderingHandler instance;
    private final Random random = new Random();
    public static final Set<Integer> entityIdForMuzzleFlash;
    private final Set<Integer> entityIdForDrawnMuzzleFlash = new HashSet<Integer>();
    public static final Map<Integer, Float> entityIdToRandomValue;
    private int sprintTransition;
    private int prevSprintTransition;
    private int sprintCooldown;
    private float sprintIntensity;
    private float banzaiProgress;
    private float banzaiImpactProgress;
    private float prevBanzaiImpactProgress;
    private float sprintToBanzaiProgress;
    private float prevSprintToBanzaiProgress;
    private float offhandTranslate;
    private float prevOffhandTranslate;
    private Field equippedProgressMainHandField;
    private Field prevEquippedProgressMainHandField;
    private float immersiveRoll;
    private float prevImmersiveRoll;
    private float fallSway;
    private float prevFallSway;
    private float meleeProgress;
    private float prevMeleeProgress;
    private boolean isMeleeAttacking;
    private long meleeStartTime;
    public static final float MELEE_DURATION = 400.0f;
    public float thirdPersonMeleeProgress;
    public float prevThirdPersonMeleeProgress;
    private boolean isThirdPersonMeleeAttacking;
    private long thirdPersonMeleeStartTime;
    public static final float THIRD_PERSON_MELEE_DURATION = 400.0f;
    private static final long PARTICLE_COOLDOWN_MS = 100L;
    private long lastParticleSpawnTime = 0L;
    private float thirdPersonMeleeStartTick = -1.0f;
    private static final float THIRD_PERSON_MELEE_TICKS = 8.0f;
    @Nullable
    private ItemStack renderingWeapon;

    public static GunRenderingHandler get() {
        if (instance == null) {
            instance = new GunRenderingHandler();
        }
        return instance;
    }

    private GunRenderingHandler() {
    }

    @Nullable
    public ItemStack getRenderingWeapon() {
        return this.renderingWeapon;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.updateState();
        this.handleClientTick();
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        this.handleRenderTick();
    }

    public void updateDualWieldShotCount(int entityId, int shotCount) {
        this.entityShotCount.put(entityId, shotCount);
    }

    private void updateState() {
        this.updateSprinting();
        this.updateMuzzleFlash();
        this.updateOffhandTranslate();
        this.updateImmersiveCamera();
    }

    private void handleClientTick() {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91302_()) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (heldItem.m_41619_()) {
            return;
        }
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            if (player.m_6117_() && player.m_7655_() == InteractionHand.MAIN_HAND && heldItem.m_41720_() instanceof GrenadeItem) {
                return;
            }
            this.renderCooldownIndicator(mc, (Player)player, heldItem);
        }
        this.updateMelee();
    }

    private void handleRenderTick() {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.m_91302_()) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null || Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return;
        }
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (heldItem.m_41619_() || player.m_6117_() && player.m_7655_() == InteractionHand.MAIN_HAND && heldItem.m_41720_() instanceof GrenadeItem && !((GrenadeItem)heldItem.m_41720_()).canCook()) {
            return;
        }
        if (heldItem.m_41720_() instanceof GunItem) {
            this.renderCooldownIndicator(mc, (Player)player, heldItem);
        }
    }

    private void renderCooldownIndicator(Minecraft mc, Player player, ItemStack heldItem) {
        float coolDown;
        Gun gun;
        if (((Boolean)Config.CLIENT.display.cooldownIndicator.get()).booleanValue() && !(gun = ((GunItem)heldItem.m_41720_()).getGun()).getGeneral().isAuto() && (coolDown = player.m_36335_().m_41521_(heldItem.m_41720_(), mc.m_91296_())) > 0.0f) {
            float scale = 3.0f;
            Window window = mc.m_91268_();
            int i = (int)((float)(window.m_85446_() / 2 - 7 - 60) / scale);
            int j = (int)Math.ceil(((double)window.m_85445_() / 2.0 - (double)(8.0f * scale)) / (double)scale);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_ICONS_LOCATION);
            PoseStack stack = new PoseStack();
            stack.m_85841_(scale, scale, scale);
            GuiGraphics guiGraphics = new GuiGraphics(mc, mc.m_91269_().m_110104_());
            int progress = (int)Math.ceil(((double)coolDown + 0.05) * 17.0) - 1;
            guiGraphics.m_280163_(GUI_ICONS_LOCATION, j, i, 36.0f, 94.0f, 16, 4, 256, 256);
            guiGraphics.m_280163_(GUI_ICONS_LOCATION, j, i, 52.0f, 94.0f, progress, 4, 256, 256);
            RenderSystem.disableBlend();
        }
    }

    private void updateSprinting() {
        this.prevSprintTransition = this.sprintTransition;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91074_.m_20142_() && !((Boolean)ModSyncedDataKeys.SHOOTING.getValue((Entity)mc.f_91074_)).booleanValue() && !((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)mc.f_91074_)).booleanValue() && !AimingHandler.get().isAiming() && this.sprintCooldown == 0) {
            if (this.sprintTransition < 5) {
                ++this.sprintTransition;
            }
        } else if (this.sprintTransition > 0) {
            --this.sprintTransition;
        }
        if (this.sprintCooldown > 0) {
            --this.sprintCooldown;
        }
    }

    public void updateMuzzleFlash() {
        entityIdForMuzzleFlash.removeAll(this.entityIdForDrawnMuzzleFlash);
        entityIdToRandomValue.keySet().removeAll(this.entityIdForDrawnMuzzleFlash);
        entityIdToFlashPosition.keySet().removeAll(this.entityIdForDrawnMuzzleFlash);
        entityIdToUseEnchantedTexture.keySet().removeAll(this.entityIdForDrawnMuzzleFlash);
        this.entityIdForDrawnMuzzleFlash.clear();
        this.entityIdForDrawnMuzzleFlash.addAll(entityIdForMuzzleFlash);
    }

    private void updateOffhandTranslate() {
        this.prevOffhandTranslate = this.offhandTranslate;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        boolean down = false;
        ItemStack heldItem = mc.f_91074_.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem) {
            Gun modifiedGun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
            GripType gripType = modifiedGun.getGeneral().getGripType(heldItem);
            down = gripType == GripType.ONE_HANDED ? (Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)mc.f_91074_) : !gripType.heldAnimation().canRenderOffhandItem() || (Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)mc.f_91074_) != false;
        }
        float direction = down ? -0.6f : 0.6f;
        this.offhandTranslate = Mth.m_14036_((float)(this.offhandTranslate + direction), (float)-1.0f, (float)1.0f);
    }

    private void updateImmersiveCamera() {
        this.prevImmersiveRoll = this.immersiveRoll;
        this.prevFallSway = this.fallSway;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ItemStack heldItem = mc.f_91074_.m_21205_();
        boolean isGun = heldItem.m_41720_() instanceof GunItem;
        if (((Boolean)Config.CLIENT.display.restrictCameraRollToWeapons.get()).booleanValue() && !isGun) {
            this.immersiveRoll = 0.0f;
            return;
        }
        float targetAngle = mc.f_91074_.f_108618_.f_108566_;
        float speed = mc.f_91074_.f_108618_.f_108566_ != 0.0f ? 0.1f : 0.15f;
        this.immersiveRoll = Mth.m_14179_((float)speed, (float)this.immersiveRoll, (float)targetAngle);
        float deltaY = (float)Mth.m_14008_((double)(mc.f_91074_.f_19855_ - mc.f_91074_.m_20186_()), (double)-1.0, (double)1.0);
        deltaY *= (float)(1.0 - AimingHandler.get().getNormalisedAdsProgress());
        this.fallSway = Mth.m_14121_((float)this.fallSway, (float)((deltaY *= (float)(1.0 - (double)(Mth.m_14154_((float)mc.f_91074_.m_146909_()) / 90.0f))) * 60.0f * ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue()), (float)10.0f);
        float intensity = mc.f_91074_.m_20142_() ? 0.75f : 1.0f;
        this.sprintIntensity = Mth.m_14121_((float)this.sprintIntensity, (float)intensity, (float)0.1f);
    }

    private void updateMelee() {
        this.updateCustomMeleeAnimation();
        this.prevSprintToBanzaiProgress = this.sprintToBanzaiProgress;
        this.prevBanzaiImpactProgress = this.banzaiImpactProgress;
        if (MeleeAttackHandler.isBanzaiActive()) {
            this.banzaiProgress = Mth.m_14036_((float)(this.banzaiProgress + 0.3f), (float)0.0f, (float)1.0f);
            this.sprintToBanzaiProgress = Mth.m_14036_((float)(this.sprintToBanzaiProgress + 0.2f), (float)0.0f, (float)1.0f);
        } else {
            this.banzaiProgress = Mth.m_14036_((float)(this.banzaiProgress - 0.3f), (float)0.0f, (float)1.0f);
            this.sprintToBanzaiProgress = Mth.m_14036_((float)(this.sprintToBanzaiProgress - 0.2f), (float)0.0f, (float)1.0f);
        }
        long currentTime = System.currentTimeMillis();
        if (this.isMeleeAttacking) {
            long elapsed = currentTime - this.meleeStartTime;
            this.prevMeleeProgress = this.meleeProgress;
            this.meleeProgress = Math.min((float)elapsed / 400.0f, 1.0f);
            if (this.meleeProgress >= 1.0f) {
                this.isMeleeAttacking = false;
                this.meleeProgress = 0.0f;
                this.prevMeleeProgress = 0.0f;
                ModSyncedDataKeys.MELEE.setValue((Entity)Minecraft.m_91087_().f_91074_, (Object)false);
            }
        } else {
            this.meleeProgress = 0.0f;
            this.prevMeleeProgress = 0.0f;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            float currentTick = (float)mc.f_91074_.f_19797_ + mc.m_91296_();
            if (this.isThirdPersonMeleeAttacking) {
                if (this.thirdPersonMeleeStartTick < 0.0f || currentTick < this.thirdPersonMeleeStartTick) {
                    this.thirdPersonMeleeStartTick = currentTick;
                }
                float elapsedTicks = currentTick - this.thirdPersonMeleeStartTick;
                this.prevThirdPersonMeleeProgress = this.thirdPersonMeleeProgress;
                this.thirdPersonMeleeProgress = Math.min(elapsedTicks / 8.0f, 1.0f);
                if (this.thirdPersonMeleeProgress >= 1.0f) {
                    this.isThirdPersonMeleeAttacking = false;
                    this.thirdPersonMeleeProgress = 0.0f;
                    this.prevThirdPersonMeleeProgress = 0.0f;
                    this.thirdPersonMeleeStartTick = -1.0f;
                    ModSyncedDataKeys.MELEE.setValue((Entity)mc.f_91074_, (Object)false);
                }
            } else {
                this.thirdPersonMeleeProgress = 0.0f;
                this.prevThirdPersonMeleeProgress = 0.0f;
                this.thirdPersonMeleeStartTick = -1.0f;
            }
        }
        if (this.banzaiImpactProgress > 0.0f) {
            this.banzaiImpactProgress = Mth.m_14036_((float)(this.banzaiImpactProgress - 0.1f), (float)0.0f, (float)1.0f);
        }
    }

    private void applySprintingTransforms(Gun modifiedGun, ItemStack stack, HumanoidArm hand, PoseStack poseStack, float partialTicks) {
        GripType gripType = modifiedGun.determineGripType(stack);
        float leftHanded = hand == HumanoidArm.LEFT ? -1.0f : 1.0f;
        float transition = ((float)this.prevSprintTransition + (float)(this.sprintTransition - this.prevSprintTransition) * partialTicks) / 5.0f;
        transition = (float)Math.sin((double)transition * Math.PI / 2.0);
        float sprintToBanzai = Mth.m_14179_((float)partialTicks, (float)this.prevSprintToBanzaiProgress, (float)this.sprintToBanzaiProgress);
        transition *= 1.0f - sprintToBanzai;
        double adsProgress = AimingHandler.get().getNormalisedAdsProgress();
        transition *= (float)(1.0 - adsProgress);
        if (((Boolean)Config.CLIENT.display.sprintAnimation.get()).booleanValue() && gripType.heldAnimation().canApplySprintingAnimation() && transition > 0.001f) {
            if (!(stack.m_41720_() instanceof AnimatedGunItem)) {
                poseStack.m_85837_(-0.25 * (double)leftHanded * (double)transition, -0.1 * (double)transition, 0.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f * leftHanded * transition));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-25.0f * transition));
            } else {
                poseStack.m_85837_(-0.25 * (double)leftHanded * (double)transition, -0.1 * (double)transition, 0.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f * leftHanded * transition));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-25.0f * transition));
            }
        }
    }

    private void applyBanzaiTransforms(PoseStack poseStack, float partialTicks) {
        float impactProgress;
        float sprintToBanzai = Mth.m_14179_((float)partialTicks, (float)this.prevSprintToBanzaiProgress, (float)this.sprintToBanzaiProgress);
        if (sprintToBanzai > 0.0f) {
            poseStack.m_85837_(0.0, -0.1 * (double)sprintToBanzai, 0.2 * (double)sprintToBanzai);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(10.0f * sprintToBanzai));
        }
        if ((impactProgress = Mth.m_14179_((float)partialTicks, (float)this.prevBanzaiImpactProgress, (float)this.banzaiImpactProgress)) > 0.0f) {
            poseStack.m_85837_(0.0, 0.0, 0.1 * (double)impactProgress);
        }
    }

    public void triggerBanzaiImpact() {
        this.banzaiImpactProgress = 1.0f;
    }

    public void startBayonetStabAnimation() {
        this.isMeleeAttacking = true;
        this.meleeStartTime = System.currentTimeMillis();
        this.meleeProgress = 0.0f;
        this.prevMeleeProgress = 0.0f;
        ModSyncedDataKeys.MELEE.setValue((Entity)Minecraft.m_91087_().f_91074_, (Object)true);
    }

    public void startThirdPersonMeleeAnimation() {
        this.isThirdPersonMeleeAttacking = true;
        this.thirdPersonMeleeStartTick = -1.0f;
        this.thirdPersonMeleeProgress = 0.0f;
        this.prevThirdPersonMeleeProgress = 0.0f;
        ModSyncedDataKeys.MELEE.setValue((Entity)Minecraft.m_91087_().f_91074_, (Object)true);
    }

    public boolean isThirdPersonMeleeAttacking() {
        return this.isThirdPersonMeleeAttacking;
    }

    public void startMeleeAnimation(ItemStack heldItem) {
        long currentTime = System.currentTimeMillis();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            assert (player != null);
            if (MeleeAttackHandler.isMeleeOnCooldown((Player)player, heldItem)) {
                return;
            }
            MeleeAttackHandler.setMeleeCooldown((Player)player, heldItem, gunItem);
            Gun modifiedGun = gunItem.getModifiedGun(heldItem);
            if (modifiedGun.getGeneral().usesCustomMeleeAnimation() && heldItem.m_41720_() instanceof AnimatedGunItem) {
                CompoundTag tag = heldItem.m_41784_();
                tag.m_128379_("scguns:IsMelee", true);
                tag.m_128356_("MeleeStartTime", currentTime);
                ModSyncedDataKeys.MELEE.setValue((Entity)player, (Object)true);
                return;
            }
        }
        if ((float)(currentTime - this.meleeStartTime) >= 400.0f) {
            this.isMeleeAttacking = true;
            this.meleeStartTime = currentTime;
            this.meleeProgress = 0.0f;
            this.prevMeleeProgress = 0.0f;
            ModSyncedDataKeys.MELEE.setValue((Entity)player, (Object)true);
        }
    }

    private void updateCustomMeleeAnimation() {
        long meleeStartTime;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        Gun gun = gunItem.getModifiedGun(heldItem);
        if (!gun.getGeneral().usesCustomMeleeAnimation()) {
            return;
        }
        if (!(heldItem.m_41720_() instanceof AnimatedGunItem)) {
            return;
        }
        CompoundTag tag = heldItem.m_41784_();
        if (!tag.m_128471_("scguns:IsMelee")) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if ((float)(currentTime - (meleeStartTime = tag.m_128454_("MeleeStartTime"))) >= 400.0f) {
            tag.m_128473_("scguns:IsMelee");
            tag.m_128473_("MeleeStartTime");
            ModSyncedDataKeys.MELEE.setValue((Entity)player, (Object)false);
        }
    }

    private void applyMeleeTransforms(PoseStack poseStack, float partialTicks) {
        if (this.isMeleeAttacking) {
            float progress = Mth.m_14179_((float)partialTicks, (float)this.prevMeleeProgress, (float)this.meleeProgress);
            assert (Minecraft.m_91087_().f_91074_ != null);
            ItemStack heldItem = Minecraft.m_91087_().f_91074_.m_21205_();
            Item item = heldItem.m_41720_();
            if (item instanceof GunItem) {
                boolean isBayonetEquipped;
                GunItem gunItem = (GunItem)item;
                Gun gun = gunItem.getModifiedGun(heldItem);
                if (gun.getGeneral().usesCustomMeleeAnimation() && heldItem.m_41720_() instanceof AnimatedGunItem) {
                    return;
                }
                if (((Boolean)Config.CLIENT.display.cinematicGunEffects.get()).booleanValue() && gun.getGeneral().hasCameraShake()) {
                    this.addCameraShake(gun, 0.5f * (1.0f - progress), 0);
                }
                if (isBayonetEquipped = gunItem.hasBayonet(heldItem)) {
                    if (progress < 0.3f) {
                        float stabProgress = progress / 0.3f;
                        poseStack.m_85837_(0.0, 0.0, -0.35 * (double)stabProgress);
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(10.0f * stabProgress));
                        if (((Boolean)Config.CLIENT.display.cinematicGunEffects.get()).booleanValue() && gun.getGeneral().hasCameraShake()) {
                            this.addCameraShake(gun, 0.3f * stabProgress, 3);
                        }
                    } else {
                        float returnProgress = (progress - 0.3f) / 0.7f;
                        poseStack.m_85837_(0.0, 0.0, 0.35 * (double)(returnProgress - 1.0f));
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(10.0f * (1.0f - returnProgress)));
                        if (((Boolean)Config.CLIENT.display.cinematicGunEffects.get()).booleanValue() && gun.getGeneral().hasCameraShake()) {
                            this.addCameraShake(gun, 0.1f * (1.0f - returnProgress), 2);
                        }
                    }
                } else if (progress < 0.33f) {
                    float raiseProgress = progress / 0.33f;
                    poseStack.m_85837_(0.0, 0.35 * (double)raiseProgress, 0.0);
                    poseStack.m_85837_(0.0, 0.0, 0.1 * (double)raiseProgress);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(35.0f * raiseProgress));
                } else if (progress < 0.66f) {
                    float swingProgress = (progress - 0.33f) / 0.33f;
                    poseStack.m_85837_(0.0, 0.35 - 0.7 * (double)swingProgress, 0.0);
                    poseStack.m_85837_(0.0, 0.1 - 0.2 * (double)swingProgress, 0.0);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(35.0f - 70.0f * swingProgress));
                } else {
                    float returnProgress = (progress - 0.66f) / 0.34f;
                    poseStack.m_85837_(0.0, -0.35 * (double)(1.0f - returnProgress), 0.0);
                    poseStack.m_85837_(0.0, 0.0, -0.1 * (double)(1.0f - returnProgress));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-35.0f * (1.0f - returnProgress)));
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderHandEvent event) {
        Item player;
        PoseStack poseStack = event.getPoseStack();
        boolean right = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? event.getHand() == InteractionHand.MAIN_HAND : event.getHand() == InteractionHand.OFF_HAND;
        HumanoidArm hand = right ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
        ItemStack heldItem = event.getItemStack();
        if (event.getHand() == InteractionHand.OFF_HAND) {
            Gun modifiedGun;
            GripType gripType;
            if (heldItem.m_41720_() instanceof GunItem) {
                event.setCanceled(true);
                return;
            }
            float offhand = 1.0f - Mth.m_14179_((float)event.getPartialTick(), (float)this.prevOffhandTranslate, (float)this.offhandTranslate);
            poseStack.m_252880_(0.0f, offhand * -0.6f, 0.0f);
            player = Minecraft.m_91087_().f_91074_;
            if (player != null && player.m_21205_().m_41720_() instanceof GunItem && (gripType = (modifiedGun = ((GunItem)player.m_21205_().m_41720_()).getModifiedGun(player.m_21205_())).getGeneral().getGripType(player.m_21205_())) != GripType.ONE_HANDED && !gripType.heldAnimation().canRenderOffhandItem()) {
                return;
            }
            poseStack.m_85837_(0.0, -1.0 * AimingHandler.get().getNormalisedAdsProgress(), 0.0);
        }
        if (!((player = heldItem.m_41720_()) instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)player;
        event.setCanceled(true);
        ItemStack overrideModel = ItemStack.f_41583_;
        if (heldItem.m_41783_() != null && heldItem.m_41783_().m_128425_("Model", 10)) {
            overrideModel = ItemStack.m_41712_((CompoundTag)heldItem.m_41783_().m_128469_("Model"));
        }
        LocalPlayer player2 = Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(overrideModel.m_41619_() ? heldItem : overrideModel, player2.m_9236_(), (LivingEntity)player2, 0);
        float scaleX = model.m_7442_().f_111790_.f_111757_.x();
        float scaleY = model.m_7442_().f_111790_.f_111757_.y();
        float scaleZ = model.m_7442_().f_111790_.f_111757_.z();
        float translateX = model.m_7442_().f_111790_.f_111756_.x();
        float translateY = model.m_7442_().f_111790_.f_111756_.y();
        float translateZ = model.m_7442_().f_111790_.f_111756_.z();
        poseStack.m_85836_();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (AimingHandler.get().getNormalisedAdsProgress() > 0.0 && modifiedGun.canAimDownSight() && event.getHand() == InteractionHand.MAIN_HAND) {
            double xOffset = translateX;
            double yOffset = translateY;
            double zOffset = translateZ;
            xOffset -= 0.5 * (double)scaleX;
            yOffset -= 0.5 * (double)scaleY;
            zOffset -= 0.5 * (double)scaleZ;
            Vec3 gunOrigin = PropertyHelper.getModelOrigin(heldItem, PropertyHelper.GUN_DEFAULT_ORIGIN);
            xOffset += gunOrigin.f_82479_ * 0.0625 * (double)scaleX;
            yOffset += gunOrigin.f_82480_ * 0.0625 * (double)scaleY;
            zOffset += gunOrigin.f_82481_ * 0.0625 * (double)scaleZ;
            Scope scope = Gun.getScope(heldItem);
            if (modifiedGun.canAttachType(IAttachment.Type.SCOPE) && scope != null) {
                Vec3 scopePosition = PropertyHelper.getAttachmentPosition(heldItem, modifiedGun, IAttachment.Type.SCOPE).m_82546_(gunOrigin);
                xOffset += scopePosition.f_82479_ * 0.0625 * (double)scaleX;
                yOffset += scopePosition.f_82480_ * 0.0625 * (double)scaleY;
                zOffset += scopePosition.f_82481_ * 0.0625 * (double)scaleZ;
                ItemStack scopeStack = Gun.getScopeStack(heldItem);
                Vec3 scopeOrigin = PropertyHelper.getModelOrigin(scopeStack, PropertyHelper.ATTACHMENT_DEFAULT_ORIGIN);
                Vec3 scopeCamera = PropertyHelper.getScopeCamera(scopeStack).m_82546_(scopeOrigin);
                Vec3 scopeScale = PropertyHelper.getAttachmentScale(heldItem, modifiedGun, IAttachment.Type.SCOPE);
                xOffset += scopeCamera.f_82479_ * 0.0625 * (double)scaleX * scopeScale.f_82479_;
                yOffset += scopeCamera.f_82480_ * 0.0625 * (double)scaleY * scopeScale.f_82480_;
                zOffset += scopeCamera.f_82481_ * 0.0625 * (double)scaleZ * scopeScale.f_82481_;
            } else {
                Vec3 ironSightCamera = PropertyHelper.getIronSightCamera(heldItem, modifiedGun, gunOrigin).m_82546_(gunOrigin);
                xOffset += ironSightCamera.f_82479_ * 0.0625 * (double)scaleX;
                yOffset += ironSightCamera.f_82480_ * 0.0625 * (double)scaleY;
                zOffset += ironSightCamera.f_82481_ * 0.0625 * (double)scaleZ;
                if (PropertyHelper.isLegacyIronSight(heldItem)) {
                    zOffset += 0.72;
                }
            }
            float side = right ? 1.0f : -1.0f;
            double time = AimingHandler.get().getNormalisedAdsProgress();
            double transition = PropertyHelper.getSightAnimations(heldItem, modifiedGun).getSightCurve().apply(time);
            poseStack.m_85837_(-0.56 * (double)side * transition, 0.52 * transition, 0.72 * transition);
            poseStack.m_85837_(-xOffset * (double)side * transition, -yOffset * transition, -zOffset * transition);
        }
        this.applyBobbingTransforms(poseStack, event.getPartialTick());
        this.applyBanzaiTransforms(poseStack, event.getPartialTick());
        float equipProgress = this.getEquipProgress(event.getPartialTick());
        poseStack.m_252781_(Axis.f_252529_.m_252977_(equipProgress * -50.0f));
        this.renderReloadArm(poseStack, event.getMultiBufferSource(), event.getPackedLight(), modifiedGun, heldItem, hand, translateX);
        int offset = right ? 1 : -1;
        poseStack.m_85837_(0.56 * (double)offset, -0.52, -0.72);
        this.applyAimingTransforms(poseStack, heldItem, modifiedGun, translateX, translateY, translateZ, offset);
        this.applySwayTransforms(poseStack, modifiedGun, heldItem, player2, translateX, translateY, translateZ, event.getPartialTick());
        this.applySprintingTransforms(modifiedGun, heldItem, hand, poseStack, event.getPartialTick());
        this.applyRecoilTransforms(poseStack, heldItem, modifiedGun);
        this.applyReloadTransforms(poseStack, event.getPartialTick());
        this.applyShieldTransforms(poseStack, player2, modifiedGun, heldItem, event.getPartialTick());
        this.applyMeleeTransforms(poseStack, event.getPartialTick());
        int blockLight = player2.m_6060_() ? 15 : player2.m_9236_().m_45517_(LightLayer.BLOCK, BlockPos.m_274446_((Position)player2.m_20299_(event.getPartialTick())));
        blockLight += entityIdForMuzzleFlash.contains(player2.m_19879_()) ? 3 : 0;
        blockLight = Math.min(blockLight, 15);
        int packedLight = LightTexture.m_109885_((int)blockLight, (int)player2.m_9236_().m_45517_(LightLayer.SKY, BlockPos.m_274446_((Position)player2.m_20299_(event.getPartialTick()))));
        poseStack.m_85836_();
        modifiedGun.getGeneral().getGripType(heldItem).heldAnimation().renderFirstPersonArms((Player)Minecraft.m_91087_().f_91074_, hand, heldItem, poseStack, event.getMultiBufferSource(), packedLight, event.getPartialTick());
        poseStack.m_85849_();
        ItemDisplayContext display = right ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
        this.renderWeapon((LivingEntity)Minecraft.m_91087_().f_91074_, heldItem, display, event.getPoseStack(), event.getMultiBufferSource(), packedLight, event.getPartialTick());
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public void onGunFire(GunFireEvent.Post event) {
        if (!event.isClient()) {
            return;
        }
        this.sprintTransition = 0;
        this.sprintCooldown = 20;
        ItemStack heldItem = event.getStack();
        GunItem gunItem = (GunItem)heldItem.m_41720_();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (((Boolean)Config.CLIENT.display.cinematicGunEffects.get()).booleanValue()) {
            this.addCameraShake(modifiedGun, 0.5f, 10);
        }
        if (event.getShooter() instanceof Player && modifiedGun.getDisplay().getFlash() != null) {
            int entityId = event.getShooter().m_19879_();
            this.showMuzzleFlashForPlayer(entityId);
            if (gunItem instanceof AnimatedDualWieldGunItem) {
                DualWieldShotTracker.get().incrementShotCount(entityId);
            }
            this.entityShotCount.put(entityId, DualWieldShotTracker.get().getShotCount(entityId));
        }
    }

    private void addCameraShake(Gun gun, float baseIntensity, int durationTicks) {
        if (!gun.getGeneral().hasCameraShake()) {
            return;
        }
        float randomIntensity = baseIntensity + (this.random.nextFloat() - 0.5f) * 0.2f;
        int randomDuration = durationTicks + this.random.nextInt(5) - 2;
        this.immersiveRoll = randomIntensity;
        this.sprintCooldown = Math.max(randomDuration, 1);
    }

    public void showMuzzleFlashForPlayer(int entityId) {
        entityIdForMuzzleFlash.add(entityId);
        entityIdToRandomValue.put(entityId, Float.valueOf(this.random.nextFloat()));
    }

    @SubscribeEvent
    public void onComputeFov(ViewportEvent.ComputeFov event) {
        if (event.usedConfiguredFov()) {
            return;
        }
        LocalPlayer player = Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (!modifiedGun.canAimDownSight()) {
            return;
        }
        if (AimingHandler.get().getNormalisedAdsProgress() <= 0.0) {
            return;
        }
        double time = AimingHandler.get().getNormalisedAdsProgress();
        SightAnimation sightAnimation = PropertyHelper.getSightAnimations(heldItem, modifiedGun);
        time = sightAnimation.getViewportCurve().apply(time);
        double viewportFov = PropertyHelper.getViewportFov(heldItem, modifiedGun);
        double newFov = viewportFov > 0.0 ? viewportFov : event.getFOV();
        event.setFOV(Mth.m_14139_((double)time, (double)event.getFOV(), (double)newFov));
    }

    private void applyBobbingTransforms(PoseStack poseStack, float partialTicks) {
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        if (((Boolean)mc.f_91066_.m_231830_().m_231551_()).booleanValue() && (entity = mc.m_91288_()) instanceof Player) {
            Player player = (Player)entity;
            float deltaDistanceWalked = player.f_19787_ - player.f_19867_;
            float distanceWalked = -(player.f_19787_ + deltaDistanceWalked * partialTicks);
            float bobbing = Mth.m_14179_((float)partialTicks, (float)player.f_36099_, (float)player.f_36100_);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-(Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI - 0.2f)) * bobbing) * 5.0f)));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(-(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * bobbing * 3.0f)));
            poseStack.m_85837_((double)(-(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * bobbing * 0.5f)), (double)(-(-Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI)) * bobbing))), 0.0);
            bobbing *= (float)(player.m_20142_() ? 8.0 : 4.0);
            bobbing = (float)((double)bobbing * (Double)Config.CLIENT.display.bobbingIntensity.get());
            double invertZoomProgress = 1.0 - AimingHandler.get().getNormalisedAdsProgress() * (double)this.sprintIntensity;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * bobbing * 3.0f * (float)invertZoomProgress));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI - 0.2f)) * bobbing) * 5.0f * (float)invertZoomProgress));
        }
    }

    private void applyAimingTransforms(PoseStack poseStack, ItemStack heldItem, Gun modifiedGun, float x, float y, float z, int offset) {
        if (!((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            poseStack.m_252880_(x * (float)offset, y, z);
            poseStack.m_85837_(0.0, -0.25, 0.25);
            float aiming = (float)Math.sin(Math.toRadians(AimingHandler.get().getNormalisedAdsProgress() * 180.0));
            aiming = PropertyHelper.getSightAnimations(heldItem, modifiedGun).getAimTransformCurve().apply(aiming);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(aiming * 10.0f * (float)offset));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(aiming * 5.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(aiming * 5.0f * (float)offset));
            poseStack.m_85837_(0.0, 0.25, -0.25);
            poseStack.m_252880_(-x * (float)offset, -y, -z);
        }
    }

    private void applySwayTransforms(PoseStack poseStack, Gun modifiedGun, ItemStack stack, LocalPlayer player, float x, float y, float z, float partialTicks) {
        if (((Boolean)Config.CLIENT.display.weaponSway.get()).booleanValue() && player != null) {
            poseStack.m_252880_(x, y, z);
            double zOffset = modifiedGun.determineGripType(stack).heldAnimation().getFallSwayZOffset();
            poseStack.m_85837_(0.0, -0.25, zOffset);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)this.prevFallSway, (float)this.fallSway)));
            poseStack.m_85837_(0.0, 0.25, -zOffset);
            float bobPitch = Mth.m_14189_((float)partialTicks, (float)player.f_108588_, (float)player.f_108586_);
            float headPitch = Mth.m_14189_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_());
            float swayPitch = headPitch - bobPitch;
            poseStack.m_252781_(((SwayType)((Object)Config.CLIENT.display.swayType.get())).getPitchRotation().m_252977_((swayPitch *= (float)(1.0 - 0.5 * AimingHandler.get().getNormalisedAdsProgress())) * ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue()));
            float bobYaw = Mth.m_14189_((float)partialTicks, (float)player.f_108587_, (float)player.f_108585_);
            float headYaw = Mth.m_14189_((float)partialTicks, (float)player.f_20886_, (float)player.f_20885_);
            float swayYaw = headYaw - bobYaw;
            poseStack.m_252781_(((SwayType)((Object)Config.CLIENT.display.swayType.get())).getYawRotation().m_252977_((swayYaw *= (float)(1.0 - 0.5 * AimingHandler.get().getNormalisedAdsProgress())) * ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue()));
            poseStack.m_252880_(-x, -y, -z);
        }
    }

    private void applyReloadTransforms(PoseStack poseStack, float partialTicks) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        if (stack.m_41720_() instanceof AnimatedGunItem) {
            return;
        }
        float reloadProgress = ReloadHandler.get().getReloadProgress(partialTicks);
        if (((GunItem)stack.m_41720_()).getGun().getReloads().getReloadType() == ReloadType.MANUAL) {
            if (reloadProgress > 0.0f) {
                poseStack.m_85837_(0.0, -0.2 * (double)reloadProgress, 0.0);
                poseStack.m_85837_(0.0, 0.0, -0.1 * (double)reloadProgress);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-35.0f * reloadProgress));
            }
        } else {
            poseStack.m_85837_(0.0, -0.35 * (double)reloadProgress, 0.0);
            poseStack.m_85837_(0.0, 0.0, -0.1 * (double)reloadProgress);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-35.0f * reloadProgress));
        }
    }

    private void applyRecoilTransforms(PoseStack poseStack, ItemStack item, Gun gun) {
        double recoilNormal = RecoilHandler.get().getGunRecoilNormal();
        if (Gun.hasAttachmentEquipped(item, gun, IAttachment.Type.SCOPE)) {
            recoilNormal -= recoilNormal * (0.5 * AimingHandler.get().getNormalisedAdsProgress());
        }
        Minecraft mc = Minecraft.m_91087_();
        float kickReduction = mc.f_91074_ != null ? 1.0f - GunModifierHelper.getKickReduction((Player)mc.f_91074_, item) : 1.0f - GunModifierHelper.getKickReduction(item);
        float recoilReduction = mc.f_91074_ != null ? 1.0f - GunModifierHelper.getRecoilModifier((Player)mc.f_91074_, item) : 1.0f - GunModifierHelper.getRecoilModifier(item);
        double kick = (double)gun.getGeneral().getRecoilKick() * 0.0625 * recoilNormal * RecoilHandler.get().getAdsRecoilReduction(gun);
        float recoilLift = (float)((double)gun.getGeneral().getRecoilAngle() * recoilNormal) * (float)RecoilHandler.get().getAdsRecoilReduction(gun);
        float recoilSwayAmount = (float)(2.0 + 1.0 * (1.0 - AimingHandler.get().getNormalisedAdsProgress()));
        float recoilSway = (float)((double)(RecoilHandler.get().getGunRecoilRandom() * recoilSwayAmount - recoilSwayAmount / 2.0f) * recoilNormal);
        poseStack.m_85837_(0.0, 0.0, kick * (double)kickReduction);
        poseStack.m_85837_(0.0, 0.0, 0.15);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(recoilSway * recoilReduction));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(recoilSway * recoilReduction));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(recoilLift * recoilReduction));
        poseStack.m_85837_(0.0, 0.0, -0.15);
    }

    private void applyShieldTransforms(PoseStack poseStack, LocalPlayer player, Gun modifiedGun, ItemStack stack, float partialTick) {
        GripType gripType = modifiedGun.determineGripType(stack);
        if (player.m_6117_() && player.m_21206_().m_41720_() == Items.f_42740_ && (gripType == GripType.ONE_HANDED || gripType == GripType.ONE_HANDED_2)) {
            double time = Mth.m_14008_((double)((float)player.m_21252_() + partialTick), (double)0.0, (double)4.0) / 4.0;
            if (gripType == GripType.ONE_HANDED) {
                poseStack.m_85837_(0.45 * time, -0.05 * time, 0.15 * time);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(30.0f * (float)time));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(10.0f * (float)time));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(-8.0f * (float)time));
            }
        }
    }

    public void applyWeaponScale(ItemStack heldItem, PoseStack stack) {
        CompoundTag compound;
        if (heldItem.m_41783_() != null && (compound = heldItem.m_41783_()).m_128425_("Scale", 5)) {
            float scale = compound.m_128457_("Scale");
            stack.m_85841_(scale, scale, scale);
        }
    }

    private void renderGun(@Nullable LivingEntity entity, ItemDisplayContext display, ItemStack stack, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light, float partialTicks) {
        IOverrideModel model;
        if (ModelOverrides.hasModel(stack) && (model = ModelOverrides.getModel(stack)) != null && (display == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || display == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || display == ItemDisplayContext.FIXED || display == ItemDisplayContext.GUI)) {
            model.render(partialTicks, display, stack, ItemStack.f_41583_, entity, poseStack, renderTypeBuffer, light, OverlayTexture.f_118083_);
            if (display == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || display == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                return;
            }
        }
        if (stack.m_41720_() instanceof AnimatedGunItem && (display == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || display == ItemDisplayContext.THIRD_PERSON_LEFT_HAND)) {
            return;
        }
        Level level = entity != null ? entity.m_9236_() : null;
        BakedModel bakedModel = Minecraft.m_91087_().m_91291_().m_174264_(stack, level, entity, 0);
        Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemDisplayContext.NONE, false, poseStack, renderTypeBuffer, light, OverlayTexture.f_118083_, bakedModel);
    }

    private void renderAttachments(@Nullable LivingEntity entity, ItemDisplayContext display, ItemStack stack, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light, float partialTicks) {
        if (stack.m_41720_() instanceof AnimatedGunItem && (display == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || display == ItemDisplayContext.FIRST_PERSON_LEFT_HAND)) {
            return;
        }
        if (stack.m_41720_() instanceof GunItem) {
            Gun modifiedGun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
            CompoundTag gunTag = stack.m_41784_();
            CompoundTag attachments = gunTag.m_128469_("Attachments");
            Set<Item> customAttachments = Set.of((Item)ModItems.SILENCER.get(), (Item)ModItems.ADVANCED_SILENCER.get(), (Item)ModItems.MUZZLE_BRAKE.get(), (Item)ModItems.VERTICAL_GRIP.get(), (Item)ModItems.LIGHT_GRIP.get(), (Item)ModItems.IRON_BAYONET.get(), (Item)ModItems.ANTHRALITE_BAYONET.get(), (Item)ModItems.DIAMOND_BAYONET.get(), (Item)ModItems.NETHERITE_BAYONET.get(), (Item)ModItems.EXTENDED_BARREL.get());
            for (String tagKey : attachments.m_128431_()) {
                ItemStack attachmentStack;
                IAttachment.Type type = IAttachment.Type.byTagKey(tagKey);
                if (type == null || !modifiedGun.canAttachType(type) || customAttachments.contains((attachmentStack = Gun.getAttachment(type, stack)).m_41720_()) || attachmentStack.m_41619_()) continue;
                poseStack.m_85836_();
                Vec3 origin = PropertyHelper.getModelOrigin(attachmentStack, PropertyHelper.ATTACHMENT_DEFAULT_ORIGIN);
                poseStack.m_85837_(-origin.f_82479_ * 0.0625, -origin.f_82480_ * 0.0625, -origin.f_82481_ * 0.0625);
                Vec3 gunOrigin = PropertyHelper.getModelOrigin(stack, PropertyHelper.GUN_DEFAULT_ORIGIN);
                poseStack.m_85837_(gunOrigin.f_82479_ * 0.0625, gunOrigin.f_82480_ * 0.0625, gunOrigin.f_82481_ * 0.0625);
                Vec3 translation = PropertyHelper.getAttachmentPosition(stack, modifiedGun, type).m_82546_(gunOrigin);
                poseStack.m_85837_(translation.f_82479_ * 0.0625, translation.f_82480_ * 0.0625, translation.f_82481_ * 0.0625);
                Vec3 scale = PropertyHelper.getAttachmentScale(stack, modifiedGun, type);
                Vec3 center = origin.m_82492_(8.0, 8.0, 8.0).m_82490_(0.0625);
                poseStack.m_85837_(center.f_82479_, center.f_82480_, center.f_82481_);
                poseStack.m_85841_((float)scale.f_82479_, (float)scale.f_82480_, (float)scale.f_82481_);
                poseStack.m_85837_(-center.f_82479_, -center.f_82480_, -center.f_82481_);
                IOverrideModel model = ModelOverrides.getModel(attachmentStack);
                if (model != null) {
                    model.render(partialTicks, display, attachmentStack, stack, entity, poseStack, renderTypeBuffer, light, OverlayTexture.f_118083_);
                } else {
                    Level level = entity != null ? entity.m_9236_() : null;
                    BakedModel bakedModel = Minecraft.m_91087_().m_91291_().m_174264_(attachmentStack, level, entity, 0);
                    Minecraft.m_91087_().m_91291_().m_115143_(attachmentStack, ItemDisplayContext.NONE, false, poseStack, renderTypeBuffer, light, OverlayTexture.f_118083_, GunModel.wrap(bakedModel));
                }
                poseStack.m_85849_();
            }
        }
    }

    public void renderWeapon(@Nullable LivingEntity entity, ItemStack stack, ItemDisplayContext display, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light, float partialTicks) {
        if (stack.m_41720_() instanceof GunItem) {
            poseStack.m_85836_();
            RenderUtil.applyTransformType(stack, poseStack, display, entity);
            this.renderGun(entity, display, stack, poseStack, renderTypeBuffer, light, partialTicks);
            this.renderAttachments(entity, display, stack, poseStack, renderTypeBuffer, light, partialTicks);
            this.renderMuzzleFlash(entity, poseStack, renderTypeBuffer, stack, display, partialTicks);
            poseStack.m_85849_();
        }
    }

    private void renderMuzzleFlash(@Nullable LivingEntity entity, PoseStack poseStack, MultiBufferSource buffer, ItemStack weapon, ItemDisplayContext display, float partialTicks) {
        Gun modifiedGun = ((GunItem)weapon.m_41720_()).getModifiedGun(weapon);
        Gun.Display.Flash flash = modifiedGun.getDisplay().getFlash();
        if (flash == null) {
            return;
        }
        if (entity == null) {
            return;
        }
        if (display != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND && display != ItemDisplayContext.THIRD_PERSON_RIGHT_HAND && display != ItemDisplayContext.FIRST_PERSON_LEFT_HAND && display != ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            return;
        }
        boolean isBeamActive = BeamHandler.activeBeams.containsKey(entity.m_20148_());
        if (!isBeamActive && !entityIdForMuzzleFlash.contains(entity.m_19879_())) {
            return;
        }
        float randomValue = entityIdToRandomValue.getOrDefault(entity.m_19879_(), Float.valueOf(0.0f)).floatValue();
        ResourceLocation flashTexture = new ResourceLocation("scguns", "textures/effect/" + flash.getTextureLocation() + ".png");
        boolean mirror = this.entityShotCount.getOrDefault(entity.m_19879_(), 0) % 2 == 1 && flash.hasAlternateMuzzleFlash();
        this.drawMuzzleFlash(weapon, modifiedGun, randomValue, mirror, poseStack, buffer, partialTicks, flashTexture, entity);
        if (flash.shouldSpawnParticles() && flash.getParticleType() != null) {
            this.spawnParticles(flash, entity);
        }
    }

    private void drawMuzzleFlash(ItemStack weapon, Gun modifiedGun, float random, boolean mirror, PoseStack poseStack, MultiBufferSource buffer, float partialTicks, ResourceLocation flashTexture, LivingEntity entity) {
        if (!PropertyHelper.hasMuzzleFlash(weapon, modifiedGun)) {
            return;
        }
        Gun.Display.Flash flash = modifiedGun.getDisplay().getFlash();
        if (flash == null) {
            return;
        }
        int shotCount = DualWieldShotTracker.get().getShotCount(entity.m_19879_());
        Vec3 muzzlePosition = shotCount % 2 == 0 ? Vec3.f_82478_ : flash.getAlternatePosition();
        this.drawSingleMuzzleFlash(weapon, modifiedGun, random, mirror, poseStack, buffer, partialTicks, flashTexture, muzzlePosition, entity);
    }

    private void drawSingleMuzzleFlash(ItemStack weapon, Gun modifiedGun, float random, boolean mirror, PoseStack poseStack, MultiBufferSource buffer, float partialTicks, ResourceLocation flashTexture, Vec3 offset, LivingEntity entity) {
        Gun.Display.Flash flash = modifiedGun.getDisplay().getFlash();
        if (flash == null) {
            return;
        }
        poseStack.m_85836_();
        Vec3 weaponOrigin = PropertyHelper.getModelOrigin(weapon, PropertyHelper.GUN_DEFAULT_ORIGIN);
        Vec3 flashPosition = entity != null && entityIdToFlashPosition.containsKey(entity.m_19879_()) ? entityIdToFlashPosition.get(entity.m_19879_()) : PropertyHelper.getMuzzleFlashPosition(weapon, modifiedGun).m_82546_(weaponOrigin);
        flashPosition = flashPosition.m_82549_(offset);
        poseStack.m_85837_(weaponOrigin.f_82479_ * 0.0625, weaponOrigin.f_82480_ * 0.0625, weaponOrigin.f_82481_ * 0.0625);
        poseStack.m_85837_(flashPosition.f_82479_ * 0.0625, flashPosition.f_82480_ * 0.0625, flashPosition.f_82481_ * 0.0625);
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(360.0f * random));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(0.0f));
        Vec3 flashScale = PropertyHelper.getMuzzleFlashScale(weapon, modifiedGun);
        float scaleX = (float)flashScale.f_82479_ / 2.0f - (float)flashScale.f_82479_ / 2.0f * (1.0f - partialTicks);
        float scaleY = (float)flashScale.f_82480_ / 2.0f - (float)flashScale.f_82480_ / 2.0f * (1.0f - partialTicks);
        poseStack.m_85841_(scaleX, scaleY, 1.0f);
        float scaleModifier = (float)GunModifierHelper.getMuzzleFlashScale(weapon, 1.0);
        poseStack.m_85841_(scaleModifier, scaleModifier, 1.0f);
        poseStack.m_85837_(-0.5, -0.5, 0.0);
        boolean shouldUseEnchanted = weapon.m_41793_();
        if (entity != null && entityIdToUseEnchantedTexture.containsKey(entity.m_19879_())) {
            shouldUseEnchanted = entityIdToUseEnchantedTexture.get(entity.m_19879_());
        }
        float minU = shouldUseEnchanted ? 0.5f : 0.0f;
        float maxU = shouldUseEnchanted ? 1.0f : 0.5f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        VertexConsumer builder = buffer.m_6299_(GunRenderType.getMuzzleFlash(flashTexture));
        builder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, 0.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, 0.0f).m_85969_(0xF000F0).m_5752_();
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(weaponOrigin.f_82479_ * 0.0625, weaponOrigin.f_82480_ * 0.0625, weaponOrigin.f_82481_ * 0.0625);
        poseStack.m_85837_(flashPosition.f_82479_ * 0.0625, flashPosition.f_82480_ * 0.0625, flashPosition.f_82481_ * 0.0625);
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(360.0f * random));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(0.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        poseStack.m_85841_(scaleX, scaleY, 1.0f);
        poseStack.m_85841_(scaleModifier, scaleModifier, 1.0f);
        poseStack.m_85837_(-0.5, -0.5, 0.0);
        matrix = poseStack.m_85850_().m_252922_();
        builder = buffer.m_6299_(GunRenderType.getMuzzleFlash(flashTexture));
        builder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, 0.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, 0.0f).m_85969_(0xF000F0).m_5752_();
        poseStack.m_85849_();
    }

    private void spawnParticles(Gun.Display.Flash flash, LivingEntity entity) {
        block5: {
            if (entity == null || !entity.m_9236_().m_5776_()) {
                return;
            }
            ClientLevel world = (ClientLevel)entity.m_9236_();
            RandomSource random = entity.m_217043_();
            double posX = entity.m_20185_();
            double posY = entity.m_20186_() + (double)entity.m_20192_();
            double posZ = entity.m_20189_();
            SimpleParticleType particleType = flash.getParticleType();
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastParticleSpawnTime < 100L) break block5;
            this.lastParticleSpawnTime = currentTime;
            double radius = flash.getParticleRingRadius();
            if (radius > 0.0) {
                for (int i = 0; i < flash.getParticleCount(); ++i) {
                    double angle = random.m_188500_() * 2.0 * Math.PI;
                    double randomizedRadius = radius * (0.8 + random.m_188500_() * 0.4);
                    double offsetX = Math.cos(angle) * randomizedRadius;
                    double offsetZ = Math.sin(angle) * randomizedRadius;
                    double spread = flash.getParticleSpread();
                    double offsetY = (random.m_188500_() - 0.5) * spread;
                    double motionStrength = 0.03 + random.m_188500_() * 0.02;
                    double motionX = (offsetX += (random.m_188500_() - 0.5) * spread * 0.5) * motionStrength;
                    double motionY = offsetY * motionStrength + 0.01;
                    double motionZ = (offsetZ += (random.m_188500_() - 0.5) * spread * 0.5) * motionStrength;
                    world.m_7106_((ParticleOptions)particleType, posX + offsetX, posY + offsetY, posZ + offsetZ, motionX, motionY, motionZ);
                }
            } else {
                for (int i = 0; i < flash.getParticleCount(); ++i) {
                    double spread = flash.getParticleSpread();
                    double offsetX = (random.m_188500_() - 0.5) * spread;
                    double offsetY = (random.m_188500_() - 0.5) * spread;
                    double offsetZ = (random.m_188500_() - 0.5) * spread;
                    world.m_7106_((ParticleOptions)particleType, posX + offsetX, posY + offsetY, posZ + offsetZ, offsetX * 0.1, offsetY * 0.1, offsetZ * 0.1);
                }
            }
        }
    }

    private void renderReloadArm(PoseStack poseStack, MultiBufferSource buffer, int light, Gun modifiedGun, ItemStack stack, HumanoidArm hand, float translateX) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91074_.f_19797_ < ReloadHandler.get().getStartReloadTick() || ReloadHandler.get().getReloadTimer() != 5) {
            return;
        }
        poseStack.m_85836_();
        int side = hand.m_20828_() == HumanoidArm.RIGHT ? 1 : -1;
        poseStack.m_252880_(translateX * (float)side, 0.0f, 0.0f);
        float interval = GunEnchantmentHelper.getRealReloadSpeed(stack);
        float reload = ((float)(mc.f_91074_.f_19797_ - ReloadHandler.get().getStartReloadTick()) + mc.m_91296_()) % interval / interval;
        float percent = 1.0f - reload;
        if (percent >= 0.5f) {
            percent = 1.0f - percent;
        }
        percent = (double)(percent *= 2.0f) < 0.5 ? 2.0f * percent * percent : -1.0f + (4.0f - 2.0f * percent) * percent;
        poseStack.m_85837_(0.0, 0.35 * (1.0 - (double)percent), 0.0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(30.0f * percent));
        poseStack.m_85849_();
    }

    private float getEquipProgress(float partialTicks) {
        if (this.equippedProgressMainHandField == null) {
            this.equippedProgressMainHandField = ObfuscationReflectionHelper.findField(ItemInHandRenderer.class, (String)"f_109302_");
            this.equippedProgressMainHandField.setAccessible(true);
        }
        if (this.prevEquippedProgressMainHandField == null) {
            this.prevEquippedProgressMainHandField = ObfuscationReflectionHelper.findField(ItemInHandRenderer.class, (String)"f_109303_");
            this.prevEquippedProgressMainHandField.setAccessible(true);
        }
        ItemInHandRenderer firstPersonRenderer = Minecraft.m_91087_().m_91290_().m_234586_();
        try {
            float equippedProgressMainHand = ((Float)this.equippedProgressMainHandField.get(firstPersonRenderer)).floatValue();
            float prevEquippedProgressMainHand = ((Float)this.prevEquippedProgressMainHandField.get(firstPersonRenderer)).floatValue();
            return 1.0f - Mth.m_14179_((float)partialTicks, (float)prevEquippedProgressMainHand, (float)equippedProgressMainHand);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    @SubscribeEvent
    public void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        if (((Boolean)Config.CLIENT.display.cameraRollEffect.get()).booleanValue()) {
            float roll = (float)Mth.m_14139_((double)event.getPartialTick(), (double)this.prevImmersiveRoll, (double)this.immersiveRoll);
            roll = (float)Math.sin((double)roll * Math.PI / 2.0);
            if (((Boolean)Config.CLIENT.display.cinematicGunEffects.get()).booleanValue()) {
                roll *= ((Double)Config.CLIENT.display.cameraRollAngle.get()).floatValue() + this.immersiveRoll;
            }
            event.setRoll(-roll);
        }
    }

    public float getThirdPersonMeleeProgress() {
        return this.thirdPersonMeleeProgress;
    }

    public float getSprintTransition(float frameTime) {
        return Mth.m_14179_((float)frameTime, (float)this.prevSprintTransition, (float)this.sprintTransition);
    }

    static {
        entityIdForMuzzleFlash = new HashSet<Integer>();
        entityIdToRandomValue = new HashMap<Integer, Float>();
    }
}

