/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.handler;

import com.mrcrayfish.framework.network.message.IMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import top.ribs.scguns.Config;
import top.ribs.scguns.ScorchedGuns;
import top.ribs.scguns.client.KeyBinds;
import top.ribs.scguns.client.handler.AimingHandler;
import top.ribs.scguns.client.handler.ControllerHandler;
import top.ribs.scguns.client.handler.DualWieldShotTracker;
import top.ribs.scguns.client.handler.ReloadHandler;
import top.ribs.scguns.common.ChargeHandler;
import top.ribs.scguns.common.FireMode;
import top.ribs.scguns.common.GripType;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.ReloadType;
import top.ribs.scguns.compat.PlayerReviveHelper;
import top.ribs.scguns.event.GunFireEvent;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.item.BayonetItem;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.animated.AnimatedDualWieldGunItem;
import top.ribs.scguns.item.animated.AnimatedGunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.C2SMessageOffhandMelee;
import top.ribs.scguns.network.message.C2SMessagePreFireSound;
import top.ribs.scguns.network.message.C2SMessageShoot;
import top.ribs.scguns.network.message.C2SMessageShooting;
import top.ribs.scguns.network.message.C2SMessageStopBeam;
import top.ribs.scguns.util.GunCompositeStatHelper;

public class ShootingHandler {
    private static ShootingHandler instance;
    private int fireTimer = 0;
    private int burstCooldownTimer;
    private boolean wasRightClickPressed = false;
    private boolean wasHoldingFireWhenEmpty = false;
    private boolean hasReleasedFireSinceEmpty = false;
    private boolean hasBufferedShot = false;
    private int bufferTimer = 0;
    private boolean lastFireKeyState = false;
    private static final int BUFFER_DURATION = 4;
    private boolean shooting;
    private boolean doEmptyClick;
    private int slot = -1;
    private int burstCounter = 0;

    public static ShootingHandler get() {
        if (instance == null) {
            instance = new ShootingHandler();
        }
        return instance;
    }

    private ShootingHandler() {
    }

    private boolean isInGame() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91265_() != null) {
            return true;
        }
        if (mc.f_91080_ != null) {
            return true;
        }
        if (!mc.f_91067_.m_91600_()) {
            return true;
        }
        return !mc.m_91302_();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMouseClick(InputEvent.InteractionKeyMappingTriggered event) {
        ItemStack heldItem;
        Item item;
        if (event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (PlayerReviveHelper.isBleeding((Player)player)) {
            return;
        }
        if (event.isAttack()) {
            ItemStack heldItem2 = player.m_21205_();
            if (heldItem2.m_41720_() instanceof GunItem) {
                event.setSwingHand(false);
                event.setCanceled(true);
            }
        } else if (event.isUseItem() && (item = (heldItem = player.m_21205_()).m_41720_()) instanceof GunItem) {
            ItemStack offhandItem;
            Gun modifiedGun;
            GripType gripType;
            GunItem gunItem = (GunItem)item;
            if (event.getHand() == InteractionHand.MAIN_HAND && (gripType = (modifiedGun = gunItem.getModifiedGun(heldItem)).getGeneral().getGripType(heldItem)) == GripType.ONE_HANDED && !player.m_21206_().m_41619_() && ((offhandItem = player.m_21206_()).m_41720_() instanceof SwordItem || offhandItem.m_41720_() instanceof BayonetItem)) {
                boolean currentRightClick = mc.f_91066_.f_92095_.m_90857_();
                if (currentRightClick && !this.wasRightClickPressed) {
                    event.setCanceled(true);
                    event.setSwingHand(false);
                    if (mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.ENTITY) {
                        EntityHitResult entityHit = (EntityHitResult)mc.f_91077_;
                        Entity target = entityHit.m_82443_();
                        PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageOffhandMelee(target.m_19879_(), (float)entityHit.m_82450_().f_82479_, (float)entityHit.m_82450_().f_82480_, (float)entityHit.m_82450_().f_82481_));
                    } else {
                        PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageOffhandMelee(-1, 0.0f, 0.0f, 0.0f));
                    }
                }
                this.wasRightClickPressed = currentRightClick;
                return;
            }
            if (event.getHand() == InteractionHand.OFF_HAND) {
                modifiedGun = gunItem.getModifiedGun(heldItem);
                gripType = modifiedGun.getGeneral().getGripType(heldItem);
                if (gripType == GripType.ONE_HANDED) {
                    return;
                }
                if (player.m_21206_().m_41720_() == Items.f_42740_ && player.m_6117_() && player.m_7655_() == InteractionHand.OFF_HAND) {
                    return;
                }
                event.setCanceled(true);
                event.setSwingHand(false);
                return;
            }
            if (AimingHandler.get().isZooming() && AimingHandler.get().isLookingAtInteractableBlock()) {
                event.setCanceled(true);
                event.setSwingHand(false);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHandleShooting(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.isInGame()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            this.shooting = false;
            this.lastFireKeyState = false;
            this.hasBufferedShot = false;
            this.bufferTimer = 0;
            return;
        }
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            if (!PlayerReviveHelper.isBleeding((Player)player)) {
                Gun modifiedGun = gunItem.getModifiedGun(heldItem);
                boolean isCurrentlyPressingFire = KeyBinds.getShootMapping().m_90857_();
                if (ScorchedGuns.controllableLoaded) {
                    isCurrentlyPressingFire |= ControllerHandler.isShooting();
                }
                if (modifiedGun.getGeneral().getFireMode() == FireMode.SEMI_AUTO) {
                    this.handleSemiAutoWithBuffer((Player)player, heldItem, isCurrentlyPressingFire);
                } else {
                    this.handleOtherFireModes((Player)player, heldItem, modifiedGun, isCurrentlyPressingFire);
                }
                this.lastFireKeyState = isCurrentlyPressingFire;
                return;
            }
        }
        if (!this.shooting) return;
        this.shooting = false;
        PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShooting(false));
        this.lastFireKeyState = false;
        this.hasBufferedShot = false;
        this.bufferTimer = 0;
    }

    private void handleSemiAutoWithBuffer(Player player, ItemStack heldItem, boolean isCurrentlyPressingFire) {
        boolean newFireInput;
        ItemCooldowns tracker = player.m_36335_();
        boolean isOnCooldown = tracker.m_41519_(heldItem.m_41720_());
        boolean bl = newFireInput = isCurrentlyPressingFire && !this.lastFireKeyState;
        if (newFireInput) {
            if (!isOnCooldown) {
                if (!this.shooting) {
                    this.shooting = true;
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShooting(true));
                }
            } else {
                this.hasBufferedShot = true;
                this.bufferTimer = 4;
            }
        }
        if (this.hasBufferedShot && !isOnCooldown) {
            if (!this.shooting) {
                this.shooting = true;
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShooting(true));
            }
            this.hasBufferedShot = false;
            this.bufferTimer = 0;
        }
        if (this.hasBufferedShot) {
            --this.bufferTimer;
            if (this.bufferTimer <= 0) {
                this.hasBufferedShot = false;
            }
        }
        if (this.shooting && !isCurrentlyPressingFire && !this.hasBufferedShot) {
            this.shooting = false;
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShooting(false));
        }
    }

    private void handleOtherFireModes(Player player, ItemStack heldItem, Gun modifiedGun, boolean shouldShoot) {
        this.hasBufferedShot = false;
        this.bufferTimer = 0;
        if (modifiedGun.getGeneral().getFireMode() == FireMode.BEAM || modifiedGun.getGeneral().getFireMode() == FireMode.SEMI_BEAM) {
            if (shouldShoot && this.burstCooldownTimer <= 0) {
                if (!this.shooting) {
                    this.shooting = true;
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShooting(true));
                }
            } else if (this.shooting) {
                this.shooting = false;
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShooting(false));
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageStopBeam());
            }
        } else if (shouldShoot && this.burstCooldownTimer <= 0) {
            if (!this.shooting) {
                this.shooting = true;
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShooting(true));
            }
        } else if (this.shooting) {
            this.shooting = false;
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShooting(false));
        }
    }

    private boolean isEmpty(Player player, ItemStack heldItem) {
        if (!(heldItem.m_41720_() instanceof GunItem)) {
            return false;
        }
        if (player.m_5833_()) {
            return false;
        }
        return (!Gun.hasAmmo(heldItem) || !Gun.canShoot(heldItem)) && !player.m_7500_();
    }

    public void fire(Player player, ItemStack heldItem) {
        boolean isPulse;
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        if (heldItem.m_41763_() && heldItem.m_41773_() >= heldItem.m_41776_() - 1) {
            player.m_5661_((Component)Component.m_237115_((String)"message.scguns.gun_broken").m_130940_(ChatFormatting.RED), true);
            return;
        }
        if (heldItem.m_41763_() && heldItem.m_41773_() >= heldItem.m_41776_() - 1) {
            return;
        }
        Gun gun = gunItem.getModifiedGun(heldItem);
        boolean bl = isPulse = gun.getGeneral().getFireMode() == FireMode.PULSE;
        if (this.isEmpty(player, heldItem)) {
            ItemCooldowns tracker = player.m_36335_();
            if (!tracker.m_41519_(heldItem.m_41720_()) && this.doEmptyClick && heldItem.m_41720_() instanceof GunItem && this.canUseTrigger(player, heldItem)) {
                this.doEmptyClick = false;
                boolean isCurrentlyHoldingFire = KeyBinds.getShootMapping().m_90857_();
                if (isPulse) {
                    ChargeHandler.updateChargeTime(player, heldItem, false);
                    this.fireTimer = 0;
                }
                if (((Boolean)Config.COMMON.gameplay.enableAutoReload.get()).booleanValue()) {
                    boolean isAutomaticWeapon;
                    boolean bl2 = isAutomaticWeapon = gun.getGeneral().getFireMode() == FireMode.AUTOMATIC;
                    if (isAutomaticWeapon) {
                        if (isCurrentlyHoldingFire && !this.wasHoldingFireWhenEmpty) {
                            this.wasHoldingFireWhenEmpty = true;
                            return;
                        }
                        if (this.wasHoldingFireWhenEmpty && !this.hasReleasedFireSinceEmpty) {
                            return;
                        }
                    }
                    boolean hasAmmoAvailable = gun.getReloads().getReloadType() == ReloadType.SINGLE_ITEM ? !Gun.findAmmo(player, gun.getReloads().getReloadItem()).stack().m_41619_() : !Gun.findAmmo(player, gun.getProjectile().getItem()).stack().m_41619_();
                    boolean isReloading = (Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player);
                    int currentAmmo = Gun.getAmmoCount(heldItem);
                    int maxAmmo = gun.getReloads().getMaxAmmo();
                    if (hasAmmoAvailable && !isReloading && currentAmmo < maxAmmo) {
                        boolean canAutoReload;
                        Item item2 = heldItem.m_41720_();
                        if (item2 instanceof AnimatedGunItem) {
                            AnimatedGunItem animatedGun = (AnimatedGunItem)item2;
                            CompoundTag tag = heldItem.m_41784_();
                            String reloadState = tag.m_128461_("scguns:ReloadState");
                            boolean isPlayingReloadStop = tag.m_128471_("scguns:IsPlayingReloadStop");
                            if (reloadState.equals("STOPPING") || isPlayingReloadStop) {
                                tag.m_128473_("scguns:ReloadState");
                                tag.m_128473_("scguns:IsPlayingReloadStop");
                                tag.m_128473_("scguns:IsReloading");
                                tag.m_128473_("IsReloading");
                                long id = GeoItem.getId((ItemStack)heldItem);
                                AnimationController controller = (AnimationController)animatedGun.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
                                if (controller != null) {
                                    controller.forceAnimationReset();
                                    if (animatedGun.isInCarbineMode(heldItem)) {
                                        controller.tryTriggerAnimation("carbine_idle");
                                    } else {
                                        controller.tryTriggerAnimation("idle");
                                    }
                                }
                            }
                        }
                        if (canAutoReload = ShootingHandler.isCanAutoReload(heldItem)) {
                            ReloadHandler.get().setReloading(true);
                            this.wasHoldingFireWhenEmpty = false;
                            this.hasReleasedFireSinceEmpty = false;
                        }
                    }
                }
            }
            this.burstCounter = 0;
            this.hasBufferedShot = false;
            this.bufferTimer = 0;
            return;
        }
        this.wasHoldingFireWhenEmpty = false;
        this.hasReleasedFireSinceEmpty = false;
        if (player.m_20142_()) {
            player.m_6858_(false);
        }
        if (!this.canFire(player, heldItem)) {
            return;
        }
        ItemCooldowns tracker = player.m_36335_();
        if (!tracker.m_41519_(heldItem.m_41720_())) {
            if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre(player, heldItem))) {
                return;
            }
            if (gunItem instanceof AnimatedGunItem) {
                AnimatedGunItem animatedGunItem = (AnimatedGunItem)gunItem;
                long id = GeoItem.getId((ItemStack)heldItem);
                AnimationController controller = (AnimationController)animatedGunItem.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
                controller.forceAnimationReset();
                if (gunItem instanceof AnimatedDualWieldGunItem) {
                    boolean useAlternate = DualWieldShotTracker.get().shouldUseAlternateAnimation(player.m_19879_());
                    if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue()) {
                        controller.tryTriggerAnimation(useAlternate ? "aim_shoot1" : "aim_shoot");
                    } else {
                        controller.tryTriggerAnimation(useAlternate ? "shoot1" : "shoot");
                    }
                }
            }
            int rate = GunCompositeStatHelper.getCompositeRate(heldItem, gun, player);
            tracker.m_41524_(heldItem.m_41720_(), rate);
            if (Gun.hasBurstFire(heldItem)) {
                if (this.burstCounter == 0) {
                    this.burstCounter = Gun.getBurstCount(heldItem);
                }
                --this.burstCounter;
                if (this.burstCounter == 0) {
                    this.burstCooldownTimer = Gun.getBurstCooldown(heldItem);
                }
            }
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShoot(player));
            MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post(player, heldItem));
        }
    }

    @SubscribeEvent
    public void onPostClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.isInGame()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null) {
            ItemStack heldItem;
            boolean currentRightClick = mc.f_91066_.f_92095_.m_90857_();
            if (!currentRightClick) {
                this.wasRightClickPressed = false;
            }
            if (PlayerReviveHelper.isBleeding((Player)player)) {
                return;
            }
            if (!this.isSameWeapon((Player)player)) {
                ModSyncedDataKeys.BURSTCOUNT.setValue((Entity)player, (Object)0);
                if (player.m_21205_().m_41720_() instanceof GunItem) {
                    this.burstCounter = 0;
                    this.burstCooldownTimer = 0;
                    this.fireTimer = 0;
                    this.wasHoldingFireWhenEmpty = false;
                    this.hasReleasedFireSinceEmpty = false;
                    player.m_21205_();
                    ChargeHandler.clearLastChargeProgress(player.m_20148_());
                }
            }
            if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
                this.burstCounter = 0;
                this.burstCooldownTimer = 0;
            }
            if ((heldItem = player.m_21205_()).m_41720_() instanceof GunItem) {
                boolean isHoldingFire;
                Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
                int maxChargeTime = gun.getGeneral().getFireTimer();
                if (this.burstCooldownTimer > 0) {
                    --this.burstCooldownTimer;
                }
                if (!(isHoldingFire = KeyBinds.getShootMapping().m_90857_()) && this.wasHoldingFireWhenEmpty) {
                    this.hasReleasedFireSinceEmpty = true;
                }
                if (gun.getGeneral().getFireMode() == FireMode.PULSE) {
                    if (isHoldingFire) {
                        if (Gun.hasAmmo(heldItem) || player.m_7500_()) {
                            int preSoundThreshold = maxChargeTime / 3;
                            if (this.fireTimer == preSoundThreshold) {
                                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessagePreFireSound((Player)player));
                            }
                            this.fireTimer = Math.min(this.fireTimer + 1, maxChargeTime);
                            ChargeHandler.updateChargeTime((Player)player, heldItem, true);
                        } else {
                            this.doEmptyClick = true;
                            this.fire((Player)player, heldItem);
                            this.fireTimer = 0;
                            ChargeHandler.updateChargeTime((Player)player, heldItem, false);
                        }
                    } else if (this.fireTimer > 0) {
                        this.fire((Player)player, heldItem);
                        this.fireTimer = 0;
                        ChargeHandler.updateChargeTime((Player)player, heldItem, false);
                    }
                } else {
                    if (!isHoldingFire && maxChargeTime != 0) {
                        this.fireTimer = maxChargeTime;
                        if (this.wasHoldingFireWhenEmpty) {
                            this.wasHoldingFireWhenEmpty = false;
                        }
                        ChargeHandler.updateChargeTime((Player)player, heldItem, false);
                    }
                    if ((isHoldingFire || this.burstCounter > 0) && this.burstCooldownTimer <= 0) {
                        if (maxChargeTime != 0) {
                            ItemCooldowns tracker = player.m_36335_();
                            if (!tracker.m_41519_(heldItem.m_41720_())) {
                                if (this.fireTimer == maxChargeTime - 2) {
                                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessagePreFireSound((Player)player));
                                }
                                --this.fireTimer;
                            } else {
                                this.fire((Player)player, heldItem);
                                if (gun.getGeneral().getFireMode() == FireMode.SEMI_AUTO || gun.getGeneral().getFireMode() == FireMode.SEMI_BEAM) {
                                    mc.f_91066_.f_92096_.m_7249_(false);
                                    this.fireTimer = maxChargeTime;
                                    ChargeHandler.updateChargeTime((Player)player, heldItem, false);
                                }
                            }
                        } else {
                            this.fire((Player)player, heldItem);
                            if (gun.getGeneral().getFireMode() == FireMode.SEMI_AUTO || gun.getGeneral().getFireMode() == FireMode.SEMI_BEAM) {
                                mc.f_91066_.f_92096_.m_7249_(false);
                            }
                        }
                        ChargeHandler.updateChargeTime((Player)player, heldItem, true);
                    } else {
                        ChargeHandler.updateChargeTime((Player)player, heldItem, false);
                        this.doEmptyClick = true;
                    }
                }
            }
            this.slot = player.m_150109_().f_35977_;
        }
    }

    private static boolean isCanAutoReload(ItemStack heldItem) {
        boolean syncedReloading;
        if (!(heldItem.m_41720_() instanceof AnimatedGunItem)) {
            return true;
        }
        CompoundTag tag = heldItem.m_41784_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (syncedReloading = ((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue())) {
            return false;
        }
        String reloadState = tag.m_128461_("scguns:ReloadState");
        if (!reloadState.isEmpty() && (reloadState.equals("LOADING") || reloadState.equals("STOPPING"))) {
            return false;
        }
        if (tag.m_128471_("scguns:IsPlayingReloadStop")) {
            return false;
        }
        Item item = heldItem.m_41720_();
        if (item instanceof AnimatedGunItem) {
            AnimatedGunItem animatedGun = (AnimatedGunItem)item;
            long id = GeoItem.getId((ItemStack)heldItem);
            AnimationController controller = (AnimationController)animatedGun.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
            if (controller != null) {
                boolean playingReload = animatedGun.isAnimationPlaying((AnimationController<GeoAnimatable>)controller, "reload");
                boolean playingCarbineReload = animatedGun.isAnimationPlaying((AnimationController<GeoAnimatable>)controller, "carbine_reload");
                boolean playingReloadStart = animatedGun.isAnimationPlaying((AnimationController<GeoAnimatable>)controller, "reload_start");
                boolean playingCarbineReloadStart = animatedGun.isAnimationPlaying((AnimationController<GeoAnimatable>)controller, "carbine_reload_start");
                boolean playingReloadLoop = animatedGun.isAnimationPlaying((AnimationController<GeoAnimatable>)controller, "reload_loop");
                boolean playingCarbineReloadLoop = animatedGun.isAnimationPlaying((AnimationController<GeoAnimatable>)controller, "carbine_reload_loop");
                boolean playingReloadStop = animatedGun.isAnimationPlaying((AnimationController<GeoAnimatable>)controller, "reload_stop");
                boolean playingCarbineReloadStop = animatedGun.isAnimationPlaying((AnimationController<GeoAnimatable>)controller, "carbine_reload_stop");
                return !playingReload && !playingCarbineReload && !playingReloadStart && !playingCarbineReloadStart && !playingReloadLoop && !playingCarbineReloadLoop && !playingReloadStop && !playingCarbineReloadStop;
            }
        }
        return true;
    }

    private boolean canFire(Player player, ItemStack heldItem) {
        if (player.m_5833_()) {
            return false;
        }
        if (player.m_7500_()) {
            return true;
        }
        if (!Gun.hasAmmo(heldItem)) {
            return false;
        }
        Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
        if (gun.getGeneral().getFireMode() == FireMode.PULSE) {
            float chargeProgress = ChargeHandler.getChargeProgress(player, heldItem);
            return chargeProgress > 0.0f;
        }
        return Gun.canShoot(heldItem);
    }

    private boolean canUseTrigger(Player player, ItemStack heldItem) {
        if (player.m_5833_()) {
            return false;
        }
        if (player.m_7500_()) {
            return true;
        }
        return Gun.canShoot(heldItem) || !Gun.hasAmmo(heldItem);
    }

    private boolean isSameWeapon(Player player) {
        if (this.slot == -1) {
            return true;
        }
        return player.m_150109_().f_35977_ == this.slot;
    }

    public boolean isShooting() {
        return this.shooting;
    }
}

