/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.render.gun.animated;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.util.RenderUtils;
import top.ribs.scguns.Config;
import top.ribs.scguns.client.GunRenderType;
import top.ribs.scguns.client.SwayType;
import top.ribs.scguns.client.handler.AimingHandler;
import top.ribs.scguns.client.handler.BeamHandler;
import top.ribs.scguns.client.handler.DualWieldShotTracker;
import top.ribs.scguns.client.handler.GunRecoilHandler;
import top.ribs.scguns.client.handler.GunRenderingHandler;
import top.ribs.scguns.client.handler.ShootingHandler;
import top.ribs.scguns.client.render.gun.IOverrideModel;
import top.ribs.scguns.client.render.gun.ModelOverrides;
import top.ribs.scguns.client.render.gun.animated.AnimatedGunModel;
import top.ribs.scguns.client.render.gun.animated.AttachmentRenderer;
import top.ribs.scguns.client.screen.AttachmentScreen;
import top.ribs.scguns.client.util.PropertyHelper;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.event.GunFireEvent;
import top.ribs.scguns.init.ModItems;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.animated.AnimatedDualWieldGunItem;
import top.ribs.scguns.item.animated.AnimatedGunItem;
import top.ribs.scguns.item.attachment.IAttachment;
import top.ribs.scguns.item.attachment.IBarrel;
import top.ribs.scguns.item.attachment.impl.Barrel;
import top.ribs.scguns.item.attachment.impl.Scope;
import top.ribs.scguns.util.GunModifierHelper;

public class AnimatedGunRenderer
extends GeoItemRenderer<AnimatedGunItem>
implements GeoRenderer<AnimatedGunItem> {
    private static final ResourceLocation custom_path = null;
    private static AnimatedGunRenderer instance;
    private final AttachmentRenderer attachmentRenderer = new AttachmentRenderer(this);
    private MultiBufferSource bufferSource;
    private ItemDisplayContext currentDisplayContext;
    private ItemStack currentRenderStack;
    private float sprintIntensity;
    private float immersiveRoll;
    private float fallSway;
    private float prevFallSway;
    private static final long PARTICLE_COOLDOWN_MS = 100L;
    private long lastParticleSpawnTime = 0L;
    private static final Set<String> ARM_BONE_NAMES;
    private static final Set<String> MAGAZINE_BONE_NAMES;
    private static final Set<Item> CUSTOM_ATTACHMENTS;
    private static final Map<String, BoneType> BONE_TYPE_CACHE;
    private static final Map<String, Boolean> BONE_VISIBILITY_CACHE;
    private static ItemStack lastCachedStack;
    private static int cacheInvalidationTimer;
    private static final int CACHE_DURATION = 20;

    public AnimatedGunRenderer(ResourceLocation path) {
        super((GeoModel)new AnimatedGunModel(path));
        instance = this;
    }

    public static AnimatedGunRenderer get() {
        if (instance == null) {
            instance = new AnimatedGunRenderer(custom_path);
        }
        return instance;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.updateImmersiveCamera();
            if (++cacheInvalidationTimer >= 20) {
                BONE_VISIBILITY_CACHE.clear();
                cacheInvalidationTimer = 0;
            }
        }
    }

    private void updateImmersiveCamera() {
        this.prevFallSway = this.fallSway;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            ItemStack heldItem = mc.f_91074_.m_21205_();
            float targetAngle = !(heldItem.m_41720_() instanceof GunItem) && (Boolean)Config.CLIENT.display.restrictCameraRollToWeapons.get() != false ? 0.0f : mc.f_91074_.f_108618_.f_108566_;
            float speed = mc.f_91074_.f_108618_.f_108566_ != 0.0f ? 0.1f : 0.15f;
            this.immersiveRoll = Mth.m_14179_((float)speed, (float)this.immersiveRoll, (float)targetAngle);
            float deltaY = (float)Mth.m_14008_((double)(mc.f_91074_.f_19855_ - mc.f_91074_.m_20186_()), (double)-1.0, (double)1.0);
            deltaY = (float)((double)deltaY * (1.0 - AimingHandler.get().getNormalisedAdsProgress()));
            deltaY = (float)((double)deltaY * (1.0 - (double)(Mth.m_14154_((float)mc.f_91074_.m_146909_()) / 90.0f)));
            this.fallSway = Mth.m_14121_((float)this.fallSway, (float)(deltaY * 60.0f * ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue()), (float)10.0f);
            float intensity = mc.f_91074_.m_20142_() ? 0.75f : 1.0f;
            this.sprintIntensity = Mth.m_14121_((float)this.sprintIntensity, (float)intensity, (float)0.1f);
        }
    }

    @SubscribeEvent
    public void onGunFire(GunFireEvent.Post event) {
        LivingEntity livingEntity;
        if (event.isClient() && (livingEntity = event.getShooter()) instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack heldItem = event.getStack();
            if (heldItem.m_41720_() instanceof AnimatedDualWieldGunItem) {
                DualWieldShotTracker.get().incrementShotCount(player.m_19879_());
            }
        }
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        this.currentDisplayContext = transformType;
        this.currentRenderStack = stack;
        this.bufferSource = bufferSource;
        if (!ItemStack.m_41728_((ItemStack)lastCachedStack, (ItemStack)stack)) {
            BONE_VISIBILITY_CACHE.clear();
            lastCachedStack = stack.m_41777_();
        }
        if (stack.m_41720_() instanceof AnimatedGunItem && transformType == ItemDisplayContext.NONE && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            this.currentDisplayContext = ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
        }
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        boolean right = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? player.m_7655_() == InteractionHand.MAIN_HAND : player.m_7655_() == InteractionHand.OFF_HAND;
        ItemStack overrideModel = ItemStack.f_41583_;
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_("Model", 10)) {
            overrideModel = ItemStack.m_41712_((CompoundTag)stack.m_41783_().m_128469_("Model"));
        }
        LocalPlayer localPlayer = Objects.requireNonNull(client.f_91074_);
        BakedModel model = client.m_91291_().m_174264_(overrideModel.m_41619_() ? stack : overrideModel, player.m_9236_(), (LivingEntity)player, 0);
        ItemTransform firstPersonTransform = model.m_7442_().f_111790_;
        float scaleX = firstPersonTransform.f_111757_.x();
        float scaleY = firstPersonTransform.f_111757_.y();
        float scaleZ = firstPersonTransform.f_111757_.z();
        float translateX = firstPersonTransform.f_111756_.x();
        float translateY = firstPersonTransform.f_111756_.y();
        float translateZ = firstPersonTransform.f_111756_.z();
        if (stack.m_41720_() instanceof AnimatedGunItem && transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            Gun modifiedGun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
            if (AimingHandler.get().getNormalisedAdsProgress() > 0.0 && modifiedGun.canAimDownSight()) {
                this.applyAdsTransforms(poseStack, stack, modifiedGun, scaleX, scaleY, scaleZ, translateX, translateY, translateZ, (Player)player);
            }
            this.applyBobbingTransforms(poseStack, client.getPartialTick());
            int offset = right ? 1 : -1;
            this.applyRecoilTransforms(poseStack, stack, modifiedGun);
            this.applyAimingTransforms(poseStack, stack, modifiedGun, translateX, translateY, translateZ, offset);
            this.applySwayTransforms(poseStack, modifiedGun, stack, localPlayer, translateX, translateY, translateZ, client.getPartialTick());
            if (ShootingHandler.get().isShooting() && !GunModifierHelper.isSilencedFire(stack)) {
                this.renderMuzzleFlash((LivingEntity)client.f_91074_, poseStack, bufferSource, stack, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, client.getPartialTick());
            }
        }
        int blockLight = this.calculateBlockLight((Player)player, stack);
        packedLight = transformType == ItemDisplayContext.GUI ? LightTexture.m_109885_((int)12, (int)12) : LightTexture.m_109885_((int)blockLight, (int)player.m_9236_().m_45517_(LightLayer.SKY, BlockPos.m_274446_((Position)player.m_20299_(client.getPartialTick()))));
        super.m_108829_(stack, transformType, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private void applyAdsTransforms(PoseStack poseStack, ItemStack stack, Gun modifiedGun, float scaleX, float scaleY, float scaleZ, float translateX, float translateY, float translateZ, Player player) {
        double xOffset = (double)translateX - 0.5 * (double)scaleX;
        double yOffset = (double)translateY - 0.5 * (double)scaleY;
        double zOffset = (double)translateZ - 0.5 * (double)scaleZ;
        Vec3 gunOrigin = PropertyHelper.getModelOrigin(stack, PropertyHelper.GUN_DEFAULT_ORIGIN);
        xOffset += gunOrigin.f_82479_ * 0.0625 * (double)scaleX;
        yOffset += gunOrigin.f_82480_ * 0.0625 * (double)scaleY;
        zOffset += gunOrigin.f_82481_ * 0.0625 * (double)scaleZ;
        Scope scope = Gun.getScope(stack);
        if (modifiedGun.canAttachType(IAttachment.Type.SCOPE) && scope != null) {
            Vec3 ironSightCamera = PropertyHelper.getAttachmentPosition(stack, modifiedGun, IAttachment.Type.SCOPE).m_82546_(gunOrigin);
            xOffset += ironSightCamera.f_82479_ * 0.0625 * (double)scaleX;
            yOffset += ironSightCamera.f_82480_ * 0.0625 * (double)scaleY;
            zOffset += ironSightCamera.f_82481_ * 0.0625 * (double)scaleZ;
            ItemStack scopeStack = Gun.getScopeStack(stack);
            Vec3 scopeOrigin = PropertyHelper.getModelOrigin(scopeStack, PropertyHelper.ATTACHMENT_DEFAULT_ORIGIN);
            Vec3 scopeCamera = PropertyHelper.getScopeCamera(scopeStack).m_82546_(scopeOrigin);
            Vec3 scopeScale = PropertyHelper.getAttachmentScale(stack, modifiedGun, IAttachment.Type.SCOPE);
            xOffset += scopeCamera.f_82479_ * 0.0625 * (double)scaleX * scopeScale.f_82479_;
            yOffset += (scopeCamera.f_82480_ * 0.0625 * (double)scaleY + 0.54) * scopeScale.f_82480_;
            zOffset += (scopeCamera.f_82481_ * 0.0625 * (double)scaleZ - 0.16) * scopeScale.f_82481_;
        } else {
            Vec3 ironSightCamera = PropertyHelper.getIronSightCamera(stack, modifiedGun, gunOrigin).m_82546_(gunOrigin);
            xOffset += ironSightCamera.f_82479_ * 0.0625 * (double)scaleX;
            yOffset += ironSightCamera.f_82480_ * 0.0625 * (double)scaleY + 0.6059;
            zOffset += ironSightCamera.f_82481_ * 0.0625 * (double)scaleZ - 0.16;
            if (PropertyHelper.isLegacyIronSight(stack)) {
                zOffset += 0.72;
            }
        }
        float side = 1.0f;
        double time = AimingHandler.get().getNormalisedAdsProgress();
        double transition = PropertyHelper.getSightAnimations(stack, modifiedGun).getSightCurve().apply(time);
        poseStack.m_85837_(-0.56 * (double)side * transition, 0.52 * transition, 0.72 * transition);
        poseStack.m_85837_(-xOffset * (double)side * transition, -yOffset * transition, -zOffset * transition);
    }

    private int calculateBlockLight(Player player, ItemStack stack) {
        int blockLight;
        int n = blockLight = player.m_6060_() ? 15 : player.m_9236_().m_45517_(LightLayer.BLOCK, BlockPos.m_274446_((Position)player.m_20299_(Minecraft.m_91087_().getPartialTick())));
        if (ShootingHandler.get().isShooting() && !GunModifierHelper.isSilencedFire(stack)) {
            blockLight += GunRenderingHandler.entityIdForMuzzleFlash.contains(player.m_19879_()) ? 3 : 0;
        }
        return Math.min(blockLight, 15);
    }

    private boolean shouldRenderArms() {
        if (!((Boolean)Config.CLIENT.display.renderArms.get()).booleanValue()) {
            return false;
        }
        if (this.currentRenderStack == null) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return false;
        }
        if (mc.f_91080_ instanceof AttachmentScreen) {
            return false;
        }
        if (this.currentDisplayContext != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND && this.currentDisplayContext != ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
            return false;
        }
        if (mc.f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return false;
        }
        return !mc.f_91074_.m_5833_() && mc.f_91074_.m_6084_();
    }

    private BoneType getBoneType(String boneName) {
        return BONE_TYPE_CACHE.computeIfAbsent(boneName, name -> {
            if (ARM_BONE_NAMES.contains(name)) {
                return BoneType.ARM;
            }
            switch (name) {
                case "cogloader_magazine": {
                    return BoneType.COGLOADER_MAGAZINE;
                }
                case "cylinder_magazine": {
                    return BoneType.CYLINDER_MAGAZINE;
                }
                case "crank_magazine": {
                    return BoneType.CRANK_MAGAZINE;
                }
                case "sliding_magazine": {
                    return BoneType.SLIDING_MAGAZINE;
                }
                case "laser_origin": {
                    return BoneType.LASER_ORIGIN;
                }
                case "seal": {
                    return BoneType.SEAL;
                }
                case "attachment_bone": {
                    return BoneType.ATTACHMENT;
                }
                case "glow": 
                case "glow_2": 
                case "glow_3": 
                case "glow_4": 
                case "glow_5": 
                case "glow_6": {
                    return BoneType.GLOW;
                }
            }
            if (MAGAZINE_BONE_NAMES.stream().anyMatch(name::contains)) {
                return BoneType.MAGAZINE;
            }
            return BoneType.REGULAR;
        });
    }

    public void renderRecursively(PoseStack poseStack, AnimatedGunItem animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        BoneType boneType = this.getBoneType(bone.getName());
        Minecraft client = Minecraft.m_91087_();
        boolean shouldRenderCustomArms = false;
        poseStack.m_85836_();
        switch (boneType) {
            case COGLOADER_MAGAZINE: {
                this.handleCogloaderMagazine(poseStack, bone, animatable);
                break;
            }
            case CYLINDER_MAGAZINE: {
                this.handleCylinderMagazine(poseStack, bone, animatable);
                break;
            }
            case CRANK_MAGAZINE: {
                this.handleCrankMagazine(poseStack, bone, animatable);
                break;
            }
            case SLIDING_MAGAZINE: {
                this.handleSlidingMagazine(poseStack, bone);
            }
        }
        if (boneType == BoneType.ARM) {
            if (this.currentDisplayContext != ItemDisplayContext.GUI) {
                boolean shouldRender = this.shouldRenderArms();
                bone.setHidden(true);
                bone.setChildrenHidden(true);
                if (shouldRender) {
                    shouldRenderCustomArms = true;
                }
            } else {
                bone.setHidden(true);
                bone.setChildrenHidden(true);
            }
        } else if (boneType == BoneType.SEAL) {
            boolean hidden = (Boolean)Config.CLIENT.display.puritySeals.get() == false;
            bone.setHidden(hidden);
            bone.setChildrenHidden(hidden);
        } else {
            this.handleBoneVisibility(bone);
        }
        if (shouldRenderCustomArms && client.f_91074_ != null) {
            this.renderPlayerArms(client, poseStack, bone, animatable, packedLight, packedOverlay);
        }
        if (boneType == BoneType.ATTACHMENT) {
            this.renderAttachments(bone, this.currentRenderStack, poseStack, renderType, buffer, packedLight, client.getPartialTick(), packedOverlay);
        }
        if (boneType == BoneType.GLOW) {
            packedLight = 0xF000F0;
        }
        super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, this.bufferSource.m_6299_(renderType), isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    private void handleCogloaderMagazine(PoseStack poseStack, GeoBone bone, AnimatedGunItem animatable) {
        float pivotX = bone.getPivotX() * 0.0625f;
        float pivotY = bone.getPivotY() * 0.0625f;
        float pivotZ = bone.getPivotZ() * 0.0625f;
        poseStack.m_252880_(pivotX, pivotY, pivotZ);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(animatable.getRotationHandler().getCurrentMagazineRotation()));
        poseStack.m_252880_(-pivotX, -pivotY, -pivotZ);
    }

    private void handleCylinderMagazine(PoseStack poseStack, GeoBone bone, AnimatedGunItem animatable) {
        float pivotX = bone.getPivotX() * 0.0625f;
        float pivotY = bone.getPivotY() * 0.0625f;
        float pivotZ = bone.getPivotZ() * 0.0625f;
        poseStack.m_252880_(pivotX, pivotY, pivotZ);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(animatable.getRotationHandler().getCurrentCylinderRotation()));
        poseStack.m_252880_(-pivotX, -pivotY, -pivotZ);
    }

    private void handleCrankMagazine(PoseStack poseStack, GeoBone bone, AnimatedGunItem animatable) {
        float pivotX = bone.getPivotX() * 0.0625f;
        float pivotY = bone.getPivotY() * 0.0625f;
        float pivotZ = bone.getPivotZ() * 0.0625f;
        poseStack.m_252880_(pivotX, pivotY, pivotZ);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(animatable.getRotationHandler().getCurrentCylinderRotation()));
        poseStack.m_252880_(-pivotX, -pivotY, -pivotZ);
    }

    private void handleSlidingMagazine(PoseStack poseStack, GeoBone bone) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && ((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)mc.f_91074_)).booleanValue()) {
            return;
        }
        float maxAmmo = Gun.getMaxAmmo(this.currentRenderStack);
        float currentAmmo = Gun.getAmmoCount(this.currentRenderStack);
        if (maxAmmo > 0.0f) {
            float slidePosition = Math.min((maxAmmo - currentAmmo) / maxAmmo, 1.0f);
            poseStack.m_252880_(slidePosition * 0.25f, 0.0f, 0.0f);
        }
    }

    private void handleBoneVisibility(GeoBone bone) {
        String boneName = bone.getName();
        String cacheKey = boneName + ":" + (this.currentItemStack != null ? this.currentItemStack.hashCode() : 0);
        Boolean cachedVisibility = BONE_VISIBILITY_CACHE.get(cacheKey);
        if (cachedVisibility != null) {
            bone.setHidden(cachedVisibility.booleanValue());
            return;
        }
        boolean hidden = this.calculateBoneVisibility(boneName);
        BONE_VISIBILITY_CACHE.put(cacheKey, hidden);
        bone.setHidden(hidden);
    }

    private boolean calculateBoneVisibility(String boneName) {
        return switch (boneName) {
            case "sights" -> {
                if (Gun.getScope(this.currentItemStack) != null) {
                    yield true;
                }
                yield false;
            }
            case "no_sights" -> {
                if (Gun.getScope(this.currentItemStack) == null) {
                    yield true;
                }
                yield false;
            }
            case "wooden_stock" -> {
                if (Gun.getAttachment(IAttachment.Type.STOCK, this.currentItemStack).m_41720_() != ModItems.WOODEN_STOCK.get()) {
                    yield true;
                }
                yield false;
            }
            case "light_stock" -> {
                if (Gun.getAttachment(IAttachment.Type.STOCK, this.currentItemStack).m_41720_() != ModItems.LIGHT_STOCK.get()) {
                    yield true;
                }
                yield false;
            }
            case "weighted_stock" -> {
                ItemStack stockAttachment = Gun.getAttachment(IAttachment.Type.STOCK, this.currentItemStack);
                if (stockAttachment.m_41720_() != ModItems.WEIGHTED_STOCK.get() && stockAttachment.m_41720_() != ModItems.BUMP_STOCK.get()) {
                    yield true;
                }
                yield false;
            }
            case "standard_stock", "standard_grip" -> {
                if (!Gun.getAttachment(IAttachment.Type.STOCK, this.currentItemStack).m_41619_()) {
                    yield true;
                }
                yield false;
            }
            case "standard_barrel", "standard_barrel1", "extended_barrel", "extended_barrel1", "silencer", "silencer1", "advanced_silencer", "advanced_silencer1", "muzzle_brake", "muzzle_brake1" -> this.handleBarrelVisibility(boneName);
            default -> boneName.contains("grip") || boneName.contains("bayonet") ? this.handleUnderBarrelVisibility(boneName) : (boneName.contains("mag") ? this.handleMagazineVisibility(boneName) : false);
        };
    }

    private boolean handleBarrelVisibility(String boneName) {
        ItemStack barrelAttachment = Gun.getAttachment(IAttachment.Type.BARREL, this.currentItemStack);
        return switch (boneName) {
            case "standard_barrel", "standard_barrel1" -> {
                if (barrelAttachment.m_41720_() == ModItems.EXTENDED_BARREL.get()) {
                    yield true;
                }
                yield false;
            }
            case "extended_barrel", "extended_barrel1" -> {
                if (barrelAttachment.m_41720_() != ModItems.EXTENDED_BARREL.get()) {
                    yield true;
                }
                yield false;
            }
            case "silencer", "silencer1" -> {
                if (barrelAttachment.m_41720_() != ModItems.SILENCER.get()) {
                    yield true;
                }
                yield false;
            }
            case "advanced_silencer", "advanced_silencer1" -> {
                if (barrelAttachment.m_41720_() != ModItems.ADVANCED_SILENCER.get()) {
                    yield true;
                }
                yield false;
            }
            case "muzzle_brake", "muzzle_brake1" -> {
                if (barrelAttachment.m_41720_() != ModItems.MUZZLE_BRAKE.get()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean handleUnderBarrelVisibility(String boneName) {
        ItemStack underBarrelAttachment = Gun.getAttachment(IAttachment.Type.UNDER_BARREL, this.currentItemStack);
        Item attachmentItem = underBarrelAttachment.m_41720_();
        return switch (boneName) {
            case "light_grip" -> {
                if (attachmentItem != ModItems.LIGHT_GRIP.get()) {
                    yield true;
                }
                yield false;
            }
            case "vertical_grip" -> {
                if (attachmentItem != ModItems.VERTICAL_GRIP.get()) {
                    yield true;
                }
                yield false;
            }
            case "iron_bayonet" -> {
                if (attachmentItem != ModItems.IRON_BAYONET.get()) {
                    yield true;
                }
                yield false;
            }
            case "anthralite_bayonet" -> {
                if (attachmentItem != ModItems.ANTHRALITE_BAYONET.get()) {
                    yield true;
                }
                yield false;
            }
            case "diamond_bayonet" -> {
                if (attachmentItem != ModItems.DIAMOND_BAYONET.get()) {
                    yield true;
                }
                yield false;
            }
            case "netherite_bayonet" -> {
                if (attachmentItem != ModItems.NETHERITE_BAYONET.get()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean handleMagazineVisibility(String boneName) {
        ItemStack magazineAttachment = Gun.getAttachment(IAttachment.Type.MAGAZINE, this.currentItemStack);
        return switch (boneName) {
            case "standard_mag", "default_mag", "standard_mag_2", "default_mag_2" -> {
                if (!magazineAttachment.m_41619_()) {
                    yield true;
                }
                yield false;
            }
            case "extended_mag", "extended_mag_2" -> {
                if (magazineAttachment.m_41720_() != ModItems.EXTENDED_MAG.get()) {
                    yield true;
                }
                yield false;
            }
            case "speed_mag", "speed_mag_2" -> {
                if (magazineAttachment.m_41720_() != ModItems.SPEED_MAG.get()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private void renderPlayerArms(Minecraft client, PoseStack poseStack, GeoBone bone, AnimatedGunItem animatable, int packedLight, int packedOverlay) {
        if (client.f_91074_ == null) {
            return;
        }
        PlayerRenderer playerEntityRenderer = (PlayerRenderer)client.m_91290_().m_114382_((Entity)client.f_91074_);
        PlayerModel playerEntityModel = (PlayerModel)playerEntityRenderer.m_7200_();
        this.setupArmTransforms(poseStack, bone);
        ResourceLocation playerSkin = client.f_91074_.m_108560_();
        VertexConsumer arm = this.bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)playerSkin));
        VertexConsumer sleeve = this.bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)playerSkin));
        if (this.isRightArm(bone)) {
            this.renderRightArm(poseStack, (PlayerModel<AbstractClientPlayer>)playerEntityModel, arm, sleeve, bone, packedLight, packedOverlay);
        } else {
            this.renderLeftArm(poseStack, (PlayerModel<AbstractClientPlayer>)playerEntityModel, arm, sleeve, bone, packedLight, packedOverlay, (Player)client.f_91074_, animatable);
        }
    }

    private void setupArmTransforms(PoseStack poseStack, GeoBone bone) {
        RenderUtils.translateMatrixToBone((PoseStack)poseStack, (CoreGeoBone)bone);
        RenderUtils.translateToPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
        RenderUtils.rotateMatrixAroundBone((PoseStack)poseStack, (CoreGeoBone)bone);
        RenderUtils.scaleMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
        RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
    }

    private boolean isRightArm(GeoBone bone) {
        String boneName = bone.getName();
        return !boneName.equals("fake_left_arm") && (boneName.equals("right_arm") || boneName.equals("fake_right_arm"));
    }

    private void renderRightArm(PoseStack poseStack, PlayerModel<AbstractClientPlayer> playerEntityModel, VertexConsumer arm, VertexConsumer sleeve, GeoBone bone, int packedLight, int packedOverlay) {
        poseStack.m_85841_(0.66f, 0.78f, 0.66f);
        poseStack.m_85837_(0.25, -0.1, 0.1625);
        playerEntityModel.f_102811_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
        playerEntityModel.f_102811_.m_171327_(0.0f, 0.0f, 0.0f);
        playerEntityModel.f_102811_.m_104306_(poseStack, arm, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        playerEntityModel.f_103375_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
        playerEntityModel.f_103375_.m_171327_(0.0f, 0.0f, 0.0f);
        playerEntityModel.f_103375_.m_104306_(poseStack, sleeve, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderLeftArm(PoseStack poseStack, PlayerModel<AbstractClientPlayer> playerEntityModel, VertexConsumer arm, VertexConsumer sleeve, GeoBone bone, int packedLight, int packedOverlay, Player player, AnimatedGunItem animatable) {
        Gun modifiedGun = ((GunItem)this.currentItemStack.m_41720_()).getModifiedGun(this.currentItemStack);
        modifiedGun.determineGripType(this.currentItemStack);
        long id = GeoItem.getId((ItemStack)player.m_21205_());
        AnimationController animationController = (AnimationController)animatable.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
        this.checkAndHandleAnimations((AnimationController<GeoAnimatable>)animationController);
        poseStack.m_85841_(0.66f, 0.79f, 0.66f);
        poseStack.m_85837_(-0.25, -0.1, 0.1625);
        playerEntityModel.f_102812_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
        playerEntityModel.f_102812_.m_171327_(0.0f, 0.0f, 0.0f);
        playerEntityModel.f_102812_.m_104306_(poseStack, arm, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        playerEntityModel.f_103374_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
        playerEntityModel.f_103374_.m_171327_(0.0f, 0.0f, 0.0f);
        playerEntityModel.f_103374_.m_104306_(poseStack, sleeve, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void checkAndHandleAnimations(AnimationController<GeoAnimatable> animationController) {
        String animName;
        if (!(animationController == null || animationController.getCurrentAnimation() == null || (animName = animationController.getCurrentAnimation().animation().name()).equals("draw") || animName.equals("reload") || animName.equals("reload_start") || animName.equals("reload_loop"))) {
            animationController.getCurrentAnimation();
        }
    }

    private void applyRecoilTransforms(PoseStack poseStack, ItemStack item, Gun gun) {
        float recoilReduction;
        float kickReduction;
        double recoilNormal = GunRecoilHandler.get().getGunRecoilNormal();
        if (Gun.hasAttachmentEquipped(item, gun, IAttachment.Type.SCOPE)) {
            recoilNormal -= recoilNormal * 0.5 * AimingHandler.get().getNormalisedAdsProgress();
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            kickReduction = 1.0f - GunModifierHelper.getKickReduction((Player)mc.f_91074_, item);
            recoilReduction = 1.0f - GunModifierHelper.getRecoilModifier((Player)mc.f_91074_, item);
        } else {
            kickReduction = 1.0f - GunModifierHelper.getKickReduction(item);
            recoilReduction = 1.0f - GunModifierHelper.getRecoilModifier(item);
        }
        double kick = (double)gun.getGeneral().getRecoilKick() * 0.0625 * recoilNormal * GunRecoilHandler.get().getAdsRecoilReduction(gun);
        float recoilLift = (float)((double)gun.getGeneral().getRecoilAngle() * recoilNormal) * (float)GunRecoilHandler.get().getAdsRecoilReduction(gun);
        float recoilSwayAmount = (float)(2.0 + (1.0 - AimingHandler.get().getNormalisedAdsProgress()));
        float recoilSway = (float)((double)(GunRecoilHandler.get().getGunRecoilRandom() * recoilSwayAmount - recoilSwayAmount / 2.0f) * recoilNormal);
        poseStack.m_85837_(0.0, 0.0, kick * (double)kickReduction);
        poseStack.m_85837_(0.0, 0.0, 0.15);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(recoilSway * recoilReduction / 5.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(recoilSway * recoilReduction / 5.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(recoilLift * recoilReduction / 5.0f));
        poseStack.m_85837_(0.0, 0.0, -0.15);
    }

    private void applyBobbingTransforms(PoseStack poseStack, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        if (!((Boolean)mc.f_91066_.m_231830_().m_231551_()).booleanValue()) {
            return;
        }
        Entity entity = mc.m_91288_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        float deltaDistanceWalked = player.f_19787_ - player.f_19867_;
        float distanceWalked = -(player.f_19787_ + deltaDistanceWalked * partialTicks);
        float bobbing = Mth.m_14179_((float)partialTicks, (float)player.f_36099_, (float)player.f_36100_);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-(Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI - 0.2f)) * bobbing) * 5.0f)));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(-(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * bobbing * 3.0f)));
        poseStack.m_85837_((double)(-(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * bobbing * 0.5f)), (double)Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI)) * bobbing), 0.0);
        bobbing *= (float)(player.m_20142_() ? 8.0 : 4.0);
        bobbing *= ((Double)Config.CLIENT.display.bobbingIntensity.get()).floatValue();
        double invertZoomProgress = 1.0 - AimingHandler.get().getNormalisedAdsProgress() * (double)this.sprintIntensity;
        if (!AimingHandler.get().isAiming()) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI - 0.2f)) * bobbing) * -2.0f * (float)invertZoomProgress));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * bobbing * 3.0f * (float)invertZoomProgress));
        }
    }

    private void applyAimingTransforms(PoseStack poseStack, ItemStack stack, Gun modifiedGun, float x, float y, float z, int offset) {
        poseStack.m_252880_(x * (float)offset, y, z);
        poseStack.m_85837_(0.0, -0.25, 0.25);
        float aiming = (float)Math.sin(Math.toRadians(AimingHandler.get().getNormalisedAdsProgress() * 180.0));
        aiming = PropertyHelper.getSightAnimations(stack, modifiedGun).getAimTransformCurve().apply(aiming / 2.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(aiming * 10.0f * (float)offset));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(aiming * 8.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(aiming * 8.0f * (float)offset));
        poseStack.m_85837_(0.0, 0.25, -0.25);
        poseStack.m_252880_(-x * (float)offset, -y, -z);
    }

    private void applySwayTransforms(PoseStack poseStack, Gun modifiedGun, ItemStack stack, LocalPlayer player, float x, float y, float z, float partialTicks) {
        if (!((Boolean)Config.CLIENT.display.weaponSway.get()).booleanValue() || player == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, z);
        double zOffset = modifiedGun.determineGripType(stack).heldAnimation().getFallSwayZOffset();
        poseStack.m_85837_(0.0, -0.25, zOffset);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)this.prevFallSway, (float)this.fallSway)));
        poseStack.m_85837_(0.0, 0.25, -zOffset);
        float bobPitch = Mth.m_14189_((float)partialTicks, (float)player.f_108588_, (float)player.f_108586_);
        float headPitch = Mth.m_14189_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_());
        float swayPitch = headPitch - bobPitch;
        float adsProgress = (float)AimingHandler.get().getNormalisedAdsProgress();
        float pitchSensitivity = ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue();
        poseStack.m_252781_(((SwayType)((Object)Config.CLIENT.display.swayType.get())).getPitchRotation().m_252977_((swayPitch *= 1.0f - 0.5f * adsProgress) * pitchSensitivity));
        float bobYaw = Mth.m_14189_((float)partialTicks, (float)player.f_108587_, (float)player.f_108585_);
        float headYaw = Mth.m_14189_((float)partialTicks, (float)player.f_20886_, (float)player.f_20885_);
        float swayYaw = headYaw - bobYaw;
        float yawSensitivity = ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue();
        poseStack.m_252781_(((SwayType)((Object)Config.CLIENT.display.swayType.get())).getYawRotation().m_252977_((swayYaw *= 1.0f - 0.5f * adsProgress) * yawSensitivity));
        poseStack.m_252880_(-x, -y, -z);
        poseStack.m_85849_();
    }

    private void renderAttachments(GeoBone bone, ItemStack stack, PoseStack poseStack, RenderType renderType, VertexConsumer renderTypeBuffer, int light, float partialTicks, int packedOverlay) {
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        Gun modifiedGun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
        CompoundTag gunTag = stack.m_41784_();
        CompoundTag attachments = gunTag.m_128469_("Attachments");
        for (String tagKey : attachments.m_128431_()) {
            ItemStack attachmentStack;
            IAttachment.Type type = IAttachment.Type.byTagKey(tagKey);
            if (type == null || !modifiedGun.canAttachType(type) || CUSTOM_ATTACHMENTS.contains((attachmentStack = Gun.getAttachment(type, stack)).m_41720_()) || attachmentStack.m_41619_()) continue;
            this.renderSingleAttachment(bone, stack, attachmentStack, type, modifiedGun, poseStack, renderType, renderTypeBuffer, light, partialTicks, packedOverlay);
        }
    }

    private void renderSingleAttachment(GeoBone bone, ItemStack stack, ItemStack attachmentStack, IAttachment.Type type, Gun modifiedGun, PoseStack poseStack, RenderType renderType, VertexConsumer renderTypeBuffer, int light, float partialTicks, int packedOverlay) {
        poseStack.m_85836_();
        Vec3 origin = PropertyHelper.getModelOrigin(attachmentStack, PropertyHelper.ATTACHMENT_DEFAULT_ORIGIN);
        Vec3 gunOrigin = PropertyHelper.getModelOrigin(stack, PropertyHelper.GUN_DEFAULT_ORIGIN);
        Vec3 translation = PropertyHelper.getAttachmentPosition(stack, modifiedGun, type).m_82546_(gunOrigin);
        Vec3 scale = PropertyHelper.getAttachmentScale(stack, modifiedGun, type);
        Vec3 center = origin.m_82492_(8.0, 8.0, 8.0).m_82490_(0.0625);
        poseStack.m_85837_(-origin.f_82479_ * 0.0625, -origin.f_82480_ * 0.0625, -origin.f_82481_ * 0.0625);
        poseStack.m_85837_(gunOrigin.f_82479_ * 0.0625, gunOrigin.f_82480_ * 0.0625, gunOrigin.f_82481_ * 0.0625);
        poseStack.m_85837_(translation.f_82479_ * 0.0625, translation.f_82480_ * 0.0625, translation.f_82481_ * 0.0625);
        poseStack.m_85837_(center.f_82479_, center.f_82480_, center.f_82481_);
        poseStack.m_85841_((float)scale.f_82479_, (float)scale.f_82480_, (float)scale.f_82481_);
        poseStack.m_85837_(-center.f_82479_, -center.f_82480_, -center.f_82481_);
        IOverrideModel overrideModel = ModelOverrides.getModel(attachmentStack);
        if (overrideModel != null) {
            overrideModel.render(partialTicks, ItemDisplayContext.NONE, attachmentStack, stack, (LivingEntity)Minecraft.m_91087_().f_91074_, poseStack, this.bufferSource, light, OverlayTexture.f_118083_);
        } else {
            this.attachmentRenderer.updateAttachment(attachmentStack);
            this.attachmentRenderer.renderForBone(poseStack, (AnimatedGunItem)this.animatable, bone, renderType, this.bufferSource, renderTypeBuffer, partialTicks, light, packedOverlay);
        }
        poseStack.m_85849_();
    }

    private void renderMuzzleFlash(@Nullable LivingEntity entity, PoseStack poseStack, MultiBufferSource buffer, ItemStack weapon, ItemDisplayContext display, float partialTicks) {
        Gun modifiedGun = ((GunItem)weapon.m_41720_()).getModifiedGun(weapon);
        Gun.Display.Flash flash = modifiedGun.getDisplay().getFlash();
        if (flash == null) {
            return;
        }
        if (display != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND && display != ItemDisplayContext.THIRD_PERSON_RIGHT_HAND && display != ItemDisplayContext.FIRST_PERSON_LEFT_HAND && display != ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            return;
        }
        if (entity == null) {
            return;
        }
        boolean isBeamActive = BeamHandler.activeBeams.containsKey(entity.m_20148_());
        if (!isBeamActive && !GunRenderingHandler.entityIdForMuzzleFlash.contains(entity.m_19879_())) {
            return;
        }
        float randomValue = GunRenderingHandler.entityIdToRandomValue.getOrDefault(entity.m_19879_(), Float.valueOf(0.0f)).floatValue();
        boolean mirror = DualWieldShotTracker.get().shouldUseAlternateAnimation(entity.m_19879_()) && flash.hasAlternateMuzzleFlash();
        ResourceLocation flashTexture = new ResourceLocation("scguns", "textures/effect/" + flash.getTextureLocation() + ".png");
        this.drawMuzzleFlash(weapon, modifiedGun, randomValue, mirror, poseStack, buffer, partialTicks, flashTexture, entity);
        if (flash.shouldSpawnParticles() && flash.getParticleType() != null) {
            this.spawnParticles(flash, entity);
        }
    }

    private void spawnParticles(Gun.Display.Flash flash, LivingEntity entity) {
        if (entity == null || !entity.m_9236_().m_5776_()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastParticleSpawnTime < 100L) {
            return;
        }
        this.lastParticleSpawnTime = currentTime;
        ClientLevel world = (ClientLevel)entity.m_9236_();
        RandomSource random = entity.m_217043_();
        double posX = entity.m_20185_();
        double posY = entity.m_20186_() + (double)entity.m_20192_();
        double posZ = entity.m_20189_();
        SimpleParticleType particleType = flash.getParticleType();
        double radius = flash.getParticleRingRadius();
        if (radius > 0.0) {
            for (int i = 0; i < flash.getParticleCount(); ++i) {
                double angle = random.m_188500_() * 2.0 * Math.PI;
                double randomizedRadius = radius * (0.8 + random.m_188500_() * 0.4);
                double offsetX = Math.cos(angle) * randomizedRadius;
                double offsetZ = Math.sin(angle) * randomizedRadius;
                double spread = flash.getParticleSpread();
                double offsetY = (random.m_188500_() - 0.5) * spread;
                double motionStrength = 0.03 + random.m_188500_() * 0.02;
                double motionX = (offsetX += (random.m_188500_() - 0.5) * spread * 0.5) * motionStrength;
                double motionY = offsetY * motionStrength + 0.01;
                double motionZ = (offsetZ += (random.m_188500_() - 0.5) * spread * 0.5) * motionStrength;
                world.m_7106_((ParticleOptions)particleType, posX + offsetX, posY + offsetY, posZ + offsetZ, motionX, motionY, motionZ);
            }
        } else {
            for (int i = 0; i < flash.getParticleCount(); ++i) {
                double spread = flash.getParticleSpread();
                double offsetX = (random.m_188500_() - 0.5) * spread;
                double offsetY = (random.m_188500_() - 0.5) * spread;
                double offsetZ = (random.m_188500_() - 0.5) * spread;
                world.m_7106_((ParticleOptions)particleType, posX + offsetX, posY + offsetY, posZ + offsetZ, offsetX * 0.1, offsetY * 0.1, offsetZ * 0.1);
            }
        }
    }

    private void drawMuzzleFlash(ItemStack weapon, Gun modifiedGun, float random, boolean mirror, PoseStack poseStack, MultiBufferSource buffer, float partialTicks, ResourceLocation flashTexture, LivingEntity entity) {
        Item item;
        if (!PropertyHelper.hasMuzzleFlash(weapon, modifiedGun)) {
            return;
        }
        Gun.Display.Flash flash = modifiedGun.getDisplay().getFlash();
        if (flash == null) {
            return;
        }
        poseStack.m_85836_();
        int shotCount = DualWieldShotTracker.get().getShotCount(entity.m_19879_());
        Vec3 weaponOrigin = PropertyHelper.getModelOrigin(weapon, PropertyHelper.GUN_DEFAULT_ORIGIN);
        Vec3 flashPosition = PropertyHelper.getMuzzleFlashPosition(weapon, modifiedGun).m_82546_(weaponOrigin);
        if (shotCount % 2 == 1 && flash.hasAlternateMuzzleFlash()) {
            Vec3 alternatePos = flash.getAlternatePosition();
            flashPosition = flashPosition.m_82520_(alternatePos.f_82479_ * 0.0625, alternatePos.f_82480_ * 0.0625, alternatePos.f_82481_ * 0.0625);
        }
        poseStack.m_85837_(weaponOrigin.f_82479_ * 0.0625, weaponOrigin.f_82480_ * 0.0625, weaponOrigin.f_82481_ * 0.0625);
        poseStack.m_85837_(flashPosition.f_82479_ * 0.0625 + 0.575, flashPosition.f_82480_ * 0.0625 + 1.08, flashPosition.f_82481_ * 0.0625);
        if (AimingHandler.get().isAiming()) {
            poseStack.m_85837_(-0.075, 0.0, 0.0);
        }
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        ItemStack barrelStack = Gun.getAttachment(IAttachment.Type.BARREL, weapon);
        if (!barrelStack.m_41619_() && (item = barrelStack.m_41720_()) instanceof IBarrel) {
            IBarrel barrel = (IBarrel)item;
            if (!PropertyHelper.isUsingBarrelMuzzleFlash(barrelStack)) {
                Vec3 scale = PropertyHelper.getAttachmentScale(weapon, modifiedGun, IAttachment.Type.BARREL);
                double length = ((Barrel)barrel.getProperties()).getLength();
                poseStack.m_85837_(0.0, 0.0, -length * 0.0625 * scale.f_82481_);
            }
        }
        poseStack.m_252781_(Axis.f_252403_.m_252977_(360.0f * random));
        if (mirror) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        }
        Vec3 flashScale = PropertyHelper.getMuzzleFlashScale(weapon, modifiedGun);
        float scaleX = (float)flashScale.f_82479_ / 2.0f - (float)flashScale.f_82479_ / 2.0f * (1.0f - partialTicks);
        float scaleY = (float)flashScale.f_82480_ / 2.0f - (float)flashScale.f_82480_ / 2.0f * (1.0f - partialTicks);
        poseStack.m_85841_(scaleX * 2.0f, scaleY * 2.0f, 1.0f);
        float scaleModifier = (float)GunModifierHelper.getMuzzleFlashScale(weapon, 1.0);
        poseStack.m_85841_(scaleModifier, scaleModifier, 1.0f);
        poseStack.m_85837_(-0.5, -0.5, 0.0);
        this.renderFlashQuad(poseStack, buffer, weapon, flashTexture);
        poseStack.m_85849_();
    }

    private void renderFlashQuad(PoseStack poseStack, MultiBufferSource buffer, ItemStack weapon, ResourceLocation flashTexture) {
        float minU = weapon.m_41793_() ? 0.5f : 0.0f;
        float maxU = weapon.m_41793_() ? 1.0f : 0.5f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        VertexConsumer builder = buffer.m_6299_(GunRenderType.getMuzzleFlash(flashTexture));
        builder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, 0.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, 0.0f).m_85969_(0xF000F0).m_5752_();
    }

    static {
        ARM_BONE_NAMES = Set.of("left_arm", "right_arm", "fake_left_arm", "fake_right_arm");
        MAGAZINE_BONE_NAMES = Set.of("_mag", "magazine");
        CUSTOM_ATTACHMENTS = Set.of((Item)ModItems.SILENCER.get(), (Item)ModItems.ADVANCED_SILENCER.get(), (Item)ModItems.MUZZLE_BRAKE.get(), (Item)ModItems.VERTICAL_GRIP.get(), (Item)ModItems.LIGHT_GRIP.get(), (Item)ModItems.IRON_BAYONET.get(), (Item)ModItems.ANTHRALITE_BAYONET.get(), (Item)ModItems.DIAMOND_BAYONET.get(), (Item)ModItems.NETHERITE_BAYONET.get(), (Item)ModItems.EXTENDED_BARREL.get(), (Item)ModItems.WOODEN_STOCK.get(), (Item)ModItems.LIGHT_STOCK.get(), (Item)ModItems.WEIGHTED_STOCK.get(), (Item)ModItems.BUMP_STOCK.get(), (Item)ModItems.EXTENDED_MAG.get(), (Item)ModItems.SPEED_MAG.get());
        BONE_TYPE_CACHE = new HashMap<String, BoneType>();
        BONE_VISIBILITY_CACHE = new HashMap<String, Boolean>();
        lastCachedStack = ItemStack.f_41583_;
        cacheInvalidationTimer = 0;
    }

    static enum BoneType {
        ARM,
        MAGAZINE,
        ATTACHMENT,
        COGLOADER_MAGAZINE,
        CYLINDER_MAGAZINE,
        CRANK_MAGAZINE,
        SLIDING_MAGAZINE,
        LASER_ORIGIN,
        SEAL,
        GLOW,
        REGULAR;

    }
}

