/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.Config;
import top.ribs.scguns.block.SulfurVentBlock;
import top.ribs.scguns.block.VentBlock;
import top.ribs.scguns.common.exosuit.ExoSuitGasMaskHandler;
import top.ribs.scguns.init.ModEffects;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.init.ModTags;

public class SulfurGasCloud {
    private static final int HELMET_DAMAGE_INTERVAL = 50;
    private static final float INNER_ZONE_RATIO = 0.25f;
    private static final double PARTICLE_RENDER_DISTANCE = 256.0;
    private static final int PERF_BASE_CLOUD_PARTICLES = 8;
    private static final int PERF_BASE_DUST_PARTICLES = 5;
    private static final int PERF_MAX_CLOUD_PARTICLES = 15;
    private static final int PERF_MAX_DUST_PARTICLES = 10;
    private static final int FULL_BASE_CLOUD_PARTICLES = 40;
    private static final int FULL_BASE_DUST_PARTICLES = 25;

    public static void spawnCloudParticlesForced(ServerLevel serverLevel, Vec3 center, double radius, int particleCount, RandomSource random) {
        if (((Boolean)Config.CLIENT.display.enablePerformanceSulfurCloud.get()).booleanValue()) {
            particleCount = Math.min(particleCount, 15);
        }
        List<ServerPlayer> nearbyPlayers = SulfurGasCloud.getNearbyPlayers(serverLevel, center, 256.0);
        for (int i = 0; i < particleCount; ++i) {
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double sphereRadius = Math.sqrt(random.m_188500_()) * radius;
            double x = center.f_82479_ + Math.cos(angle) * sphereRadius;
            double z = center.f_82481_ + Math.sin(angle) * sphereRadius;
            double y = center.f_82480_ + (random.m_188500_() - 0.5) * (radius * 0.5);
            double speed = 0.002 + random.m_188500_() * 0.005;
            double xSpeed = (random.m_188500_() - 0.5) * speed;
            double ySpeed = random.m_188500_() * speed * 0.5;
            double zSpeed = (random.m_188500_() - 0.5) * speed;
            for (ServerPlayer player : nearbyPlayers) {
                serverLevel.m_8624_(player, (ParticleOptions)((SimpleParticleType)ModParticleTypes.SULFUR_SMOKE.get()), true, x, y, z, 1, xSpeed, ySpeed, zSpeed, 0.1);
            }
        }
    }

    public static void destroyNatureInArea(Level level, Vec3 center, double radius, RandomSource random) {
        if (level.f_46443_) {
            return;
        }
        if (random.m_188503_(100) > 65) {
            return;
        }
        BlockPos centerPos = BlockPos.m_274446_((Position)center);
        int blockRadius = (int)Math.ceil(radius);
        ArrayList<BlockPos> blocksToDestroy = new ArrayList<BlockPos>();
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)centerPos.m_7918_(-blockRadius, -2, -blockRadius), (BlockPos)centerPos.m_7918_(blockRadius, 2, blockRadius))) {
            BlockState blockState;
            if (!(center.m_82554_(Vec3.m_82512_((Vec3i)checkPos)) <= radius) || !SulfurGasCloud.shouldDestroyBlock(blockState = level.m_8055_(checkPos))) continue;
            blocksToDestroy.add(checkPos.m_7949_());
        }
        if (!blocksToDestroy.isEmpty()) {
            int destroyCount = Math.min(1 + random.m_188503_(3), blocksToDestroy.size());
            for (int i = 0; i < destroyCount; ++i) {
                BlockPos posToDestroy = (BlockPos)blocksToDestroy.get(random.m_188503_(blocksToDestroy.size()));
                SulfurGasCloud.destroyBlock(level, posToDestroy);
                blocksToDestroy.remove(posToDestroy);
            }
        }
    }

    private static boolean shouldDestroyBlock(BlockState blockState) {
        return blockState.m_204336_(BlockTags.f_13041_) || blockState.m_204336_(BlockTags.f_13073_) || blockState.m_204336_(BlockTags.f_13104_) || blockState.m_204336_(BlockTags.f_13037_) || blockState.m_204336_(BlockTags.f_13040_) || blockState.m_60713_(Blocks.f_50034_) || blockState.m_60713_(Blocks.f_50359_) || blockState.m_60713_(Blocks.f_50035_) || blockState.m_60713_(Blocks.f_50360_) || blockState.m_60713_(Blocks.f_50037_) || blockState.m_60713_(Blocks.f_50038_) || blockState.m_60713_(Blocks.f_50036_) || blockState.m_60713_(Blocks.f_50191_) || blockState.m_60713_(Blocks.f_152475_) || blockState.m_60713_(Blocks.f_152543_) || blockState.m_60713_(Blocks.f_152544_) || blockState.m_60713_(Blocks.f_50685_) || blockState.m_60713_(Blocks.f_50130_) || blockState.m_60713_(Blocks.f_50571_) || blockState.m_60713_(Blocks.f_50128_) || blockState.m_60713_(Blocks.f_50575_) || blockState.m_60713_(Blocks.f_50576_);
    }

    private static void destroyBlock(Level level, BlockPos pos) {
        level.m_8055_(pos);
        BlockState belowState = level.m_8055_(pos.m_7495_());
        if (belowState.m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 3);
        }
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    public static void spawnDustParticlesForced(ServerLevel serverLevel, Vec3 center, double radius, int particleCount, RandomSource random) {
        if (((Boolean)Config.CLIENT.display.enablePerformanceSulfurCloud.get()).booleanValue()) {
            particleCount = Math.min(particleCount, 10);
        }
        List<ServerPlayer> nearbyPlayers = SulfurGasCloud.getNearbyPlayers(serverLevel, center, 256.0);
        for (int i = 0; i < particleCount; ++i) {
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double dustRadius = Math.sqrt(random.m_188500_()) * (radius * 1.2);
            double x = center.f_82479_ + Math.cos(angle) * dustRadius;
            double z = center.f_82481_ + Math.sin(angle) * dustRadius;
            double y = center.f_82480_ + 0.1 + random.m_188500_() * 0.3;
            double speed = 0.001 + random.m_188500_() * 0.002;
            double xSpeed = (random.m_188500_() - 0.5) * speed;
            double ySpeed = random.m_188500_() * speed * 0.5;
            double zSpeed = (random.m_188500_() - 0.5) * speed;
            for (ServerPlayer player : nearbyPlayers) {
                serverLevel.m_8624_(player, (ParticleOptions)((SimpleParticleType)ModParticleTypes.SULFUR_DUST.get()), true, x, y, z, 1, xSpeed, ySpeed, zSpeed, 0.1);
            }
        }
    }

    private static List<ServerPlayer> getNearbyPlayers(ServerLevel serverLevel, Vec3 center, double renderDistance) {
        AABB searchArea = new AABB(center.m_82492_(renderDistance, renderDistance, renderDistance), center.m_82520_(renderDistance, renderDistance, renderDistance));
        return serverLevel.m_45976_(ServerPlayer.class, searchArea);
    }

    public static void applyGasEffects(Level level, Vec3 center, double radius, int baseDuration, int baseAmplifier) {
        if (level.f_46443_) {
            return;
        }
        double radiusSquared = radius * radius;
        double innerRadiusSquared = radiusSquared * 0.25;
        AABB effectArea = new AABB(center.m_82492_(radius, radius, radius), center.m_82520_(radius, radius, radius));
        List entities = level.m_45976_(LivingEntity.class, effectArea);
        for (LivingEntity entity : entities) {
            Player player;
            double distanceSquared = entity.m_20238_(center);
            if (distanceSquared > radiusSquared || entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_()) || entity instanceof Player && ExoSuitGasMaskHandler.hasProtection(player = (Player)entity)) continue;
            ItemStack helmet = entity.m_6844_(EquipmentSlot.HEAD);
            if (helmet.m_204117_(ModTags.Items.GAS_MASK)) {
                SulfurGasCloud.damageGasMask(entity, helmet);
                continue;
            }
            boolean inInnerZone = distanceSquared <= innerRadiusSquared;
            int amplifier = inInnerZone ? baseAmplifier + 1 : baseAmplifier;
            int duration = inInnerZone ? baseDuration * 2 : baseDuration;
            entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SULFUR_POISONING.get(), duration, amplifier));
            if (!inInnerZone) continue;
            entity.m_6469_(entity.m_269291_().m_269425_(), 1.0f);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 60, 0));
        }
    }

    public static boolean isInGasEffectArea(Level level, Vec3 position, int checkRadius) {
        BlockPos centerPos = BlockPos.m_274446_((Position)position);
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)centerPos.m_7918_(-checkRadius, -checkRadius, -checkRadius), (BlockPos)centerPos.m_7918_(checkRadius, checkRadius, checkRadius))) {
            Vec3 ventPos;
            double distanceSquared;
            boolean isBaseVent;
            BlockState state = level.m_8055_(checkPos);
            if (!(state.m_60734_() instanceof SulfurVentBlock)) continue;
            boolean isActive = (Boolean)state.m_61143_((Property)VentBlock.ACTIVE);
            boolean bl = isBaseVent = state.m_61143_(VentBlock.VENT_TYPE) == VentBlock.VentType.BASE;
            if (!isActive || !isBaseVent || !((distanceSquared = position.m_82557_(ventPos = Vec3.m_82512_((Vec3i)checkPos))) <= 64.0)) continue;
            return true;
        }
        return false;
    }

    private static void damageGasMask(LivingEntity entity, ItemStack helmet) {
        String lastDamageKey = "LastHelmetDamageTick";
        long lastDamage = entity.getPersistentData().m_128454_(lastDamageKey);
        if (lastDamage + 50L <= (long)entity.f_19797_) {
            entity.getPersistentData().m_128356_(lastDamageKey, (long)entity.f_19797_);
            int unbreakingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)helmet);
            if (SulfurGasCloud.shouldDamageItem(unbreakingLevel, entity.m_217043_())) {
                helmet.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.HEAD));
            }
        }
    }

    private static boolean shouldDamageItem(int unbreakingLevel, RandomSource random) {
        if (unbreakingLevel > 0) {
            int chance = 1 + unbreakingLevel;
            return random.m_188503_(chance) == 0;
        }
        return true;
    }

    public static void applyGasEffects(Level level, BlockPos pos, double radius, int baseDuration, int baseAmplifier) {
        Vec3 center = Vec3.m_82512_((Vec3i)pos);
        SulfurGasCloud.applyGasEffects(level, center, radius, baseDuration, baseAmplifier);
    }

    public static void spawnEnhancedGasCloud(Level level, Vec3 center, double radius, float intensity, RandomSource random) {
        int baseDustParticles;
        int baseCloudParticles;
        if (level.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (((Boolean)Config.CLIENT.display.enablePerformanceSulfurCloud.get()).booleanValue()) {
            baseCloudParticles = 8;
            baseDustParticles = 5;
        } else {
            baseCloudParticles = 40;
            baseDustParticles = 25;
        }
        int cloudParticles = Math.round((float)baseCloudParticles * intensity);
        int dustParticles = Math.round((float)baseDustParticles * intensity);
        SulfurGasCloud.spawnCloudParticlesForced(serverLevel, center, radius, cloudParticles, random);
        SulfurGasCloud.spawnDustParticlesForced(serverLevel, center, radius, dustParticles, random);
    }

    public static boolean isFireInArea(Level level, Vec3 center, double radius) {
        BlockPos centerPos = BlockPos.m_274446_((Position)center);
        int blockRadius = (int)Math.ceil(radius);
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)centerPos.m_7918_(-blockRadius, -1, -blockRadius), (BlockPos)centerPos.m_7918_(blockRadius, 1, blockRadius))) {
            BlockState blockState;
            if (!(center.m_82554_(Vec3.m_82512_((Vec3i)checkPos)) <= radius) || !SulfurGasCloud.isFireSource(blockState = level.m_8055_(checkPos))) continue;
            return true;
        }
        return false;
    }

    public static boolean isFireSource(BlockState blockState) {
        return blockState.m_60713_(Blocks.f_50083_) || blockState.m_60713_(Blocks.f_50084_) || blockState.m_60713_(Blocks.f_50683_) && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_) != false || blockState.m_60713_(Blocks.f_50684_) && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_) != false;
    }

    public static void triggerGasExplosion(Level level, Vec3 center, double radius) {
        if (level.f_46443_) {
            return;
        }
        RandomSource random = level.f_46441_;
        for (int i = 0; i < 6; ++i) {
            double xOffset = (random.m_188500_() - 0.5) * 2.0 * radius;
            double yOffset = (random.m_188500_() - 0.5) * 2.0 * radius;
            double zOffset = (random.m_188500_() - 0.5) * 2.0 * radius;
            Vec3 explosionPos = center.m_82520_(xOffset, yOffset, zOffset);
            level.m_254849_(null, explosionPos.f_82479_, explosionPos.f_82480_, explosionPos.f_82481_, 4.0f, Level.ExplosionInteraction.NONE);
        }
    }

    public static void extinguishFireInArea(Level level, Vec3 center, double radius) {
        BlockPos centerPos = BlockPos.m_274446_((Position)center);
        int blockRadius = (int)Math.ceil(radius);
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)centerPos.m_7918_(-blockRadius, -1, -blockRadius), (BlockPos)centerPos.m_7918_(blockRadius, 1, blockRadius))) {
            if (!(center.m_82554_(Vec3.m_82512_((Vec3i)checkPos)) <= radius)) continue;
            BlockState blockState = level.m_8055_(checkPos);
            if (blockState.m_60713_(Blocks.f_50083_) || blockState.m_60713_(Blocks.f_50084_)) {
                level.m_7731_(checkPos, Blocks.f_50016_.m_49966_(), 3);
                continue;
            }
            if (!blockState.m_60713_(Blocks.f_50683_) && !blockState.m_60713_(Blocks.f_50684_)) continue;
            level.m_7731_(checkPos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public static boolean isTemporaryLightInArea(Level level, Vec3 center, double radius) {
        BlockPos centerPos = BlockPos.m_274446_((Position)center);
        int blockRadius = (int)Math.ceil(radius);
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)centerPos.m_7918_(-blockRadius, -1, -blockRadius), (BlockPos)centerPos.m_7918_(blockRadius, 1, blockRadius))) {
            BlockState blockState;
            if (!(center.m_82554_(Vec3.m_82512_((Vec3i)checkPos)) <= radius) || !(blockState = level.m_8055_(checkPos)).m_60734_().getClass().getSimpleName().equals("TemporaryLightBlock")) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAndHandleFireExplosion(Level level, Vec3 center, double radius) {
        if (SulfurGasCloud.isFireInArea(level, center, radius) || SulfurGasCloud.isTemporaryLightInArea(level, center, radius)) {
            SulfurGasCloud.triggerGasExplosion(level, center, radius);
            SulfurGasCloud.extinguishFireInArea(level, center, radius);
            return true;
        }
        return false;
    }
}

