/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.headshot;

import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.interfaces.IHeadshotBox;

public class DynamicHeadshotBox<T extends LivingEntity>
implements IHeadshotBox<T> {
    private static final double DEFAULT_HEAD_SCALE = 0.6;
    private static final double MIN_HEAD_SIZE = 6.0;
    private static final double MAX_HEAD_SIZE = 12.0;

    @Override
    @Nullable
    public AABB getHeadshotBox(T entity) {
        if (entity == null) {
            return null;
        }
        double entityWidth = entity.m_20205_();
        double entityHeight = entity.m_20206_();
        double eyeHeight = entity.m_20192_();
        double baseHeadSize = Math.max(entityWidth, entityHeight * 0.25) * 0.6;
        double headSizePixels = baseHeadSize * 16.0;
        headSizePixels = Math.max(6.0, Math.min(12.0, headSizePixels));
        return DynamicHeadshotBox.getHeadBox(entity, headSizePixels, eyeHeight);
    }

    @NotNull
    private static <T extends LivingEntity> AABB getHeadBox(T entity, double headSizePixels, double eyeHeight) {
        double headSize = headSizePixels * 0.0625;
        double halfHeadSize = headSize / 2.0;
        AABB headBox = new AABB(-halfHeadSize, 0.0, -halfHeadSize, halfHeadSize, headSize, halfHeadSize);
        double headBottom = eyeHeight - headSize * 0.2;
        headBox = headBox.m_82386_(0.0, headBottom, 0.0);
        if (entity.m_6162_()) {
            double babyScale = 0.75;
            Vec3 center = headBox.m_82399_();
            headBox = new AABB(center.f_82479_ - halfHeadSize * babyScale, center.f_82480_ - headSize * babyScale * 0.5, center.f_82481_ - halfHeadSize * babyScale, center.f_82479_ + halfHeadSize * babyScale, center.f_82480_ + headSize * babyScale * 0.5, center.f_82481_ + halfHeadSize * babyScale);
        }
        return headBox;
    }
}

