/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ribs.scguns.entity.player.PlayerGunProgression;

@Mod.EventBusSubscriber(modid="scguns")
public class EliteTierConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<PlayerGunProgression.GunTier, EliteData> ELITE_TIERS = new EnumMap<PlayerGunProgression.GunTier, EliteData>(PlayerGunProgression.GunTier.class);
    private static final ResourceLocation CONFIG_LOCATION = new ResourceLocation("scguns", "entity/elite_tiers.json");

    public static void loadConfig(ResourceManager resourceManager) {
        block17: {
            ELITE_TIERS.clear();
            try {
                Resource resource = resourceManager.m_213713_(CONFIG_LOCATION).orElse(null);
                if (resource != null) {
                    try (InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);){
                        Gson gson = new Gson();
                        JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                        if (json != null) {
                            for (Map.Entry entry : json.entrySet()) {
                                String tierName = (String)entry.getKey();
                                JsonObject tierData = ((JsonElement)entry.getValue()).getAsJsonObject();
                                try {
                                    PlayerGunProgression.GunTier tier = PlayerGunProgression.GunTier.valueOf(tierName);
                                    ArrayList<Item> weapons = new ArrayList<Item>();
                                    if (tierData.has("weapons")) {
                                        JsonArray weaponsArray = tierData.getAsJsonArray("weapons");
                                        for (JsonElement weaponElement : weaponsArray) {
                                            String weaponId = weaponElement.getAsString();
                                            Item weapon = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(weaponId));
                                            if (weapon != null) {
                                                weapons.add(weapon);
                                                continue;
                                            }
                                            LOGGER.warn("Unknown elite weapon for tier {}: {}", (Object)tierName, (Object)weaponId);
                                        }
                                    }
                                    ArrayList<ArmorPiece> armor = new ArrayList<ArmorPiece>();
                                    if (tierData.has("armor")) {
                                        JsonArray armorArray = tierData.getAsJsonArray("armor");
                                        for (JsonElement armorElement : armorArray) {
                                            ArmorPiece piece = ArmorPiece.fromJson(armorElement.getAsJsonObject());
                                            if (piece == null) continue;
                                            armor.add(piece);
                                        }
                                    }
                                    ELITE_TIERS.put(tier, new EliteData(weapons, armor));
                                }
                                catch (IllegalArgumentException e) {
                                    LOGGER.error("Invalid tier name in elite config: {}", (Object)tierName);
                                }
                            }
                        }
                        LOGGER.info("Loaded elite tier config: {} elite tiers configured", (Object)ELITE_TIERS.size());
                        break block17;
                    }
                }
                LOGGER.warn("Elite tier config not found at {}", (Object)CONFIG_LOCATION);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load elite tier config at {}", (Object)CONFIG_LOCATION, (Object)e);
            }
        }
    }

    @Nullable
    public static EliteData getEliteData(PlayerGunProgression.GunTier tier) {
        return ELITE_TIERS.get((Object)tier);
    }

    public static boolean hasEliteData(PlayerGunProgression.GunTier tier) {
        EliteData data = ELITE_TIERS.get((Object)tier);
        return data != null && data.hasEliteWeapons();
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                EliteTierConfig.loadConfig(resourceManager);
            }
        });
    }

    public record ArmorPiece(Item item, String slot, float chance) {
        public static ArmorPiece fromJson(JsonObject json) {
            String itemId = json.get("item").getAsString();
            String slot = json.get("slot").getAsString();
            float chance = json.has("chance") ? json.get("chance").getAsFloat() : 1.0f;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
            if (item == null) {
                LOGGER.warn("Unknown armor item: {}", (Object)itemId);
                return null;
            }
            return new ArmorPiece(item, slot, chance);
        }
    }

    public record EliteData(List<Item> eliteWeapons, List<ArmorPiece> armor) {
        @Nullable
        public Item getRandomWeapon(RandomSource random) {
            if (this.eliteWeapons.isEmpty()) {
                return null;
            }
            return this.eliteWeapons.get(random.m_188503_(this.eliteWeapons.size()));
        }

        public boolean hasEliteWeapons() {
            return !this.eliteWeapons.isEmpty();
        }
    }
}

