/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.config;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.config.EliteTierConfig;
import top.ribs.scguns.config.GunMobValues;
import top.ribs.scguns.config.GunnerMobConfig;
import top.ribs.scguns.config.TieredWeaponConfig;
import top.ribs.scguns.entity.ai.AIType;
import top.ribs.scguns.entity.ai.GunAttackGoal;
import top.ribs.scguns.entity.player.PlayerGunProgression;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.util.GunCurseUtil;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GunnerMobSpawner {
    public static final UUID GUN_FOLLOW_RANGE_MODIFIER_UUID = UUID.randomUUID();

    @SubscribeEvent
    public static void onSpecialSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (!GunMobValues.enabled) {
            return;
        }
        Mob entity = event.getEntity();
        if (!(entity instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)entity;
        if (!entity.m_6095_().m_204039_(ModTags.Entities.GUNNER)) {
            return;
        }
        GunnerMobConfig.MobGunnerData gunnerData = GunnerMobConfig.getGunnerData(entity.m_6095_());
        if (gunnerData != null) {
            if (entity.m_217043_().m_188501_() >= gunnerData.spawnChance()) {
                return;
            }
            mob.m_20049_("MobGunner");
            mob.m_20049_("ThematicGunner");
            return;
        }
        Player nearestPlayer = entity.m_9236_().m_45930_((Entity)entity, 64.0);
        if (nearestPlayer != null) {
            PlayerGunProgression progression = PlayerGunProgression.get(nearestPlayer);
            List<PlayerGunProgression.GunTier> availableTiers = progression.getAvailableMobTiers();
            boolean hasValidTiers = false;
            for (PlayerGunProgression.GunTier tier : availableTiers) {
                if (!TieredWeaponConfig.hasTierWeapons(tier)) continue;
                hasValidTiers = true;
                break;
            }
            double spawnChance = GunMobValues.getGunnerSpawnChance(entity.m_9236_().m_46791_());
            if (hasValidTiers && (double)entity.m_217043_().m_188501_() < spawnChance) {
                mob.m_20049_("MobGunner");
                mob.m_20049_("ProgressionGunner");
            }
        }
    }

    @SubscribeEvent
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)livingEntity;
        ItemStack heldItem = mob.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem) {
            GunnerMobSpawner.reassessWeaponGoal(mob);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        AbstractPiglin abstractPiglin;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)livingEntity;
        if (mob.f_19797_ >= 2) {
            return;
        }
        ItemStack heldItem = mob.m_21205_();
        if (mob instanceof AbstractPiglin && (abstractPiglin = (AbstractPiglin)mob).m_9236_().m_46472_() == Level.f_46428_) {
            for (String tag : mob.m_19880_()) {
                if (!tag.startsWith("RaidMember_") && !mob.m_19880_().contains("MobGunner")) continue;
                abstractPiglin.m_34670_(true);
                break;
            }
        }
        if (!GunMobValues.enabled) {
            return;
        }
        if (mob.m_19880_().contains("MobGunner") && !(heldItem.m_41720_() instanceof GunItem)) {
            if (mob.m_19880_().contains("ThematicGunner")) {
                GunnerMobSpawner.equipThematicGun(mob);
            } else if (mob.m_19880_().contains("ProgressionGunner")) {
                GunnerMobSpawner.equipProgressionGun(mob);
            }
        }
        if (heldItem.m_41720_() instanceof GunItem) {
            GunnerMobSpawner.reassessWeaponGoal(mob);
        }
    }

    private static void equipThematicGun(PathfinderMob mob) {
        GunnerMobConfig.MobGunnerData gunnerData = GunnerMobConfig.getGunnerData(mob.m_6095_());
        if (gunnerData != null) {
            ItemStack modifiedGun;
            Item gun = gunnerData.getRandomWeapon(mob.m_217043_());
            if (gun == null) {
                return;
            }
            AIType aiType = AIType.values()[mob.m_217043_().m_188503_(AIType.values().length)];
            boolean elite = (double)mob.m_217043_().m_188501_() < GunMobValues.eliteChance && GunMobValues.elitesEnabled;
            int aiLevel = gunnerData.aiDifficulty() + (elite ? 1 : 0);
            if (elite) {
                mob.m_20049_("EliteGunner");
                mob.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
            }
            for (GunnerMobConfig.ArmorPiece armorPiece : gunnerData.allowedArmor()) {
                EquipmentSlot slot;
                if (!(mob.m_217043_().m_188501_() < armorPiece.spawnChance())) continue;
                if ((slot = (switch (armorPiece.slot()) {
                    case "head" -> EquipmentSlot.HEAD;
                    case "chest" -> EquipmentSlot.CHEST;
                    case "legs" -> EquipmentSlot.LEGS;
                    case "feet" -> EquipmentSlot.FEET;
                    default -> null;
                })) == null) continue;
                mob.m_8061_(slot, new ItemStack((ItemLike)armorPiece.item()));
            }
            if (!mob.m_9236_().f_46443_ && !GunnerMobSpawner.hasGunAttackGoal(mob)) {
                modifiedGun = GunnerMobSpawner.createModifiedGun(mob, gun);
                mob.f_21345_.m_25352_(2, new GunAttackGoal<PathfinderMob>(mob, modifiedGun, 1.2f, aiType, aiLevel));
                mob.m_20049_("GunAttackAssigned");
            }
            modifiedGun = GunnerMobSpawner.createModifiedGun(mob, gun);
            GunCurseUtil.applyCurseIfRoll(modifiedGun, mob.m_217043_());
            mob.m_8061_(EquipmentSlot.MAINHAND, modifiedGun);
            GunnerMobSpawner.extendFollowRange(mob);
        }
    }

    private static void equipProgressionGun(PathfinderMob mob) {
        ItemStack modifiedGun;
        Item gun;
        PlayerGunProgression.GunTier selectedTier;
        Player nearestPlayer = mob.m_9236_().m_45930_((Entity)mob, 64.0);
        if (nearestPlayer == null) {
            return;
        }
        PlayerGunProgression progression = PlayerGunProgression.get(nearestPlayer);
        List<PlayerGunProgression.GunTier> availableTiers = progression.getAvailableMobTiers();
        if (availableTiers.isEmpty()) {
            return;
        }
        boolean isElite = (double)mob.m_217043_().m_188501_() < GunMobValues.eliteChance && GunMobValues.elitesEnabled;
        ArrayList<PlayerGunProgression.GunTier> validTiers = new ArrayList<PlayerGunProgression.GunTier>();
        for (PlayerGunProgression.GunTier tier : availableTiers) {
            if (isElite) {
                if (!EliteTierConfig.hasEliteData(tier)) continue;
                validTiers.add(tier);
                continue;
            }
            if (!TieredWeaponConfig.hasTierWeapons(tier)) continue;
            validTiers.add(tier);
        }
        if (validTiers.isEmpty()) {
            return;
        }
        float rand = mob.m_217043_().m_188501_();
        if (rand < 0.6f) {
            index = mob.m_217043_().m_188503_(Math.max(1, validTiers.size() / 2));
            selectedTier = (PlayerGunProgression.GunTier)((Object)validTiers.get(index));
        } else if (rand < 0.9f && validTiers.size() > 1) {
            int midStart = validTiers.size() / 3;
            int midEnd = validTiers.size() * 2 / 3;
            if (midEnd <= midStart) {
                midEnd = midStart + 1;
            }
            if (midEnd >= validTiers.size()) {
                midEnd = validTiers.size() - 1;
            }
            int index = midStart + mob.m_217043_().m_188503_(midEnd - midStart + 1);
            selectedTier = (PlayerGunProgression.GunTier)((Object)validTiers.get(index));
        } else {
            index = Math.max(0, validTiers.size() - 1 - mob.m_217043_().m_188503_(Math.max(1, validTiers.size() / 3)));
            selectedTier = (PlayerGunProgression.GunTier)((Object)validTiers.get(index));
        }
        if (isElite) {
            EliteTierConfig.EliteData eliteData = EliteTierConfig.getEliteData(selectedTier);
            if (eliteData == null) {
                return;
            }
            gun = eliteData.getRandomWeapon(mob.m_217043_());
            if (gun == null) {
                return;
            }
            mob.m_20049_("EliteGunner");
            mob.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
            for (EliteTierConfig.ArmorPiece armorPiece : eliteData.armor()) {
                EquipmentSlot slot;
                if (!(mob.m_217043_().m_188501_() < armorPiece.chance())) continue;
                if ((slot = (switch (armorPiece.slot()) {
                    case "head" -> EquipmentSlot.HEAD;
                    case "chest" -> EquipmentSlot.CHEST;
                    case "legs" -> EquipmentSlot.LEGS;
                    case "feet" -> EquipmentSlot.FEET;
                    default -> null;
                })) == null) continue;
                mob.m_8061_(slot, new ItemStack((ItemLike)armorPiece.item()));
            }
        } else {
            gun = TieredWeaponConfig.getRandomWeaponForTier(selectedTier, mob.m_217043_());
            if (gun == null) {
                return;
            }
        }
        AIType aiType = AIType.values()[mob.m_217043_().m_188503_(AIType.values().length)];
        int aiLevel = 2 + (isElite ? 1 : 0);
        if (!mob.m_9236_().f_46443_ && !GunnerMobSpawner.hasGunAttackGoal(mob)) {
            modifiedGun = GunnerMobSpawner.createModifiedGun(mob, gun);
            mob.f_21345_.m_25352_(2, new GunAttackGoal<PathfinderMob>(mob, modifiedGun, 1.2f, aiType, aiLevel));
            mob.m_20049_("GunAttackAssigned");
        }
        modifiedGun = GunnerMobSpawner.createModifiedGun(mob, gun);
        GunCurseUtil.applyCurseIfRoll(modifiedGun, mob.m_217043_());
        mob.m_8061_(EquipmentSlot.MAINHAND, modifiedGun);
        GunnerMobSpawner.extendFollowRange(mob);
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (!GunMobValues.enabled) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)entity;
        mob.m_20137_("GunAttackAssigned");
        ItemStack heldItem = mob.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem) {
            GunnerMobSpawner.reassessWeaponGoal(mob);
        } else {
            GunnerMobSpawner.resetFollowRange(mob);
        }
    }

    public static boolean hasGunAttackGoal(PathfinderMob mob) {
        return mob.f_21345_.m_148105_().stream().anyMatch(goal -> goal.m_26015_() instanceof GunAttackGoal);
    }

    public static void reassessWeaponGoal(PathfinderMob mob) {
        if (mob.m_9236_().f_46443_ || GunnerMobSpawner.hasGunAttackGoal(mob)) {
            return;
        }
        for (String tag : mob.m_19880_()) {
            if (!tag.startsWith("RaidMember_")) continue;
            return;
        }
        AIType aiType = AIType.values()[mob.m_217043_().m_188503_(AIType.values().length)];
        int aiDifficulty = mob.m_217043_().m_188503_(4) + 1;
        ItemStack heldItem = mob.m_21205_();
        mob.f_21345_.m_25352_(2, new GunAttackGoal<PathfinderMob>(mob, heldItem, 1.2f, aiType, aiDifficulty));
        mob.m_20049_("GunAttackAssigned");
        GunnerMobSpawner.extendFollowRange(mob);
    }

    private static ItemStack createModifiedGun(PathfinderMob mob, Item gun) {
        ItemStack gunStack = new ItemStack((ItemLike)gun);
        if (gun instanceof GunItem) {
            GunItem gunItem = (GunItem)gun;
            if (gunStack.m_41783_() != null) {
                Gun gunModified = gunItem.getModifiedGun(gunStack);
                gunStack.m_41783_().m_128405_("AmmoCount", mob.m_217043_().m_188503_(gunModified.getReloads().getMaxAmmo()));
            }
        }
        return gunStack;
    }

    public static void extendFollowRange(PathfinderMob mob) {
        if (mob.m_21051_(Attributes.f_22277_) != null) {
            double additionalRange = 64.0 - mob.m_21051_(Attributes.f_22277_).m_22115_();
            AttributeModifier modifier = new AttributeModifier(GUN_FOLLOW_RANGE_MODIFIER_UUID, "Gun follow range modifier", additionalRange, AttributeModifier.Operation.ADDITION);
            if (!mob.m_21051_(Attributes.f_22277_).m_22109_(modifier)) {
                mob.m_21051_(Attributes.f_22277_).m_22125_(modifier);
            }
        }
    }

    public static void resetFollowRange(PathfinderMob mob) {
        if (mob.m_21051_(Attributes.f_22277_) != null) {
            mob.m_21051_(Attributes.f_22277_).m_22120_(GUN_FOLLOW_RANGE_MODIFIER_UUID);
        }
    }
}

