/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ribs.scguns.entity.ai.AIType;

@Mod.EventBusSubscriber(modid="scguns")
public class RaidConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, RaidData> RAIDS_BY_ID = new HashMap<String, RaidData>();
    private static final Map<Integer, List<RaidData>> RAIDS_BY_LEVEL = new HashMap<Integer, List<RaidData>>();

    public static void loadRaidConfigs(ResourceManager resourceManager) {
        RAIDS_BY_ID.clear();
        RAIDS_BY_LEVEL.clear();
        for (Map.Entry entry : resourceManager.m_214159_("raids", loc -> loc.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            String path = location.m_135815_();
            String fileName = path.substring(path.lastIndexOf(47) + 1);
            String raidId = fileName.replace("_raid.json", "").replace(".json", "");
            try (InputStreamReader reader = new InputStreamReader(((Resource)entry.getValue()).m_215507_(), StandardCharsets.UTF_8);){
                Gson gson = new Gson();
                JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                RaidData raidData = RaidConfig.parseRaidData(json);
                if (raidData == null) continue;
                RAIDS_BY_ID.put(raidData.raidId(), raidData);
                if (raidData.raidLevel() != null) {
                    RAIDS_BY_LEVEL.computeIfAbsent(raidData.raidLevel(), k -> new ArrayList()).add(raidData);
                    LOGGER.info("Loaded progression raid: {} (Level: {})", (Object)raidData.raidId(), (Object)raidData.raidLevel());
                    continue;
                }
                LOGGER.info("Loaded custom raid: {}", (Object)raidData.raidId());
            }
            catch (Exception e) {
                LOGGER.error("Failed to load raid config: {}", (Object)raidId, (Object)e);
            }
        }
        LOGGER.info("Loaded {} total raids ({} progression, {} custom)", (Object)RAIDS_BY_ID.size(), (Object)RAIDS_BY_LEVEL.values().stream().mapToInt(List::size).sum(), (Object)(RAIDS_BY_ID.size() - RAIDS_BY_LEVEL.values().stream().mapToInt(List::size).sum()));
    }

    @Nullable
    public static RaidData getRaidById(String raidId) {
        return RAIDS_BY_ID.get(raidId);
    }

    @Nullable
    public static RaidData getRaidByRaidId(String raidId) {
        return RaidConfig.getRaidById(raidId);
    }

    public static List<RaidData> getRaidsAtLevel(int level) {
        return RAIDS_BY_LEVEL.getOrDefault(level, Collections.emptyList());
    }

    public static List<RaidData> getRaidsForLevel(int playerLevel) {
        ArrayList<RaidData> availableRaids = new ArrayList<RaidData>();
        for (int level = 1; level <= playerLevel; ++level) {
            availableRaids.addAll(RaidConfig.getRaidsAtLevel(level));
        }
        return availableRaids;
    }

    public static int getMaxRaidLevel() {
        return RAIDS_BY_LEVEL.keySet().stream().max(Integer::compareTo).orElse(0);
    }

    public static Collection<RaidData> getAllRaids() {
        return RAIDS_BY_ID.values();
    }

    public static Collection<RaidData> getProgressionRaids() {
        ArrayList<RaidData> progressionRaids = new ArrayList<RaidData>();
        for (RaidData raid : RAIDS_BY_ID.values()) {
            if (raid.raidLevel() == null) continue;
            progressionRaids.add(raid);
        }
        return progressionRaids;
    }

    public static Collection<RaidData> getCustomRaids() {
        ArrayList<RaidData> customRaids = new ArrayList<RaidData>();
        for (RaidData raid : RAIDS_BY_ID.values()) {
            if (raid.raidLevel() != null) continue;
            customRaids.add(raid);
        }
        return customRaids;
    }

    public static boolean hasRaidWithId(String raidId) {
        return RAIDS_BY_ID.containsKey(raidId);
    }

    @Nullable
    private static RaidData parseRaidData(JsonObject json) {
        try {
            String raidId = json.get("raid_id").getAsString();
            Integer raidLevel = null;
            if (json.has("raid_level")) {
                raidLevel = json.get("raid_level").getAsInt();
            }
            BossData boss = RaidConfig.parseBossData(json.getAsJsonObject("boss"));
            HenchmenData henchmen = RaidConfig.parseHenchmenData(json.getAsJsonObject("henchmen"));
            SpawnConditions conditions = RaidConfig.parseSpawnConditions(json.getAsJsonObject("spawn_conditions"));
            return new RaidData(raidId, raidLevel, boss, henchmen, conditions);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing raid data", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static BossData parseBossData(JsonObject json) {
        try {
            String entityId = json.get("entity_type").getAsString();
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entityId));
            if (entityType == null) {
                LOGGER.warn("Unknown entity type: {}", (Object)entityId);
                return null;
            }
            String customName = json.has("custom_name") ? json.get("custom_name").getAsString() : null;
            HealthConfig healthConfig = RaidConfig.parseHealthConfig(json);
            WeaponEntry weapon = null;
            if (json.has("weapon")) {
                JsonObject weaponObj = json.getAsJsonObject("weapon");
                Item weaponItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(weaponObj.get("item").getAsString()));
                float dropChance = weaponObj.has("drop_chance") ? weaponObj.get("drop_chance").getAsFloat() : 0.085f;
                weapon = new WeaponEntry(weaponItem, dropChance);
            }
            ArrayList<ArmorEntry> armor = new ArrayList<ArmorEntry>();
            if (json.has("armor")) {
                JsonArray armorArray = json.getAsJsonArray("armor");
                for (JsonElement element : armorArray) {
                    float dropChance;
                    JsonObject armorObj = element.getAsJsonObject();
                    Item armorItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(armorObj.get("item").getAsString()));
                    String slot = armorObj.get("slot").getAsString();
                    float f = dropChance = armorObj.has("drop_chance") ? armorObj.get("drop_chance").getAsFloat() : 0.085f;
                    if (armorItem == null) continue;
                    armor.add(new ArmorEntry(armorItem, slot, dropChance));
                }
            }
            List<EffectEntry> effects = RaidConfig.parseEffects(json);
            int aiDifficulty = json.has("ai_difficulty") ? json.get("ai_difficulty").getAsInt() : 3;
            AIType aiType = json.has("ai_type") ? AIType.valueOf(json.get("ai_type").getAsString()) : AIType.DEFAULT;
            ResourceLocation lootTable = json.has("special_loot_table") ? new ResourceLocation(json.get("special_loot_table").getAsString()) : null;
            MountData mount = null;
            if (json.has("mount")) {
                mount = RaidConfig.parseMountData(json.getAsJsonObject("mount"));
            }
            return new BossData(entityType, customName, healthConfig, weapon, armor, effects, aiDifficulty, aiType, lootTable, mount);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing boss data", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static MountData parseMountData(JsonObject json) {
        try {
            String mountId = json.get("entity_type").getAsString();
            EntityType mountType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(mountId));
            if (mountType == null) {
                LOGGER.warn("Unknown mount type: {}", (Object)mountId);
                return null;
            }
            HealthConfig healthConfig = RaidConfig.parseHealthConfig(json);
            ArrayList<ArmorEntry> armor = new ArrayList<ArmorEntry>();
            if (json.has("armor")) {
                JsonArray armorArray = json.getAsJsonArray("armor");
                for (JsonElement element : armorArray) {
                    float dropChance;
                    JsonObject armorObj = element.getAsJsonObject();
                    Item armorItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(armorObj.get("item").getAsString()));
                    String slot = armorObj.get("slot").getAsString();
                    float f = dropChance = armorObj.has("drop_chance") ? armorObj.get("drop_chance").getAsFloat() : 0.085f;
                    if (armorItem == null) continue;
                    armor.add(new ArmorEntry(armorItem, slot, dropChance));
                }
            }
            List<EffectEntry> effects = RaidConfig.parseEffects(json);
            boolean dropsLoot = !json.has("drops_loot") || json.get("drops_loot").getAsBoolean();
            return new MountData(mountType, healthConfig, armor, effects, dropsLoot);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing mount data", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static HenchmenData parseHenchmenData(JsonObject json) {
        try {
            ArrayList<HenchmanType> types = new ArrayList<HenchmanType>();
            if (json.has("types")) {
                JsonArray typesArray = json.getAsJsonArray("types");
                for (JsonElement element : typesArray) {
                    JsonObject typeObj = element.getAsJsonObject();
                    String entityId = typeObj.get("entity_type").getAsString();
                    EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entityId));
                    if (entityType == null) continue;
                    float weight = typeObj.has("weight") ? typeObj.get("weight").getAsFloat() : 1.0f;
                    HealthConfig healthConfig = RaidConfig.parseHealthConfig(typeObj);
                    ArrayList<Item> weapons = new ArrayList<Item>();
                    if (typeObj.has("weapons")) {
                        JsonArray weaponsArray = typeObj.getAsJsonArray("weapons");
                        for (Object weaponElement : weaponsArray) {
                            Item weapon = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(weaponElement.getAsString()));
                            if (weapon == null) continue;
                            weapons.add(weapon);
                        }
                    }
                    ArrayList<ArmorEntry> armor = new ArrayList<ArmorEntry>();
                    if (typeObj.has("armor")) {
                        Object weaponElement;
                        JsonArray armorArray = typeObj.getAsJsonArray("armor");
                        weaponElement = armorArray.iterator();
                        while (weaponElement.hasNext()) {
                            float chance;
                            JsonElement armorElement = (JsonElement)weaponElement.next();
                            JsonObject armorObj = armorElement.getAsJsonObject();
                            Item armorItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(armorObj.get("item").getAsString()));
                            String slot = armorObj.get("slot").getAsString();
                            float f = chance = armorObj.has("chance") ? armorObj.get("chance").getAsFloat() : 0.5f;
                            if (armorItem == null) continue;
                            armor.add(new ArmorEntry(armorItem, slot, chance));
                        }
                    }
                    List<EffectEntry> effects = RaidConfig.parseEffects(typeObj);
                    int aiDifficulty = typeObj.has("ai_difficulty") ? typeObj.get("ai_difficulty").getAsInt() : 2;
                    AIType aiType = typeObj.has("ai_type") ? AIType.valueOf(typeObj.get("ai_type").getAsString()) : AIType.DEFAULT;
                    types.add(new HenchmanType(entityType, weight, healthConfig, weapons, armor, effects, aiDifficulty, aiType));
                }
            }
            int maxAlive = json.has("max_concurrent") ? json.get("max_concurrent").getAsInt() : (json.has("max_alive") ? json.get("max_alive").getAsInt() : 4);
            int maxTotal = json.has("max_total") ? json.get("max_total").getAsInt() : 15;
            int spawnInterval = json.has("spawn_interval_ticks") ? json.get("spawn_interval_ticks").getAsInt() : 200;
            int spawnRadius = json.has("spawn_radius") ? json.get("spawn_radius").getAsInt() : 20;
            int spawnAttempts = json.has("spawn_attempts_per_wave") ? json.get("spawn_attempts_per_wave").getAsInt() : 3;
            return new HenchmenData(types, maxAlive, maxTotal, spawnInterval, spawnRadius, spawnAttempts);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing henchmen data", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static HealthConfig parseHealthConfig(JsonObject json) {
        Float fixedHealth = json.has("fixed_health") ? Float.valueOf(json.get("fixed_health").getAsFloat()) : null;
        Float healthMultiplier = json.has("health_multiplier") ? Float.valueOf(json.get("health_multiplier").getAsFloat()) : null;
        return new HealthConfig(fixedHealth, healthMultiplier);
    }

    private static List<EffectEntry> parseEffects(JsonObject json) {
        ArrayList<EffectEntry> effects = new ArrayList<EffectEntry>();
        if (json.has("effects")) {
            JsonArray effectsArray = json.getAsJsonArray("effects");
            for (JsonElement element : effectsArray) {
                JsonObject effectObj = element.getAsJsonObject();
                String effectId = effectObj.get("effect").getAsString();
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectId));
                if (effect == null) continue;
                int amplifier = effectObj.has("amplifier") ? effectObj.get("amplifier").getAsInt() : 0;
                int duration = effectObj.has("duration") ? effectObj.get("duration").getAsInt() : -1;
                boolean ambient = effectObj.has("ambient") && effectObj.get("ambient").getAsBoolean();
                boolean visible = !effectObj.has("visible") || effectObj.get("visible").getAsBoolean();
                effects.add(new EffectEntry(effect, amplifier, duration, ambient, visible));
            }
        }
        return effects;
    }

    @Nullable
    private static SpawnConditions parseSpawnConditions(JsonObject json) {
        try {
            int minPlayers = json.has("min_players_nearby") ? json.get("min_players_nearby").getAsInt() : 1;
            int searchRadius = json.has("search_radius") ? json.get("search_radius").getAsInt() : 64;
            ArrayList<ResourceLocation> validDimensions = new ArrayList<ResourceLocation>();
            if (json.has("valid_dimensions")) {
                JsonArray dimsArray = json.getAsJsonArray("valid_dimensions");
                for (JsonElement element : dimsArray) {
                    validDimensions.add(new ResourceLocation(element.getAsString()));
                }
            } else {
                validDimensions.add(new ResourceLocation("minecraft:overworld"));
            }
            String announcement = json.has("announcement_message") ? json.get("announcement_message").getAsString() : "\u00a7c\u00a7lA raid approaches!";
            return new SpawnConditions(minPlayers, searchRadius, validDimensions, announcement);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing spawn conditions", (Throwable)e);
            return null;
        }
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                RaidConfig.loadRaidConfigs(resourceManager);
            }
        });
    }

    public record RaidData(String raidId, @Nullable Integer raidLevel, BossData boss, HenchmenData henchmen, SpawnConditions spawnConditions) {
    }

    public record BossData(EntityType<?> entityType, @Nullable String customName, HealthConfig healthConfig, @Nullable WeaponEntry weapon, List<ArmorEntry> armor, List<EffectEntry> effects, int aiDifficulty, AIType aiType, @Nullable ResourceLocation specialLootTable, @Nullable MountData mount) {
    }

    public record HenchmenData(List<HenchmanType> types, int maxAlive, int maxTotal, int spawnIntervalTicks, int spawnRadius, int spawnAttemptsPerWave) {
        @Nullable
        public HenchmanType selectRandomType(RandomSource random) {
            if (this.types.isEmpty()) {
                return null;
            }
            float totalWeight = 0.0f;
            for (HenchmanType type : this.types) {
                totalWeight += type.weight;
            }
            float roll = random.m_188501_() * totalWeight;
            float currentWeight = 0.0f;
            for (HenchmanType type : this.types) {
                if (!(roll < (currentWeight += type.weight))) continue;
                return type;
            }
            return this.types.get(this.types.size() - 1);
        }
    }

    public record SpawnConditions(int minPlayersNearby, int searchRadius, List<ResourceLocation> validDimensions, String announcementMessage) {
    }

    public record HealthConfig(@Nullable Float fixedHealth, @Nullable Float healthMultiplier) {
        public boolean useMultiplier() {
            return this.healthMultiplier != null;
        }
    }

    public record WeaponEntry(Item item, float dropChance) {
    }

    public record ArmorEntry(Item item, String slot, float dropChance) {
    }

    public record MountData(EntityType<?> entityType, HealthConfig healthConfig, List<ArmorEntry> armor, List<EffectEntry> effects, boolean mountDropsLoot) {
    }

    public record HenchmanType(EntityType<?> entityType, float weight, HealthConfig healthConfig, List<Item> weapons, List<ArmorEntry> armor, List<EffectEntry> effects, int aiDifficulty, AIType aiType) {
    }

    public record EffectEntry(MobEffect effect, int amplifier, int duration, boolean ambient, boolean visible) {
    }
}

