/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ribs.scguns.entity.player.PlayerGunProgression;

@Mod.EventBusSubscriber(modid="scguns")
public class TieredWeaponConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<PlayerGunProgression.GunTier, List<Item>> TIER_WEAPONS = new EnumMap<PlayerGunProgression.GunTier, List<Item>>(PlayerGunProgression.GunTier.class);
    private static final ResourceLocation CONFIG_LOCATION = new ResourceLocation("scguns", "entity/tier_weapons.json");

    public static void loadConfig(ResourceManager resourceManager) {
        block14: {
            TIER_WEAPONS.clear();
            try {
                Resource resource = resourceManager.m_213713_(CONFIG_LOCATION).orElse(null);
                if (resource != null) {
                    try (InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);){
                        Gson gson = new Gson();
                        JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                        if (json != null) {
                            for (Map.Entry entry : json.entrySet()) {
                                String tierName = (String)entry.getKey();
                                JsonArray weaponsArray = ((JsonElement)entry.getValue()).getAsJsonArray();
                                try {
                                    PlayerGunProgression.GunTier tier = PlayerGunProgression.GunTier.valueOf(tierName);
                                    ArrayList<Item> weapons = new ArrayList<Item>();
                                    for (JsonElement weaponElement : weaponsArray) {
                                        String weaponId = weaponElement.getAsString();
                                        Item weapon = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(weaponId));
                                        if (weapon != null) {
                                            weapons.add(weapon);
                                            continue;
                                        }
                                        LOGGER.warn("Unknown weapon item for tier {}: {}", (Object)tierName, (Object)weaponId);
                                    }
                                    TIER_WEAPONS.put(tier, weapons);
                                }
                                catch (IllegalArgumentException e) {
                                    LOGGER.error("Invalid tier name: {}", (Object)tierName);
                                }
                            }
                        }
                        LOGGER.info("Loaded tiered weapon config: {} tiers configured", (Object)TIER_WEAPONS.size());
                        break block14;
                    }
                }
                LOGGER.warn("Tiered weapon config not found at {}", (Object)CONFIG_LOCATION);
                TieredWeaponConfig.loadDefaults();
            }
            catch (Exception e) {
                LOGGER.error("Failed to load tiered weapon config at {}", (Object)CONFIG_LOCATION, (Object)e);
                TieredWeaponConfig.loadDefaults();
            }
        }
    }

    private static void loadDefaults() {
        LOGGER.info("Loading default tiered weapon configuration");
    }

    public static Item getRandomWeaponForTier(PlayerGunProgression.GunTier tier, RandomSource random) {
        List<Item> weapons = TIER_WEAPONS.get((Object)tier);
        if (weapons == null || weapons.isEmpty()) {
            return null;
        }
        return weapons.get(random.m_188503_(weapons.size()));
    }

    public static List<Item> getWeaponsForTier(PlayerGunProgression.GunTier tier) {
        return TIER_WEAPONS.getOrDefault((Object)tier, Collections.emptyList());
    }

    public static boolean hasTierWeapons(PlayerGunProgression.GunTier tier) {
        List<Item> weapons = TIER_WEAPONS.get((Object)tier);
        return weapons != null && !weapons.isEmpty();
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                TieredWeaponConfig.loadConfig(resourceManager);
            }
        });
    }
}

