/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.effect;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.world.ProjectileExplosion;

public class RocketExplosion
extends ProjectileExplosion {
    private final float customDamage;
    private final float explosionRadius;
    private final Level world;
    private final double x;
    private final double y;
    private final double z;
    private final ExplosionDamageCalculator context;

    public RocketExplosion(Level level, Entity entity, DamageSource damageSource, ExplosionDamageCalculator explosionDamageCalculator, double x, double y, double z, float radius, float customDamage, boolean fire, Explosion.BlockInteraction blockInteraction) {
        super(level, entity, damageSource, explosionDamageCalculator, x, y, z, radius, fire, blockInteraction);
        this.customDamage = customDamage;
        this.explosionRadius = radius;
        this.world = level;
        this.x = x;
        this.y = y;
        this.z = z;
        this.context = explosionDamageCalculator != null ? explosionDamageCalculator : new ExplosionDamageCalculator();
    }

    @Override
    public void m_46061_() {
        this.playExplosionSound();
        HashSet set = Sets.newHashSet();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    if (x != 0 && x != 15 && y != 0 && y != 15 && z != 0 && z != 15) continue;
                    double d0 = (float)x / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)y / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)z / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double blockX = this.x;
                    double blockY = this.y;
                    double blockZ = this.z;
                    for (float f = this.explosionRadius * (0.7f + this.world.f_46441_.m_188501_() * 0.6f); f > 0.0f; f -= 0.225f) {
                        FluidState fluidState;
                        BlockState blockState;
                        BlockPos pos = BlockPos.m_274561_((double)blockX, (double)blockY, (double)blockZ);
                        Optional optional = this.context.m_6617_((Explosion)this, (BlockGetter)this.world, pos, blockState = this.world.m_8055_(pos), fluidState = this.world.m_6425_(pos));
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.context.m_6714_((Explosion)this, (BlockGetter)this.world, pos, blockState, f)) {
                            set.add(pos);
                        }
                        blockX += d0 * (double)0.3f;
                        blockY += d1 * (double)0.3f;
                        blockZ += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.m_46081_().addAll(set);
        float damageRadius = this.explosionRadius * 2.0f;
        int minX = Mth.m_14107_((double)(this.x - (double)damageRadius - 1.0));
        int maxX = Mth.m_14107_((double)(this.x + (double)damageRadius + 1.0));
        int minY = Mth.m_14107_((double)(this.y - (double)damageRadius - 1.0));
        int maxY = Mth.m_14107_((double)(this.y + (double)damageRadius + 1.0));
        int minZ = Mth.m_14107_((double)(this.z - (double)damageRadius - 1.0));
        int maxZ = Mth.m_14107_((double)(this.z + (double)damageRadius + 1.0));
        List entities = this.world.m_45976_(Entity.class, new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        ForgeEventFactory.onExplosionDetonate((Level)this.world, (Explosion)this, (List)entities, (double)damageRadius);
        Vec3 explosionPos = new Vec3(this.x, this.y, this.z);
        for (Entity entity : entities) {
            Player player;
            float damage;
            if (entity.m_6128_()) continue;
            double distance = Math.sqrt(entity.m_20238_(explosionPos));
            double maxDamageDistance = this.explosionRadius;
            double maxDistance = (double)this.explosionRadius * 2.0;
            if (distance >= maxDistance) continue;
            if (distance <= maxDamageDistance) {
                damage = this.customDamage;
            } else {
                float falloffMultiplier = 1.0f - (float)((distance - maxDamageDistance) / (maxDistance - maxDamageDistance));
                damage = this.customDamage * falloffMultiplier;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                damage = this.applyBlastProtection(livingEntity, damage);
            }
            if (!(damage > 0.0f)) continue;
            entity.m_6469_(this.m_46077_(), damage);
            double deltaX = entity.m_20185_() - this.x;
            double deltaY = entity.m_20188_() - this.y;
            double deltaZ = entity.m_20189_() - this.z;
            double distanceToExplosion = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
            if (distanceToExplosion != 0.0) {
                deltaX /= distanceToExplosion;
                deltaY /= distanceToExplosion;
                deltaZ /= distanceToExplosion;
            } else {
                deltaX = 0.0;
                deltaY = 1.0;
                deltaZ = 0.0;
            }
            double knockbackStrength = Math.max(0.0, (1.0 - distance / maxDistance) * 0.5);
            entity.m_20256_(entity.m_20184_().m_82520_(deltaX * knockbackStrength, deltaY * knockbackStrength, deltaZ * knockbackStrength));
            if (!(entity instanceof Player) || (player = (Player)entity).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
            this.m_46078_().put(player, new Vec3(deltaX * knockbackStrength, deltaY * knockbackStrength, deltaZ * knockbackStrength));
        }
    }

    private void playExplosionSound() {
        if (!this.world.f_46443_) {
            float volume = Math.min(4.0f, this.explosionRadius * 0.6f);
            float pitch = 0.8f + this.world.f_46441_.m_188501_() * 0.4f;
            this.world.m_6263_(null, this.x, this.y, this.z, SoundEvents.f_11913_, SoundSource.BLOCKS, volume, pitch);
        }
    }

    private float applyBlastProtection(LivingEntity target, float damage) {
        int protectionLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44968_, (LivingEntity)target);
        if (protectionLevel > 0) {
            float reduction = (float)protectionLevel * 0.08f;
            reduction = Math.min(reduction, 0.8f);
            damage *= 1.0f - reduction;
        }
        return damage;
    }

    @Override
    protected float getEntityDamageAmount(Entity entity, double distance) {
        double maxDistance = (double)this.explosionRadius * 2.0;
        if (distance >= maxDistance) {
            return 0.0f;
        }
        float falloffMultiplier = 1.0f - (float)(distance / maxDistance);
        return this.customDamage * falloffMultiplier;
    }

    public void m_46075_(boolean spawnParticles) {
        super.m_46075_(spawnParticles);
        if (spawnParticles && !this.world.f_46443_) {
            this.spawnCustomRocketParticles();
        }
    }

    private void spawnCustomRocketParticles() {
        ServerLevel serverLevel = (ServerLevel)this.world;
        double sizeMultiplier = (double)this.explosionRadius / 4.0;
        BlockPos explosionPos = BlockPos.m_274561_((double)this.x, (double)this.y, (double)this.z);
        BlockState blockAtExplosion = this.world.m_8055_(explosionPos);
        double adjustedY = !blockAtExplosion.m_60795_() ? (double)explosionPos.m_123342_() + 1.0 : this.y + 0.2;
        double renderDistance = 128.0;
        List nearbyPlayers = serverLevel.m_45976_(ServerPlayer.class, new AABB(this.x - renderDistance, this.y - renderDistance, this.z - renderDistance, this.x + renderDistance, this.y + renderDistance, this.z + renderDistance));
        for (ServerPlayer player : nearbyPlayers) {
            serverLevel.m_8624_(player, (ParticleOptions)((SimpleParticleType)ModParticleTypes.ROCKET_EXPLOSION.get()), true, this.x, adjustedY, this.z, 1, 0.1, 0.1, 0.1, sizeMultiplier);
        }
        for (int burstWave = 0; burstWave < 3; ++burstWave) {
            int particlesInBurst = 8 + burstWave * 4;
            double burstRadius = (double)this.explosionRadius * (0.3 + (double)burstWave * 0.15);
            for (int i = 0; i < particlesInBurst; ++i) {
                double angle = (double)i / (double)particlesInBurst * 2.0 * Math.PI;
                double distance = burstRadius * (0.5 + this.world.f_46441_.m_188500_() * 0.5);
                double burstX = Math.cos(angle) * distance;
                double burstZ = Math.sin(angle) * distance;
                double burstY = (this.world.f_46441_.m_188500_() - 0.3) * (double)this.explosionRadius * 0.1;
                double speedX = Math.cos(angle) * (0.3 + this.world.f_46441_.m_188500_() * 0.4);
                double speedY = 0.2 + this.world.f_46441_.m_188500_() * 0.3;
                double speedZ = Math.sin(angle) * (0.3 + this.world.f_46441_.m_188500_() * 0.4);
                for (ServerPlayer player : nearbyPlayers) {
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, true, this.x + burstX, adjustedY + burstY, this.z + burstZ, 2, speedX, speedY, speedZ, 0.1);
                    if (i % 2 != 0) continue;
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123756_, true, this.x + burstX, adjustedY + burstY, this.z + burstZ, 1, speedX * 0.5, speedY * 0.5, speedZ * 0.5, 0.05);
                }
            }
        }
        for (int scatter = 0; scatter < 25; ++scatter) {
            double scatterRadius = (double)this.explosionRadius * 1.2;
            double scatterAngle = this.world.f_46441_.m_188500_() * 2.0 * Math.PI;
            double scatterDistance = this.world.f_46441_.m_188500_() * scatterRadius;
            double scatterX = Math.cos(scatterAngle) * scatterDistance;
            double scatterZ = Math.sin(scatterAngle) * scatterDistance;
            double scatterY = (this.world.f_46441_.m_188500_() - 0.5) * (double)this.explosionRadius * 0.3;
            double scatterSpeedX = (this.world.f_46441_.m_188500_() - 0.5) * 0.6;
            double scatterSpeedY = this.world.f_46441_.m_188500_() * 0.4;
            double scatterSpeedZ = (this.world.f_46441_.m_188500_() - 0.5) * 0.6;
            if (this.world.f_46441_.m_188499_()) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.x + scatterX, adjustedY + scatterY, this.z + scatterZ, 1, scatterSpeedX, scatterSpeedY, scatterSpeedZ, 0.1);
                continue;
            }
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.x + scatterX, adjustedY + scatterY, this.z + scatterZ, 1, scatterSpeedX, scatterSpeedY, scatterSpeedZ, 0.05);
        }
        this.createSimpleDelayedEffects(serverLevel, adjustedY, sizeMultiplier);
    }

    private void createSimpleDelayedEffects(ServerLevel serverLevel, double adjustedY, double sizeMultiplier) {
        for (int i = 0; i < 6; ++i) {
            double angle = (double)i / 6.0 * 2.0 * Math.PI;
            double distance = (double)this.explosionRadius * (0.6 + this.world.f_46441_.m_188500_() * 0.4);
            double offsetX = Math.cos(angle) * distance;
            double offsetZ = Math.sin(angle) * distance;
            double offsetY = (this.world.f_46441_.m_188500_() - 0.5) * (double)this.explosionRadius * 0.1;
            DelayedRocketParticle delayedParticle = new DelayedRocketParticle(this.world, this.x + offsetX, adjustedY + offsetY, this.z + offsetZ, sizeMultiplier * 0.6, 2 + this.world.f_46441_.m_188503_(3), angle, 0);
            this.world.m_7967_((Entity)delayedParticle);
        }
    }

    public static class DelayedRocketParticle
    extends Entity {
        private final double particleSize;
        private final int spawnDelay;
        private final double angle;
        private final int waveIndex;
        private int ticksAlive = 0;

        public DelayedRocketParticle(Level world, double x, double y, double z, double size, int delay, double angle, int wave) {
            super(EntityType.f_147036_, world);
            this.m_6034_(x, y, z);
            this.particleSize = size;
            this.spawnDelay = delay;
            this.angle = angle;
            this.waveIndex = wave;
            this.f_19794_ = true;
        }

        public void m_8119_() {
            super.m_8119_();
            ++this.ticksAlive;
            if (this.ticksAlive == this.spawnDelay && !this.m_9236_().m_5776_()) {
                ServerLevel serverLevel = (ServerLevel)this.m_9236_();
                double renderDistance = 128.0;
                List nearbyPlayers = serverLevel.m_45976_(ServerPlayer.class, new AABB(this.m_20185_() - renderDistance, this.m_20186_() - renderDistance, this.m_20189_() - renderDistance, this.m_20185_() + renderDistance, this.m_20186_() + renderDistance, this.m_20189_() + renderDistance));
                for (ServerPlayer player : nearbyPlayers) {
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123783_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, this.particleSize);
                }
                double speedX = Math.cos(this.angle) * (0.1 + this.m_9236_().f_46441_.m_188500_() * 0.15);
                double speedY = 0.1 + this.m_9236_().f_46441_.m_188500_() * 0.2;
                double speedZ = Math.sin(this.angle) * (0.1 + this.m_9236_().f_46441_.m_188500_() * 0.15);
                if (this.waveIndex == 0 || this.m_9236_().f_46441_.m_188500_() < 0.3) {
                    for (ServerPlayer player : nearbyPlayers) {
                        serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, speedX, speedY, speedZ, 0.1);
                    }
                }
                if (this.m_9236_().f_46441_.m_188500_() < 0.4) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, speedX * 0.3, speedY * 0.3, speedZ * 0.3, 0.1);
                }
                if (this.waveIndex <= 1 && this.m_9236_().f_46441_.m_188500_() < 0.2) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20189_(), this.m_20189_(), 3, speedX * 0.2, speedY * 0.2, speedZ * 0.2, 0.05);
                }
                this.m_146870_();
            }
            if (this.ticksAlive > 20) {
                this.m_146870_();
            }
        }

        protected void m_8097_() {
        }

        protected void m_7378_(CompoundTag tag) {
        }

        protected void m_7380_(CompoundTag tag) {
        }
    }
}

