/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.effect;

import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import top.ribs.scguns.init.ModEffects;

public class SulfurPoisoningEffect
extends MobEffect {
    public SulfurPoisoningEffect(MobEffectCategory typeIn, int liquidColorIn) {
        super(typeIn, liquidColorIn);
        this.m_19472_(Attributes.f_22279_, "7107DE5E-7CE8-4030-940E-514C1F160890", -0.25, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.m_19472_(Attributes.f_22288_, "9107DE5E-7CE8-4030-940E-514C1F160892", -0.3, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.m_19472_(Attributes.f_22283_, "A107DE5E-7CE8-4030-940E-514C1F160893", -0.2, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        float damage;
        int originalDuration;
        MobEffectInstance effect = entity.m_21124_((MobEffect)ModEffects.SULFUR_POISONING.get());
        if (effect == null) {
            return;
        }
        int duration = effect.m_19557_();
        float intensityRatio = this.calculateIntensityRatio(duration, originalDuration = this.getOriginalDuration(effect));
        int damageInterval = Math.max(20, (int)(40.0f - (float)(amplifier * 10) * intensityRatio));
        if (entity.f_19797_ % damageInterval == 0 && (damage = (1.0f + (float)amplifier * 0.5f) * intensityRatio) > 0.2f) {
            entity.m_6469_(entity.m_269291_().m_269425_(), damage);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.handlePlayerEffects(player, amplifier, intensityRatio, entity.m_217043_());
        }
        if (intensityRatio > 0.3f) {
            this.applyIntensePhaseEffects(entity, amplifier, intensityRatio, entity.m_217043_());
        }
        super.m_6742_(entity, amplifier);
    }

    private void handlePlayerEffects(Player player, int amplifier, float intensityRatio, RandomSource random) {
        if (intensityRatio > 0.5f) {
            if (player.f_19797_ % (int)(60.0f / intensityRatio) == 0) {
                player.m_36324_().m_38703_(0.15f + (float)amplifier * 0.1f * intensityRatio);
            }
        } else if (player.f_19797_ % 100 == 0) {
            player.m_36324_().m_38703_(0.05f + (float)amplifier * 0.03f * intensityRatio);
        }
    }

    private void applyIntensePhaseEffects(LivingEntity entity, int amplifier, float intensityRatio, RandomSource random) {
        if (intensityRatio < 0.7f) {
            return;
        }
        if (entity.f_19797_ % 200 == 0 && random.m_188501_() < 0.3f * intensityRatio) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, (int)(60.0f * intensityRatio), 0));
        }
        if (intensityRatio > 0.8f && entity.f_19797_ % 300 == 0 && random.m_188501_() < 0.2f) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, (int)(40.0f * intensityRatio), 0));
        }
        if (intensityRatio > 0.9f && amplifier >= 2 && entity.f_19797_ % 400 == 0 && random.m_188501_() < 0.1f) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 30, 0));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 1));
        }
    }

    private float calculateIntensityRatio(int remainingDuration, int originalDuration) {
        if (originalDuration <= 0) {
            return 1.0f;
        }
        float ratio = (float)remainingDuration / (float)originalDuration;
        if (ratio > 0.7f) {
            return 1.0f;
        }
        if (ratio > 0.3f) {
            return 0.4f + (ratio - 0.3f) * 1.5f;
        }
        return Math.max(0.1f, ratio * 1.33f);
    }

    private int getOriginalDuration(MobEffectInstance effect) {
        int currentDuration = effect.m_19557_();
        if (currentDuration > 1000) {
            return Math.max(1200, currentDuration + 200);
        }
        if (currentDuration > 500) {
            return Math.max(800, currentDuration + 150);
        }
        return Math.max(400, currentDuration + 100);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public static boolean hasFireVulnerability(LivingEntity entity) {
        return entity.m_21023_((MobEffect)ModEffects.SULFUR_POISONING.get());
    }

    public static float getFireDamageMultiplier(LivingEntity entity) {
        if (!SulfurPoisoningEffect.hasFireVulnerability(entity)) {
            return 1.0f;
        }
        MobEffectInstance effect = entity.m_21124_((MobEffect)ModEffects.SULFUR_POISONING.get());
        if (effect == null) {
            return 1.0f;
        }
        int amplifier = effect.m_19564_();
        SulfurPoisoningEffect poisonEffect = (SulfurPoisoningEffect)effect.m_19544_();
        float intensityRatio = poisonEffect.calculateIntensityRatio(effect.m_19557_(), poisonEffect.getOriginalDuration(effect));
        float baseMultiplier = 1.3f + (float)amplifier * 0.3f;
        return 1.0f + (baseMultiplier - 1.0f) * intensityRatio;
    }
}

