/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.entity.monster.CogKnightEntity;
import top.ribs.scguns.item.GunItem;

public class CogKnightModel<T extends Entity>
extends HierarchicalModel<T>
implements ArmedModel {
    private final ModelPart main;
    private final ModelPart head;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart torso;
    private final ModelPart cog;
    private final ModelPart cog2;
    private final PartPose headDefault;
    private final PartPose leftArmDefault;
    private final PartPose rightArmDefault;
    private final PartPose torsoDefault;
    private final PartPose mainDefault;
    private float attackStartTime = -1.0f;
    private int lastAttackTimeout = 0;
    private static final float ATTACK_DURATION = 12.0f;

    public CogKnightModel(ModelPart root) {
        this.main = root.m_171324_("CogKnight");
        ModelPart full = this.main.m_171324_("Full");
        this.head = full.m_171324_("Head");
        this.leftArm = full.m_171324_("LeftArm");
        this.rightArm = full.m_171324_("RightArm");
        this.torso = full.m_171324_("Torso");
        this.cog = this.torso.m_171324_("Cog");
        this.cog2 = this.torso.m_171324_("Cog2");
        this.headDefault = this.head.m_171308_();
        this.leftArmDefault = this.leftArm.m_171308_();
        this.rightArmDefault = this.rightArm.m_171308_();
        this.torsoDefault = this.torso.m_171308_();
        this.mainDefault = this.main.m_171308_();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition CogKnight = partdefinition.m_171599_("CogKnight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)7.0f, (float)-0.6589f));
        PartDefinition Full = CogKnight.m_171599_("Full", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)0.8889f, (float)-0.1111f));
        PartDefinition Torso = Full.m_171599_("Torso", CubeListBuilder.m_171558_().m_171514_(0, 65).m_171488_(5.0f, -9.8889f, -4.8889f, 2.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(30, 44).m_171488_(-4.0f, -0.8889f, -2.8889f, 8.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(35, 0).m_171488_(-5.0f, 3.1111f, -3.8889f, 10.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-6.0f, 6.1111f, -5.8889f, 12.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(33, 27).m_171488_(-5.0f, 15.1111f, -4.8889f, 10.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(0, 20).m_171488_(-6.0f, -7.8889f, -5.8889f, 12.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(62, 23).m_171488_(-4.0f, -7.8889f, 3.1111f, 8.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(30, 37).m_171488_(-7.0f, -9.8889f, 1.1111f, 14.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(64, 37).m_171488_(-7.0f, -9.8889f, -4.8889f, 2.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Cog = Torso.m_171599_("Cog", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-4.6289f, (float)6.67f));
        PartDefinition cube_r1 = Cog.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(45, 23).m_171488_(-1.5f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(40, 69).m_171488_(-1.0f, -5.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.01f, (float)0.1f, (float)0.0f, (float)1.5708f, (float)1.5708f));
        PartDefinition cube_r2 = Cog.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(48, 69).m_171488_(-1.0f, -5.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.015f, (float)0.05f, (float)0.0f, (float)1.5708f, (float)2.3562f));
        PartDefinition cube_r3 = Cog.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(48, 69).m_171488_(-1.0f, -5.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.015f, (float)0.05f, (float)0.0f, (float)1.5708f, (float)0.7854f));
        PartDefinition cube_r4 = Cog.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(40, 69).m_171488_(-1.0f, -5.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.01f, (float)0.1f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition Cog2 = Torso.m_171599_("Cog2", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)17.3511f, (float)-0.33f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = Cog2.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(45, 23).m_171488_(-0.75f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(40, 69).m_171488_(-0.25f, -5.0f, -1.0f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.01f, (float)0.12f, (float)0.0f, (float)1.5708f, (float)1.5708f));
        PartDefinition cube_r6 = Cog2.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(48, 69).m_171488_(-0.25f, -5.0f, -1.0f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.015f, (float)0.07f, (float)0.0f, (float)1.5708f, (float)2.3562f));
        PartDefinition cube_r7 = Cog2.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(48, 69).m_171488_(-0.25f, -5.0f, -1.0f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.015f, (float)0.07f, (float)0.0f, (float)1.5708f, (float)0.7854f));
        PartDefinition cube_r8 = Cog2.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(40, 69).m_171488_(-0.25f, -5.0f, -1.0f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.01f, (float)0.12f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition Head = Full.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171488_(-3.0f, -9.0f, -5.0f, 8.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(36, 11).m_171488_(-2.0f, -10.0f, -4.0f, 6.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(64, 47).m_171488_(-3.0f, -8.0f, -6.0f, 8.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(69, 0).m_171488_(-4.0f, -8.0f, -6.0f, 1.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(26, 67).m_171488_(5.0f, -8.0f, -6.0f, 1.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(20, 53).m_171488_(-2.5f, -9.0f, 2.0f, 7.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-6.8889f, (float)0.1111f));
        PartDefinition head_r1 = Head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171488_(-2.0f, -24.0f, -40.75f, 6.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)38.0f, (float)0.0f, (float)-1.1781f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = Full.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(16, 62).m_171488_(-5.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(49, 46).m_171488_(-6.0f, -3.0f, -4.0f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(59, 57).m_171488_(-2.0f, -4.0f, -4.0f, 2.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(39, 57).m_171488_(-6.0f, 7.0f, -3.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(58, 11).m_171488_(-5.0f, 14.0f, -3.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-7.8889f, (float)0.1111f));
        PartDefinition LeftHand = LeftArm.m_171599_("LeftHand", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightHand = Full.m_171599_("RightHand", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)6.0f, (float)-7.8889f, (float)0.1111f));
        PartDefinition RightArm = Full.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(16, 62).m_171480_().m_171488_(1.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(49, 46).m_171480_().m_171488_(2.0f, -3.0f, -4.0f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(59, 57).m_171480_().m_171488_(0.0f, -4.0f, -4.0f, 2.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(39, 57).m_171480_().m_171488_(1.0f, 7.0f, -3.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(58, 11).m_171480_().m_171488_(0.0f, 14.0f, -3.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)-7.8889f, (float)0.1111f));
        PartDefinition SHIELD = RightArm.m_171599_("SHIELD", CubeListBuilder.m_171558_().m_171514_(74, 24).m_171488_(-6.0f, 9.5f, -4.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(67, 59).m_171488_(-1.0f, 1.5f, -5.0f, 2.0f, 16.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 24).m_171488_(-4.0f, 9.5f, -4.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 24).m_171488_(-4.0f, 9.5f, 3.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)5.5f, (float)0.0f));
        PartDefinition cube_r9 = SHIELD.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(8, 84).m_171488_(-1.575f, -1.25f, -4.0f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition cube_r10 = SHIELD.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(8, 73).m_171488_(-1.575f, -1.75f, -4.0f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)19.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_6973_(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.main.m_171322_(this.mainDefault);
        this.head.m_171322_(this.headDefault);
        this.leftArm.m_171322_(this.leftArmDefault);
        this.rightArm.m_171322_(this.rightArmDefault);
        this.torso.m_171322_(this.torsoDefault);
        if (entity instanceof CogKnightEntity) {
            CogKnightEntity cogKnight = (CogKnightEntity)((Object)entity);
            boolean isHoldingGun = cogKnight.m_21205_().m_41720_() instanceof GunItem;
            float bobAmount = Mth.m_14031_((float)(ageInTicks * 0.05f));
            this.main.f_104201_ += bobAmount;
            if (limbSwingAmount > 0.01f) {
                float walkSway = Mth.m_14031_((float)(limbSwing * 0.6f)) * limbSwingAmount * 0.3f;
                this.main.f_104205_ = walkSway * 0.1f;
                this.torso.f_104204_ = walkSway * 0.05f;
                if (!(isHoldingGun || cogKnight.isCharging() || cogKnight.isAttacking())) {
                    float hoverAngle = limbSwingAmount * 0.4f;
                    float tinySwing = Mth.m_14031_((float)(ageInTicks * 0.15f)) * 0.05f;
                    this.leftArm.f_104203_ = hoverAngle + tinySwing;
                    this.rightArm.f_104203_ = hoverAngle - tinySwing;
                }
            }
            float backCogSpeed = 0.1f;
            float propellerSpeed = 0.4f;
            if (cogKnight.isCharging()) {
                backCogSpeed = 0.3f;
                this.main.f_104203_ = -0.3f;
                this.leftArm.f_104203_ = -1.5f;
                this.leftArm.f_104205_ = -0.2f;
                float chargeTime = ageInTicks * 0.8f;
                this.leftArm.f_104203_ += Mth.m_14089_((float)chargeTime) * 0.1f;
                this.torso.f_104205_ = Mth.m_14031_((float)(ageInTicks * 0.6f)) * 0.1f;
            } else if (cogKnight.isAttacking() && cogKnight.getAttackTimeout() > 0) {
                backCogSpeed = 0.25f;
                this.animateAttackSmooth(cogKnight.getAttackTimeout(), ageInTicks);
            } else if (isHoldingGun) {
                this.leftArm.f_104203_ = -1.5708f;
                this.leftArm.f_104204_ = 0.0f;
                this.leftArm.f_104205_ = 0.0f;
                this.rightArm.f_104203_ = -1.3f;
                this.rightArm.f_104204_ = 0.6f;
                this.rightArm.f_104205_ = 0.2f;
            }
            this.cog2.f_104204_ = ageInTicks * propellerSpeed % ((float)Math.PI * 2);
            this.cog.f_104205_ = ageInTicks * backCogSpeed % ((float)Math.PI * 2);
            float clampedYaw = Mth.m_14036_((float)netHeadYaw, (float)-75.0f, (float)75.0f);
            float clampedPitch = Mth.m_14036_((float)headPitch, (float)-30.0f, (float)30.0f);
            this.head.f_104204_ = clampedYaw * ((float)Math.PI / 180);
            this.head.f_104203_ = clampedPitch * ((float)Math.PI / 180);
        }
    }

    private void animateAttackSmooth(int attackTimeout, float ageInTicks) {
        if (attackTimeout <= 0) {
            this.leftArm.f_104203_ = 0.0f;
            this.leftArm.f_104204_ = 0.0f;
            this.leftArm.f_104205_ = 0.0f;
            this.torso.f_104204_ = 0.0f;
            this.attackStartTime = -1.0f;
            this.lastAttackTimeout = 0;
            return;
        }
        if (attackTimeout > this.lastAttackTimeout || this.attackStartTime < 0.0f) {
            this.attackStartTime = ageInTicks;
        }
        this.lastAttackTimeout = attackTimeout;
        float elapsedTime = ageInTicks - this.attackStartTime;
        float attackProgress = elapsedTime / 12.0f;
        attackProgress = Mth.m_14036_((float)attackProgress, (float)0.0f, (float)1.0f);
        float swingCurve = Mth.m_14031_((float)(attackProgress * (float)Math.PI));
        this.leftArm.f_104203_ = -swingCurve * 2.0f;
        this.leftArm.f_104204_ = 0.0f;
        this.leftArm.f_104205_ = 0.0f;
        this.torso.f_104204_ = 0.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.main.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void m_6002_(HumanoidArm pSide, PoseStack pPoseStack) {
        if (pSide == HumanoidArm.LEFT) {
            boolean isHoldingGun;
            float mainYOffset = this.main.f_104201_;
            pPoseStack.m_85837_(0.0625, 0.4375 + (double)(mainYOffset / 16.0f), 0.0);
            this.leftArm.m_104299_(pPoseStack);
            float armRotation = this.leftArm.f_104203_;
            float armZRot = this.leftArm.f_104205_;
            float dynamicOffset = 0.6f;
            boolean isCharging = armRotation < -1.4f && armZRot < -0.2f;
            boolean bl = isHoldingGun = Math.abs(armRotation + 1.5708f) < 0.1f;
            if (isCharging) {
                pPoseStack.m_85837_(-0.35, 0.5, -0.2);
            } else if (isHoldingGun) {
                pPoseStack.m_85837_(-0.25, (double)dynamicOffset - 0.1, 0.05);
            } else if (armRotation < -0.5f) {
                pPoseStack.m_85837_(-0.25, (double)(dynamicOffset += Math.abs(armRotation + 0.3f) * 0.1f), 0.0);
            } else {
                pPoseStack.m_85837_(-0.25, (double)dynamicOffset, 0.0);
            }
        }
    }

    public ModelPart m_142109_() {
        return this.main;
    }
}

