/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.animatable.GeoItem;
import top.ribs.scguns.entity.client.ModModelLayers;
import top.ribs.scguns.entity.client.ViventrumModel;
import top.ribs.scguns.entity.monster.ViventrumEntity;

public class ViventrumRenderer
extends MobRenderer<ViventrumEntity, ViventrumModel<ViventrumEntity>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("scguns", "textures/entity/viventrum.png");

    public ViventrumRenderer(EntityRendererProvider.Context context) {
        super(context, new ViventrumModel(context.m_174023_(ModModelLayers.VIVENTRUM_LAYER)), 0.3f);
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
        this.m_115326_(new ViventrumHelmetLayer(this, context.m_174027_(), context.m_234598_()));
    }

    public ResourceLocation getTextureLocation(ViventrumEntity entity) {
        return TEXTURE;
    }

    public void render(ViventrumEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.9f, 0.9f, 0.9f);
        poseStack.m_85837_(0.0, 0.45, 0.0);
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.m_85849_();
    }

    private static class ViventrumHelmetLayer
    extends RenderLayer<ViventrumEntity, ViventrumModel<ViventrumEntity>> {
        private final ItemInHandRenderer itemInHandRenderer;
        private final HumanoidModel<ViventrumEntity> helmetModel;

        public ViventrumHelmetLayer(MobRenderer<ViventrumEntity, ViventrumModel<ViventrumEntity>> renderer, EntityModelSet modelSet, ItemInHandRenderer itemInHandRenderer) {
            super(renderer);
            this.itemInHandRenderer = itemInHandRenderer;
            this.helmetModel = new HumanoidModel(modelSet.m_171103_(ModelLayers.f_171164_));
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, ViventrumEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack helmetStack = entity.m_6844_(EquipmentSlot.HEAD);
            if (helmetStack.m_41619_()) {
                return;
            }
            Item item = helmetStack.m_41720_();
            poseStack.m_85836_();
            ((ViventrumModel)this.m_117386_()).m_5585_().m_104299_(poseStack);
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                if (item instanceof GeoItem) {
                    poseStack.m_85849_();
                    return;
                }
                this.renderVanillaHelmet(poseStack, buffer, packedLight, entity, helmetStack, armorItem);
            } else if (item instanceof BlockItem) {
                poseStack.m_85841_(0.625f, -0.625f, -0.625f);
                poseStack.m_85837_(0.0, -0.5, 0.0);
                this.itemInHandRenderer.m_269530_((LivingEntity)entity, helmetStack, ItemDisplayContext.HEAD, false, poseStack, buffer, packedLight);
            }
            poseStack.m_85849_();
        }

        private void renderVanillaHelmet(PoseStack poseStack, MultiBufferSource buffer, int packedLight, ViventrumEntity entity, ItemStack helmetStack, ArmorItem armorItem) {
            poseStack.m_85841_(1.05f, 1.05f, 1.05f);
            poseStack.m_85837_(0.0, 0.1, -0.0);
            this.helmetModel.f_102808_.f_104203_ = 0.0f;
            this.helmetModel.f_102808_.f_104204_ = 0.0f;
            this.helmetModel.f_102808_.f_104205_ = 0.0f;
            this.helmetModel.f_102810_.f_104207_ = false;
            this.helmetModel.f_102811_.f_104207_ = false;
            this.helmetModel.f_102812_.f_104207_ = false;
            this.helmetModel.f_102813_.f_104207_ = false;
            this.helmetModel.f_102814_.f_104207_ = false;
            this.helmetModel.f_102809_.f_104207_ = false;
            this.helmetModel.f_102808_.f_104207_ = true;
            ResourceLocation texture = this.getArmorTexture(helmetStack);
            RenderType renderType = RenderType.m_110431_((ResourceLocation)texture);
            VertexConsumer vertexConsumer = buffer.m_6299_(renderType);
            this.helmetModel.f_102808_.m_104306_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            this.helmetModel.f_102810_.f_104207_ = true;
            this.helmetModel.f_102811_.f_104207_ = true;
            this.helmetModel.f_102812_.f_104207_ = true;
            this.helmetModel.f_102813_.f_104207_ = true;
            this.helmetModel.f_102814_.f_104207_ = true;
        }

        private ResourceLocation getArmorTexture(ItemStack stack) {
            ArmorItem item = (ArmorItem)stack.m_41720_();
            String texture = item.m_40401_().m_6082_();
            String domain = "minecraft";
            int idx = texture.indexOf(58);
            if (idx != -1) {
                domain = texture.substring(0, idx);
                texture = texture.substring(idx + 1);
            }
            String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d.png", domain, texture, 1);
            return new ResourceLocation(s1);
        }
    }
}

