/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.entity.projectile.EnemyProjectileEntity;
import top.ribs.scguns.init.ModSounds;

public class BlundererEntity
extends Raider
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(BlundererEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MUZZLE_FLASH_TIMER = SynchedEntityData.m_135353_(BlundererEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    private int idleAnimationTimeout = 0;
    private int attackTime = -1;

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21643_;
    }

    public BlundererEntity(EntityType<? extends Raider> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20084_(UUID.randomUUID());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 21.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22282_, (double)0.8f).m_22268_(Attributes.f_22281_, 2.0);
    }

    public void triggerMuzzleFlash() {
        this.f_19804_.m_135381_(MUZZLE_FLASH_TIMER, (Object)10);
    }

    public boolean isMuzzleFlashVisible() {
        return (Integer)this.f_19804_.m_135370_(MUZZLE_FLASH_TIMER) > 0;
    }

    public void m_8119_() {
        int currentTimer;
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
            this.spawnSmokeParticles();
        }
        if ((currentTimer = ((Integer)this.f_19804_.m_135370_(MUZZLE_FLASH_TIMER)).intValue()) > 0) {
            this.f_19804_.m_135381_(MUZZLE_FLASH_TIMER, (Object)(currentTimer - 1));
        }
        if (this.isAttacking() && --this.attackTime <= 0) {
            this.attackTime = 50;
            LivingEntity target = this.m_5448_();
            if (target != null) {
                this.m_6504_(target, 1.0f);
            }
        }
    }

    private void spawnSmokeParticles() {
        if (this.isMuzzleFlashVisible()) {
            double offsetX = 0.0;
            double offsetY = (double)this.m_20192_() - 0.5;
            double offsetZ = 0.0;
            double posX = this.m_20185_() + offsetX;
            double posY = this.m_20186_() + offsetY;
            double posZ = this.m_20189_() + offsetZ;
            RandomSource random = this.m_217043_();
            for (int i = 0; i < 3; ++i) {
                double particleOffsetX = random.m_188583_() * 0.1;
                double particleOffsetY = random.m_188583_() * 0.1;
                double particleOffsetZ = random.m_188583_() * 0.1;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, posX, posY, posZ, particleOffsetX, particleOffsetY, particleOffsetZ);
            }
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isAttacking()) {
            if (this.attackAnimationTimeout <= 0) {
                this.attackAnimationTimeout = 20;
                this.attackAnimationState.m_216977_(this.f_19797_);
            }
            --this.attackAnimationTimeout;
        } else {
            this.attackAnimationState.m_216973_();
        }
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(MUZZLE_FLASH_TIMER, (Object)0);
    }

    public void m_7895_(int pWave, boolean pUnusedFalse) {
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new RangedAttackGoal(this, 1.0, 50, 15.0f){

            public void m_8041_() {
                super.m_8041_();
                BlundererEntity.this.setAttacking(false);
            }

            public void m_8056_() {
                super.m_8056_();
                BlundererEntity.this.setAttacking(true);
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[]{Raider.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12307_;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12310_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12309_;
    }

    public void m_6504_(@NotNull LivingEntity target, float distanceFactor) {
        int numberOfPellets = 5;
        float maxSpreadAngle = 11.0f;
        double offsetX = 0.0;
        double offsetY = (double)this.m_20192_() - 0.5;
        double offsetZ = -0.5;
        double targetX = target.m_20185_() - (this.m_20185_() + offsetX);
        double targetY = target.m_20188_() - (this.m_20186_() + offsetY);
        double targetZ = target.m_20189_() - (this.m_20189_() + offsetZ);
        double distance = Math.sqrt(targetX * targetX + targetY * targetY + targetZ * targetZ);
        double baseX = targetX / distance;
        double baseY = targetY / distance;
        double baseZ = targetZ / distance;
        for (int i = 0; i < numberOfPellets; ++i) {
            double perpZ1;
            double perpY1;
            double perpX1;
            EnemyProjectileEntity projectile = new EnemyProjectileEntity(this.m_9236_(), (LivingEntity)this);
            float spreadRadius = (float)(Math.random() * Math.toRadians(maxSpreadAngle));
            float spreadAngle = (float)(Math.random() * 2.0 * Math.PI);
            if (Math.abs(baseY) < 0.9) {
                perpX1 = 0.0;
                perpY1 = baseZ;
                perpZ1 = -baseY;
            } else {
                perpX1 = baseZ;
                perpY1 = 0.0;
                perpZ1 = -baseX;
            }
            double perpLength1 = Math.sqrt(perpX1 * perpX1 + perpY1 * perpY1 + perpZ1 * perpZ1);
            double perpX2 = baseY * (perpZ1 /= perpLength1) - baseZ * (perpY1 /= perpLength1);
            double perpY2 = baseZ * (perpX1 /= perpLength1) - baseX * perpZ1;
            double perpZ2 = baseX * perpY1 - baseY * perpX1;
            double spreadX = Math.cos(spreadAngle) * Math.sin(spreadRadius);
            double spreadZ = Math.sin(spreadAngle) * Math.sin(spreadRadius);
            double finalX = baseX * Math.cos(spreadRadius) + (perpX1 * spreadX + perpX2 * spreadZ);
            double finalY = baseY * Math.cos(spreadRadius) + (perpY1 * spreadX + perpY2 * spreadZ);
            double finalZ = baseZ * Math.cos(spreadRadius) + (perpZ1 * spreadX + perpZ2 * spreadZ);
            projectile.m_6034_(this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ);
            projectile.m_6686_(finalX, finalY, finalZ, 2.6f, 0.0f);
            this.m_9236_().m_7967_((Entity)projectile);
        }
        this.m_5496_((SoundEvent)ModSounds.BLACKPOWDER_FIRE.get(), 1.0f, 1.0f);
        this.triggerMuzzleFlash();
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12308_;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_37897_(this.m_6095_() != EntityType.f_20495_ || pReason != MobSpawnType.NATURAL);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return this.m_37885_() == null && super.m_6785_(pDistanceToClosestPlayer);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_37885_() != null;
    }

    public void m_20084_(UUID uuid) {
        super.m_20084_(uuid);
    }
}

