/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.init.ModSounds;

public class DissidentEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(DissidentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEAPING = SynchedEntityData.m_135353_(DissidentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    private int idleAnimationTimeout = 0;

    public DissidentEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 10;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.31).m_22268_(Attributes.f_22285_, 0.5).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22282_, (double)0.8f).m_22268_(Attributes.f_22281_, 5.0);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isAttacking()) {
            if (this.attackAnimationTimeout <= 0) {
                this.attackAnimationTimeout = 12;
                this.attackAnimationState.m_216977_(this.f_19797_);
            }
            --this.attackAnimationTimeout;
        } else {
            this.attackAnimationState.m_216973_();
        }
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.9;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Mob) {
            return (Mob)entity;
        }
        return null;
    }

    protected void m_8022_() {
        boolean flag = !(this.m_6688_() instanceof Mob);
        boolean flag1 = !(this.m_20202_() instanceof Boat);
        this.f_21345_.m_25360_(Goal.Flag.MOVE, flag);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, flag && flag1);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, flag);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        Zombie babyZombie;
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pLevel.m_213780_().m_188501_() < 0.25f && (babyZombie = (Zombie)EntityType.f_20501_.m_20615_((Level)pLevel.m_6018_())) != null) {
            babyZombie.m_6863_(true);
            babyZombie.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            babyZombie.m_6518_(pLevel, pDifficulty, pReason, null, null);
            babyZombie.m_20329_((Entity)this);
            pLevel.m_7967_((Entity)babyZombie);
        }
        return pSpawnData;
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(LEAPING, (Object)false);
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void setLeaping(boolean leaping) {
        this.f_19804_.m_135381_(LEAPING, (Object)leaping);
    }

    public boolean isLeaping() {
        return (Boolean)this.f_19804_.m_135370_(LEAPING);
    }

    protected void m_7581_(ItemEntity pItemEntity) {
        super.m_7581_(pItemEntity);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new LeapAttackGoal(this, 1.0, 10.0, 80));
        this.f_21345_.m_25352_(2, (Goal)new DissidentAttackGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{DissidentEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(3, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 30.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public void m_7822_(byte pId) {
        if (pId == 5) {
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 15; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0, this.m_20186_(), this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0, (this.f_19796_.m_188500_() - 0.5) * 0.2, this.f_19796_.m_188500_() * 0.1, (this.f_19796_.m_188500_() - 0.5) * 0.2);
                }
            }
        } else {
            super.m_7822_(pId);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isLeaping() && !this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.8, 1.0));
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12605_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.DISSIDENT_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.DISSIDENT_DIE.get();
    }

    public float getAttackSoundVolume() {
        return 1.0f;
    }

    public static class LeapAttackGoal
    extends Goal {
        private final DissidentEntity mob;
        private final double leapStrength;
        private final double maxLeapDistance;
        private final int leapCooldown;
        private int cooldownTicks;
        private LivingEntity target;
        private boolean isLeaping;
        private int leapTicks;

        public LeapAttackGoal(DissidentEntity mob, double leapStrength, double maxLeapDistance, int leapCooldown) {
            this.mob = mob;
            this.leapStrength = leapStrength;
            this.maxLeapDistance = maxLeapDistance;
            this.leapCooldown = leapCooldown;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (this.cooldownTicks > 0) {
                --this.cooldownTicks;
                return false;
            }
            this.target = this.mob.m_5448_();
            if (this.target == null || !this.target.m_6084_()) {
                return false;
            }
            double distanceToTarget = this.mob.m_20280_((Entity)this.target);
            return distanceToTarget >= 9.0 && distanceToTarget <= this.maxLeapDistance * this.maxLeapDistance && this.mob.m_20096_() && this.mob.m_142582_((Entity)this.target);
        }

        public boolean m_8045_() {
            return this.isLeaping && this.leapTicks > 0 && this.target != null && this.target.m_6084_();
        }

        public void m_8056_() {
            this.isLeaping = true;
            this.leapTicks = 30;
            this.mob.setLeaping(true);
            double dx = this.target.m_20185_() - this.mob.m_20185_();
            double dy = this.target.m_20186_() - this.mob.m_20186_();
            double dz = this.target.m_20189_() - this.mob.m_20189_();
            double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
            if (horizontalDistance > 0.1) {
                dx /= horizontalDistance;
                dz /= horizontalDistance;
                double horizontalVelocity = this.leapStrength;
                double verticalVelocity = 0.6;
                if (dy > 0.0) {
                    verticalVelocity += Math.min(dy * 0.3, 0.5);
                }
                this.mob.m_20334_(dx * horizontalVelocity, verticalVelocity, dz * horizontalVelocity);
                this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)5);
                this.mob.m_5496_(SoundEvents.f_12253_, 1.2f, 0.8f);
            }
        }

        public void m_8037_() {
            if (this.target == null || !this.isLeaping) {
                return;
            }
            --this.leapTicks;
            this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            if (this.mob.m_20280_((Entity)this.target) <= 3.0) {
                this.performLeapAttack();
            }
            if (this.mob.m_20096_() && this.mob.m_20184_().f_82480_ <= 0.1) {
                this.leapTicks = Math.min(this.leapTicks, 5);
                if (this.mob.m_20280_((Entity)this.target) <= 6.0) {
                    this.performLeapAttack();
                }
            }
        }

        public void m_8041_() {
            this.isLeaping = false;
            this.mob.setLeaping(false);
            this.cooldownTicks = this.leapCooldown;
            this.target = null;
            this.leapTicks = 0;
        }

        private void performLeapAttack() {
            if (this.target != null && this.mob.m_20280_((Entity)this.target) <= 6.0) {
                float leapDamage = (float)this.mob.m_21133_(Attributes.f_22281_) * 1.3f;
                this.target.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), leapDamage);
                this.target.m_20256_(this.target.m_20184_().m_82520_(0.0, 0.2, 0.0));
                this.mob.m_5496_(SoundEvents.f_12353_, 1.0f, 1.2f);
                this.mob.setAttacking(true);
            }
            this.leapTicks = 0;
        }
    }

    public static class DissidentAttackGoal
    extends MeleeAttackGoal {
        private final DissidentEntity entity;
        private int attackDelay = 10;
        private int ticksUntilNextAttack = 10;
        private boolean shouldCountTillNextAttack = false;

        public DissidentAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.entity = (DissidentEntity)pMob;
        }

        public void m_8056_() {
            super.m_8056_();
            this.attackDelay = 10;
            this.ticksUntilNextAttack = 10;
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            if (this.isEnemyWithinAttackDistance(pEnemy, pDistToEnemySqr)) {
                this.shouldCountTillNextAttack = true;
                if (this.isTimeToStartAttackAnimation()) {
                    this.entity.setAttacking(true);
                }
                if (this.m_25564_()) {
                    this.f_25540_.m_21563_().m_24946_(pEnemy.m_20185_(), pEnemy.m_20188_(), pEnemy.m_20189_());
                    this.performAttack(pEnemy);
                }
            } else {
                this.m_25563_();
                this.shouldCountTillNextAttack = false;
                this.entity.setAttacking(false);
                this.entity.attackAnimationTimeout = 0;
            }
        }

        private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
            double adjustedAttackDistance = this.m_6639_(pEnemy) * 1.1;
            return pDistToEnemySqr <= adjustedAttackDistance;
        }

        protected void m_25563_() {
            this.ticksUntilNextAttack = this.m_183277_(this.attackDelay * 2);
        }

        protected boolean m_25564_() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected boolean isTimeToStartAttackAnimation() {
            return this.ticksUntilNextAttack <= this.attackDelay;
        }

        protected int m_25565_() {
            return this.ticksUntilNextAttack;
        }

        protected void performAttack(LivingEntity pEnemy) {
            this.m_25563_();
            this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
            this.f_25540_.m_7327_((Entity)pEnemy);
            PathfinderMob pathfinderMob = this.f_25540_;
            if (pathfinderMob instanceof DissidentEntity) {
                DissidentEntity dissident = (DissidentEntity)pathfinderMob;
                this.f_25540_.m_9236_().m_6263_(null, dissident.m_20185_(), dissident.m_20186_(), dissident.m_20189_(), SoundEvents.f_11958_, SoundSource.HOSTILE, dissident.getAttackSoundVolume(), 1.0f);
            }
        }

        public void m_8037_() {
            super.m_8037_();
            LivingEntity target = this.f_25540_.m_5448_();
            if (target != null) {
                double distanceToTarget = this.f_25540_.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                if (this.shouldCountTillNextAttack) {
                    this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
                }
                if (!this.isEnemyWithinAttackDistance(target, distanceToTarget)) {
                    this.f_25540_.m_21573_().m_5624_((Entity)target, 1.2);
                    this.m_25563_();
                    this.shouldCountTillNextAttack = false;
                    this.entity.setAttacking(false);
                    this.entity.attackAnimationTimeout = 0;
                }
            }
        }

        public void m_8041_() {
            this.entity.setAttacking(false);
            super.m_8041_();
        }
    }
}

