/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.config.EntityEquipmentConfig;
import top.ribs.scguns.entity.ai.ConsumeGoldGoal;
import top.ribs.scguns.entity.ai.GoldSeekingGoal;
import top.ribs.scguns.entity.monster.ZombifiedHornlinEntity;
import top.ribs.scguns.entity.util.IGoldConsumingEntity;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.item.GunItem;

public class HornlinEntity
extends Monster
implements RangedAttackMob,
IGoldConsumingEntity {
    private static final double ALLIANCE_RANGE = 26.0;
    private static final int ALERT_RANGE_Y = 10;
    private static final int CONVERSION_TIME = 200;
    private int ticksUntilNextAlert = 0;
    private static final EntityDataAccessor<Boolean> DATA_EATING = SynchedEntityData.m_135353_(HornlinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_PREPARING_EAT = SynchedEntityData.m_135353_(HornlinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ItemStack> DATA_HELD_FOOD = SynchedEntityData.m_135353_(HornlinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private int goldEatingCooldown = 0;
    private int slagProductionCooldown = 0;
    private ItemEntity targetGoldItem = null;
    private float accumulatedGoldValue = 0.0f;
    private int timeInOverworld = 0;

    public HornlinEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22279_, 0.24).m_22268_(Attributes.f_22285_, 0.5).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22282_, (double)0.8f).m_22268_(Attributes.f_22281_, 2.0);
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        EntityEquipmentConfig.equipEntity((Mob)this, "hornlin");
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_EATING, (Object)false);
        this.f_19804_.m_135372_(DATA_PREPARING_EAT, (Object)false);
        this.f_19804_.m_135372_(DATA_HELD_FOOD, (Object)ItemStack.f_41583_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.goldEatingCooldown > 0) {
                --this.goldEatingCooldown;
            }
            if (this.slagProductionCooldown > 0) {
                --this.slagProductionCooldown;
            }
            this.checkForConversion();
            if (this.m_5448_() != null) {
                this.maybeAlertAllies();
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new ConsumeGoldGoal((Mob)this, this));
        this.f_21345_.m_25352_(1, (Goal)new GoldSeekingGoal((Mob)this, this, 1.0, 16.0f));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, player -> this.isWearingGold((Player)player) && !((Player)player).m_7500_() && !player.m_5833_()));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherBoss.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherSkeleton.class, true));
    }

    public boolean m_6779_(LivingEntity target) {
        if (target instanceof HornlinEntity) {
            return false;
        }
        return super.m_6779_(target);
    }

    private boolean isWearingGold(Player player) {
        for (ItemStack itemStack : player.m_6168_()) {
            ArmorItem armorItem;
            Item item = itemStack.m_41720_();
            if (!(item instanceof ArmorItem) || (armorItem = (ArmorItem)item).m_40401_() != ArmorMaterials.GOLD) continue;
            return false;
        }
        return true;
    }

    private void maybeAlertAllies() {
        if (this.ticksUntilNextAlert > 0) {
            --this.ticksUntilNextAlert;
        } else {
            if (this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                this.alertAllies();
            }
            this.ticksUntilNextAlert = 20 + this.f_19796_.m_188503_(20);
        }
    }

    private void alertAllies() {
        AABB alertArea = AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(26.0, 10.0, 26.0);
        this.m_9236_().m_6443_(HornlinEntity.class, alertArea, EntitySelector.f_20408_).stream().filter(entity -> entity != this).filter(entity -> entity.m_5448_() == null).filter(entity -> !entity.m_7307_((Entity)this.m_5448_())).forEach(entity -> entity.m_6710_(this.m_5448_()));
        this.m_9236_().m_6443_(Piglin.class, alertArea, EntitySelector.f_20408_).stream().filter(entity -> entity.m_5448_() == null).filter(entity -> !entity.m_7307_((Entity)this.m_5448_())).forEach(entity -> {
            LivingEntity patt7733$temp = this.m_5448_();
            if (patt7733$temp instanceof Player) {
                Player player = (Player)patt7733$temp;
                try {
                    Brain brain = entity.m_6274_();
                    brain.m_21879_(MemoryModuleType.f_26334_, (Object)player.m_20148_());
                    brain.m_21879_(MemoryModuleType.f_26372_, (Object)player);
                    entity.m_6710_((LivingEntity)player);
                }
                catch (Exception e) {
                    entity.m_6710_((LivingEntity)player);
                }
            } else {
                entity.m_6710_(this.m_5448_());
            }
        });
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (this.m_5448_() == null && target != null) {
            this.ticksUntilNextAlert = this.f_19796_.m_188503_(20);
        }
        super.m_6710_(target);
    }

    private void checkForConversion() {
        if (this.m_9236_().m_46472_() == Level.f_46428_ && !this.isConverting()) {
            this.timeInOverworld = 0;
        }
        if (this.isConverting()) {
            ++this.timeInOverworld;
            if (this.timeInOverworld > 200) {
                this.convertToZombifiedHornlin();
            }
        }
    }

    public boolean isConverting() {
        if (this.m_9236_().m_46472_() != Level.f_46428_ || this.m_21525_()) {
            return false;
        }
        if (this.m_19880_().contains("MobGunner")) {
            return false;
        }
        ItemStack mainHandItem = this.m_21205_();
        return !(mainHandItem.m_41720_() instanceof GunItem);
    }

    private void convertToZombifiedHornlin() {
        ZombifiedHornlinEntity zombifiedHornlin = (ZombifiedHornlinEntity)this.m_21406_((EntityType)ModEntities.ZOMBIFIED_HORNLIN.get(), true);
        if (zombifiedHornlin != null) {
            zombifiedHornlin.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            this.playConvertedSound();
        }
    }

    protected void playConvertedSound() {
        this.m_5496_(SoundEvents.f_12300_, 1.0f, 1.0f);
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12301_;
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12304_;
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12303_;
    }

    public void m_6504_(@NotNull LivingEntity target, float distanceFactor) {
        this.m_7327_((Entity)target);
    }

    @Override
    public boolean isEatingGold() {
        return (Boolean)this.f_19804_.m_135370_(DATA_EATING);
    }

    public void setEatingGold(boolean eating) {
        this.f_19804_.m_135381_(DATA_EATING, (Object)eating);
    }

    @Override
    public boolean isPreparingToEat() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PREPARING_EAT);
    }

    public void setPreparingToEat(boolean preparing) {
        this.f_19804_.m_135381_(DATA_PREPARING_EAT, (Object)preparing);
    }

    @Override
    public ItemStack getHeldFoodItem() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_HELD_FOOD);
    }

    public void setHeldFoodItem(ItemStack stack) {
        this.f_19804_.m_135381_(DATA_HELD_FOOD, (Object)stack);
    }

    @Override
    public ItemEntity getTargetGoldItem() {
        return this.targetGoldItem;
    }

    @Override
    public void setTargetGoldItem(ItemEntity item) {
        this.targetGoldItem = item;
    }

    @Override
    public float getAccumulatedGoldValue() {
        return this.accumulatedGoldValue;
    }

    @Override
    public void setAccumulatedGoldValue(float value) {
        this.accumulatedGoldValue = value;
    }

    @Override
    public void addAccumulatedGoldValue(float value) {
        this.accumulatedGoldValue += value;
    }

    @Override
    public int getGoldEatingCooldown() {
        return this.goldEatingCooldown;
    }

    @Override
    public void setGoldEatingCooldown(int ticks) {
        this.goldEatingCooldown = ticks;
    }

    @Override
    public int getSlagProductionCooldown() {
        return this.slagProductionCooldown;
    }

    @Override
    public void setSlagProductionCooldown(int ticks) {
        this.slagProductionCooldown = ticks;
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("AccumulatedGoldValue", this.accumulatedGoldValue);
        tag.m_128405_("SlagProductionCooldown", this.slagProductionCooldown);
        tag.m_128405_("TimeInOverworld", this.timeInOverworld);
        tag.m_128405_("GoldEatingCooldown", this.goldEatingCooldown);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.accumulatedGoldValue = tag.m_128457_("AccumulatedGoldValue");
        this.slagProductionCooldown = tag.m_128451_("SlagProductionCooldown");
        this.timeInOverworld = tag.m_128451_("TimeInOverworld");
        this.goldEatingCooldown = tag.m_128451_("GoldEatingCooldown");
    }
}

