/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.init.ModTags;

public class ScampRocketEntity
extends Projectile {
    private static final EntityDataAccessor<Boolean> HAS_EXPLODED = SynchedEntityData.m_135353_(ScampRocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int life = 0;
    private double damage = 8.0;
    private float explosionRadius = 3.0f;

    public ScampRocketEntity(EntityType<? extends ScampRocketEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ScampRocketEntity(EntityType<? extends ScampRocketEntity> pEntityType, Level pLevel, LivingEntity pShooter) {
        this(pEntityType, pLevel);
        this.m_5602_((Entity)pShooter);
        this.m_6034_(pShooter.m_20185_(), pShooter.m_20188_() - 0.1, pShooter.m_20189_());
    }

    public void setDamage(double pDamage) {
        this.damage = pDamage;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(HAS_EXPLODED, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (((Boolean)this.f_19804_.m_135370_(HAS_EXPLODED)).booleanValue()) {
            return;
        }
        Vec3 vec3 = this.m_20184_();
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
        if (hitresult.m_6662_() != HitResult.Type.MISS) {
            this.m_6532_(hitresult);
        }
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20186_() + vec3.f_82480_;
        double d2 = this.m_20189_() + vec3.f_82481_;
        this.m_6034_(d0, d1, d2);
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            if (this.f_19796_.m_188503_(2) == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
            if (this.f_19796_.m_188503_(2) == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
        if (++this.life >= 200) {
            this.explode();
        }
    }

    protected void m_6532_(@NotNull HitResult pResult) {
        super.m_6532_(pResult);
        if (!this.m_9236_().f_46443_ && !((Boolean)this.f_19804_.m_135370_(HAS_EXPLODED)).booleanValue()) {
            this.explode();
        }
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        if (entity.equals((Object)this.m_19749_()) && this.life < 5) {
            return;
        }
        if (entity instanceof LivingEntity) {
            entity.m_6469_(this.m_269291_().m_269036_((Entity)this, this.m_19749_()), (float)this.damage);
        }
    }

    private void explode() {
        if (((Boolean)this.f_19804_.m_135370_(HAS_EXPLODED)).booleanValue()) {
            return;
        }
        this.f_19804_.m_135381_(HAS_EXPLODED, (Object)true);
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionRadius, Level.ExplosionInteraction.NONE);
            this.destroyBreakableBlocks();
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, this.m_5720_(), 1.0f, 1.0f);
            this.m_146870_();
        } else {
            for (int i = 0; i < 20; ++i) {
                double offsetX = this.f_19796_.m_188583_() * 0.3;
                double offsetY = this.f_19796_.m_188583_() * 0.3;
                double offsetZ = this.f_19796_.m_188583_() * 0.3;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
            }
        }
    }

    private void destroyBreakableBlocks() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        double breakRadius = (double)this.explosionRadius * 1.5;
        BlockPos center = this.m_20183_();
        int range = (int)Math.ceil(breakRadius);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_(-range, -range, -range), (BlockPos)center.m_7918_(range, range, range))) {
            Level level;
            BlockState state;
            double distance = Math.sqrt(pos.m_203193_((Position)this.m_20182_()));
            if (distance > breakRadius || (state = this.m_9236_().m_8055_(pos)).m_60795_() || !state.m_204336_(ModTags.Blocks.TANK_BREAKABLE)) continue;
            float breakChance = 1.0f - (float)(distance / breakRadius);
            breakChance *= 0.8f;
            if (!(this.f_19796_.m_188501_() < breakChance) || !((level = this.m_9236_()) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.m_46469_().m_46207_(GameRules.f_46136_) && this.f_19796_.m_188501_() < 0.15f) {
                Block.m_49881_((BlockState)state, (Level)serverLevel, (BlockPos)pos, null, null, (ItemStack)ItemStack.f_41583_);
            }
            this.m_9236_().m_46961_(pos, false);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 3, 0.25, 0.25, 0.25, 0.05);
        }
    }

    public boolean m_6087_() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EXPLODED) == false;
    }

    public float m_6143_() {
        return 1.0f;
    }

    protected boolean m_5603_(@NotNull Entity pTarget) {
        return super.m_5603_(pTarget) && !pTarget.f_19794_;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6783_(double pDistance) {
        return pDistance < 16384.0;
    }

    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("life", this.life);
        pCompound.m_128347_("damage", this.damage);
        pCompound.m_128350_("explosionRadius", this.explosionRadius);
        pCompound.m_128379_("hasExploded", ((Boolean)this.f_19804_.m_135370_(HAS_EXPLODED)).booleanValue());
    }

    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.life = pCompound.m_128451_("life");
        this.damage = pCompound.m_128459_("damage");
        this.explosionRadius = pCompound.m_128457_("explosionRadius");
        this.f_19804_.m_135381_(HAS_EXPLODED, (Object)pCompound.m_128471_("hasExploded"));
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6686_(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        Vec3 vec3 = new Vec3(pX, pY, pZ).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy)).m_82490_((double)pVelocity);
        this.m_20256_(vec3);
        double d0 = vec3.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.29577951308232));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.29577951308232));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }
}

