/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.entity.projectile.EnemyProjectileEntity;
import top.ribs.scguns.init.ModEffects;
import top.ribs.scguns.init.ModSounds;

public class SkyCarrierEntity
extends FlyingMob
implements Enemy {
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.m_135353_(SkyCarrierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MUZZLE_FLASH_TIMER = SynchedEntityData.m_135353_(SkyCarrierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_PHASING = SynchedEntityData.m_135353_(SkyCarrierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private int shootCooldown = 0;
    private Vec3 initialTargetPosition = null;
    private int phasingTimer = 0;
    private static final int MAX_PHASING_TIME = 200;

    public SkyCarrierEntity(EntityType<? extends SkyCarrierEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new SkyCarrierMoveControl(this, 5.0, 8.0, 2.0, 0.6, 0.1);
    }

    public void setInitialTarget(Vec3 targetPosition) {
        this.initialTargetPosition = targetPosition;
        this.phasingTimer = 200;
        this.setPhasing(true);
    }

    public boolean isPhasing() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_PHASING);
    }

    public void setPhasing(boolean phasing) {
        this.f_19804_.m_135381_(DATA_IS_PHASING, (Object)phasing);
        this.f_19794_ = phasing;
    }

    public boolean m_7301_(@NotNull MobEffectInstance pPotionEffect) {
        MobEffect effect = pPotionEffect.m_19544_();
        if (effect == MobEffects.f_19614_ || effect == MobEffects.f_19615_ || effect == MobEffects.f_19612_ || effect == MobEffects.f_19605_ || effect == MobEffects.f_19618_ || effect == MobEffects.f_19604_ || effect == MobEffects.f_19610_ || effect == MobEffects.f_19613_ || effect == MobEffects.f_19597_ || effect == MobEffects.f_19599_ || effect == MobEffects.f_19602_ || effect == ModEffects.SULFUR_POISONING.get() || effect == MobEffects.f_19601_) {
            return false;
        }
        return super.m_7301_(pPotionEffect);
    }

    public boolean m_8028_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.isPhasing()) {
            this.handlePhasing();
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
            this.spawnSmokeParticles();
        } else if (this.shootCooldown > 0) {
            --this.shootCooldown;
        } else {
            LivingEntity target = this.m_5448_();
            if (target != null && this.m_20280_((Entity)target) < 625.0 && !this.isPhasing()) {
                this.fireProjectile();
                this.shootCooldown = 20;
            }
        }
        int currentTimer = (Integer)this.f_19804_.m_135370_(MUZZLE_FLASH_TIMER);
        if (currentTimer > 0) {
            this.f_19804_.m_135381_(MUZZLE_FLASH_TIMER, (Object)(currentTimer - 1));
        }
    }

    private void handlePhasing() {
        if (this.initialTargetPosition == null) {
            this.setPhasing(false);
            return;
        }
        double distanceToTarget = this.m_20182_().m_82554_(this.initialTargetPosition);
        --this.phasingTimer;
        if (distanceToTarget < 3.0 || this.phasingTimer <= 0) {
            this.setPhasing(false);
            this.initialTargetPosition = null;
        } else {
            Vec3 direction = this.initialTargetPosition.m_82546_(this.m_20182_()).m_82541_();
            this.m_20256_(direction.m_82490_(0.3));
        }
    }

    private void spawnSmokeParticles() {
        if (this.isMuzzleFlashVisible()) {
            double offsetX = 0.0;
            double offsetY = (double)this.m_20192_() - 0.5;
            double offsetZ = 0.0;
            double posX = this.m_20185_() + offsetX;
            double posY = this.m_20186_() + offsetY;
            double posZ = this.m_20189_() + offsetZ;
            RandomSource random = this.m_217043_();
            for (int i = 0; i < 1; ++i) {
                double particleOffsetX = random.m_188583_() * 0.1;
                double particleOffsetY = random.m_188583_() * 0.1;
                double particleOffsetZ = random.m_188583_() * 0.1;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, posX, posY, posZ, particleOffsetX, particleOffsetY, particleOffsetZ);
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RandomFloatAroundGoal(this, 100));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(6, (Goal)new SkyCarrierFaceAndBackAwayFromTargetGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22276_, 22.0).m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22285_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_CHARGING, (Object)false);
        this.f_19804_.m_135372_(MUZZLE_FLASH_TIMER, (Object)0);
        this.f_19804_.m_135372_(DATA_IS_PHASING, (Object)false);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11737_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12008_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    public void triggerMuzzleFlash() {
        this.f_19804_.m_135381_(MUZZLE_FLASH_TIMER, (Object)10);
    }

    public boolean isMuzzleFlashVisible() {
        return (Integer)this.f_19804_.m_135370_(MUZZLE_FLASH_TIMER) > 0;
    }

    private void fireProjectile() {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            double turretOffsetHeight = 0.4;
            double turretOffsetBack = 0.4;
            double spawnHeight = this.m_20186_() + (double)this.m_20206_() + turretOffsetHeight;
            double spawnX = this.m_20185_() - Math.sin(Math.toRadians(this.m_146908_())) * turretOffsetBack;
            double spawnZ = this.m_20189_() + Math.cos(Math.toRadians(this.m_146908_())) * turretOffsetBack;
            EnemyProjectileEntity brassBolt = new EnemyProjectileEntity(this.m_9236_(), (LivingEntity)this);
            brassBolt.m_6034_(spawnX, spawnHeight, spawnZ);
            double dx = target.m_20185_() - spawnX;
            double dy = target.m_20188_() - spawnHeight + 0.1;
            double dz = target.m_20189_() - spawnZ;
            brassBolt.m_6686_(dx, dy, dz, 3.0f, 2.0f);
            this.m_9236_().m_7967_((Entity)brassBolt);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.BRUISER_SILENCED_FIRE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            this.triggerMuzzleFlash();
        }
    }

    @NotNull
    protected PathNavigation m_6037_(Level level) {
        return new FlyingPathNavigation((Mob)this, level);
    }

    private static class SkyCarrierMoveControl
    extends MoveControl {
        private final SkyCarrierEntity skyCarrier;
        private final double minDistance;
        private final double maxDistance;
        private final double bufferZone;
        private final double approachSpeed;
        private final double backingSpeed;

        public SkyCarrierMoveControl(SkyCarrierEntity skyCarrier, double minDistance, double maxDistance, double bufferZone, double approachSpeed, double backingSpeed) {
            super((Mob)skyCarrier);
            this.skyCarrier = skyCarrier;
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
            this.bufferZone = bufferZone;
            this.approachSpeed = approachSpeed;
            this.backingSpeed = backingSpeed;
        }

        public void m_8126_() {
            double distance;
            if (this.skyCarrier.isPhasing()) {
                return;
            }
            LivingEntity target = this.skyCarrier.m_5448_();
            Vec3 movementVector = Vec3.f_82478_;
            AABB repulsionBox = this.skyCarrier.m_20191_().m_82400_(2.0);
            List nearbyCarriers = this.skyCarrier.m_9236_().m_6443_(SkyCarrierEntity.class, repulsionBox, e -> e != this.skyCarrier);
            Vec3 repulsionVector = Vec3.f_82478_;
            for (SkyCarrierEntity other : nearbyCarriers) {
                Vec3 toOther = this.skyCarrier.m_20182_().m_82546_(other.m_20182_());
                distance = toOther.m_82553_();
                if (!(distance < 2.0) || !(distance > 0.0)) continue;
                repulsionVector = repulsionVector.m_82549_(toOther.m_82541_().m_82490_(0.5 / distance));
            }
            if (target != null) {
                Vec3 ourPos;
                Vec3 targetPos = target.m_20182_();
                Vec3 directionToTarget = targetPos.m_82546_(ourPos = this.skyCarrier.m_20182_());
                distance = directionToTarget.m_82553_();
                if (distance < this.minDistance) {
                    movementVector = directionToTarget.m_82541_().m_82548_().m_82490_(this.backingSpeed);
                    this.updateRotationTowardsTarget(targetPos);
                } else if (distance > this.maxDistance + this.bufferZone) {
                    movementVector = directionToTarget.m_82541_().m_82490_(this.approachSpeed);
                    this.updateRotationTowardsDirection(movementVector);
                } else if (distance < this.minDistance - this.bufferZone) {
                    movementVector = directionToTarget.m_82541_().m_82548_().m_82490_(this.backingSpeed);
                    this.updateRotationTowardsTarget(targetPos);
                } else {
                    this.updateRotationTowardsDirection(directionToTarget.m_82541_());
                }
                movementVector = movementVector.m_82549_(repulsionVector.m_82490_(0.3));
                this.skyCarrier.m_20256_(movementVector);
            } else {
                this.handleIdleMovement();
            }
        }

        private void handleIdleMovement() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 direction = new Vec3(this.f_24975_ - this.skyCarrier.m_20185_(), this.f_24976_ - this.skyCarrier.m_20186_(), this.f_24977_ - this.skyCarrier.m_20189_());
                double distance = direction.m_82553_();
                if (distance < 1.0) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.skyCarrier.m_20256_(Vec3.f_82478_);
                } else {
                    direction = direction.m_82541_().m_82490_(this.approachSpeed);
                    this.skyCarrier.m_20256_(direction);
                    this.updateRotationTowardsDirection(direction);
                }
            }
        }

        private void updateRotationTowardsTarget(Vec3 targetPos) {
            double dx = targetPos.f_82479_ - this.skyCarrier.m_20185_();
            double dz = targetPos.f_82481_ - this.skyCarrier.m_20189_();
            float targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232 - 90.0);
            this.skyCarrier.m_146922_(targetYaw);
            this.skyCarrier.f_20883_ = this.skyCarrier.m_146908_();
            this.skyCarrier.f_20885_ = this.skyCarrier.m_146908_();
        }

        private void updateRotationTowardsDirection(Vec3 direction) {
            if (direction.m_82556_() == 0.0) {
                return;
            }
            float targetYaw = (float)(Math.atan2(direction.f_82481_, direction.f_82479_) * 57.29577951308232 - 90.0);
            this.skyCarrier.m_146922_(targetYaw);
            this.skyCarrier.f_20883_ = this.skyCarrier.m_146908_();
            this.skyCarrier.f_20885_ = this.skyCarrier.m_146908_();
        }
    }

    public static class RandomFloatAroundGoal
    extends Goal {
        private final SkyCarrierEntity skyCarrier;
        private int tickDelay;

        public RandomFloatAroundGoal(SkyCarrierEntity skyCarrier, int initialDelay) {
            this.skyCarrier = skyCarrier;
            this.tickDelay = initialDelay;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.skyCarrier.isPhasing() && --this.tickDelay <= 0;
        }

        public void m_8056_() {
            this.setNewWanderTarget();
            this.tickDelay = 100;
        }

        private void setNewWanderTarget() {
            double x = this.skyCarrier.m_20185_() + (this.skyCarrier.m_217043_().m_188500_() * 20.0 - 10.0);
            double y = this.skyCarrier.m_20186_() + (this.skyCarrier.m_217043_().m_188500_() * 20.0 - 10.0);
            double z = this.skyCarrier.m_20189_() + (this.skyCarrier.m_217043_().m_188500_() * 20.0 - 10.0);
            this.skyCarrier.m_21566_().m_6849_(x, y, z, 1.0);
        }
    }

    private static class SkyCarrierFaceAndBackAwayFromTargetGoal
    extends Goal {
        private final SkyCarrierEntity skyCarrier;

        public SkyCarrierFaceAndBackAwayFromTargetGoal(SkyCarrierEntity skyCarrier) {
            this.skyCarrier = skyCarrier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return !this.skyCarrier.isPhasing() && this.skyCarrier.m_5448_() != null;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.skyCarrier.m_5448_();
            if (target != null) {
                Vec3 targetPos = new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_());
                Vec3 ourPos = new Vec3(this.skyCarrier.m_20185_(), this.skyCarrier.m_20186_(), this.skyCarrier.m_20189_());
                Vec3 vectorToTarget = targetPos.m_82546_(ourPos).m_82541_();
                float targetYaw = -((float)Math.atan2(vectorToTarget.f_82479_, vectorToTarget.f_82481_)) * 57.295776f;
                targetYaw = Mth.m_14177_((float)targetYaw);
                this.skyCarrier.m_146922_(targetYaw);
                this.skyCarrier.f_20885_ = this.skyCarrier.f_20883_ = this.skyCarrier.m_146908_();
            }
        }
    }
}

