/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.config.EntityEquipmentConfig;
import top.ribs.scguns.entity.ai.ConsumeGoldGoal;
import top.ribs.scguns.entity.ai.GoldSeekingGoal;
import top.ribs.scguns.entity.util.IGoldConsumingEntity;

public class ZombifiedHornlinEntity
extends Monster
implements RangedAttackMob,
NeutralMob,
IGoldConsumingEntity {
    private static final double ALLIANCE_RANGE = 26.0;
    private static final int ALERT_RANGE_Y = 10;
    private static final EntityDataAccessor<Boolean> DATA_EATING = SynchedEntityData.m_135353_(ZombifiedHornlinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_PREPARING_EAT = SynchedEntityData.m_135353_(ZombifiedHornlinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ItemStack> DATA_HELD_FOOD = SynchedEntityData.m_135353_(ZombifiedHornlinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private int goldEatingCooldown = 0;
    private int slagProductionCooldown = 0;
    private ItemEntity targetGoldItem = null;
    private float accumulatedGoldValue = 0.0f;
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", 0.05, AttributeModifier.Operation.ADDITION);
    private static final UniformInt FIRST_ANGER_SOUND_DELAY = TimeUtil.m_145020_((int)0, (int)1);
    private int playFirstAngerSoundIn;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    private static final UniformInt ALERT_INTERVAL = TimeUtil.m_145020_((int)1, (int)2);
    private int ticksUntilNextAlert;

    public ZombifiedHornlinEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22285_, 0.5).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22282_, (double)0.8f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22287_, 0.0);
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        EntityEquipmentConfig.equipEntity((Mob)this, "zombified_hornlin");
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_EATING, (Object)false);
        this.f_19804_.m_135372_(DATA_PREPARING_EAT, (Object)false);
        this.f_19804_.m_135372_(DATA_HELD_FOOD, (Object)ItemStack.f_41583_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.goldEatingCooldown > 0) {
                --this.goldEatingCooldown;
            }
            if (this.slagProductionCooldown > 0) {
                --this.slagProductionCooldown;
            }
            if (this.m_5448_() != null) {
                this.maybeAlertAllies();
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new ConsumeGoldGoal((Mob)this, this));
        this.f_21345_.m_25352_(1, (Goal)new GoldSeekingGoal((Mob)this, this, 1.0, 16.0f));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, player -> this.m_21674_((LivingEntity)player) && !((Player)player).m_7500_() && !((Player)player).m_5833_()));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    private void maybeAlertAllies() {
        if (this.ticksUntilNextAlert > 0) {
            --this.ticksUntilNextAlert;
        } else {
            if (this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                this.alertAllies();
            }
            this.ticksUntilNextAlert = ALERT_INTERVAL.m_214085_(this.f_19796_);
        }
    }

    private void alertAllies() {
        AABB alertArea = AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(26.0, 10.0, 26.0);
        this.m_9236_().m_6443_(ZombifiedHornlinEntity.class, alertArea, EntitySelector.f_20408_).stream().filter(entity -> entity != this).filter(entity -> entity.m_5448_() == null).filter(entity -> !entity.m_7307_((Entity)this.m_5448_())).forEach(entity -> {
            entity.m_6710_(this.m_5448_());
            entity.m_6825_();
            if (this.m_5448_() instanceof Player) {
                entity.m_6925_(this.m_5448_().m_20148_());
            }
        });
        this.m_9236_().m_6443_(ZombifiedPiglin.class, alertArea, EntitySelector.f_20408_).stream().filter(entity -> entity.m_5448_() == null).filter(entity -> !entity.m_7307_((Entity)this.m_5448_())).forEach(entity -> {
            LivingEntity patt8205$temp = this.m_5448_();
            if (patt8205$temp instanceof Player) {
                Player player = (Player)patt8205$temp;
                entity.m_6598_(player);
                entity.m_6825_();
                entity.m_6925_(player.m_20148_());
                entity.m_6710_(this.m_5448_());
                try {
                    Field ticksUntilNextAlertField = entity.getClass().getDeclaredField("ticksUntilNextAlert");
                    ticksUntilNextAlertField.setAccessible(true);
                    ticksUntilNextAlertField.setInt(entity, 0);
                    Field playFirstAngerSoundInField = entity.getClass().getDeclaredField("playFirstAngerSoundIn");
                    playFirstAngerSoundInField.setAccessible(true);
                    playFirstAngerSoundInField.setInt(entity, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (this.m_5448_() == null && target != null) {
            this.playFirstAngerSoundIn = FIRST_ANGER_SOUND_DELAY.m_214085_(this.f_19796_);
            this.ticksUntilNextAlert = ALERT_INTERVAL.m_214085_(this.f_19796_);
        }
        if (target instanceof Player) {
            this.m_6598_((Player)target);
        }
        super.m_6710_(target);
    }

    protected void m_8024_() {
        Player persistentTarget;
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (this.m_21660_()) {
            if (!this.m_6162_() && !attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                attributeinstance.m_22118_(SPEED_MODIFIER_ATTACKING);
            }
            this.maybePlayFirstAngerSound();
        } else if (attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
            attributeinstance.m_22130_(SPEED_MODIFIER_ATTACKING);
        }
        this.m_21666_((ServerLevel)this.m_9236_(), true);
        if (this.m_21660_()) {
            this.f_20889_ = this.f_19797_;
        }
        if (this.m_5448_() == null && this.m_21660_() && this.m_6120_() != null && (persistentTarget = this.m_9236_().m_46003_(this.m_6120_())) != null && this.m_20280_((Entity)persistentTarget) <= this.m_21133_(Attributes.f_22277_) * this.m_21133_(Attributes.f_22277_)) {
            this.m_6710_((LivingEntity)persistentTarget);
        }
        super.m_8024_();
    }

    private void maybePlayFirstAngerSound() {
        if (this.playFirstAngerSoundIn > 0) {
            --this.playFirstAngerSoundIn;
            if (this.playFirstAngerSoundIn == 0) {
                this.playAngerSound();
            }
        }
    }

    private void playAngerSound() {
        this.m_5496_(SoundEvents.f_12611_, this.m_6121_() * 2.0f, this.m_6100_() * 1.8f);
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.m_21660_() ? SoundEvents.f_12611_ : SoundEvents.f_12610_;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12613_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12612_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.7f;
    }

    public void m_6504_(@NotNull LivingEntity target, float distanceFactor) {
        this.m_7327_((Entity)target);
    }

    @Override
    public boolean isEatingGold() {
        return (Boolean)this.f_19804_.m_135370_(DATA_EATING);
    }

    public void setEatingGold(boolean eating) {
        this.f_19804_.m_135381_(DATA_EATING, (Object)eating);
    }

    @Override
    public boolean isPreparingToEat() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PREPARING_EAT);
    }

    public void setPreparingToEat(boolean preparing) {
        this.f_19804_.m_135381_(DATA_PREPARING_EAT, (Object)preparing);
    }

    @Override
    public ItemStack getHeldFoodItem() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_HELD_FOOD);
    }

    public void setHeldFoodItem(ItemStack stack) {
        this.f_19804_.m_135381_(DATA_HELD_FOOD, (Object)stack);
    }

    @Override
    public ItemEntity getTargetGoldItem() {
        return this.targetGoldItem;
    }

    @Override
    public void setTargetGoldItem(ItemEntity item) {
        this.targetGoldItem = item;
    }

    @Override
    public float getAccumulatedGoldValue() {
        return this.accumulatedGoldValue;
    }

    @Override
    public void setAccumulatedGoldValue(float value) {
        this.accumulatedGoldValue = value;
    }

    @Override
    public void addAccumulatedGoldValue(float value) {
        this.accumulatedGoldValue += value;
    }

    @Override
    public int getGoldEatingCooldown() {
        return this.goldEatingCooldown;
    }

    @Override
    public void setGoldEatingCooldown(int ticks) {
        this.goldEatingCooldown = ticks;
    }

    @Override
    public int getSlagProductionCooldown() {
        return this.slagProductionCooldown;
    }

    @Override
    public void setSlagProductionCooldown(int ticks) {
        this.slagProductionCooldown = ticks;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int time) {
        this.remainingPersistentAngerTime = time;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(@Nullable UUID target) {
        this.persistentAngerTarget = target;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        this.m_21678_(tag);
        tag.m_128350_("AccumulatedGoldValue", this.accumulatedGoldValue);
        tag.m_128405_("SlagProductionCooldown", this.slagProductionCooldown);
        tag.m_128405_("GoldEatingCooldown", this.goldEatingCooldown);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.m_147285_(this.m_9236_(), tag);
        this.accumulatedGoldValue = tag.m_128457_("AccumulatedGoldValue");
        this.slagProductionCooldown = tag.m_128451_("SlagProductionCooldown");
        this.goldEatingCooldown = tag.m_128451_("GoldEatingCooldown");
    }

    public boolean m_6935_(Player player) {
        return this.m_21674_((LivingEntity)player);
    }
}

