/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.player;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.init.ModTags;

public class PlayerGunProgression {
    private static final String NBT_KEY = "SCGunsProgression";
    private static final String TIER_KEY = "CurrentTier";
    private static final String RAID_LEVEL_KEY = "RaidLevel";
    private GunTier currentTier = GunTier.NONE;
    private int currentRaidLevel = 0;

    public GunTier getCurrentTier() {
        return this.currentTier;
    }

    public int getCurrentRaidLevel() {
        return this.currentRaidLevel;
    }

    public List<GunTier> getAvailableMobTiers() {
        return this.currentTier.getAvailableMobTiers();
    }

    public boolean updateTier(GunTier newTier) {
        if (newTier.getLevel() > this.currentTier.getLevel()) {
            this.currentTier = newTier;
            this.currentRaidLevel = newTier.getRaidLevel();
            return true;
        }
        return false;
    }

    public void setTier(GunTier tier) {
        this.currentTier = tier;
        this.currentRaidLevel = tier.getRaidLevel();
    }

    public void setRaidLevel(int level) {
        this.currentRaidLevel = Math.max(0, level);
    }

    public boolean checkAndUpdateFromItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        for (GunTier tier : GunTier.values()) {
            if (tier == GunTier.NONE || !ModTags.Items.isInTierTag(stack, tier)) continue;
            return this.updateTier(tier);
        }
        return false;
    }

    public CompoundTag saveNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(TIER_KEY, this.currentTier.getLevel());
        tag.m_128359_("TierName", this.currentTier.name());
        tag.m_128405_(RAID_LEVEL_KEY, this.currentRaidLevel);
        return tag;
    }

    public void loadNBT(CompoundTag tag) {
        if (tag.m_128441_("TierName")) {
            try {
                this.currentTier = GunTier.valueOf(tag.m_128461_("TierName"));
                this.currentRaidLevel = this.currentTier.getRaidLevel();
            }
            catch (IllegalArgumentException e) {
                this.currentTier = GunTier.NONE;
                this.currentRaidLevel = 0;
            }
        } else if (tag.m_128441_(TIER_KEY)) {
            int level = tag.m_128451_(TIER_KEY);
            this.currentTier = GunTier.fromLevel(level);
            this.currentRaidLevel = this.currentTier.getRaidLevel();
        } else {
            this.currentTier = GunTier.NONE;
            this.currentRaidLevel = 0;
        }
        if (tag.m_128441_(RAID_LEVEL_KEY)) {
            this.currentRaidLevel = tag.m_128451_(RAID_LEVEL_KEY);
        }
    }

    public static PlayerGunProgression get(Player player) {
        CompoundTag persistentData = player.getPersistentData();
        PlayerGunProgression progression = new PlayerGunProgression();
        if (persistentData.m_128441_(NBT_KEY)) {
            progression.loadNBT(persistentData.m_128469_(NBT_KEY));
        }
        return progression;
    }

    public static void save(Player player, PlayerGunProgression progression) {
        CompoundTag persistentData = player.getPersistentData();
        persistentData.m_128365_(NBT_KEY, (Tag)progression.saveNBT());
    }

    public static boolean updateAndSave(Player player, ItemStack stack) {
        PlayerGunProgression progression = PlayerGunProgression.get(player);
        boolean updated = progression.checkAndUpdateFromItem(stack);
        if (updated) {
            PlayerGunProgression.save(player, progression);
        }
        return updated;
    }

    public static enum GunTier {
        NONE(0, null, 0),
        ANTIQUE(1, "antique_gun_tier", 1),
        FRONTIER(2, "frontier_gun_tier", 1),
        COPPER(3, "copper_gun_tier", 2),
        IRON(4, "iron_gun_tier", 3),
        WRECKER(5, "wrecker_gun_tier", 3),
        OCEAN(5, "ocean_gun_tier", 3),
        DIAMOND_STEEL(6, "diamond_steel_gun_tier", 4),
        TREATED_BRASS(6, "treated_brass_gun_tier", 4),
        PIGLIN(6, "piglin_gun_tier", 4),
        DEEP_DARK(6, "deep_dark_gun_tier", 4),
        END(7, "end_gun_tier", 5),
        SCORCHED(7, "scorched_gun_tier", 5);

        private final int level;
        private final String tagName;
        private final int raidLevel;

        private GunTier(int level, String tagName, int raidLevel) {
            this.level = level;
            this.tagName = tagName;
            this.raidLevel = raidLevel;
        }

        public int getLevel() {
            return this.level;
        }

        public String getTagName() {
            return this.tagName;
        }

        public int getRaidLevel() {
            return this.raidLevel;
        }

        public static GunTier fromLevel(int level) {
            for (GunTier tier : GunTier.values()) {
                if (tier.level != level) continue;
                return tier;
            }
            return NONE;
        }

        public List<GunTier> getAvailableMobTiers() {
            ArrayList<GunTier> tiers = new ArrayList<GunTier>();
            switch (this) {
                case NONE: 
                case ANTIQUE: {
                    break;
                }
                case FRONTIER: {
                    tiers.add(ANTIQUE);
                    break;
                }
                case COPPER: {
                    tiers.add(FRONTIER);
                    tiers.add(ANTIQUE);
                    break;
                }
                case IRON: 
                case WRECKER: 
                case OCEAN: {
                    tiers.add(COPPER);
                    tiers.add(FRONTIER);
                    tiers.add(ANTIQUE);
                    break;
                }
                case DIAMOND_STEEL: 
                case TREATED_BRASS: 
                case PIGLIN: 
                case DEEP_DARK: {
                    tiers.add(IRON);
                    tiers.add(COPPER);
                    tiers.add(FRONTIER);
                    tiers.add(ANTIQUE);
                    break;
                }
                case END: 
                case SCORCHED: {
                    tiers.add(DIAMOND_STEEL);
                    tiers.add(TREATED_BRASS);
                    tiers.add(IRON);
                    tiers.add(COPPER);
                    tiers.add(FRONTIER);
                    tiers.add(ANTIQUE);
                }
            }
            return tiers;
        }
    }
}

