/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.Config;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.init.ModEnchantments;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.interfaces.IDamageable;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageBlood;
import top.ribs.scguns.network.message.S2CMessageProjectileHitBlock;
import top.ribs.scguns.network.message.S2CMessageProjectileHitEntity;
import top.ribs.scguns.util.GunEnchantmentHelper;

public class BearPackShellProjectileEntity
extends ProjectileEntity {
    private static final float SHIELD_DISABLE_CHANCE = 0.4f;
    private static final float SHIELD_DAMAGE_PENETRATION = 0.4f;
    private int remainingPenetrations;

    public BearPackShellProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.remainingPenetrations = 2;
    }

    public BearPackShellProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
        int collateralLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.COLLATERAL.get()), (ItemStack)weapon);
        this.remainingPenetrations = 2 + collateralLevel;
    }

    @Override
    public void m_8119_() {
        super.onProjectileTick();
        if (!this.m_9236_().m_5776_()) {
            Vec3 startVec = this.m_20182_();
            Vec3 endVec = startVec.m_82549_(this.m_20184_());
            BlockHitResult blockResult = BearPackShellProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_LEAVES);
            boolean hitBlock = false;
            if (blockResult.m_6662_() != HitResult.Type.MISS) {
                endVec = blockResult.m_82450_();
                hitBlock = true;
            }
            List<ProjectileEntity.EntityResult> hitEntities = this.findEntitiesOnPath(startVec, endVec);
            boolean hitSomething = false;
            while (this.remainingPenetrations > 0 && hitEntities != null && !hitEntities.isEmpty()) {
                ProjectileEntity.EntityResult closestEntity = null;
                double closestEntityDist = Double.MAX_VALUE;
                for (ProjectileEntity.EntityResult entity : hitEntities) {
                    double dist = startVec.m_82557_(entity.getHitPos());
                    if (!(dist < closestEntityDist)) continue;
                    closestEntityDist = dist;
                    closestEntity = entity;
                }
                if (closestEntity == null) break;
                this.onHitEntity(closestEntity.getEntity(), closestEntity.getHitPos(), startVec, endVec, closestEntity.isHeadshot());
                hitEntities.remove(closestEntity);
                hitSomething = true;
            }
            if (hitBlock) {
                BlockState state = this.m_9236_().m_8055_(blockResult.m_82425_());
                this.onHitBlock(state, blockResult.m_82425_(), blockResult.m_82434_(), blockResult.m_82450_().f_82479_, blockResult.m_82450_().f_82480_, blockResult.m_82450_().f_82481_);
                return;
            }
            if (hitSomething && this.remainingPenetrations <= 0) {
                this.m_142687_(Entity.RemovalReason.KILLED);
                return;
            }
        }
        this.m_6034_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
        if (this.projectile.isGravity()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, this.modifiedGravity, 0.0));
        }
        this.updateHeading();
        if (this.f_19797_ >= this.life) {
            this.onExpired();
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        LivingEntity livingEntity;
        boolean wasAlive;
        float newDamage;
        if (entity.m_19879_() == this.shooterId) {
            return;
        }
        float damage = this.getDamage();
        boolean critical = damage != (newDamage = this.getCriticalDamage(this.getWeapon(), this.f_19796_, damage));
        damage = newDamage;
        ResourceLocation advantage = this.getProjectile().getAdvantage();
        damage *= this.advantageMultiplier(entity);
        boolean bl = wasAlive = entity instanceof LivingEntity && entity.m_6084_();
        if (headshot) {
            damage = (float)((double)damage * (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get());
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            damage = this.applyProjectileProtection(livingTarget, damage);
            damage = this.calculateArmorBypassDamage(livingTarget, damage);
        }
        DamageSource source = ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, this.shooter);
        boolean blocked = ProjectileEntity.ProjectileHelper.handleShieldHit(entity, this, damage, 0.4f);
        if (blocked) {
            float penetratingDamage = damage * 0.4f;
            entity.m_6469_(source, penetratingDamage);
        } else if (!entity.m_6095_().m_204039_(ModTags.Entities.GHOST) || advantage.equals((Object)ModTags.Entities.UNDEAD.f_203868_())) {
            entity.m_6469_(source, damage);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                ResourceLocation effectLocation = this.getProjectile().getImpactEffect();
                if (effectLocation != null) {
                    MobEffect effect;
                    float effectChance = this.getProjectile().getImpactEffectChance();
                    if (this.f_19796_.m_188501_() < effectChance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
                        int duration = this.getProjectile().getImpactEffectDuration();
                        if (this.remainingPenetrations < 2) {
                            duration = (int)((float)duration * 0.75f);
                        }
                        livingEntity2.m_7292_(new MobEffectInstance(effect, duration, this.getProjectile().getImpactEffectAmplifier()));
                    }
                }
            }
        }
        if (entity instanceof LivingEntity) {
            GunEnchantmentHelper.applyElementalPopEffect(this.getWeapon(), (LivingEntity)entity);
        }
        if (this.shooter instanceof Player) {
            int hitType = critical ? 2 : (headshot ? 1 : 0);
            PacketHandler.getPlayChannel().sendToPlayer(() -> (ServerPlayer)this.shooter, (IMessage)new S2CMessageProjectileHitEntity(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, hitType, entity instanceof Player));
        }
        if (wasAlive && entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_6084_()) {
            this.checkForDiamondSteelBonus(livingEntity, hitVec);
        }
        PacketHandler.getPlayChannel().sendToTracking(() -> entity, (IMessage)new S2CMessageBlood(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, entity.m_6095_()));
        if (this.remainingPenetrations > 0) {
            --this.remainingPenetrations;
            entity.f_19802_ = 0;
            Vec3 motion = this.m_20184_();
            this.m_6034_(this.m_20185_() + motion.f_82479_ * 0.2, this.m_20186_() + motion.f_82480_ * 0.2, this.m_20189_() + motion.f_82481_ * 0.2);
            this.m_20256_(motion.m_82542_(0.8, 0.8, 0.8));
        }
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        boolean isOpen;
        PacketHandler.getPlayChannel().sendToTrackingChunk(() -> this.m_9236_().m_46745_(pos), (IMessage)new S2CMessageProjectileHitBlock(x, y, z, pos, face));
        if (state.m_60734_() instanceof DoorBlock && !(isOpen = ((Boolean)state.m_61143_((Property)DoorBlock.f_52727_)).booleanValue())) {
            this.m_9236_().m_7731_(pos, (BlockState)state.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(true)), 10);
            this.m_9236_().m_5594_(null, pos, SoundEvents.f_12627_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (state.m_60734_() instanceof IDamageable) {
            ((IDamageable)state.m_60734_()).onBlockDamaged(this.m_9236_(), state, pos, this, this.getDamage(), (int)Math.ceil((double)this.getDamage() / 2.0) + 1);
        }
        if (!state.m_247087_()) {
            --this.remainingPenetrations;
            if (this.remainingPenetrations <= 0) {
                this.remainingPenetrations = 0;
                super.m_142687_(Entity.RemovalReason.KILLED);
            } else {
                Vec3 motion = this.m_20184_();
                this.m_20256_(motion.m_82542_(0.8, 0.8, 0.8));
                this.m_6034_(this.m_20185_() + motion.f_82479_ * 0.2, this.m_20186_() + motion.f_82480_ * 0.2, this.m_20189_() + motion.f_82481_ * 0.2);
            }
        } else {
            this.remainingPenetrations = 0;
            super.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.KILLED && this.remainingPenetrations > 0 && this.f_19797_ < this.life) {
            return;
        }
        super.m_142687_(reason);
    }

    @Override
    protected void onProjectileTick() {
        if (this.m_9236_().f_46443_ && this.f_19797_ > 1 && this.f_19797_ < this.life && this.f_19797_ % 5 == 0) {
            double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            double velocityX = (this.f_19796_.m_188500_() - 0.5) * 0.1;
            double velocityY = (this.f_19796_.m_188500_() - 0.5) * 0.1;
            double velocityZ = (this.f_19796_.m_188500_() - 0.5) * 0.1;
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123745_, true, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, velocityX, velocityY, velocityZ);
        }
    }
}

