/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.item.GunItem;

public class BlazeRodProjectileEntity
extends ProjectileEntity {
    private static final float REUSE_CHANCE = 0.75f;
    private static final float POWDER_DROP_CHANCE = 0.75f;
    private static final float FIRE_CHANCE = 0.75f;
    private static final int FIRE_DURATION = 5;
    private boolean canBeReused = false;

    public BlazeRodProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public BlazeRodProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
        this.canBeReused = this.f_19796_.m_188501_() < 0.75f;
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        super.onHitBlock(state, pos, face, x, y, z);
        if (this.canBeReused && !this.m_9236_().f_46443_) {
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_42585_));
            double bounceStrength = 0.05;
            itemEntity.m_20334_((this.f_19796_.m_188500_() - 0.5) * bounceStrength, 0.2, (this.f_19796_.m_188500_() - 0.5) * bounceStrength);
            this.m_9236_().m_7967_((Entity)itemEntity);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11705_, SoundSource.NEUTRAL, 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        } else {
            if (!this.m_9236_().f_46443_ && this.f_19796_.m_188501_() < 0.75f) {
                ItemEntity powderEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_42593_));
                double bounceStrength = 0.15;
                powderEntity.m_20334_((this.f_19796_.m_188500_() - 0.5) * bounceStrength, 0.15, (this.f_19796_.m_188500_() - 0.5) * bounceStrength);
                this.m_9236_().m_7967_((Entity)powderEntity);
            }
            if (!this.m_9236_().f_46443_) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 8, 0.2, 0.2, 0.2, 0.05);
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11937_, SoundSource.NEUTRAL, 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        if (!this.m_9236_().f_46443_ && this.f_19796_.m_188501_() < 0.75f) {
            entity.m_20254_(5);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.5, entity.m_20189_(), 10, 0.2, 0.2, 0.2, 0.05);
        }
        super.onHitEntity(entity, hitVec, startVec, endVec, headshot);
        if (this.canBeReused && !this.m_9236_().f_46443_) {
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_42585_));
            double bounceStrength = 0.05;
            itemEntity.m_20334_((this.f_19796_.m_188500_() - 0.5) * bounceStrength, 0.2, (this.f_19796_.m_188500_() - 0.5) * bounceStrength);
            this.m_9236_().m_7967_((Entity)itemEntity);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11705_, SoundSource.NEUTRAL, 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        } else {
            if (!this.m_9236_().f_46443_ && this.f_19796_.m_188501_() < 0.75f) {
                ItemEntity powderEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_42593_));
                double bounceStrength = 0.15;
                powderEntity.m_20334_((this.f_19796_.m_188500_() - 0.5) * bounceStrength, 0.15, (this.f_19796_.m_188500_() - 0.5) * bounceStrength);
                this.m_9236_().m_7967_((Entity)powderEntity);
            }
            if (!this.m_9236_().f_46443_) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 8, 0.2, 0.2, 0.2, 0.05);
            }
        }
    }

    @Override
    protected void onProjectileTick() {
        super.onProjectileTick();
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("CanBeReused", this.canBeReused);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.canBeReused = compound.m_128471_("CanBeReused");
    }

    @Override
    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeBoolean(this.canBeReused);
    }

    @Override
    public void readSpawnData(FriendlyByteBuf buffer) {
        super.readSpawnData(buffer);
        this.canBeReused = buffer.readBoolean();
    }
}

