/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import com.mrcrayfish.framework.network.message.IMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.config.BrassBoltConfig;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModSounds;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageTurretBulletTrail;

public class EnemyProjectileEntity
extends AbstractArrow {
    private boolean trailSpawned = false;

    public EnemyProjectileEntity(EntityType<? extends AbstractArrow> type, Level world) {
        super(type, world);
    }

    public EnemyProjectileEntity(Level world, LivingEntity shooter) {
        this((EntityType<EnemyProjectileEntity>)((EntityType)ModEntities.BRASS_BOLT.get()), world, shooter);
    }

    public EnemyProjectileEntity(EntityType<EnemyProjectileEntity> type, Level world, LivingEntity shooter) {
        super(type, shooter, world);
        this.m_36781_(BrassBoltConfig.getDamageForEntity(shooter.m_6095_()));
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            int damage = Mth.m_14165_((double)this.m_36789_());
            if (livingEntity.m_6469_(this.m_269291_().m_269418_((AbstractArrow)this, this.m_19749_()), (float)damage) && livingEntity.m_6084_()) {
                this.m_7761_(livingEntity);
            }
            livingEntity.m_21317_(livingEntity.m_21234_() - 1);
        }
        this.m_146870_();
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.m_146870_();
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && (this.f_36703_ || this.f_19797_ > 300)) {
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().f_46443_ && !this.trailSpawned && this.f_19797_ == 1) {
            this.spawnBulletTrail();
            this.trailSpawned = true;
        }
        super.m_8119_();
        if (!this.f_36703_ && !this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
        }
    }

    private void spawnBulletTrail() {
        Vec3 position = this.m_20182_();
        Vec3 motion = this.m_20184_();
        int trailColor = 0xFFAA00;
        double trailLength = 1.0;
        int maxAge = 300;
        double trailThickness = 0.7;
        S2CMessageTurretBulletTrail message = new S2CMessageTurretBulletTrail(this.m_19879_(), position, motion, trailColor, trailLength, maxAge, trailThickness);
        PacketHandler.getPlayChannel().sendToTrackingEntity(() -> this, (IMessage)message);
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        this.m_146870_();
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return (SoundEvent)ModSounds.BULLET_FLYBY.get();
    }

    public void m_5496_(SoundEvent soundEvent, float volume, float pitch) {
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128347_("damage", this.m_36789_());
        compound.m_128379_("TrailSpawned", this.trailSpawned);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("damage")) {
            this.m_36781_(compound.m_128459_("damage"));
        }
        this.trailSpawned = compound.m_128471_("TrailSpawned");
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_20221_(BlockPos pos) {
        this.m_146870_();
    }

    public boolean m_36792_() {
        return false;
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
    }

    public void m_36745_(LivingEntity pShooter, float pVelocity) {
    }
}

