/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.valkyrienskies.mod.common.world.RaycastUtilsKt;
import top.ribs.scguns.Config;
import top.ribs.scguns.ScorchedGuns;
import top.ribs.scguns.attributes.SCAttributes;
import top.ribs.scguns.block.NitroKegBlock;
import top.ribs.scguns.block.PowderKegBlock;
import top.ribs.scguns.cache.HotBarrelCache;
import top.ribs.scguns.common.BoundingBoxManager;
import top.ribs.scguns.common.ChargeHandler;
import top.ribs.scguns.common.FireMode;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.SpreadTracker;
import top.ribs.scguns.config.ProjectileAdvantageConfig;
import top.ribs.scguns.effect.RocketExplosion;
import top.ribs.scguns.event.GunProjectileHitEvent;
import top.ribs.scguns.init.ModBlocks;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.init.ModEnchantments;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.interfaces.IDamageable;
import top.ribs.scguns.interfaces.IExplosionDamageable;
import top.ribs.scguns.interfaces.IHeadshotBox;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.animated.AnimatedDiamondSteelGunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageBlood;
import top.ribs.scguns.network.message.S2CMessageProjectileHitBlock;
import top.ribs.scguns.network.message.S2CMessageProjectileHitEntity;
import top.ribs.scguns.network.message.S2CMessageRemoveProjectile;
import top.ribs.scguns.util.BufferUtil;
import top.ribs.scguns.util.GunEnchantmentHelper;
import top.ribs.scguns.util.GunModifierHelper;
import top.ribs.scguns.util.ReflectionUtil;
import top.ribs.scguns.util.math.ExtendedEntityRayTraceResult;
import top.ribs.scguns.world.ProjectileExplosion;

public class ProjectileEntity
extends Entity
implements IEntityAdditionalSpawnData {
    static final Predicate<Entity> PROJECTILE_TARGETS = input -> input != null && input.m_6087_() && !input.m_5833_();
    public static final Predicate<BlockState> IGNORE_LEAVES = input -> input != null && (Boolean)Config.COMMON.gameplay.ignoreLeaves.get() != false && input.m_60734_() instanceof LeavesBlock;
    protected int shooterId;
    protected LivingEntity shooter;
    protected Gun modifiedGun;
    protected Gun.General general;
    protected Gun.Projectile projectile;
    private ItemStack weapon = ItemStack.f_41583_;
    private ItemStack item = ItemStack.f_41583_;
    protected float additionalDamage = 0.0f;
    protected float attributeAdditionalDamage = 0.0f;
    protected double attributeDamageMultiplier = 0.0;
    protected EntityDimensions entitySize;
    protected double modifiedGravity;
    protected int life;
    private int soundTime = 0;
    private float chargeProgress;
    protected float armorBypassAmount = 2.0f;
    private float modifiedKnockback;

    public ProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public ProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        this(entityType, worldIn);
        AttributeInstance speedAttr;
        ServerPlayer player;
        this.shooterId = shooter.m_19879_();
        this.shooter = shooter;
        this.modifiedGun = modifiedGun;
        this.general = modifiedGun.getGeneral();
        this.projectile = modifiedGun.getProjectile();
        if (shooter instanceof ServerPlayer) {
            player = (ServerPlayer)shooter;
            this.chargeProgress = player.getPersistentData().m_128457_("ChargeProgress");
        } else if (shooter instanceof Player) {
            Player player2 = (Player)shooter;
            this.chargeProgress = ChargeHandler.getChargeProgress(player2, weapon);
        } else {
            this.chargeProgress = 0.0f;
        }
        if (shooter instanceof Player) {
            player = (Player)shooter;
            ChargeHandler.clearLastChargeProgress(player.m_20148_());
        }
        float baseArmorBypass = this.projectile.getArmorPen();
        float puncturingBypass = GunEnchantmentHelper.getPuncturingArmorBypass(weapon);
        this.setArmorBypassAmount(baseArmorBypass + puncturingBypass);
        float baseKnockback = this.projectile.getKnockbackStrength();
        this.modifiedKnockback = GunEnchantmentHelper.getHeavyShotKnockback(weapon, baseKnockback);
        AttributeInstance additionalDamageAttr = shooter.m_21051_((Attribute)SCAttributes.ADDITIONAL_BULLET_DAMAGE.get());
        this.attributeAdditionalDamage = additionalDamageAttr != null ? (float)additionalDamageAttr.m_22135_() : 0.0f;
        AttributeInstance damageMultAttr = shooter.m_21051_((Attribute)SCAttributes.BULLET_DAMAGE_MULTIPLIER.get());
        this.attributeDamageMultiplier = damageMultAttr != null ? damageMultAttr.m_22135_() : 1.0;
        this.entitySize = new EntityDimensions(this.projectile.getSize(), this.projectile.getSize(), false);
        this.modifiedGravity = modifiedGun.getProjectile().isGravity() ? GunModifierHelper.getModifiedProjectileGravity(weapon, -0.04) : 0.0;
        this.life = GunModifierHelper.getModifiedProjectileLife(weapon, this.projectile.getLife());
        Vec3 dir = this.getDirection(shooter, weapon, item, modifiedGun);
        double speedModifier = GunEnchantmentHelper.getProjectileSpeedModifier(weapon);
        double speed = GunModifierHelper.getModifiedProjectileSpeed(weapon, this.projectile.getSpeed() * speedModifier);
        if (modifiedGun.getGeneral().getFireMode() == FireMode.PULSE) {
            float chargeSpeedMultiplier = this.calculateChargeSpeedMultiplier(this.chargeProgress);
            speed *= (double)chargeSpeedMultiplier;
        }
        this.m_20334_(dir.f_82479_ * (speed *= (speedAttr = shooter.m_21051_((Attribute)SCAttributes.PROJECTILE_SPEED.get())) != null ? speedAttr.m_22135_() : 1.0), dir.f_82480_ * speed, dir.f_82481_ * speed);
        this.updateHeading();
        double posX = shooter.f_19790_ + (shooter.m_20185_() - shooter.f_19790_) / 2.0;
        double posY = shooter.f_19791_ + (shooter.m_20186_() - shooter.f_19791_) / 2.0 + (double)shooter.m_20192_();
        double posZ = shooter.f_19792_ + (shooter.m_20189_() - shooter.f_19792_) / 2.0;
        this.m_6034_(posX, posY, posZ);
        Item ammo = this.projectile.getItem();
        if (ammo != null) {
            ItemStack model;
            int customModelData = -1;
            if (weapon.m_41783_() != null && weapon.m_41783_().m_128425_("Model", 10) && (model = ItemStack.m_41712_((CompoundTag)weapon.m_41783_().m_128469_("Model"))).m_41783_() != null && model.m_41783_().m_128441_("CustomModelData")) {
                customModelData = model.m_41783_().m_128451_("CustomModelData");
            }
            ItemStack ammoStack = new ItemStack((ItemLike)ammo);
            if (customModelData != -1) {
                ammoStack.m_41784_().m_128405_("CustomModelData", customModelData);
            }
            this.item = ammoStack;
        }
    }

    public float getModifiedKnockback() {
        return this.modifiedKnockback;
    }

    private float calculateChargeSpeedMultiplier(float chargeProgress) {
        chargeProgress = Mth.m_14036_((float)chargeProgress, (float)0.0f, (float)1.0f);
        float minChargeSpeedMultiplier = 0.4f;
        float maxChargeSpeedMultiplier = 1.0f;
        return minChargeSpeedMultiplier + (maxChargeSpeedMultiplier - minChargeSpeedMultiplier) * chargeProgress;
    }

    protected void m_8097_() {
    }

    public void setArmorBypassAmount(float amount) {
        this.armorBypassAmount = amount;
    }

    protected float calculateArmorBypassDamage(LivingEntity target, float damage) {
        int armorValue = target.m_21230_();
        float baseReduction = Math.min(0.75f, (float)armorValue * 0.004f);
        if (this.armorBypassAmount <= 0.0f) {
            return damage * (1.0f - baseReduction);
        }
        float bypassPercent = this.armorBypassAmount / 10.0f;
        float effectiveArmor = (float)armorValue * (1.0f - bypassPercent);
        float finalReduction = Math.min(0.75f, effectiveArmor * 0.004f);
        return damage * (1.0f - finalReduction);
    }

    public float getDamage() {
        float damage = this.getaFloat();
        damage = GunModifierHelper.getModifiedDamage(this.weapon, this.modifiedGun, damage);
        damage = GunEnchantmentHelper.getAcceleratorDamage(this.weapon, damage);
        damage = GunEnchantmentHelper.getHeavyShotDamage(this.weapon, damage);
        LivingEntity livingEntity = this.shooter;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            damage = GunEnchantmentHelper.getHotBarrelDamage(player, this.weapon, damage);
        }
        damage = GunEnchantmentHelper.getChargeDamage(this.weapon, damage, this.chargeProgress);
        damage *= ((Double)Config.COMMON.gameplay.globalDamageMultiplier.get()).floatValue();
        if (this.getPersistentData().m_128441_("AIDamageScale")) {
            float scale = this.getPersistentData().m_128457_("AIDamageScale");
            damage *= scale;
        }
        return Math.max(0.0f, damage);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.entitySize;
    }

    private Vec3 getDirection(LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        AttributeInstance spreadAttr;
        float gunSpread;
        Player player;
        float baseSpread = modifiedGun.getGeneral().getSpread();
        if (shooter instanceof Player) {
            player = (Player)shooter;
            gunSpread = GunModifierHelper.getModifiedSpread(player, weapon, baseSpread);
        } else {
            gunSpread = GunModifierHelper.getModifiedSpread(weapon, baseSpread);
        }
        if (modifiedGun.getGeneral().getFireMode() == FireMode.PULSE) {
            float chargeSpreadMultiplier = this.calculateChargeSpreadMultiplier(this.chargeProgress);
            gunSpread *= chargeSpreadMultiplier;
        }
        if (gunSpread == 0.0f) {
            return ProjectileEntity.getVectorFromRotation(shooter.m_146909_(), shooter.m_146908_());
        }
        if (shooter instanceof Player) {
            player = (Player)shooter;
            if (!modifiedGun.getGeneral().isAlwaysSpread()) {
                float spreadTrackerMultiplier = SpreadTracker.get(player).getSpread(item);
                gunSpread *= spreadTrackerMultiplier;
            }
            if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue()) {
                gunSpread *= 0.7f;
            }
        }
        float attrMultiplier = (spreadAttr = shooter.m_21051_((Attribute)SCAttributes.SPREAD_MULTIPLIER.get())) != null ? (float)spreadAttr.m_22135_() : 1.0f;
        float spreadRadians = (gunSpread *= attrMultiplier) * ((float)Math.PI / 180);
        float angleY = this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
        float angleX = this.f_19796_.m_188501_() * spreadRadians;
        Vec3 forward = ProjectileEntity.getVectorFromRotation(shooter.m_146909_(), shooter.m_146908_());
        Vec3 right = Math.abs(forward.f_82480_) < 0.999 ? new Vec3(0.0, 1.0, 0.0).m_82537_(forward).m_82541_() : new Vec3(1.0, 0.0, 0.0);
        Vec3 up = forward.m_82537_(right).m_82541_();
        Vec3 spreadVector = forward;
        spreadVector = this.rotateVector(spreadVector, right, angleX);
        spreadVector = this.rotateVector(spreadVector, forward, angleY);
        return spreadVector.m_82541_();
    }

    private float calculateChargeSpreadMultiplier(float chargeProgress) {
        chargeProgress = Mth.m_14036_((float)chargeProgress, (float)0.0f, (float)1.0f);
        float minChargeSpreadMultiplier = 2.0f;
        float maxChargeSpreadMultiplier = 0.3f;
        return minChargeSpreadMultiplier - (minChargeSpreadMultiplier - maxChargeSpreadMultiplier) * (chargeProgress * chargeProgress);
    }

    private Vec3 rotateVector(Vec3 vector, Vec3 axis, float angle) {
        float sin = Mth.m_14031_((float)angle);
        float cos = Mth.m_14089_((float)angle);
        float dot = (float)vector.m_82526_(axis);
        return new Vec3(vector.f_82479_ * (double)cos + (axis.f_82480_ * vector.f_82481_ - axis.f_82481_ * vector.f_82480_) * (double)sin + axis.f_82479_ * (double)dot * (double)(1.0f - cos), vector.f_82480_ * (double)cos + (axis.f_82481_ * vector.f_82479_ - axis.f_82479_ * vector.f_82481_) * (double)sin + axis.f_82480_ * (double)dot * (double)(1.0f - cos), vector.f_82481_ * (double)cos + (axis.f_82479_ * vector.f_82480_ - axis.f_82480_ * vector.f_82479_) * (double)sin + axis.f_82481_ * (double)dot * (double)(1.0f - cos));
    }

    public float getaFloat() {
        float initialDamage = this.projectile.getDamage() + this.additionalDamage + this.attributeAdditionalDamage;
        initialDamage *= (float)this.attributeDamageMultiplier;
        if (this.projectile.isDamageReduceOverLife()) {
            float modifier = ((float)this.projectile.getLife() - (float)(this.f_19797_ - 1)) / (float)this.projectile.getLife();
            initialDamage *= modifier;
        }
        return initialDamage / (float)this.general.getProjectileAmount();
    }

    public void setWeapon(ItemStack weapon) {
        this.weapon = weapon.m_41777_();
    }

    public ItemStack getWeapon() {
        return this.weapon;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setAdditionalDamage(float additionalDamage) {
        this.additionalDamage = additionalDamage;
    }

    public double getModifiedGravity() {
        return this.modifiedGravity;
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateHeading();
        this.onProjectileTick();
        if (!this.m_9236_().m_5776_()) {
            Object result;
            Vec3 startVec = this.m_20182_();
            Vec3 endVec = startVec.m_82549_(this.m_20184_());
            BlockHitResult fluidResult = this.m_9236_().m_45547_(new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this));
            AABB range = new AABB(startVec.f_82479_ - 5.0, startVec.f_82480_ - 5.0, startVec.f_82481_ - 5.0, startVec.f_82479_ + 5.0, startVec.f_82480_ + 5.0, startVec.f_82481_ + 5.0);
            List players = this.m_9236_().m_45976_(Player.class, range);
            ResourceLocation flybySound = this.modifiedGun.getSounds().getFlybySound();
            if (!players.isEmpty() && flybySound != null && this.modifiedGun.getGeneral().getProjectileAmount() == 1 && this.f_19797_ > 3 && this.soundTime < this.f_19797_ - 3) {
                this.m_9236_().m_6263_(null, startVec.f_82479_, startVec.f_82480_, startVec.f_82481_, Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(flybySound)), SoundSource.NEUTRAL, 0.5f + this.m_9236_().m_213780_().m_188501_() * 0.4f, 0.8f + this.m_9236_().m_213780_().m_188501_() * 0.4f);
                this.soundTime = this.f_19797_;
            }
            if (fluidResult.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos blockPos = fluidResult.m_82425_();
                BlockState blockState = this.m_9236_().m_8055_(blockPos);
                FluidState fluidState = blockState.m_60819_();
                if (fluidState.m_205070_(FluidTags.f_13131_)) {
                    this.onWaterImpact(fluidResult.m_82450_());
                } else if (fluidState.m_205070_(FluidTags.f_13132_)) {
                    this.onLavaImpact(fluidResult.m_82450_());
                }
            }
            if ((result = ProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_LEAVES)).m_6662_() != HitResult.Type.MISS) {
                endVec = result.m_82450_();
            }
            List<EntityResult> hitEntities = null;
            int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.COLLATERAL.get()), (ItemStack)this.weapon);
            if (level == 0) {
                EntityResult entityResult = this.findEntityOnPath(startVec, endVec);
                if (entityResult != null) {
                    hitEntities = Collections.singletonList(entityResult);
                }
            } else {
                hitEntities = this.findEntitiesOnPath(startVec, endVec);
            }
            if (hitEntities != null && !hitEntities.isEmpty()) {
                for (EntityResult entityResult : hitEntities) {
                    result = new ExtendedEntityRayTraceResult(entityResult);
                    Entity entity = ((EntityHitResult)result).m_82443_();
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (this.shooter instanceof Player && !((Player)this.shooter).m_7099_(player)) {
                            result = null;
                        }
                    }
                    if (result == null) continue;
                    this.onHit((HitResult)result, startVec, endVec);
                }
            } else {
                this.onHit((HitResult)result, startVec, endVec);
            }
        }
        double nextPosX = this.m_20185_() + this.m_20184_().m_7096_();
        double nextPosY = this.m_20186_() + this.m_20184_().m_7098_();
        double nextPosZ = this.m_20189_() + this.m_20184_().m_7094_();
        this.m_6034_(nextPosX, nextPosY, nextPosZ);
        if (this.projectile.isGravity()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, this.modifiedGravity, 0.0));
        }
        if (this.f_19797_ >= this.life) {
            if (this.m_6084_()) {
                this.onExpired();
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void onProjectileTick() {
    }

    protected void onExpired() {
    }

    @Nullable
    protected EntityResult findEntityOnPath(Vec3 startVec, Vec3 endVec) {
        Vec3 hitVec = null;
        Entity hitEntity = null;
        boolean headshot = false;
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : entities) {
            Vec3 hitPos;
            double distanceToHit;
            EntityResult result;
            if (entity.equals((Object)this.shooter) || (result = this.getHitResult(entity, startVec, endVec)) == null || !((distanceToHit = startVec.m_82554_(hitPos = result.getHitPos())) < closestDistance)) continue;
            hitVec = hitPos;
            hitEntity = entity;
            closestDistance = distanceToHit;
            headshot = result.isHeadshot();
        }
        return hitEntity != null ? new EntityResult(hitEntity, hitVec, headshot) : null;
    }

    protected List<EntityResult> findEntitiesOnPath(Vec3 startVec, Vec3 endVec) {
        ArrayList<EntityResult> hitEntities = new ArrayList<EntityResult>();
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        for (Entity entity : entities) {
            EntityResult result = this.getHitResult(entity, startVec, endVec);
            if (result == null) continue;
            hitEntities.add(result);
        }
        return hitEntities;
    }

    @Nullable
    public EntityResult getHitResult(Entity entity, Vec3 startVec, Vec3 endVec) {
        AABB box;
        IHeadshotBox<LivingEntity> headshotBox;
        double expandHeight = entity instanceof Player && !entity.m_6047_() ? 0.0625 : 0.0;
        AABB boundingBox = entity.m_20191_();
        if (((Boolean)Config.COMMON.gameplay.improvedHitboxes.get()).booleanValue() && entity instanceof ServerPlayer && this.shooter instanceof ServerPlayer) {
            int ping = (int)Math.floor((double)((ServerPlayer)this.shooter).f_8943_ / 1000.0 * 20.0 + 0.5);
            boundingBox = BoundingBoxManager.getBoundingBox((Player)entity, ping);
        }
        boundingBox = boundingBox.m_82363_(0.0, expandHeight, 0.0);
        Vec3 hitPos = boundingBox.m_82371_(startVec, endVec).orElse(null);
        Vec3 grownHitPos = boundingBox.m_82377_(((Double)Config.COMMON.gameplay.growBoundingBoxAmount.get()).doubleValue(), 0.0, ((Double)Config.COMMON.gameplay.growBoundingBoxAmount.get()).doubleValue()).m_82371_(startVec, endVec).orElse(null);
        if (hitPos == null && grownHitPos != null) {
            BlockHitResult raytraceresult = ProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, grownHitPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_LEAVES);
            if (raytraceresult.m_6662_() == HitResult.Type.BLOCK) {
                return null;
            }
            hitPos = grownHitPos;
        }
        boolean headshot = false;
        if (((Boolean)Config.COMMON.gameplay.enableHeadShots.get()).booleanValue() && entity instanceof LivingEntity && (headshotBox = BoundingBoxManager.getHeadshotBoxes(entity.m_6095_())) != null && (box = headshotBox.getHeadshotBox((LivingEntity)entity)) != null) {
            Optional headshotHitPos = (box = box.m_82386_(boundingBox.m_82399_().f_82479_, boundingBox.f_82289_, boundingBox.m_82399_().f_82481_)).m_82371_(startVec, endVec);
            if (!headshotHitPos.isPresent()) {
                box = box.m_82377_(((Double)Config.COMMON.gameplay.growBoundingBoxAmount.get()).doubleValue(), 0.0, ((Double)Config.COMMON.gameplay.growBoundingBoxAmount.get()).doubleValue());
                headshotHitPos = box.m_82371_(startVec, endVec);
            }
            if (headshotHitPos.isPresent() && (hitPos == null || ((Vec3)headshotHitPos.get()).m_82554_(hitPos) < 0.5)) {
                hitPos = (Vec3)headshotHitPos.get();
                headshot = true;
            }
        }
        if (hitPos == null) {
            return null;
        }
        return new EntityResult(entity, hitPos, headshot);
    }

    public void onHit(HitResult result, Vec3 startVec, Vec3 endVec) {
        if (MinecraftForge.EVENT_BUS.post((Event)new GunProjectileHitEvent(result, this))) {
            return;
        }
        if (result instanceof BlockHitResult) {
            float destroySpeed;
            BlockHitResult blockHitResult = (BlockHitResult)result;
            if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
                return;
            }
            Vec3 hitVec = result.m_82450_();
            BlockPos pos = blockHitResult.m_82425_();
            BlockState state = this.m_9236_().m_8055_(pos);
            Block block = state.m_60734_();
            if (((Boolean)Config.COMMON.gameplay.griefing.enableGlassBreaking.get()).booleanValue() && state.m_204336_(ModTags.Blocks.FRAGILE) && (destroySpeed = state.m_60800_((BlockGetter)this.m_9236_(), pos)) >= 0.0f) {
                float chance = ((Double)Config.COMMON.gameplay.griefing.fragileBaseBreakChance.get()).floatValue() / (destroySpeed + 1.0f);
                if (this.f_19796_.m_188501_() < chance) {
                    this.m_9236_().m_46961_(pos, ((Boolean)Config.COMMON.gameplay.griefing.fragileBlockDrops.get()).booleanValue());
                }
            }
            if (!state.m_247087_()) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (block instanceof IDamageable) {
                ((IDamageable)block).onBlockDamaged(this.m_9236_(), state, pos, this, this.getDamage(), (int)Math.ceil((double)this.getDamage() / 2.0) + 1);
            }
            this.onHitBlock(state, pos, blockHitResult.m_82434_(), hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_);
            if (block instanceof TargetBlock) {
                TargetBlock targetBlock = (TargetBlock)block;
                int power = ReflectionUtil.updateTargetBlock(targetBlock, (LevelAccessor)this.m_9236_(), state, blockHitResult, this);
                LivingEntity livingEntity = this.shooter;
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    serverPlayer.m_36220_(Stats.f_12953_);
                    CriteriaTriggers.f_10561_.m_70211_(serverPlayer, (Entity)this, blockHitResult.m_82450_(), power);
                }
            }
            if (block instanceof BellBlock) {
                BellBlock bell = (BellBlock)block;
                bell.m_49712_(this.m_9236_(), pos, blockHitResult.m_82434_());
            }
            return;
        }
        if (result instanceof ExtendedEntityRayTraceResult) {
            ExtendedEntityRayTraceResult entityHitResult = (ExtendedEntityRayTraceResult)result;
            Entity entity = entityHitResult.m_82443_();
            if (entity.m_19879_() == this.shooterId) {
                return;
            }
            LivingEntity state = this.shooter;
            if (state instanceof Player) {
                Player player = (Player)state;
                if (entity.m_20367_((Entity)player)) {
                    return;
                }
                HotBarrelCache.getHotBarrelLevel(player, this.weapon);
                boolean shouldFire = GunEnchantmentHelper.shouldSetOnFire(player, this.weapon);
                if (shouldFire) {
                    entity.m_20254_(5);
                }
            } else if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.HOT_BARREL.get()), (ItemStack)this.weapon) > 0) {
                entity.m_20254_(5);
            }
            this.onHitEntity(entity, result.m_82450_(), startVec, endVec, entityHitResult.isHeadshot());
            int collateralLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.COLLATERAL.get()), (ItemStack)this.weapon);
            ResourceLocation advantage = this.getProjectile().getAdvantage();
            if (!entity.m_6095_().m_204039_(ModTags.Entities.GHOST) || !advantage.equals((Object)ModTags.Entities.UNDEAD.f_203868_()) || collateralLevel == 0) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            entity.f_19802_ = 0;
        }
    }

    protected void onLavaImpact(Vec3 impactPos) {
        if (!this.m_9236_().m_5776_() && ((Boolean)Config.CLIENT.particle.enableLavaImpactParticles.get()).booleanValue()) {
            int i;
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            for (i = 0; i < 5; ++i) {
                double ySpeed = 0.2 + this.f_19796_.m_188500_() * 0.3;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, impactPos.f_82479_, impactPos.f_82480_, impactPos.f_82481_, 1, 0.02, 0.0, 0.02, ySpeed);
            }
            for (i = 0; i < 3; ++i) {
                double xSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.1;
                double ySpeed = 0.2 + this.f_19796_.m_188500_() * 0.2;
                double zSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.1;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, impactPos.f_82479_, impactPos.f_82480_, impactPos.f_82481_, 1, xSpeed, ySpeed, zSpeed, 0.05);
            }
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, impactPos.f_82479_, impactPos.f_82480_ + 0.05, impactPos.f_82481_, 3, 0.1, 0.1, 0.1, 0.2);
        }
        this.m_9236_().m_6263_(null, impactPos.f_82479_, impactPos.f_82480_, impactPos.f_82481_, SoundEvents.f_12032_, SoundSource.NEUTRAL, 0.6f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
    }

    protected void onWaterImpact(Vec3 impactPos) {
        if (!this.m_9236_().m_5776_()) {
            boolean enableParticles = true;
            try {
                enableParticles = (Boolean)Config.CLIENT.particle.enableWaterImpactParticles.get();
            }
            catch (IllegalStateException e) {
                enableParticles = true;
            }
            if (enableParticles) {
                int i;
                ServerLevel serverLevel = (ServerLevel)this.m_9236_();
                boolean isSubmerged = this.m_20069_();
                int splashParticles = isSubmerged ? 10 : 40;
                int bubbleParticles = isSubmerged ? 10 : 30;
                int snowflakeParticles = isSubmerged ? 5 : 15;
                int fallingWaterParticles = isSubmerged ? 5 : 20;
                for (i = 0; i < fallingWaterParticles; ++i) {
                    double ySpeed = 0.5 + this.f_19796_.m_188500_() * 0.5;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123804_, impactPos.f_82479_, impactPos.f_82480_, impactPos.f_82481_, 1, 0.05, 0.0, 0.05, ySpeed);
                }
                for (i = 0; i < snowflakeParticles; ++i) {
                    double xSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                    double ySpeed = 0.3 + this.f_19796_.m_188500_() * 0.3;
                    double zSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, impactPos.f_82479_, impactPos.f_82480_, impactPos.f_82481_, 1, xSpeed, ySpeed, zSpeed, 0.1);
                }
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, impactPos.f_82479_, impactPos.f_82480_ + 0.1, impactPos.f_82481_, splashParticles, 0.2, 0.2, 0.2, 0.4);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123772_, impactPos.f_82479_, impactPos.f_82480_, impactPos.f_82481_, bubbleParticles, 0.5, 0.3, 0.5, 0.2);
            }
            this.m_9236_().m_6263_(null, impactPos.f_82479_, impactPos.f_82480_, impactPos.f_82481_, SoundEvents.f_12277_, SoundSource.NEUTRAL, 1.2f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
        }
    }

    public float advantageMultiplier(Entity entity) {
        ResourceLocation advantage = this.getProjectile().getAdvantage();
        if (advantage.equals((Object)ModTags.Entities.NONE.f_203868_())) {
            return 1.0f;
        }
        ProjectileAdvantageConfig.AdvantageData advantageData = ProjectileAdvantageConfig.getAdvantageData(advantage.toString());
        if (advantageData == null) {
            return 1.0f;
        }
        boolean hasMatchingTag = false;
        for (String targetTag : advantageData.targetTags()) {
            ResourceLocation tagLocation = new ResourceLocation(targetTag);
            TagKey entityTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagLocation);
            if (!entity.m_6095_().m_204039_(entityTag)) continue;
            hasMatchingTag = true;
            break;
        }
        if (hasMatchingTag) {
            if (advantageData.causesFire() && advantageData.fireDuration() > 0) {
                entity.m_20254_(advantageData.fireDuration());
            }
            return advantageData.multiplier();
        }
        return 1.0f;
    }

    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        LivingEntity livingEntity;
        float newDamage;
        float damage = this.getDamage();
        boolean critical = damage != (newDamage = this.getCriticalDamage(this.weapon, this.f_19796_, damage));
        damage = newDamage;
        damage *= this.advantageMultiplier(entity);
        boolean wasAlive = entity instanceof LivingEntity && entity.m_6084_();
        LivingEntity livingEntity2 = this.shooter;
        if (livingEntity2 instanceof Player) {
            Player player = (Player)livingEntity2;
            damage = GunEnchantmentHelper.getWaterProofDamage(this.weapon, player, damage);
        }
        if (headshot) {
            damage = (float)((double)damage * (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get());
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            damage = GunEnchantmentHelper.getPuncturingDamageReduction(this.weapon, livingTarget, damage);
            damage = this.applyProjectileProtection(livingTarget, damage);
            damage = this.calculateArmorBypassDamage(livingTarget, damage);
        }
        DamageSource source = ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, this.shooter);
        boolean blocked = ProjectileHelper.handleShieldHit(entity, this, damage);
        if (!(blocked || entity.m_6095_().m_204039_(ModTags.Entities.GHOST) && !this.getProjectile().getAdvantage().equals((Object)ModTags.Entities.UNDEAD.f_203868_()))) {
            if (damage > 0.0f) {
                entity.m_6469_(source, damage);
            }
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                ResourceLocation effectLocation = this.projectile.getImpactEffect();
                if (effectLocation != null) {
                    MobEffect effect;
                    float effectChance = this.projectile.getImpactEffectChance();
                    if (this.f_19796_.m_188501_() < effectChance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
                        livingEntity.m_7292_(new MobEffectInstance(effect, this.projectile.getImpactEffectDuration(), this.projectile.getImpactEffectAmplifier()));
                    }
                }
            }
        }
        if (entity instanceof LivingEntity) {
            GunEnchantmentHelper.applyElementalPopEffect(this.weapon, (LivingEntity)entity);
        }
        if (this.shooter instanceof Player) {
            int hitType = critical ? 2 : (headshot ? 1 : 0);
            PacketHandler.getPlayChannel().sendToPlayer(() -> (ServerPlayer)this.shooter, (IMessage)new S2CMessageProjectileHitEntity(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, hitType, entity instanceof Player));
        }
        if (wasAlive && entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_6084_()) {
            this.checkForDiamondSteelBonus(livingEntity, hitVec);
        }
        PacketHandler.getPlayChannel().sendToTracking(() -> entity, (IMessage)new S2CMessageBlood(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, entity.m_6095_()));
    }

    void checkForDiamondSteelBonus(LivingEntity killedEntity, Vec3 position) {
        int baseXP;
        int bonusXP;
        Player player;
        ItemStack weapon;
        LivingEntity livingEntity;
        if (!this.m_9236_().f_46443_ && (livingEntity = this.getShooter()) instanceof Player && ((weapon = (player = (Player)livingEntity).m_21205_()).m_41720_() instanceof AnimatedDiamondSteelGunItem || weapon.m_41720_() instanceof AnimatedDiamondSteelGunItem) && (bonusXP = Math.round((float)(baseXP = killedEntity.m_213860_()) * 0.2f)) > 0) {
            ExperienceOrb xpOrb = new ExperienceOrb(this.m_9236_(), position.f_82479_, position.f_82480_, position.f_82481_, bonusXP);
            this.m_9236_().m_7967_((Entity)xpOrb);
        }
    }

    public float applyProjectileProtection(LivingEntity target, float damage) {
        int protectionLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44969_, (LivingEntity)target);
        if (protectionLevel > 0) {
            float reduction = (float)protectionLevel * 0.1f;
            reduction = Math.min(reduction, 0.8f);
            damage *= 1.0f - reduction;
        }
        return damage;
    }

    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        boolean isOpen;
        PacketHandler.getPlayChannel().sendToTrackingChunk(() -> this.m_9236_().m_46745_(pos), (IMessage)new S2CMessageProjectileHitBlock(x, y, z, pos, face));
        Block block = state.m_60734_();
        if (this.primeTNT(state, pos)) {
            return;
        }
        if (block instanceof DoorBlock && !(isOpen = ((Boolean)state.m_61143_((Property)DoorBlock.f_52727_)).booleanValue())) {
            this.m_9236_().m_7731_(pos, (BlockState)state.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(true)), 10);
            this.m_9236_().m_5594_(null, pos, SoundEvents.f_12627_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (!state.m_247087_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (block instanceof IDamageable) {
            ((IDamageable)block).onBlockDamaged(this.m_9236_(), state, pos, this, this.getDamage(), (int)Math.ceil((double)this.getDamage() / 2.0) + 1);
        }
    }

    boolean primeTNT(BlockState state, BlockPos pos) {
        Block block = state.m_60734_();
        if (block == Blocks.f_50077_) {
            if (!this.m_9236_().m_5776_()) {
                TntBlock.m_57433_((Level)this.m_9236_(), (BlockPos)pos);
                this.m_9236_().m_7471_(pos, false);
            }
            return true;
        }
        if (block == ModBlocks.POWDER_KEG.get()) {
            if (!this.m_9236_().m_5776_()) {
                PowderKegBlock.explode(this.m_9236_(), pos);
                this.m_9236_().m_7471_(pos, false);
            }
            return true;
        }
        if (block == ModBlocks.NITRO_KEG.get()) {
            if (!this.m_9236_().m_5776_()) {
                NitroKegBlock.explode(this.m_9236_(), pos);
                this.m_9236_().m_7471_(pos, false);
            }
            return true;
        }
        return true;
    }

    protected void m_7378_(CompoundTag compound) {
        this.projectile = new Gun.Projectile();
        this.projectile.deserializeNBT(compound.m_128469_("Projectile"));
        this.general = new Gun.General();
        this.general.deserializeNBT(compound.m_128469_("General"));
        this.modifiedGravity = compound.m_128459_("ModifiedGravity");
        this.life = compound.m_128451_("MaxLife");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_("Projectile", (Tag)this.projectile.serializeNBT());
        compound.m_128365_("General", (Tag)this.general.serializeNBT());
        compound.m_128347_("ModifiedGravity", this.modifiedGravity);
        compound.m_128405_("MaxLife", this.life);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.projectile.serializeNBT());
        buffer.m_130079_(this.general.serializeNBT());
        buffer.writeInt(this.shooterId);
        BufferUtil.writeItemStackToBufIgnoreTag((ByteBuf)buffer, this.item);
        buffer.writeDouble(this.modifiedGravity);
        buffer.m_130130_(this.life);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.projectile = new Gun.Projectile();
        this.projectile.deserializeNBT(buffer.m_130260_());
        this.general = new Gun.General();
        this.general.deserializeNBT(buffer.m_130260_());
        this.shooterId = buffer.readInt();
        this.item = BufferUtil.readItemStackFromBufIgnoreTag((ByteBuf)buffer);
        this.modifiedGravity = buffer.readDouble();
        this.life = buffer.m_130242_();
        this.entitySize = new EntityDimensions(this.projectile.getSize(), this.projectile.getSize(), false);
    }

    public void updateHeading() {
        double horizontalDistance = this.m_20184_().m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7094_()) * 57.29577951308232));
        this.m_146926_((float)(Mth.m_14136_((double)this.m_20184_().m_7098_(), (double)horizontalDistance) * 57.29577951308232));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public Gun.Projectile getProjectile() {
        return this.projectile;
    }

    static Vec3 getVectorFromRotation(float pitch, float yaw) {
        float f = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -Mth.m_14089_((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public LivingEntity getShooter() {
        return this.shooter;
    }

    public int getShooterId() {
        return this.shooterId;
    }

    float getCriticalDamage(ItemStack weapon, RandomSource rand, float damage) {
        float chance = GunModifierHelper.getCriticalChance(weapon);
        if (rand.m_188501_() < chance) {
            float critMultiplier = this.modifiedGun.getGeneral().getCritDamageMultiplier();
            return damage * critMultiplier;
        }
        return damage;
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public void onRemovedFromWorld() {
        if (!this.m_9236_().f_46443_) {
            PacketHandler.getPlayChannel().sendToNearbyPlayers(this::getDeathTargetPoint, (IMessage)new S2CMessageRemoveProjectile(this.m_19879_()));
        }
    }

    LevelLocation getDeathTargetPoint() {
        return LevelLocation.create((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)256.0);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static BlockHitResult rayTraceBlocks(Level world, ClipContext context, Predicate<BlockState> ignorePredicate) {
        return ProjectileEntity.performRayTrace(context, (rayTraceContext, blockPos) -> {
            if (ScorchedGuns.valkyrienSkiesLoaded) {
                return RaycastUtilsKt.clipIncludeShips((Level)world, (ClipContext)context);
            }
            BlockState blockState = world.m_8055_(blockPos);
            if (ignorePredicate.test(blockState)) {
                return null;
            }
            FluidState fluidState = world.m_6425_(blockPos);
            Vec3 startVec = rayTraceContext.m_45702_();
            Vec3 endVec = rayTraceContext.m_45693_();
            VoxelShape blockShape = rayTraceContext.m_45694_(blockState, (BlockGetter)world, blockPos);
            BlockHitResult blockResult = world.m_45558_(startVec, endVec, blockPos, blockShape, blockState);
            VoxelShape fluidShape = rayTraceContext.m_45698_(fluidState, (BlockGetter)world, blockPos);
            BlockHitResult fluidResult = fluidShape.m_83220_(startVec, endVec, blockPos);
            double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(blockResult.m_82450_());
            double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(fluidResult.m_82450_());
            return blockDistance <= fluidDistance ? blockResult : fluidResult;
        }, rayTraceContext -> {
            Vec3 Vector3d = rayTraceContext.m_45702_().m_82546_(rayTraceContext.m_45693_());
            return BlockHitResult.m_82426_((Vec3)rayTraceContext.m_45693_(), (Direction)Direction.m_122366_((double)Vector3d.f_82479_, (double)Vector3d.f_82480_, (double)Vector3d.f_82481_), (BlockPos)BlockPos.m_274446_((Position)rayTraceContext.m_45693_()));
        });
    }

    private static <T> T performRayTrace(ClipContext context, BiFunction<ClipContext, BlockPos, T> hitFunction, Function<ClipContext, T> p_217300_2_) {
        int blockZ;
        int blockY;
        Vec3 endVec;
        Vec3 startVec = context.m_45702_();
        if (startVec.equals((Object)(endVec = context.m_45693_()))) {
            return p_217300_2_.apply(context);
        }
        double startX = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82479_, (double)startVec.f_82479_);
        double startY = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82480_, (double)startVec.f_82480_);
        double startZ = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82481_, (double)startVec.f_82481_);
        double endX = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82479_, (double)endVec.f_82479_);
        double endY = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82480_, (double)endVec.f_82480_);
        double endZ = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82481_, (double)endVec.f_82481_);
        int blockX = Mth.m_14107_((double)endX);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(blockX, blockY = Mth.m_14107_((double)endY), blockZ = Mth.m_14107_((double)endZ));
        T t = hitFunction.apply(context, (BlockPos)mutablePos);
        if (t != null) {
            return t;
        }
        double deltaX = startX - endX;
        double deltaY = startY - endY;
        double deltaZ = startZ - endZ;
        int signX = Mth.m_14205_((double)deltaX);
        int signY = Mth.m_14205_((double)deltaY);
        int signZ = Mth.m_14205_((double)deltaZ);
        double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / deltaX;
        double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / deltaY;
        double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / deltaZ;
        double d12 = d9 * (signX > 0 ? 1.0 - Mth.m_14185_((double)endX) : Mth.m_14185_((double)endX));
        double d13 = d10 * (signY > 0 ? 1.0 - Mth.m_14185_((double)endY) : Mth.m_14185_((double)endY));
        double d14 = d11 * (signZ > 0 ? 1.0 - Mth.m_14185_((double)endZ) : Mth.m_14185_((double)endZ));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    blockX += signX;
                    d12 += d9;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                blockY += signY;
                d13 += d10;
            } else {
                blockZ += signZ;
                d14 += d11;
            }
            if ((t1 = hitFunction.apply(context, (BlockPos)mutablePos.m_122178_(blockX, blockY, blockZ))) == null) continue;
            return t1;
        }
        return p_217300_2_.apply(context);
    }

    public static void createExplosion(Entity entity, float radius, boolean forceNone) {
        ProjectileEntity projectile;
        LivingEntity shooter;
        boolean allowBlockRemoval;
        DamageSource damageSource;
        Level world = entity.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        if (entity instanceof ProjectileEntity) {
            ProjectileEntity projectile2 = (ProjectileEntity)entity;
            damageSource = entity.m_269291_().m_269036_(entity, (Entity)projectile2.getShooter());
        } else {
            damageSource = null;
        }
        DamageSource source = damageSource;
        boolean bl = allowBlockRemoval = (Boolean)Config.COMMON.gameplay.griefing.enableBlockRemovalOnExplosions.get() != false && !forceNone;
        if (allowBlockRemoval && entity instanceof ProjectileEntity && (shooter = (projectile = (ProjectileEntity)entity).getShooter()) != null && !(shooter instanceof Player)) {
            allowBlockRemoval = (Boolean)Config.COMMON.gameplay.griefing.enableMobExplosionBlockRemoval.get();
        }
        Explosion.BlockInteraction mode = allowBlockRemoval ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
        ProjectileExplosion explosion = new ProjectileExplosion(world, entity, source, null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, false, mode){

            @Override
            protected float getEntityDamageAmount(Entity entity, double distance) {
                return 0.0f;
            }
        };
        if (ForgeEventFactory.onExplosionStart((Level)world, (Explosion)explosion)) {
            return;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        explosion.m_46081_().forEach(pos -> {
            if (world.m_8055_(pos).m_60734_() instanceof IExplosionDamageable) {
                ((IExplosionDamageable)world.m_8055_(pos).m_60734_()).onProjectileExploded(world, world.m_8055_(pos), (BlockPos)pos, entity);
            }
        });
        if (!explosion.m_254884_()) {
            explosion.m_46080_();
        }
        for (ServerPlayer player : ((ServerLevel)world).m_6907_()) {
            if (!(player.m_20275_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()) < 4096.0)) continue;
            player.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(player)));
        }
    }

    public static void createRocketExplosion(Entity entity, float radius, float damage, boolean forceNone) {
        ProjectileEntity projectile;
        LivingEntity shooter;
        boolean allowBlockRemoval;
        DamageSource damageSource;
        Level world = entity.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        if (entity instanceof ProjectileEntity) {
            ProjectileEntity projectile2 = (ProjectileEntity)entity;
            damageSource = entity.m_269291_().m_269036_(entity, (Entity)projectile2.getShooter());
        } else {
            damageSource = null;
        }
        DamageSource source = damageSource;
        boolean bl = allowBlockRemoval = (Boolean)Config.COMMON.gameplay.griefing.enableBlockRemovalOnExplosions.get() != false && !forceNone;
        if (allowBlockRemoval && entity instanceof ProjectileEntity && (shooter = (projectile = (ProjectileEntity)entity).getShooter()) != null && !(shooter instanceof Player)) {
            allowBlockRemoval = (Boolean)Config.COMMON.gameplay.griefing.enableMobExplosionBlockRemoval.get();
        }
        Explosion.BlockInteraction mode = allowBlockRemoval ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
        RocketExplosion explosion = new RocketExplosion(world, entity, source, null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, damage, false, mode);
        if (ForgeEventFactory.onExplosionStart((Level)world, (Explosion)explosion)) {
            return;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        explosion.m_46081_().forEach(pos -> {
            if (world.m_8055_(pos).m_60734_() instanceof IExplosionDamageable) {
                ((IExplosionDamageable)world.m_8055_(pos).m_60734_()).onProjectileExploded(world, world.m_8055_(pos), (BlockPos)pos, entity);
            }
        });
        if (!explosion.m_254884_()) {
            explosion.m_46080_();
        }
    }

    public static void createFireExplosion(Entity entity, float radius, boolean forceNone) {
        DamageSource damageSource;
        Level world = entity.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        if (entity instanceof ProjectileEntity) {
            ProjectileEntity projectile = (ProjectileEntity)entity;
            damageSource = entity.m_269291_().m_269036_(entity, (Entity)projectile.getShooter());
        } else {
            damageSource = null;
        }
        DamageSource source = damageSource;
        Explosion.BlockInteraction mode = Explosion.BlockInteraction.KEEP;
        ProjectileExplosion explosion = new ProjectileExplosion(world, entity, source, null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius * 0.5f, true, mode){

            @Override
            protected float getEntityDamageAmount(Entity entity, double distance) {
                return 0.0f;
            }
        };
        if (ForgeEventFactory.onExplosionStart((Level)world, (Explosion)explosion)) {
            return;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        BlockPos centerPos = entity.m_20183_();
        AABB effectArea = new AABB(centerPos).m_82400_((double)radius);
        List nearbyEntities = world.m_45976_(LivingEntity.class, effectArea);
        for (LivingEntity livingEntity : nearbyEntities) {
            double distance = livingEntity.m_20270_(entity);
            if (!(distance <= (double)radius)) continue;
            livingEntity.m_20254_(8);
            float damage = (float)(4.0 * (1.0 - distance / (double)radius));
            livingEntity.m_6469_(world.m_269111_().m_269387_(), damage);
        }
    }

    public static void createSoulFireExplosion(Entity entity, float radius, boolean forceNone) {
        DamageSource damageSource;
        Level world = entity.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        if (entity instanceof ProjectileEntity) {
            ProjectileEntity projectile = (ProjectileEntity)entity;
            damageSource = entity.m_269291_().m_269036_(entity, (Entity)projectile.getShooter());
        } else {
            damageSource = null;
        }
        DamageSource source = damageSource;
        Explosion.BlockInteraction mode = Explosion.BlockInteraction.KEEP;
        ProjectileExplosion explosion = new ProjectileExplosion(world, entity, source, null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius * 0.5f, false, mode){

            @Override
            protected float getEntityDamageAmount(Entity entity, double distance) {
                return 0.0f;
            }
        };
        if (ForgeEventFactory.onExplosionStart((Level)world, (Explosion)explosion)) {
            return;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        BlockPos centerPos = entity.m_20183_();
        AABB effectArea = new AABB(centerPos).m_82400_((double)radius);
        List nearbyEntities = world.m_45976_(LivingEntity.class, effectArea);
        for (LivingEntity livingEntity : nearbyEntities) {
            double distance = livingEntity.m_20270_(entity);
            if (!(distance <= (double)radius)) continue;
            livingEntity.m_20254_(8);
            float damage = (float)(4.0 * (1.0 - distance / (double)radius));
            livingEntity.m_6469_(world.m_269111_().m_269387_(), damage);
        }
        int radiusInt = (int)Math.ceil(radius);
        int radiusSquared = radiusInt * radiusInt;
        for (int x = -radiusInt; x <= radiusInt; ++x) {
            block2: for (int z = -radiusInt; z <= radiusInt; ++z) {
                BlockPos columnPos = centerPos.m_7918_(x, 0, z);
                if (!(centerPos.m_123331_((Vec3i)columnPos) <= (double)radiusSquared)) continue;
                for (int y = -radiusInt; y <= radiusInt; ++y) {
                    BlockPos pos = centerPos.m_7918_(x, y, z);
                    BlockState stateAtPos = world.m_8055_(pos);
                    BlockState stateBelow = world.m_8055_(pos.m_7495_());
                    if (!stateAtPos.m_60795_() || !stateBelow.m_60783_((BlockGetter)world, pos.m_7495_(), Direction.UP) && stateBelow.m_60795_()) continue;
                    world.m_7731_(pos, ((Block)ModBlocks.FAKE_SOUL_FIRE.get()).m_49966_(), 3);
                    continue block2;
                }
            }
        }
    }

    public static void createChokeExplosion(Entity entity, float radius) {
        Level world = entity.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        BlockPos centerPos = entity.m_20183_();
        int radiusInt = (int)Math.ceil(radius);
        int radiusSquared = radiusInt * radiusInt;
        for (int x = -radiusInt; x <= radiusInt; ++x) {
            for (int y = -radiusInt; y <= radiusInt; ++y) {
                for (int z = -radiusInt; z <= radiusInt; ++z) {
                    BlockPos pos = centerPos.m_7918_(x, y, z);
                    if (!(centerPos.m_123331_((Vec3i)pos) <= (double)radiusSquared) || world.m_8055_(pos).m_60734_() != Blocks.f_50083_) continue;
                    world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
            }
        }
        AABB effectArea = new AABB(centerPos).m_82400_((double)radius);
        List affectedEntities = world.m_45976_(LivingEntity.class, effectArea);
        for (LivingEntity affectedEntity : affectedEntities) {
            if (!affectedEntity.m_6060_()) continue;
            affectedEntity.m_20095_();
        }
        if (!world.m_5776_()) {
            ServerLevel serverLevel = (ServerLevel)world;
            for (int i = 0; i < 200; ++i) {
                double offsetX = (serverLevel.f_46441_.m_188500_() - 0.5) * 2.0 * (double)radius;
                double offsetY = (serverLevel.f_46441_.m_188500_() - 0.5) * 0.2;
                double offsetZ = (serverLevel.f_46441_.m_188500_() - 0.5) * 2.0 * (double)radius;
                double posX = (double)centerPos.m_123341_() + offsetX;
                double posY = (double)centerPos.m_123342_() + offsetY;
                double posZ = (double)centerPos.m_123343_() + offsetZ;
                double speedX = (serverLevel.f_46441_.m_188500_() - 0.5) * 0.1;
                double speedY = (serverLevel.f_46441_.m_188500_() - 0.5) * 0.1;
                double speedZ = (serverLevel.f_46441_.m_188500_() - 0.5) * 0.1;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123790_, posX, posY, posZ, 1, speedX, speedY, speedZ, 0.1);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, posX, posY, posZ, 1, speedX, speedY, speedZ, 0.1);
            }
        }
    }

    public Entity getOwner() {
        return this.shooter;
    }

    public static class EntityResult {
        private final Entity entity;
        private final Vec3 hitVec;
        private final boolean headshot;

        public EntityResult(Entity entity, Vec3 hitVec, boolean headshot) {
            this.entity = entity;
            this.hitVec = hitVec;
            this.headshot = headshot;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public Vec3 getHitPos() {
            return this.hitVec;
        }

        public boolean isHeadshot() {
            return this.headshot;
        }
    }

    public static class ProjectileHelper {
        public static final float DEFAULT_SHIELD_DISABLE_CHANCE = 0.3f;

        public static boolean handleShieldHit(Entity target, Entity projectile, float damage, float shieldDisableChance) {
            InteractionHand hand;
            boolean isBlockingOffHand;
            if (!(target instanceof Player)) {
                return false;
            }
            Player player = (Player)target;
            ItemStack mainHandItem = player.m_21205_();
            ItemStack offHandItem = player.m_21206_();
            boolean isBlockingMainHand = player.m_21254_() && mainHandItem.m_41720_() instanceof ShieldItem;
            boolean bl = isBlockingOffHand = player.m_21254_() && offHandItem.m_41720_() instanceof ShieldItem;
            if (!isBlockingMainHand && !isBlockingOffHand) {
                return false;
            }
            ItemStack shield = isBlockingMainHand ? mainHandItem : offHandItem;
            InteractionHand interactionHand = hand = isBlockingMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            if (projectile.m_9236_().m_213780_().m_188501_() < shieldDisableChance) {
                player.m_36335_().m_41524_(shield.m_41720_(), 100);
                player.m_5810_();
                player.m_9236_().m_7605_((Entity)player, (byte)30);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12347_, SoundSource.PLAYERS, 1.0f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
                return false;
            }
            player.m_6469_(player.m_269291_().m_269264_(), 0.5f);
            shield.m_41622_(12, (LivingEntity)player, p -> p.m_21190_(hand));
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
            return true;
        }

        public static boolean handleShieldHit(Entity target, Entity projectile, float damage) {
            return ProjectileHelper.handleShieldHit(target, projectile, damage, 0.3f);
        }
    }
}

