/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.throwable;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.entity.throwable.GrenadeEntity;
import top.ribs.scguns.entity.throwable.ThrowableGrenadeEntity;
import top.ribs.scguns.entity.throwable.ThrowableItemEntity;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModItems;

public class ThrowableChokeBombEntity
extends ThrowableGrenadeEntity {
    private final float explosionRadius;

    public ThrowableChokeBombEntity(EntityType<? extends ThrowableGrenadeEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.explosionRadius = 4.0f;
    }

    public ThrowableChokeBombEntity(Level world, LivingEntity entity, int timeLeft, float radius) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.THROWABLE_CHOKE_BOMB.get()), world, entity);
        this.setShouldBounce(true);
        this.setItem(new ItemStack((ItemLike)ModItems.CHOKE_BOMB.get()));
        this.setMaxLife(60);
        this.explosionRadius = radius;
    }

    @Override
    protected void m_8097_() {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    public void particleTick() {
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123790_, true, this.m_20185_(), this.m_20186_() + 0.35, this.m_20189_(), 0.0, 0.0, 0.0);
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_175821_, true, this.m_20185_(), this.m_20186_() + 0.35, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onDeath() {
        double y = this.m_20186_() + (double)this.m_6095_().m_20680_().f_20378_ * 0.5;
        this.m_9236_().m_6263_(null, this.m_20185_(), y, this.m_20189_(), SoundEvents.f_11934_, SoundSource.BLOCKS, 2.0f, 1.0f);
        GrenadeEntity.createChokeExplosion((Entity)this, this.explosionRadius);
        this.spawnExplosionParticles(new Vec3(this.m_20185_(), y, this.m_20189_()));
    }

    private void spawnExplosionParticles(Vec3 position) {
        if (!this.m_9236_().f_46443_) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            for (int i = 0; i < 10; ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double speedX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double speedY = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double speedZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, speedX, speedY, speedZ, 0.1);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123790_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, speedX, speedY, speedZ, 0.1);
            }
        }
    }
}

