/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.throwable;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.entity.throwable.ThrowableGrenadeEntity;
import top.ribs.scguns.entity.throwable.ThrowableItemEntity;
import top.ribs.scguns.init.ModEffects;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModItems;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageBlood;
import top.ribs.scguns.particles.TrailData;

public class ThrowableNailBombEntity
extends ThrowableGrenadeEntity {
    public float rotation;
    private static final float LACERATION_CHANCE = 0.35f;
    private static final int LACERATION_DURATION = 200;
    private static final int LACERATION_AMPLIFIER = 0;

    public ThrowableNailBombEntity(EntityType<? extends ThrowableGrenadeEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public ThrowableNailBombEntity(Level world, LivingEntity entity, int timeLeft) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.THROWABLE_NAIL_BOMB.get()), world, entity);
        this.setShouldBounce(false);
        this.setItem(new ItemStack((ItemLike)ModItems.NAIL_BOMB.get()));
        this.setMaxLife(60);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    public void particleTick() {
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 0.0, 0.0, 0.0);
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123797_, true, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), (this.f_19796_.m_188500_() - 0.5) * 0.1, (this.f_19796_.m_188500_() - 0.5) * 0.1, (this.f_19796_.m_188500_() - 0.5) * 0.1);
        }
    }

    @Override
    public void onDeath() {
        double y = this.m_20186_() + (double)this.m_6095_().m_20680_().f_20378_ * 0.5;
        this.m_9236_().m_6263_(null, this.m_20185_(), y, this.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.m_9236_().m_6263_(null, this.m_20185_(), y, this.m_20189_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 1.5f, 0.8f);
        ThrowableNailBombEntity.createShrapnelExplosion((Entity)this, 15.0f, false);
        this.spawnExplosionParticles(new Vec3(this.m_20185_(), y, this.m_20189_()));
    }

    public static void createShrapnelExplosion(Entity entity, float radius, boolean damageBlocks) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        Level world = entity.m_9236_();
        Vec3 origin = entity.m_20182_();
        world.m_6263_(null, origin.f_82479_, origin.f_82480_, origin.f_82481_, SoundEvents.f_11983_, SoundSource.NEUTRAL, 2.0f, 0.8f + world.f_46441_.m_188501_() * 0.4f);
        world.m_6263_(null, origin.f_82479_, origin.f_82480_, origin.f_82481_, SoundEvents.f_144050_, SoundSource.NEUTRAL, 1.5f, 1.2f + world.f_46441_.m_188501_() * 0.3f);
        ServerLevel serverLevel = (ServerLevel)world;
        for (int i = 0; i < 40; ++i) {
            double angle = world.f_46441_.m_188500_() * Math.PI * 2.0;
            double pitch = (world.f_46441_.m_188500_() - 0.5) * Math.PI * 0.5;
            double speed = 0.3 + world.f_46441_.m_188500_() * 0.4;
            double offsetX = Math.cos(angle) * Math.cos(pitch) * speed;
            double offsetY = Math.sin(pitch) * speed;
            double offsetZ = Math.sin(angle) * Math.cos(pitch) * speed;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, origin.f_82479_, origin.f_82480_, origin.f_82481_, 1, offsetX, offsetY, offsetZ, 0.02);
        }
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123747_, origin.f_82479_, origin.f_82480_, origin.f_82481_, 1, 0.1, 0.1, 0.1, 0.0);
        int shrapnelCount = 30;
        float baseDamage = 8.0f;
        for (int i = 0; i < shrapnelCount; ++i) {
            Vec3 direction = ThrowableNailBombEntity.generateRandomDirection(world.f_46441_);
            Vec3 endPos = origin.m_82549_(direction.m_82490_((double)radius));
            ThrowableNailBombEntity.traceShrapnelRay(world, entity, origin, endPos, baseDamage, i);
        }
    }

    private static Vec3 generateRandomDirection(RandomSource random) {
        float z;
        float y;
        float x;
        float lengthSquared;
        while ((lengthSquared = (x = random.m_188501_() * 2.0f - 1.0f) * x + (y = random.m_188501_() * 2.0f - 1.0f) * y + (z = random.m_188501_() * 2.0f - 1.0f) * z) > 1.0f || lengthSquared < 0.001f) {
        }
        float length = Mth.m_14116_((float)lengthSquared);
        return new Vec3((double)(x / length), (double)(y / length), (double)(z / length));
    }

    private static void traceShrapnelRay(Level world, Entity source, Vec3 start, Vec3 end, float damage, int rayIndex) {
        BlockHitResult blockHit;
        List<Entity> hitEntities = ThrowableNailBombEntity.findEntitiesAlongRay(world, source, start, end);
        Vec3 traceEnd = end;
        boolean hitSomething = false;
        Entity closestEntity = null;
        double closestDistance = Double.MAX_VALUE;
        Vec3 closestHitPos = null;
        for (Entity entity : hitEntities) {
            double distance;
            Vec3 hitPos;
            if (!ThrowableNailBombEntity.isValidShrapnelTarget(entity, source) || (hitPos = ThrowableNailBombEntity.getEntityHitPosition(entity, start, end)) == null || !((distance = start.m_82557_(hitPos)) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
            closestHitPos = hitPos;
        }
        if (closestEntity != null) {
            ThrowableNailBombEntity.damageEntityWithShrapnel(world, closestEntity, closestHitPos, damage, source);
            traceEnd = closestHitPos;
            hitSomething = true;
        }
        if (!hitSomething && (blockHit = world.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, source))).m_6662_() != HitResult.Type.MISS) {
            traceEnd = blockHit.m_82450_();
        }
        ThrowableNailBombEntity.createShrapnelTracer(world, start, traceEnd);
    }

    private static List<Entity> findEntitiesAlongRay(Level world, Entity source, Vec3 start, Vec3 end) {
        AABB searchBox = new AABB(start, end).m_82400_(1.0);
        return world.m_6249_(source, searchBox, entity -> entity != null && entity.m_6087_() && !entity.m_5833_() && ThrowableNailBombEntity.isValidShrapnelTarget(entity, source));
    }

    private static boolean isValidShrapnelTarget(Entity entity, Entity source) {
        return entity != source;
    }

    private static Vec3 getEntityHitPosition(Entity entity, Vec3 start, Vec3 end) {
        AABB boundingBox = entity.m_20191_();
        return boundingBox.m_82371_(start, end).orElse(null);
    }

    private static void damageEntityWithShrapnel(Level world, Entity entity, Vec3 hitPos, float damage, Entity source) {
        DamageSource damageSource;
        Entity thrower = null;
        if (source instanceof ThrowableItemEntity) {
            ThrowableItemEntity throwable = (ThrowableItemEntity)source;
            thrower = throwable.m_19749_();
        }
        if (thrower instanceof LivingEntity) {
            LivingEntity livingThrower = (LivingEntity)thrower;
            damageSource = world.m_269111_().m_269036_(source, (Entity)livingThrower);
        } else {
            damageSource = world.m_269111_().m_269036_(source, null);
        }
        entity.m_6469_(damageSource, damage);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!world.m_5776_()) {
                if (world.f_46441_.m_188501_() < 0.35f) {
                    MobEffectInstance laceration = new MobEffectInstance((MobEffect)ModEffects.LACERATED.get(), 200, 0, false, false, true);
                    livingEntity.m_7292_(laceration);
                }
                PacketHandler.getPlayChannel().sendToTracking(() -> entity, (IMessage)new S2CMessageBlood(hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, entity.m_6095_()));
            }
        }
        entity.f_19802_ = Math.min(entity.f_19802_, 3);
    }

    private static void createShrapnelTracer(Level world, Vec3 start, Vec3 end) {
        if (world.m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        Vec3 direction = end.m_82546_(start);
        double distance = direction.m_82553_();
        if (distance < 0.1) {
            return;
        }
        direction = direction.m_82541_();
        int maxSegments = Math.min(20, (int)(distance * 2.5));
        for (int i = 1; i <= maxSegments; ++i) {
            double progress = (double)i / (double)maxSegments;
            Vec3 particlePos = start.m_82549_(direction.m_82490_(distance * progress));
            double densityFactor = Math.max(0.3, 1.0 - progress * 0.6);
            int particlesAtThisPoint = Math.max(1, (int)(6.0 * densityFactor));
            double spreadRadius = 0.03 + progress * 0.15;
            for (int j = 0; j < particlesAtThisPoint; ++j) {
                double offsetX = (world.f_46441_.m_188500_() - 0.5) * spreadRadius;
                double offsetY = (world.f_46441_.m_188500_() - 0.5) * spreadRadius;
                double offsetZ = (world.f_46441_.m_188500_() - 0.5) * spreadRadius;
                TrailData trailData = new TrailData(false);
                serverLevel.m_8767_((ParticleOptions)trailData, particlePos.f_82479_ + offsetX, particlePos.f_82480_ + offsetY, particlePos.f_82481_ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void spawnExplosionParticles(Vec3 position) {
        if (!this.m_9236_().f_46443_) {
            double speedZ;
            double speedY;
            double speedX;
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            for (i = 0; i < 20; ++i) {
                offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                speedX = (this.f_19796_.m_188500_() - 0.5) * 0.8;
                speedY = (this.f_19796_.m_188500_() - 0.5) * 0.8;
                speedZ = (this.f_19796_.m_188500_() - 0.5) * 0.8;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, speedX, speedY, speedZ, 0.1);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, speedX * 1.5, speedY * 1.5, speedZ * 1.5, 0.2);
            }
            for (i = 0; i < 10; ++i) {
                offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.8;
                offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.6;
                offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.8;
                speedX = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                speedY = this.f_19796_.m_188500_() * 0.4;
                speedZ = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, speedX, speedY, speedZ, 0.05);
            }
        }
    }
}

