/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.util;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import top.ribs.scguns.init.ModBlocks;
import top.ribs.scguns.init.ModItems;

public class GoldConsumptionHelper {
    private static final float DEFAULT_GOLD_VALUE = 3.0f;
    private static final float DEFAULT_PIGLIN_LOVED_VALUE = 4.0f;

    public static boolean isGoldItem(ItemStack stack) {
        if (GoldConsumptionHelper.isPoisonItem(stack)) {
            return true;
        }
        if (GoldConsumptionHelper.isVanillaGoldItem(stack)) {
            return true;
        }
        return stack.m_204117_(ItemTags.f_13151_);
    }

    private static boolean isVanillaGoldItem(ItemStack stack) {
        ArmorItem armor;
        Item item;
        return stack.m_150930_(Items.f_42417_) || stack.m_150930_(Items.f_42587_) || stack.m_150930_(Items.f_41912_) || stack.m_150930_(Items.f_151053_) || stack.m_150930_(Items.f_150997_) || (item = stack.m_41720_()) instanceof ArmorItem && (armor = (ArmorItem)item).m_40401_() == ArmorMaterials.GOLD || stack.m_150930_(Items.f_42430_) || stack.m_150930_(Items.f_42432_) || stack.m_150930_(Items.f_42433_) || stack.m_150930_(Items.f_42431_) || stack.m_150930_(Items.f_42434_) || stack.m_150930_(Items.f_42436_) || stack.m_150930_(Items.f_42677_) || stack.m_150930_(Items.f_42652_) || stack.m_150930_(Items.f_150967_) || stack.m_150930_(Items.f_41833_) || stack.m_150930_(Items.f_41836_) || stack.m_150930_(Items.f_42437_);
    }

    public static boolean isPoisonItem(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.SULFUR_CHUNK.get()) || stack.m_150930_(((Block)ModBlocks.SULFUR_BLOCK.get()).m_5456_()) || stack.m_150930_(((Block)ModBlocks.NETHER_SULFUR_ORE.get()).m_5456_()) || stack.m_150930_(((Block)ModBlocks.SULFUR_ORE.get()).m_5456_()) || stack.m_150930_(((Block)ModBlocks.DEEPSLATE_SULFUR_ORE.get()).m_5456_()) || stack.m_150930_((Item)ModItems.SULFUR_DUST.get());
    }

    public static float getGoldNuggetValue(ItemStack stack) {
        if (stack.m_150930_(Items.f_42587_)) {
            return 0.7f;
        }
        if (stack.m_150930_(Items.f_42417_)) {
            return 6.0f;
        }
        if (stack.m_150930_(Items.f_41912_)) {
            return 54.0f;
        }
        if (stack.m_150930_(Items.f_151053_)) {
            return 6.0f;
        }
        if (stack.m_150930_(Items.f_150997_)) {
            return 54.0f;
        }
        if (stack.m_150930_(Items.f_42436_)) {
            return 48.0f;
        }
        if (stack.m_150930_(Items.f_42437_)) {
            return 432.0f;
        }
        if (stack.m_150930_(Items.f_42677_)) {
            return 6.0f;
        }
        if (stack.m_150930_(Items.f_42652_)) {
            return 24.0f;
        }
        if (stack.m_150930_(Items.f_41836_) || stack.m_150930_(Items.f_41833_) || stack.m_150930_(Items.f_150967_)) {
            return 5.0f;
        }
        if (stack.m_150930_(Items.f_42476_)) {
            return 30.0f;
        }
        if (stack.m_150930_(Items.f_42477_)) {
            return 48.0f;
        }
        if (stack.m_150930_(Items.f_42478_)) {
            return 42.0f;
        }
        if (stack.m_150930_(Items.f_42479_)) {
            return 24.0f;
        }
        if (stack.m_150930_(Items.f_42430_)) {
            return 12.0f;
        }
        if (stack.m_150930_(Items.f_42432_)) {
            return 18.0f;
        }
        if (stack.m_150930_(Items.f_42433_)) {
            return 18.0f;
        }
        if (stack.m_150930_(Items.f_42431_)) {
            return 6.0f;
        }
        if (stack.m_150930_(Items.f_42434_)) {
            return 12.0f;
        }
        if (stack.m_204117_(ItemTags.f_13151_)) {
            return 4.0f;
        }
        return 3.0f;
    }

    public static float getHealthFromGold(ItemStack stack) {
        float goldValue = GoldConsumptionHelper.getGoldNuggetValue(stack);
        return Math.min(goldValue / 3.0f, 8.0f);
    }

    public static void applyPoisonEffects(Mob entity, ItemStack poisonStack) {
        Level level;
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 0));
        entity.m_6469_(entity.m_269291_().m_269425_(), 2.0f);
        entity.m_5496_(SoundEvents.f_12323_, 1.0f, 0.8f + entity.m_217043_().m_188501_() * 0.4f);
        if (!entity.m_9236_().f_46443_ && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 8; ++i) {
                double particleX = entity.m_20185_() + (entity.m_217043_().m_188500_() - 0.5) * 0.6;
                double particleY = entity.m_20186_() + (double)entity.m_20192_() - 0.1;
                double particleZ = entity.m_20189_() + (entity.m_217043_().m_188500_() - 0.5) * 0.6;
                double velocityX = (entity.m_217043_().m_188500_() - 0.5) * 0.3;
                double velocityY = entity.m_217043_().m_188500_() * 0.3 + 0.1;
                double velocityZ = (entity.m_217043_().m_188500_() - 0.5) * 0.3;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123753_, particleX, particleY, particleZ, 1, velocityX, velocityY, velocityZ, 0.0);
            }
        }
    }

    public static void showEatingParticles(Mob entity) {
        Level level;
        if (!entity.m_9236_().f_46443_ && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 3; ++i) {
                double particleX = entity.m_20185_() + (entity.m_217043_().m_188500_() - 0.5) * 0.5;
                double particleY = entity.m_20186_() + (double)entity.m_20192_() - 0.1;
                double particleZ = entity.m_20189_() + (entity.m_217043_().m_188500_() - 0.5) * 0.5;
                double velocityX = (entity.m_217043_().m_188500_() - 0.5) * 0.15;
                double velocityY = entity.m_217043_().m_188500_() * 0.15;
                double velocityZ = (entity.m_217043_().m_188500_() - 0.5) * 0.15;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123753_, particleX, particleY, particleZ, 1, velocityX, velocityY, velocityZ, 0.0);
            }
        }
    }

    public static void showSlagProductionParticles(Mob entity) {
        Level level;
        if (!entity.m_9236_().f_46443_ && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 5; ++i) {
                double particleX = entity.m_20185_() + (entity.m_217043_().m_188500_() - 0.5);
                double particleY = entity.m_20186_() + (double)entity.m_20192_();
                double particleZ = entity.m_20189_() + (entity.m_217043_().m_188500_() - 0.5);
                double velocityX = (entity.m_217043_().m_188500_() - 0.5) * 0.4;
                double velocityY = entity.m_217043_().m_188500_() * 0.4 + 0.2;
                double velocityZ = (entity.m_217043_().m_188500_() - 0.5) * 0.4;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123753_, particleX, particleY, particleZ, 1, velocityX, velocityY, velocityZ, 0.0);
            }
        }
    }
}

