/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.event;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.init.ModBlocks;
import top.ribs.scguns.init.ModItems;

@Mod.EventBusSubscriber(modid="scguns")
public class GuanoItemEventHandler {
    private static final Set<ItemEntity> guanoItems = new HashSet<ItemEntity>();

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        ItemStack stack = itemEntity.m_32055_();
        if (stack.m_150930_((Item)ModItems.BAT_GUANO.get())) {
            guanoItems.add(itemEntity);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<ItemEntity> iterator = guanoItems.iterator();
        while (iterator.hasNext()) {
            ItemEntity itemEntity = iterator.next();
            if (!itemEntity.m_6084_() || itemEntity.m_213877_()) {
                iterator.remove();
                continue;
            }
            if (!itemEntity.m_20096_() || itemEntity.f_19797_ % 15 != 0 || !GuanoItemEventHandler.tryFormGuanoLayer(itemEntity)) continue;
            iterator.remove();
        }
    }

    private static boolean tryFormGuanoLayer(ItemEntity itemEntity) {
        int layers;
        Level level = itemEntity.m_9236_();
        BlockPos pos = itemEntity.m_20183_();
        BlockState stateAtPos = level.m_8055_(pos);
        BlockState stateBelow = level.m_8055_(pos.m_7495_());
        if (stateAtPos.m_60713_((Block)ModBlocks.BAT_GUANO_LAYER.get()) && (layers = ((Integer)stateAtPos.m_61143_((Property)SnowLayerBlock.f_56581_)).intValue()) < 8) {
            level.m_7731_(pos, (BlockState)stateAtPos.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers + 1)), 3);
            itemEntity.m_32055_().m_41774_(1);
            if (itemEntity.m_32055_().m_41619_()) {
                itemEntity.m_146870_();
                return true;
            }
            return false;
        }
        if (!stateBelow.m_60795_() && stateBelow.m_60804_((BlockGetter)level, pos.m_7495_()) && stateAtPos.m_60795_()) {
            BlockState newLayer = (BlockState)((Block)ModBlocks.BAT_GUANO_LAYER.get()).m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(1));
            level.m_7731_(pos, newLayer, 3);
            itemEntity.m_32055_().m_41774_(1);
            if (itemEntity.m_32055_().m_41619_()) {
                itemEntity.m_146870_();
                return true;
            }
        }
        return false;
    }
}

