/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.init.ModTags;

@Mod.EventBusSubscriber(modid="scguns")
public class OceanWeaponEventHandler {
    private static final Map<UUID, Boolean> appliedDolphinGrace = new HashMap<UUID, Boolean>();

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            OceanWeaponEventHandler.applyDolphinGrace(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            OceanWeaponEventHandler.applyDolphinGrace(player);
        }
    }

    private static void applyDolphinGrace(Player player) {
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offHandItem = player.m_21206_();
        boolean holdingOceanWeapon = OceanWeaponEventHandler.isOceanWeapon(mainHandItem) || OceanWeaponEventHandler.isOceanWeapon(offHandItem);
        boolean isInWater = player.m_204029_(FluidTags.f_13131_);
        MobEffectInstance dolphinGraceEffect = player.m_21124_(MobEffects.f_19593_);
        UUID playerId = player.m_20148_();
        boolean wasAppliedByUs = appliedDolphinGrace.getOrDefault(playerId, false);
        if (holdingOceanWeapon && isInWater) {
            if (dolphinGraceEffect == null || dolphinGraceEffect.m_19557_() <= 10) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19593_, 60, 0, false, false, false));
                appliedDolphinGrace.put(playerId, true);
            } else if (dolphinGraceEffect.m_19557_() > 60) {
                appliedDolphinGrace.put(playerId, false);
            }
        } else if (wasAppliedByUs && dolphinGraceEffect != null && dolphinGraceEffect.m_19557_() <= 60) {
            player.m_21195_(MobEffects.f_19593_);
            appliedDolphinGrace.remove(playerId);
        } else if (!holdingOceanWeapon || !isInWater) {
            appliedDolphinGrace.remove(playerId);
        }
    }

    private static boolean isOceanWeapon(ItemStack itemStack) {
        return !itemStack.m_41619_() && itemStack.m_204117_(ModTags.Items.OCEAN_GUN);
    }
}

