/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.init;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.config.RaidConfig;
import top.ribs.scguns.entity.player.PlayerGunProgression;
import top.ribs.scguns.entity.raid.ActiveRaid;
import top.ribs.scguns.entity.raid.RaidManager;
import top.ribs.scguns.event.GunProgressionEventHandler;

public class ModCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"scguns").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"progression").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"tier", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (PlayerGunProgression.GunTier tier : PlayerGunProgression.GunTier.values()) {
                builder.suggest(tier.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            String tierName = StringArgumentType.getString((CommandContext)context, (String)"tier");
            return ModCommands.executeSetProgression((CommandSourceStack)context.getSource(), player, tierName);
        }))))).then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            return ModCommands.executeClearProgression((CommandSourceStack)context.getSource(), player);
        })))).then(Commands.m_82127_((String)"check").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            return ModCommands.executeCheckProgression((CommandSourceStack)context.getSource(), player);
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"raid").then(Commands.m_82127_((String)"start").then(Commands.m_82129_((String)"raid_id", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (RaidConfig.RaidData raid : RaidConfig.getAllRaids()) {
                builder.suggest(raid.raidId());
            }
            return builder.buildFuture();
        }).executes(context -> {
            String raidId = StringArgumentType.getString((CommandContext)context, (String)"raid_id");
            return ModCommands.executeStartRaidById((CommandSourceStack)context.getSource(), raidId);
        })))).then(Commands.m_82127_((String)"stop").executes(context -> ModCommands.executeStopAllRaids((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"list").executes(context -> ModCommands.executeListRaids((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"listall").executes(context -> ModCommands.executeListAllAvailableRaids((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"startnext").executes(context -> ModCommands.executeStartNextRaid((CommandSourceStack)context.getSource())))));
    }

    private static int executeStartRaidById(CommandSourceStack source, String raidId) {
        if (!source.m_6761_(2)) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.scguns.no_permission"));
            return 0;
        }
        ServerLevel serverLevel = source.m_81372_();
        RaidConfig.RaidData raidConfig = RaidConfig.getRaidById(raidId);
        if (raidConfig == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.scguns.raid.no_config", (Object[])new Object[]{raidId}));
            return 0;
        }
        Vec3 sourcePos = source.m_81371_();
        RaidManager manager = RaidManager.get(serverLevel);
        manager.startRaid(raidConfig, serverLevel, sourcePos);
        MutableComponent raidName = Component.m_237113_((String)raidConfig.raidId()).m_130940_(ChatFormatting.GOLD);
        source.m_288197_(() -> ModCommands.lambda$executeStartRaidById$10((Component)raidName), true);
        return 1;
    }

    private static int executeListAllAvailableRaids(CommandSourceStack source) {
        if (!source.m_6761_(2)) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.scguns.no_permission"));
            return 0;
        }
        Collection<RaidConfig.RaidData> progressionRaids = RaidConfig.getProgressionRaids();
        Collection<RaidConfig.RaidData> customRaids = RaidConfig.getCustomRaids();
        source.m_288197_(() -> Component.m_237113_((String)"=== Available Raids ===").m_130940_(ChatFormatting.GOLD), false);
        if (!progressionRaids.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"Progression Raids:").m_130940_(ChatFormatting.YELLOW), false);
            for (RaidConfig.RaidData raid : progressionRaids) {
                String levelStr = raid.raidLevel() != null ? "Level " + raid.raidLevel() : "NONE";
                source.m_288197_(() -> Component.m_237113_((String)("  - " + raid.raidId() + " (" + levelStr + ")")).m_130940_(ChatFormatting.WHITE), false);
            }
        }
        if (!customRaids.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"Custom Raids:").m_130940_(ChatFormatting.AQUA), false);
            for (RaidConfig.RaidData raid : customRaids) {
                source.m_288197_(() -> Component.m_237113_((String)("  - " + raid.raidId())).m_130940_(ChatFormatting.WHITE), false);
            }
        }
        if (progressionRaids.isEmpty() && customRaids.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"No raids configured!").m_130940_(ChatFormatting.RED), false);
        }
        return 1;
    }

    private static int executeStartNextRaid(CommandSourceStack source) {
        if (!source.m_6761_(2)) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.scguns.no_permission"));
            return 0;
        }
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.scguns.requires_player"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ServerLevel serverLevel = source.m_81372_();
        PlayerGunProgression progression = PlayerGunProgression.get((Player)player);
        int currentRaidLevel = progression.getCurrentRaidLevel();
        if (currentRaidLevel == 0) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.scguns.unlock_gun"));
            return 0;
        }
        List<RaidConfig.RaidData> nextLevelRaids = RaidConfig.getRaidsAtLevel(currentRaidLevel + 1);
        if (nextLevelRaids.isEmpty()) {
            source.m_81352_((Component)Component.m_237113_((String)"No higher level raids available!"));
            return 0;
        }
        RaidConfig.RaidData raidConfig = nextLevelRaids.get(0);
        Vec3 sourcePos = source.m_81371_();
        RaidManager manager = RaidManager.get(serverLevel);
        manager.startRaid(raidConfig, serverLevel, sourcePos);
        MutableComponent raidName = Component.m_237113_((String)raidConfig.raidId()).m_130940_(ChatFormatting.GOLD);
        source.m_288197_(() -> ModCommands.lambda$executeStartNextRaid$17((Component)raidName), true);
        return 1;
    }

    private static int executeSetProgression(CommandSourceStack source, ServerPlayer player, String tierName) {
        PlayerGunProgression.GunTier tier;
        if (!source.m_6761_(2)) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.scguns.no_permission"));
            return 0;
        }
        try {
            tier = PlayerGunProgression.GunTier.valueOf(tierName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.scguns.progression.invalid_tier", (Object[])new Object[]{tierName}));
            return 0;
        }
        PlayerGunProgression progression = PlayerGunProgression.get((Player)player);
        progression.setTier(tier);
        PlayerGunProgression.save((Player)player, progression);
        GunProgressionEventHandler.sendTierUnlockedMessage((Player)player, tier);
        MutableComponent tierComponent = Component.m_237115_((String)("gun_tier.scguns." + tier.name().toLowerCase())).m_130940_(ChatFormatting.GOLD);
        source.m_288197_(() -> ModCommands.lambda$executeSetProgression$18(player, (Component)tierComponent), true);
        return 1;
    }

    private static int executeClearProgression(CommandSourceStack source, ServerPlayer player) {
        if (!source.m_6761_(2)) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.scguns.no_permission"));
            return 0;
        }
        PlayerGunProgression progression = new PlayerGunProgression();
        PlayerGunProgression.save((Player)player, progression);
        player.m_213846_((Component)Component.m_237115_((String)"commands.scguns.progression.reset").m_130940_(ChatFormatting.RED));
        source.m_288197_(() -> Component.m_237110_((String)"commands.scguns.progression.cleared", (Object[])new Object[]{player.m_5446_()}), true);
        return 1;
    }

    private static int executeCheckProgression(CommandSourceStack source, ServerPlayer player) {
        List<RaidConfig.RaidData> availableRaids;
        if (!source.m_6761_(2)) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.scguns.no_permission"));
            return 0;
        }
        PlayerGunProgression progression = PlayerGunProgression.get((Player)player);
        PlayerGunProgression.GunTier currentTier = progression.getCurrentTier();
        int raidLevel = progression.getCurrentRaidLevel();
        List<PlayerGunProgression.GunTier> availableTiers = progression.getAvailableMobTiers();
        MutableComponent tierComponent = Component.m_237115_((String)("gun_tier.scguns." + currentTier.name().toLowerCase())).m_130940_(ChatFormatting.GOLD);
        source.m_288197_(() -> Component.m_237113_((String)"Player: ").m_7220_(player.m_5446_()), false);
        source.m_288197_(() -> ModCommands.lambda$executeCheckProgression$21((Component)tierComponent), false);
        source.m_288197_(() -> Component.m_237113_((String)("Raid Level: " + raidLevel)).m_130940_(ChatFormatting.AQUA), false);
        if (!availableTiers.isEmpty()) {
            MutableComponent mobTiersMessage = Component.m_237113_((String)"Available Mob Tiers: ");
            for (int i = 0; i < availableTiers.size(); ++i) {
                PlayerGunProgression.GunTier mobTier = availableTiers.get(i);
                MutableComponent mobTierComponent = Component.m_237115_((String)("gun_tier.scguns." + mobTier.name().toLowerCase())).m_130940_(ChatFormatting.RED);
                mobTiersMessage = mobTiersMessage.m_6881_().m_7220_((Component)mobTierComponent);
                if (i >= availableTiers.size() - 1) continue;
                mobTiersMessage = mobTiersMessage.m_6881_().m_130946_(", ");
            }
            MutableComponent finalMobTiersMessage = mobTiersMessage;
            source.m_288197_(() -> ModCommands.lambda$executeCheckProgression$23((Component)finalMobTiersMessage), false);
        }
        if (!(availableRaids = RaidConfig.getRaidsForLevel(raidLevel)).isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)("Available Raids (" + availableRaids.size() + "):")).m_130940_(ChatFormatting.GREEN), false);
            for (RaidConfig.RaidData raid : availableRaids) {
                String levelStr = raid.raidLevel() != null ? " (Level " + raid.raidLevel() + ")" : "";
                source.m_288197_(() -> Component.m_237113_((String)("  - " + raid.raidId() + levelStr)), false);
            }
        }
        return 1;
    }

    private static int executeStopAllRaids(CommandSourceStack source) {
        if (!source.m_6761_(2)) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.scguns.no_permission"));
            return 0;
        }
        ServerLevel serverLevel = source.m_81372_();
        RaidManager manager = RaidManager.get(serverLevel);
        Collection<ActiveRaid> activeRaids = manager.getActiveRaids();
        if (activeRaids.isEmpty()) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.scguns.raid.none_active"));
            return 0;
        }
        int count = 0;
        for (ActiveRaid raid : new ArrayList<ActiveRaid>(activeRaids)) {
            raid.endRaid(false);
            ++count;
        }
        int finalCount = count;
        source.m_288197_(() -> Component.m_237110_((String)"commands.scguns.raid.stopped", (Object[])new Object[]{finalCount}), true);
        return 1;
    }

    private static int executeListRaids(CommandSourceStack source) {
        if (!source.m_6761_(2)) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.scguns.no_permission"));
            return 0;
        }
        ServerLevel serverLevel = source.m_81372_();
        RaidManager manager = RaidManager.get(serverLevel);
        Collection<ActiveRaid> activeRaids = manager.getActiveRaids();
        if (activeRaids.isEmpty()) {
            source.m_288197_(() -> Component.m_237115_((String)"commands.scguns.raid.list_none"), false);
            return 1;
        }
        source.m_288197_(() -> Component.m_237115_((String)"commands.scguns.raid.list_header").m_130940_(ChatFormatting.GOLD), false);
        for (ActiveRaid raid : activeRaids) {
            Integer raidLevel = raid.getRaidLevel();
            MutableComponent raidInfo = raidLevel != null ? Component.m_237113_((String)(raid.getConfig().raidId() + " (Level " + raidLevel + ")")).m_130940_(ChatFormatting.YELLOW) : Component.m_237113_((String)(raid.getConfig().raidId() + " (Custom)")).m_130940_(ChatFormatting.AQUA);
            int henchmenCount = raid.getAliveHenchmenCount();
            long duration = raid.getRaidDuration() / 20L;
            MutableComponent finalRaidInfo = raidInfo;
            source.m_288197_(() -> ModCommands.lambda$executeListRaids$29((Component)finalRaidInfo, henchmenCount, duration), false);
        }
        return 1;
    }

    private static /* synthetic */ Component lambda$executeListRaids$29(Component finalRaidInfo, int henchmenCount, long duration) {
        return Component.m_237110_((String)"commands.scguns.raid.list_entry", (Object[])new Object[]{finalRaidInfo, henchmenCount, duration});
    }

    private static /* synthetic */ Component lambda$executeCheckProgression$23(Component finalMobTiersMessage) {
        return finalMobTiersMessage;
    }

    private static /* synthetic */ Component lambda$executeCheckProgression$21(Component tierComponent) {
        return Component.m_237113_((String)"Gun Tier: ").m_7220_(tierComponent);
    }

    private static /* synthetic */ Component lambda$executeSetProgression$18(ServerPlayer player, Component tierComponent) {
        return Component.m_237110_((String)"commands.scguns.progression.set", (Object[])new Object[]{player.m_5446_(), tierComponent});
    }

    private static /* synthetic */ Component lambda$executeStartNextRaid$17(Component raidName) {
        return Component.m_237110_((String)"commands.scguns.raid.started", (Object[])new Object[]{raidName});
    }

    private static /* synthetic */ Component lambda$executeStartRaidById$10(Component raidName) {
        return Component.m_237110_((String)"commands.scguns.raid.started", (Object[])new Object[]{raidName});
    }
}

