/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.init;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import top.ribs.scguns.entity.player.PlayerGunProgression;

public class ModTags {
    public static Map<ResourceLocation, TagKey<Block>> blockTagCache = new HashMap<ResourceLocation, TagKey<Block>>();

    public static class Entities {
        public static final TagKey<EntityType<?>> ASGHARIAN_MOB_TYPES = Entities.tag("asgharian_mob_types");
        public static final TagKey<EntityType<?>> DISABLE_BULLET_TRAIL = Entities.tag("disable_bullet_trail");
        public static final TagKey<EntityType<?>> GUNNER = Entities.tag("gunner");
        public static final TagKey<EntityType<?>> CANNOT_BE_LACERATED = Entities.tag("cannot_be_lacerated");
        public static final TagKey<EntityType<?>> RED_BLOOD = Entities.tag("red_blood");
        public static final TagKey<EntityType<?>> WHITE_BLOOD = Entities.tag("white_blood");
        public static final TagKey<EntityType<?>> GREEN_BLOOD = Entities.tag("green_blood");
        public static final TagKey<EntityType<?>> BLUE_BLOOD = Entities.tag("blue_blood");
        public static final TagKey<EntityType<?>> YELLOW_BLOOD = Entities.tag("yellow_blood");
        public static final TagKey<EntityType<?>> PURPLE_BLOOD = Entities.tag("purple_blood");
        public static final TagKey<EntityType<?>> BLACK_BLOOD = Entities.tag("black_blood");
        public static final TagKey<EntityType<?>> NON_SWARM_TARGETED = Entities.tag("non_swarm_targeted");
        public static final TagKey<EntityType<?>> FLEEING_FROM_GUNS = Entities.tag("fleeing_from_guns");
        public static final TagKey<EntityType<?>> AGGRO_FROM_GUNS = Entities.tag("aggro_from_guns");
        public static final TagKey<EntityType<?>> NONE = Entities.tag("none");
        public static final TagKey<EntityType<?>> HEAVY = Entities.tag("heavy");
        public static final TagKey<EntityType<?>> VERY_HEAVY = Entities.tag("very_heavy");
        public static final TagKey<EntityType<?>> UNDEAD = Entities.tag("undead");
        public static final TagKey<EntityType<?>> GHOST = Entities.tag("ghost");
        public static final TagKey<EntityType<?>> WITHER = Entities.tag("wither");
        public static final TagKey<EntityType<?>> FIRE = Entities.tag("fire");
        public static final TagKey<EntityType<?>> ILLAGER = Entities.tag("illager");
        public static final TagKey<EntityType<?>> BOT = Entities.tag("bot");
        public static final TagKey<EntityType<?>> WATER = Entities.tag("water");
        public static final TagKey<EntityType<?>> TURRET_BLACKLIST = Entities.tag("turret_blacklist");
        public static final TagKey<EntityType<?>> TURRET_ENEMY_WHITELIST = Entities.tag("turret_enemy_whitelist");

        public static TagKey<EntityType<?>> tag(String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("scguns", name));
        }
    }

    public static class Items {
        public static final TagKey<Item> DOES_NOT_EJECT_CASINGS = Items.tag("does_not_eject_casings");
        public static final TagKey<Item> SINGLE_SHOT = Items.tag("single_shot");
        public static final TagKey<Item> NON_COLLATERAL = Items.tag("non_collateral");
        public static final TagKey<Item> ONE_HANDED_CARBINE = Items.tag("one_handed_carbine");
        public static final TagKey<Item> HEAVY_WEAPON = Items.tag("heavy_weapon");
        public static final TagKey<Item> OCEAN_GUN = Items.tag("ocean_gun");
        public static final TagKey<Item> PIGLIN_GUN = Items.tag("piglin_gun");
        public static final TagKey<Item> BUILT_IN_BAYONET = Items.tag("built_in_bayonet");
        public static final TagKey<Item> WEAK_FILTER = Items.tag("weak_filter");
        public static final TagKey<Item> STRONG_FILTER = Items.tag("strong_filter");
        public static final TagKey<Item> WEAK_COMPOST = Items.tag("weak_compost");
        public static final TagKey<Item> NORMAL_COMPOST = Items.tag("normal_compost");
        public static final TagKey<Item> STRONG_COMPOST = Items.tag("strong_compost");
        public static final TagKey<Item> COMPOST_DROPS = Items.tag("compost_drops");
        public static final TagKey<Item> GAS_MASK = Items.tag("gas_mask");
        public static final TagKey<Item> EXPLOSIVE_BLOCK = Items.tag("explosive_block");
        public static final TagKey<Item> GEOTHERMAL_VENT_OUTPUT = Items.tag("geothermal_vent_output");
        public static final TagKey<Item> SULFUR_VENT_OUTPUT = Items.tag("sulfur_vent_output");
        public static final TagKey<Item> MINING_GUN = Items.tag("mining_gun");
        public static final TagKey<Item> ANTIQUE_GUN_TIER = Items.tag("antique_gun_tier");
        public static final TagKey<Item> FRONTIER_GUN_TIER = Items.tag("frontier_gun_tier");
        public static final TagKey<Item> COPPER_GUN_TIER = Items.tag("copper_gun_tier");
        public static final TagKey<Item> IRON_GUN_TIER = Items.tag("iron_gun_tier");
        public static final TagKey<Item> WRECKER_GUN_TIER = Items.tag("wrecker_gun_tier");
        public static final TagKey<Item> OCEAN_GUN_TIER = Items.tag("ocean_gun_tier");
        public static final TagKey<Item> DIAMOND_STEEL_GUN_TIER = Items.tag("diamond_steel_gun_tier");
        public static final TagKey<Item> TREATED_BRASS_GUN_TIER = Items.tag("treated_brass_gun_tier");
        public static final TagKey<Item> PIGLIN_GUN_TIER = Items.tag("piglin_gun_tier");
        public static final TagKey<Item> DEEP_DARK_GUN_TIER = Items.tag("deep_dark_gun_tier");
        public static final TagKey<Item> END_GUN_TIER = Items.tag("end_gun_tier");
        public static final TagKey<Item> SCORCHED_GUN_TIER = Items.tag("scorched_gun_tier");
        public static final TagKey<Item> ENTITY_BLACKLISTED_GUN = Items.tag("entity_blacklisted_gun");

        public static boolean isInTierTag(ItemStack stack, PlayerGunProgression.GunTier tier) {
            if (stack.m_41619_() || tier.getTagName() == null) {
                return false;
            }
            return switch (tier) {
                case PlayerGunProgression.GunTier.ANTIQUE -> stack.m_204117_(ANTIQUE_GUN_TIER);
                case PlayerGunProgression.GunTier.FRONTIER -> stack.m_204117_(FRONTIER_GUN_TIER);
                case PlayerGunProgression.GunTier.COPPER -> stack.m_204117_(COPPER_GUN_TIER);
                case PlayerGunProgression.GunTier.IRON -> stack.m_204117_(IRON_GUN_TIER);
                case PlayerGunProgression.GunTier.WRECKER -> stack.m_204117_(WRECKER_GUN_TIER);
                case PlayerGunProgression.GunTier.OCEAN -> stack.m_204117_(OCEAN_GUN_TIER);
                case PlayerGunProgression.GunTier.DIAMOND_STEEL -> stack.m_204117_(DIAMOND_STEEL_GUN_TIER);
                case PlayerGunProgression.GunTier.TREATED_BRASS -> stack.m_204117_(TREATED_BRASS_GUN_TIER);
                case PlayerGunProgression.GunTier.PIGLIN -> stack.m_204117_(PIGLIN_GUN_TIER);
                case PlayerGunProgression.GunTier.DEEP_DARK -> stack.m_204117_(DEEP_DARK_GUN_TIER);
                case PlayerGunProgression.GunTier.END -> stack.m_204117_(END_GUN_TIER);
                case PlayerGunProgression.GunTier.SCORCHED -> stack.m_204117_(SCORCHED_GUN_TIER);
                default -> false;
            };
        }

        public static PlayerGunProgression.GunTier getTierForItem(ItemStack stack) {
            if (stack.m_41619_()) {
                return null;
            }
            for (PlayerGunProgression.GunTier tier : PlayerGunProgression.GunTier.values()) {
                if (tier == PlayerGunProgression.GunTier.NONE || !Items.isInTierTag(stack, tier)) continue;
                return tier;
            }
            return null;
        }

        private static TagKey<Item> tag(String name) {
            return ItemTags.create((ResourceLocation)new ResourceLocation("scguns", name));
        }
    }

    public static class Blocks {
        public static final TagKey<Block> FRAGILE = Blocks.tag("fragile");
        public static final TagKey<Block> SCULK_BLOCKS = Blocks.tag("sculk_blocks");
        public static final TagKey<Block> TANK_BREAKABLE = Blocks.tag("tank_breakable");
        public static final TagKey<Block> ASGHARIAN_BRICKS = Blocks.tag("asgharian_bricks");

        private static TagKey<Block> tag(String name) {
            return BlockTags.create((ResourceLocation)new ResourceLocation("scguns", name));
        }

        private static TagKey<Block> tag() {
            return BlockTags.create((ResourceLocation)new ResourceLocation("scguns", "fragile"));
        }
    }
}

