/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import top.ribs.scguns.interfaces.IEnergyGun;
import top.ribs.scguns.item.GunItem;

public class EnergyGunItem
extends GunItem
implements IEnergyGun {
    private final int capacity;

    public EnergyGunItem(Item.Properties properties, int capacity) {
        super(properties);
        this.capacity = capacity;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){
            private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> new ItemEnergyStorage(stack, EnergyGunItem.this.capacity));

            public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                return cap == ForgeCapabilities.ENERGY ? this.energy.cast() : LazyOptional.empty();
            }
        };
    }

    @Override
    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    @Override
    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)this.getEnergyStored(stack) / (float)this.getMaxEnergyStored(stack));
    }

    @Override
    public int m_142159_(ItemStack stack) {
        return 65280;
    }

    public int getEnergyStored(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public int getMaxEnergyStored(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getMaxEnergyStored).orElse(0);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, worldIn, tooltip, flag);
        int energyStored = this.getEnergyStored(stack);
        int maxEnergy = this.getMaxEnergyStored(stack);
        tooltip.add((Component)Component.m_237115_((String)"info.scguns.energy").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(energyStored + " / " + maxEnergy + " FE")).m_130940_(ChatFormatting.GREEN)));
    }

    public static class ItemEnergyStorage
    implements IEnergyStorage {
        private final ItemStack stack;
        private final int capacity;
        private int energy;

        public ItemEnergyStorage(ItemStack stack, int capacity) {
            this.stack = stack;
            this.capacity = capacity;
            this.energy = this.loadEnergyFromNBT();
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int energyReceived = Math.min(this.capacity - this.energy, maxReceive);
            if (!simulate) {
                this.energy += energyReceived;
                this.updateEnergyTag();
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int energyExtracted = Math.min(this.energy, maxExtract);
            if (!simulate) {
                this.energy -= energyExtracted;
                this.updateEnergyTag();
            }
            return energyExtracted;
        }

        public int getEnergyStored() {
            return this.energy;
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }

        private void updateEnergyTag() {
            CompoundTag tag = this.stack.m_41784_();
            tag.m_128405_("Energy", this.energy);
        }

        private int loadEnergyFromNBT() {
            CompoundTag tag = this.stack.m_41783_();
            return tag != null && tag.m_128425_("Energy", 3) ? tag.m_128451_("Energy") : 0;
        }
    }
}

