/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.Config;

public interface IColored {
    default public boolean canColor(ItemStack stack) {
        return true;
    }

    default public boolean hasColor(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41784_();
        return tagCompound.m_128425_("Color", 3);
    }

    default public int getColor(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41784_();
        return tagCompound.m_128451_("Color");
    }

    default public void setColor(ItemStack stack, int color) {
        CompoundTag tagCompound = stack.m_41784_();
        tagCompound.m_128405_("Color", color);
    }

    default public void removeColor(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41784_();
        tagCompound.m_128473_("Color");
    }

    public static ItemStack dye(ItemStack stack, List<DyeItem> dyes) {
        ItemStack resultStack = ItemStack.f_41583_;
        int[] combinedColors = new int[3];
        int maxColor = 0;
        int colorCount = 0;
        IColored coloredItem = null;
        if (IColored.isDyeable(stack)) {
            coloredItem = (IColored)stack.m_41720_();
            resultStack = stack.m_41777_();
            resultStack.m_41764_(1);
            if (coloredItem.hasColor(stack)) {
                int color = coloredItem.getColor(resultStack);
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                maxColor = (int)((float)maxColor + Math.max(red, Math.max(green, blue)) * 255.0f);
                combinedColors[0] = (int)((float)combinedColors[0] + red * 255.0f);
                combinedColors[1] = (int)((float)combinedColors[1] + green * 255.0f);
                combinedColors[2] = (int)((float)combinedColors[2] + blue * 255.0f);
                ++colorCount;
            }
            for (DyeItem dyeitem : dyes) {
                float[] colorComponents = dyeitem.m_41089_().m_41068_();
                int red = (int)(colorComponents[0] * 255.0f);
                int green = (int)(colorComponents[1] * 255.0f);
                int blue = (int)(colorComponents[2] * 255.0f);
                maxColor += Math.max(red, Math.max(green, blue));
                combinedColors[0] = combinedColors[0] + red;
                combinedColors[1] = combinedColors[1] + green;
                combinedColors[2] = combinedColors[2] + blue;
                ++colorCount;
            }
        }
        if (coloredItem == null) {
            return ItemStack.f_41583_;
        }
        int red = combinedColors[0] / colorCount;
        int green = combinedColors[1] / colorCount;
        int blue = combinedColors[2] / colorCount;
        float averageColor = (float)maxColor / (float)colorCount;
        float maxValue = Math.max(red, Math.max(green, blue));
        red = (int)((float)red * averageColor / maxValue);
        green = (int)((float)green * averageColor / maxValue);
        blue = (int)((float)blue * averageColor / maxValue);
        int finalColor = (red << 8) + green;
        finalColor = (finalColor << 8) + blue;
        coloredItem.setColor(resultStack, finalColor);
        return resultStack;
    }

    public static boolean isDyeable(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IColored) {
            IColored colored = (IColored)item;
            return colored.canColor(stack) || (Boolean)Config.SERVER.experimental.forceDyeableAttachments.get() != false;
        }
        return false;
    }
}

