/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item.animated;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.interfaces.IAirGun;
import top.ribs.scguns.item.animated.AnimatedGunItem;
import top.ribs.scguns.util.AirSourceHelper;

public class AnimatedAirGunItem
extends AnimatedGunItem
implements IAirGun {
    public AnimatedAirGunItem(Item.Properties properties, String path, SoundEvent reloadSoundMagOut, SoundEvent reloadSoundMagIn, SoundEvent reloadSoundEnd, SoundEvent boltPullSound, SoundEvent boltReleaseSound) {
        super(properties, path, reloadSoundMagOut, reloadSoundMagIn, reloadSoundEnd, boltPullSound, boltReleaseSound);
    }

    @Override
    public boolean m_142522_(ItemStack stack) {
        Boolean result = (Boolean)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Player player = AnimatedAirGunItem.getClientPlayer();
            if (player != null) {
                AirSourceHelper.AirSource airSource = AirSourceHelper.getBestAirSource(player);
                return airSource.isAvailable() || stack.m_41768_();
            }
            return stack.m_41768_();
        });
        return result != null && result != false;
    }

    @Override
    public int m_142158_(ItemStack stack) {
        Integer width = (Integer)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            AirSourceHelper.AirInfo airInfo;
            Player player = AnimatedAirGunItem.getClientPlayer();
            if (player != null && (airInfo = AirSourceHelper.getAirInfo(player)).sourceType() != AirSourceHelper.AirSource.Type.NONE) {
                return airInfo.barWidth();
            }
            return Math.round(13.0f - (float)stack.m_41773_() * 13.0f / (float)stack.m_41776_());
        });
        return width != null ? width : 0;
    }

    @Override
    public int m_142159_(ItemStack stack) {
        Integer color = (Integer)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            AirSourceHelper.AirInfo airInfo;
            Player player = AnimatedAirGunItem.getClientPlayer();
            if (player != null && (airInfo = AirSourceHelper.getAirInfo(player)).sourceType() != AirSourceHelper.AirSource.Type.NONE) {
                return airInfo.barColor();
            }
            if ((double)stack.m_41773_() >= (double)stack.m_41776_() / 1.5) {
                return Objects.requireNonNull(ChatFormatting.RED.m_126665_());
            }
            float f = Math.max(0.0f, ((float)stack.m_41776_() - (float)stack.m_41773_()) / (float)stack.m_41776_());
            return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
        });
        return color != null ? color : Mth.m_14169_((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        Player player;
        super.m_7373_(stack, world, tooltip, flag);
        Gun gun = this.getModifiedGun(stack);
        int airUsage = gun.getGeneral().getEnergyUse();
        tooltip.add((Component)Component.m_237115_((String)"info.airgun.air_usage").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(airUsage)).m_130940_(ChatFormatting.WHITE)));
        if (world != null && world.f_46443_ && (player = AnimatedAirGunItem.getClientPlayer()) != null) {
            AirSourceHelper.AirSource airSource = AirSourceHelper.getBestAirSource(player);
            switch (airSource.getType()) {
                case CREATE_BACKTANK: {
                    tooltip.add((Component)Component.m_237115_((String)"info.airgun.using_backtank").m_130940_(ChatFormatting.GREEN));
                    break;
                }
                case AIR_CANISTER: {
                    tooltip.add((Component)Component.m_237115_((String)"info.airgun.using_canister").m_130940_(ChatFormatting.AQUA));
                    break;
                }
                default: {
                    tooltip.add((Component)Component.m_237115_((String)"info.airgun.requires_air_source").m_130940_(ChatFormatting.RED));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }
}

