/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item.animated;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import top.ribs.scguns.Config;
import top.ribs.scguns.client.render.armor.BrassMaskArmorRenderer;
import top.ribs.scguns.entity.monster.DissidentEntity;
import top.ribs.scguns.init.ModEntities;

public class BrassMaskArmorItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public BrassMaskArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private BrassMaskArmorRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new BrassMaskArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Player player = pContext.m_43723_();
        Level level = pContext.m_43725_();
        BlockPos pos = pContext.m_8083_();
        if (player != null && player.m_6144_() && this.isValidHomUnculusStructure(level, pos)) {
            if (!level.m_5776_()) {
                BlockPos topPos;
                BlockPos bottomPos;
                if (!player.m_150110_().f_35937_) {
                    pContext.m_43722_().m_41774_(1);
                }
                if (level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50129_)) {
                    bottomPos = pos;
                    topPos = pos.m_7494_();
                } else {
                    bottomPos = pos.m_7495_();
                    topPos = pos;
                }
                level.m_7731_(bottomPos, Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(topPos, Blocks.f_50016_.m_49966_(), 3);
                this.spawnCreationEffects((ServerLevel)level, bottomPos.m_7494_());
                level.m_5594_(null, bottomPos, SoundEvents.f_12090_, SoundSource.BLOCKS, 0.8f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
                boolean disableVillagers = (Boolean)Config.COMMON.gameplay.disableVillagerSpawning.get();
                if (disableVillagers) {
                    double dissidentChance = (Double)Config.COMMON.gameplay.dissidentSpawnChance.get();
                    if (level.f_46441_.m_188500_() < dissidentChance) {
                        DissidentEntity dissident = new DissidentEntity((EntityType<? extends Monster>)((EntityType)ModEntities.DISSIDENT.get()), level);
                        dissident.m_7678_((double)bottomPos.m_123341_() + 0.5, bottomPos.m_123342_(), (double)bottomPos.m_123343_() + 0.5, 0.0f, 0.0f);
                        level.m_7967_((Entity)dissident);
                        level.m_5594_(null, bottomPos, SoundEvents.f_12616_, SoundSource.HOSTILE, 1.0f, 0.8f);
                    }
                } else {
                    boolean createDissident = level.f_46441_.m_188499_();
                    if (createDissident) {
                        DissidentEntity dissident = new DissidentEntity((EntityType<? extends Monster>)((EntityType)ModEntities.DISSIDENT.get()), level);
                        dissident.m_7678_((double)bottomPos.m_123341_() + 0.5, bottomPos.m_123342_(), (double)bottomPos.m_123343_() + 0.5, 0.0f, 0.0f);
                        level.m_7967_((Entity)dissident);
                        level.m_5594_(null, bottomPos, SoundEvents.f_12616_, SoundSource.HOSTILE, 1.0f, 0.8f);
                    } else {
                        Villager villager = new Villager(EntityType.f_20492_, level);
                        villager.m_7678_((double)bottomPos.m_123341_() + 0.5, (double)bottomPos.m_123342_(), (double)bottomPos.m_123343_() + 0.5, 0.0f, 0.0f);
                        List villagerTypes = BuiltInRegistries.f_256934_.m_123024_().toList();
                        VillagerType randomType = (VillagerType)villagerTypes.get(level.f_46441_.m_188503_(villagerTypes.size()));
                        villager.m_34375_(villager.m_7141_().m_35567_(randomType).m_35565_(VillagerProfession.f_35585_));
                        level.m_7967_((Entity)villager);
                        level.m_5594_(null, bottomPos, SoundEvents.f_12504_, SoundSource.NEUTRAL, 1.0f, 1.2f);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(pContext);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        if (pPlayer.m_6144_()) {
            return InteractionResultHolder.m_19098_((Object)pPlayer.m_21120_(pHand));
        }
        return super.m_7203_(pLevel, pPlayer, pHand);
    }

    private boolean isValidHomUnculusStructure(Level level, BlockPos pos) {
        BlockState clickedBlock = level.m_8055_(pos);
        if (!clickedBlock.m_60713_(Blocks.f_50129_)) {
            return false;
        }
        if (level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50129_)) {
            return true;
        }
        return level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50129_);
    }

    private void spawnCreationEffects(ServerLevel level, BlockPos pos) {
        double z;
        double y;
        double x;
        int i;
        for (i = 0; i < 20; ++i) {
            x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 2.0;
            y = (double)pos.m_123342_() + level.f_46441_.m_188500_() * 2.0;
            z = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 2.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
        for (i = 0; i < 15; ++i) {
            x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 1.5;
            y = (double)pos.m_123342_() + level.f_46441_.m_188500_() * 1.5;
            z = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 1.5;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 1, 0.0, 0.1, 0.0, 0.05);
        }
    }

    private PlayState predicate(AnimationState animationState) {
        animationState.getController().setAnimation(RawAnimation.begin().then("animation.brass_mask.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

