/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item.attachment.impl;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.common.GunModifiers;
import top.ribs.scguns.interfaces.IGunModifier;
import top.ribs.scguns.item.attachment.IAttachment;

@Mod.EventBusSubscriber(modid="scguns", value={Dist.CLIENT})
public abstract class Attachment {
    protected IGunModifier[] modifiers;
    private static final DecimalFormat PERCENTAGE_FORMAT = new DecimalFormat("0.#");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.##");

    Attachment(IGunModifier ... modifiers) {
        this.modifiers = modifiers;
    }

    public IGunModifier[] getModifiers() {
        return this.modifiers;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void addInformationEvent(ItemTooltipEvent event) {
        IAttachment attachment;
        List<Component> enhancedTooltips;
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() instanceof IAttachment && !(enhancedTooltips = Attachment.generateEnhancedTooltips(attachment = (IAttachment)stack.m_41720_())).isEmpty()) {
            event.getToolTip().add(Component.m_237115_((String)"tooltip.scguns.attachment.stats").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}));
            event.getToolTip().addAll(enhancedTooltips);
        }
    }

    private static List<Component> generateEnhancedTooltips(IAttachment<?> attachment) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        IGunModifier[] modifiers = ((Attachment)attachment.getProperties()).getModifiers();
        AttachmentStats stats = Attachment.analyzeAttachmentStats(modifiers);
        Attachment.addDamageTooltips(tooltips, stats);
        Attachment.addAccuracyTooltips(tooltips, stats);
        Attachment.addHandlingTooltips(tooltips, stats);
        Attachment.addSpecialTooltips(tooltips, stats);
        return tooltips;
    }

    private static AttachmentStats analyzeAttachmentStats(IGunModifier[] modifiers) {
        AttachmentStats stats = new AttachmentStats();
        float baseDamage = 10.0f;
        float baseSpread = 2.0f;
        double baseSpeed = 20.0;
        double baseAdsSpeed = 1.0;
        float baseRecoil = 1.0f;
        float baseKick = 1.0f;
        int baseRate = 10;
        double baseReloadSpeed = 1.0;
        int baseAmmoCapacity = 30;
        for (IGunModifier modifier : modifiers) {
            stats.additionalDamage += modifier.additionalDamage();
            baseDamage = modifier.modifyProjectileDamage(baseDamage);
            stats.criticalChance += modifier.criticalChance();
            baseSpread = modifier.modifyProjectileSpread(baseSpread);
            baseSpeed = modifier.modifyProjectileSpeed(baseSpeed);
            baseAdsSpeed = modifier.modifyAimDownSightSpeed(baseAdsSpeed);
            baseRate = modifier.modifyFireRate(baseRate);
            baseReloadSpeed = modifier.modifyReloadSpeed(baseReloadSpeed);
            stats.ammoCapacity = modifier.modifyAmmoCapacity(baseAmmoCapacity);
            if (modifier == GunModifiers.EXTENDED_BARREL_MODIFIER) {
                baseRecoil *= 1.15f;
                baseKick *= 1.2f;
            } else {
                baseRecoil *= modifier.recoilModifier();
                baseKick *= modifier.kickModifier();
            }
            if (!modifier.silencedFire()) continue;
            stats.silenced = true;
        }
        stats.damageMultiplier = (baseDamage - 10.0f) / 10.0f;
        stats.spreadReduction = (2.0f - baseSpread) / 2.0f;
        stats.speedMultiplier = (baseSpeed - 20.0) / 20.0;
        stats.adsSpeedMultiplier = baseAdsSpeed - 1.0;
        stats.recoilReduction = 1.0f - baseRecoil;
        stats.kickReduction = 1.0f - baseKick;
        stats.fireRateChange = (float)(baseRate - 10) / 10.0f;
        stats.reloadSpeedChange = 1.0 - baseReloadSpeed;
        stats.capacityMultiplier = (float)(stats.ammoCapacity - baseAmmoCapacity) / (float)baseAmmoCapacity;
        return stats;
    }

    private static void addDamageTooltips(List<Component> tooltips, AttachmentStats stats) {
        MutableComponent tooltip;
        if (stats.additionalDamage != 0.0f) {
            String damageText = (stats.additionalDamage > 0.0f ? "+" : "") + DECIMAL_FORMAT.format((double)stats.additionalDamage / 2.0);
            tooltip = Component.m_237110_((String)"tooltip.scguns.attachment.damage.additional", (Object[])new Object[]{damageText}).m_130940_(stats.additionalDamage > 0.0f ? ChatFormatting.GREEN : ChatFormatting.RED);
            tooltips.add((Component)tooltip);
        }
        if (Math.abs(stats.damageMultiplier) > 0.001f) {
            String percentText = (stats.damageMultiplier > 0.0f ? "+" : "") + PERCENTAGE_FORMAT.format(stats.damageMultiplier * 100.0f) + "%";
            tooltip = Component.m_237110_((String)"tooltip.scguns.attachment.damage.multiplier", (Object[])new Object[]{percentText}).m_130940_(stats.damageMultiplier > 0.0f ? ChatFormatting.GREEN : ChatFormatting.RED);
            tooltips.add((Component)tooltip);
        }
        if (stats.criticalChance > 0.0f) {
            String critText = "+" + PERCENTAGE_FORMAT.format(stats.criticalChance * 100.0f) + "%";
            tooltip = Component.m_237110_((String)"tooltip.scguns.attachment.critical_chance", (Object[])new Object[]{critText}).m_130940_(ChatFormatting.YELLOW);
            tooltips.add((Component)tooltip);
        }
    }

    private static void addAccuracyTooltips(List<Component> tooltips, AttachmentStats stats) {
        MutableComponent tooltip;
        if (Math.abs(stats.spreadReduction) > 0.001f) {
            String spreadText = (stats.spreadReduction > 0.0f ? "-" : "+") + PERCENTAGE_FORMAT.format(Math.abs(stats.spreadReduction * 100.0f)) + "%";
            tooltip = Component.m_237110_((String)"tooltip.scguns.attachment.spread", (Object[])new Object[]{spreadText}).m_130940_(stats.spreadReduction > 0.0f ? ChatFormatting.GREEN : ChatFormatting.RED);
            tooltips.add((Component)tooltip);
        }
        if (Math.abs(stats.speedMultiplier) > 0.001) {
            String speedText = (stats.speedMultiplier > 0.0 ? "+" : "") + PERCENTAGE_FORMAT.format(stats.speedMultiplier * 100.0) + "%";
            tooltip = Component.m_237110_((String)"tooltip.scguns.attachment.projectile_speed", (Object[])new Object[]{speedText}).m_130940_(stats.speedMultiplier > 0.0 ? ChatFormatting.GREEN : ChatFormatting.RED);
            tooltips.add((Component)tooltip);
        }
    }

    private static void addHandlingTooltips(List<Component> tooltips, AttachmentStats stats) {
        MutableComponent tooltip;
        if (Math.abs(stats.adsSpeedMultiplier) > 0.001) {
            String adsText = (stats.adsSpeedMultiplier > 0.0 ? "+" : "") + PERCENTAGE_FORMAT.format(stats.adsSpeedMultiplier * 100.0) + "%";
            tooltip = Component.m_237110_((String)"tooltip.scguns.attachment.ads_speed", (Object[])new Object[]{adsText}).m_130940_(stats.adsSpeedMultiplier > 0.0 ? ChatFormatting.GREEN : ChatFormatting.RED);
            tooltips.add((Component)tooltip);
        }
        if (Math.abs(stats.recoilReduction) > 0.001f) {
            String recoilText = (stats.recoilReduction > 0.0f ? "-" : "+") + PERCENTAGE_FORMAT.format(Math.abs(stats.recoilReduction * 100.0f)) + "%";
            tooltip = Component.m_237110_((String)"tooltip.scguns.attachment.recoil", (Object[])new Object[]{recoilText}).m_130940_(stats.recoilReduction > 0.0f ? ChatFormatting.GREEN : ChatFormatting.RED);
            tooltips.add((Component)tooltip);
        }
        if (Math.abs(stats.kickReduction) > 0.001f) {
            String kickText = (stats.kickReduction > 0.0f ? "-" : "+") + PERCENTAGE_FORMAT.format(Math.abs(stats.kickReduction * 100.0f)) + "%";
            tooltip = Component.m_237110_((String)"tooltip.scguns.attachment.kick", (Object[])new Object[]{kickText}).m_130940_(stats.kickReduction > 0.0f ? ChatFormatting.GREEN : ChatFormatting.RED);
            tooltips.add((Component)tooltip);
        }
        if (Math.abs(stats.fireRateChange) > 0.001f) {
            String rateText = (stats.fireRateChange > 0.0f ? "+" : "") + PERCENTAGE_FORMAT.format(stats.fireRateChange * 100.0f) + "%";
            tooltip = Component.m_237110_((String)"tooltip.scguns.attachment.fire_rate", (Object[])new Object[]{rateText}).m_130940_(stats.fireRateChange > 0.0f ? ChatFormatting.GREEN : ChatFormatting.RED);
            tooltips.add((Component)tooltip);
        }
        if (Math.abs(stats.reloadSpeedChange) > 0.001) {
            String reloadText = (stats.reloadSpeedChange > 0.0 ? "+" : "") + PERCENTAGE_FORMAT.format(stats.reloadSpeedChange * 100.0) + "%";
            tooltip = Component.m_237110_((String)"tooltip.scguns.attachment.reload_speed", (Object[])new Object[]{reloadText}).m_130940_(stats.reloadSpeedChange > 0.0 ? ChatFormatting.GREEN : ChatFormatting.RED);
            tooltips.add((Component)tooltip);
        }
        if ((double)Math.abs(stats.capacityMultiplier) > 0.001) {
            String capacityText = (stats.capacityMultiplier > 0.0f ? "+" : "") + PERCENTAGE_FORMAT.format(stats.capacityMultiplier * 100.0f) + "%";
            tooltip = Component.m_237110_((String)"tooltip.scguns.attachment.ammo_capacity", (Object[])new Object[]{capacityText}).m_130940_(stats.capacityMultiplier > 0.0f ? ChatFormatting.GREEN : ChatFormatting.RED);
            tooltips.add((Component)tooltip);
        }
    }

    private static void addSpecialTooltips(List<Component> tooltips, AttachmentStats stats) {
        if (stats.silenced) {
            MutableComponent tooltip = Component.m_237115_((String)"tooltip.scguns.attachment.silenced").m_130940_(ChatFormatting.AQUA);
            tooltips.add((Component)tooltip);
        }
    }

    private static class AttachmentStats {
        float additionalDamage = 0.0f;
        float damageMultiplier = 0.0f;
        float criticalChance = 0.0f;
        float spreadReduction = 0.0f;
        double speedMultiplier = 0.0;
        double adsSpeedMultiplier = 0.0;
        float recoilReduction = 0.0f;
        float kickReduction = 0.0f;
        float fireRateChange = 0.0f;
        double reloadSpeedChange = 0.0;
        int ammoCapacity = 30;
        float capacityMultiplier = 0.0f;
        boolean silenced = false;

        private AttachmentStats() {
        }
    }
}

