/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import java.util.Collection;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import top.ribs.scguns.common.GripType;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.enchantment.CorrodedEnchantment;
import top.ribs.scguns.init.ModEnchantments;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.item.BayonetItem;
import top.ribs.scguns.item.GunItem;

public class C2SMessageOffhandMelee
extends PlayMessage<C2SMessageOffhandMelee> {
    private int targetId;
    private float x;
    private float y;
    private float z;
    private static final float OFFHAND_DAMAGE_MULTIPLIER = 0.65f;
    private static final float OFFHAND_COOLDOWN_MULTIPLIER = 1.25f;

    public C2SMessageOffhandMelee() {
    }

    public C2SMessageOffhandMelee(int targetId, float x, float y, float z) {
        this.targetId = targetId;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void encode(C2SMessageOffhandMelee message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.targetId);
        buffer.writeFloat(message.x);
        buffer.writeFloat(message.y);
        buffer.writeFloat(message.z);
    }

    public C2SMessageOffhandMelee decode(FriendlyByteBuf buffer) {
        return new C2SMessageOffhandMelee(buffer.readInt(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    public void handle(C2SMessageOffhandMelee message, MessageContext context) {
        context.execute(() -> {
            ServerPlayer player = context.getPlayer();
            if (player == null || player.m_5833_()) {
                return;
            }
            ItemStack mainHand = player.m_21205_();
            ItemStack offHand = player.m_21206_();
            Item patt2063$temp = mainHand.m_41720_();
            if (!(patt2063$temp instanceof GunItem)) {
                return;
            }
            GunItem gunItem = (GunItem)patt2063$temp;
            Gun gun = gunItem.getModifiedGun(mainHand);
            GripType gripType = gun.getGeneral().getGripType(mainHand);
            if (gripType != GripType.ONE_HANDED) {
                return;
            }
            if (!(offHand.m_41720_() instanceof SwordItem) && !(offHand.m_41720_() instanceof BayonetItem)) {
                return;
            }
            float attackStrength = player.m_36403_(0.5f);
            if (attackStrength < 0.95f) {
                return;
            }
            player.m_21011_(InteractionHand.OFF_HAND, true);
            float attackSpeed = this.getWeaponAttackSpeed(offHand);
            player.m_36334_();
            float cooldownTicks = 20.0f / attackSpeed * 1.25f;
            player.m_36335_().m_41524_(offHand.m_41720_(), (int)cooldownTicks);
            if (message.targetId == -1) {
                return;
            }
            Entity target = player.m_9236_().m_6815_(message.targetId);
            if (target == null) {
                return;
            }
            double distance = player.m_20270_(target);
            if (distance > 6.0) {
                return;
            }
            this.performOffhandMeleeAttack(player, target, offHand, attackStrength);
        });
        context.setHandled(true);
    }

    private void performOffhandMeleeAttack(ServerPlayer player, Entity target, ItemStack weapon, float attackStrength) {
        DamageSource damageSource;
        boolean damaged;
        boolean isCritical;
        float baseDamage = this.getWeaponDamage(weapon) * 0.65f;
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            baseDamage += EnchantmentHelper.m_44833_((ItemStack)weapon, (MobType)livingTarget.m_6336_());
            int corrodedLevel = weapon.getEnchantmentLevel((Enchantment)ModEnchantments.CORRODED.get());
            if (corrodedLevel > 0 && this.isBotEntity(livingTarget)) {
                baseDamage += CorrodedEnchantment.getBotDamageBonus(corrodedLevel);
            }
        }
        float damage = baseDamage * (0.2f + attackStrength * attackStrength * 0.8f);
        boolean bl = isCritical = player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && !player.m_20159_();
        if (isCritical) {
            damage *= 1.3f;
        }
        if (damaged = target.m_6469_(damageSource = player.m_269291_().m_269075_((Player)player), damage)) {
            if (target instanceof LivingEntity) {
                int corrodedLevel;
                float sweepingLevel;
                LivingEntity livingTarget = (LivingEntity)target;
                float knockback = 0.25f;
                int knockbackLevel = EnchantmentHelper.m_44894_((LivingEntity)player);
                if (knockbackLevel > 0) {
                    knockback += (float)knockbackLevel * 0.4f;
                }
                livingTarget.m_147240_((double)knockback, Math.sin((double)player.m_146908_() * Math.PI / 180.0), -Math.cos((double)player.m_146908_() * Math.PI / 180.0));
                int fireAspectLevel = EnchantmentHelper.m_44914_((LivingEntity)player);
                if (fireAspectLevel > 0) {
                    livingTarget.m_20254_(fireAspectLevel * 4);
                }
                if ((sweepingLevel = EnchantmentHelper.m_44821_((LivingEntity)player)) > 0.0f && weapon.m_41720_() instanceof SwordItem) {
                    this.applySweepingDamage(player, target, weapon, sweepingLevel, damage * 0.25f);
                }
                if ((corrodedLevel = weapon.getEnchantmentLevel((Enchantment)ModEnchantments.CORRODED.get())) > 0) {
                    this.applyCorrodedEffects(player, livingTarget, weapon, corrodedLevel);
                }
                this.spawnEnchantmentParticles(player, weapon, livingTarget);
            }
            if (weapon.m_41763_()) {
                weapon.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.OFF_HAND));
            }
            SoundEvent soundEvent = isCritical ? SoundEvents.f_12313_ : SoundEvents.f_12316_;
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, SoundSource.PLAYERS, 0.8f, 1.1f);
            if (target instanceof LivingEntity) {
                ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, target.m_20185_(), target.m_20186_() + (double)target.m_20206_() * 0.5, target.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (isCritical && target instanceof LivingEntity) {
                ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, target.m_20185_(), target.m_20186_() + (double)target.m_20206_() * 0.5, target.m_20189_(), 6, 0.15, 0.15, 0.15, 0.0);
            }
        }
    }

    private void applyCorrodedEffects(ServerPlayer player, LivingEntity target, ItemStack weapon, int corrodedLevel) {
        if (this.isBotEntity(target)) {
            this.spawnCorrodedParticles(target, corrodedLevel);
        } else if (player.m_9236_().m_213780_().m_188501_() < 0.3f) {
            int poisonDuration = 60 + corrodedLevel * 20;
            target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, poisonDuration, 0));
        }
    }

    private void spawnCorrodedParticles(LivingEntity entity, int level) {
        Level level2 = entity.m_9236_();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            Random random = new Random();
            for (int i = 0; i < level * 5; ++i) {
                double offsetX = (random.nextDouble() - 0.5) * (double)entity.m_20205_();
                double offsetY = random.nextDouble() * (double)entity.m_20206_();
                double offsetZ = (random.nextDouble() - 0.5) * (double)entity.m_20205_();
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, entity.m_20185_() + offsetX, entity.m_20186_() + offsetY, entity.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    private boolean isBotEntity(LivingEntity entity) {
        return entity.m_6095_().m_204039_(ModTags.Entities.BOT);
    }

    private void spawnEnchantmentParticles(ServerPlayer player, ItemStack weapon, LivingEntity target) {
        int fireAspectLevel;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int sharpnessLevel = weapon.getEnchantmentLevel(Enchantments.f_44977_);
        int smiteLevel = weapon.getEnchantmentLevel(Enchantments.f_44978_);
        int baneLevel = weapon.getEnchantmentLevel(Enchantments.f_44979_);
        boolean hasRelevantEnchantment = false;
        if (smiteLevel > 0 && target.m_6336_() == MobType.f_21641_) {
            hasRelevantEnchantment = true;
        } else if (baneLevel > 0 && target.m_6336_() == MobType.f_21642_) {
            hasRelevantEnchantment = true;
        } else if (sharpnessLevel > 0) {
            hasRelevantEnchantment = true;
        }
        if (hasRelevantEnchantment) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123808_, target.m_20185_(), target.m_20186_() + (double)target.m_20206_() * 0.5, target.m_20189_(), 8, (double)target.m_20205_() * 0.5, (double)target.m_20206_() * 0.25, (double)target.m_20205_() * 0.5, 0.02);
        }
        if ((fireAspectLevel = weapon.getEnchantmentLevel(Enchantments.f_44981_)) > 0) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, target.m_20185_(), target.m_20186_() + (double)target.m_20206_() * 0.5, target.m_20189_(), fireAspectLevel * 2, (double)target.m_20205_() * 0.3, (double)target.m_20206_() * 0.2, (double)target.m_20205_() * 0.3, 0.05);
        }
    }

    private void applySweepingDamage(ServerPlayer player, Entity target, ItemStack weapon, float sweepingLevel, float sweepDamage) {
        double range = 1.0 + (double)sweepingLevel;
        for (LivingEntity entity : player.m_9236_().m_45976_(LivingEntity.class, target.m_20191_().m_82377_(range, 0.25, range))) {
            ArmorStand armorStand;
            if (entity == player || entity == target || player.m_7307_((Entity)entity) || entity instanceof ArmorStand && (armorStand = (ArmorStand)entity).m_31677_() || !(player.m_20280_((Entity)entity) < range * range)) continue;
            entity.m_147240_((double)0.4f, Math.sin((double)player.m_146908_() * Math.PI / 180.0), -Math.cos((double)player.m_146908_() * Math.PI / 180.0));
            entity.m_6469_(player.m_269291_().m_269075_((Player)player), sweepDamage);
        }
    }

    private float getWeaponAttackSpeed(ItemStack weapon) {
        Collection speedModifiers = weapon.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_);
        float attackSpeed = 4.0f;
        for (AttributeModifier modifier : speedModifiers) {
            attackSpeed += (float)modifier.m_22218_();
        }
        return Math.max(0.1f, attackSpeed);
    }

    private float getWeaponDamage(ItemStack weapon) {
        Collection damageModifiers = weapon.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_);
        float damage = 1.0f;
        for (AttributeModifier modifier : damageModifiers) {
            damage += (float)modifier.m_22218_();
        }
        return damage;
    }
}

