/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api;

import com.github.juliarn.npclib.api.Position;
import com.github.juliarn.npclib.api.util.Util;
import org.jetbrains.annotations.NotNull;

final class DefaultPosition
implements Position {
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;
    private final String worldId;

    public DefaultPosition(double x, double y, double z, float yaw, float pitch, @NotNull String worldId) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.worldId = worldId;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double z() {
        return this.z;
    }

    @Override
    public float yaw() {
        return this.yaw;
    }

    @Override
    public float pitch() {
        return this.pitch;
    }

    @Override
    @NotNull
    public String worldId() {
        return this.worldId;
    }

    @Override
    public int blockX() {
        return Util.floor(this.x);
    }

    @Override
    public int blockY() {
        return Util.floor(this.y);
    }

    @Override
    public int blockZ() {
        return Util.floor(this.z);
    }

    @Override
    public int chunkX() {
        return this.blockX() >> 4;
    }

    @Override
    public int chunkY() {
        return this.blockY() >> 8;
    }

    @Override
    public int chunkZ() {
        return this.blockZ() >> 4;
    }
}

