/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api.flag;

import com.github.juliarn.npclib.api.flag.NpcFlag;
import com.github.juliarn.npclib.api.util.Util;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

final class DefaultNpcFlag<T>
implements NpcFlag<T> {
    private final String key;
    private final T defaultValue;
    private final Predicate<T> valueTester;

    public DefaultNpcFlag(@NotNull String key, @Nullable T defaultValue, @NotNull Predicate<T> valueTester) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.valueTester = valueTester;
    }

    @Override
    @NotNull
    public String key() {
        return this.key;
    }

    @Override
    public @UnknownNullability T defaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean accepts(@Nullable T value) {
        return this.valueTester.test(value);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        return Util.equals(NpcFlag.class, this, obj, (orig, comp) -> orig.key().equals(comp.key()));
    }
}

