/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api.protocol.meta;

import com.github.juliarn.npclib.api.protocol.enums.EntityPose;
import com.github.juliarn.npclib.api.protocol.enums.EntityStatus;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadataFactory;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.function.Function;

interface DefaultEntityMetadata {
    public static final EntityMetadataFactory<Collection<EntityStatus>, Byte> ENTITY_STATUS = EntityMetadataFactory.metaFactoryBuilder().baseIndex(0).type((Type)((Object)Byte.class)).inputConverter(entries -> {
        if (entries.isEmpty()) {
            return (byte)0;
        }
        byte entryMask = 0;
        for (EntityStatus entry : entries) {
            entryMask = (byte)(entryMask | entry.bitmask());
        }
        return entryMask;
    }).build();
    public static final EntityMetadataFactory<EntityPose, EntityPose> ENTITY_POSE = EntityMetadataFactory.metaFactoryBuilder().baseIndex(6).type((Type)((Object)EntityPose.class)).inputConverter(Function.identity()).availabilityChecker(versionAccessor -> versionAccessor.atLeast(1, 14, 0)).build();
    public static final EntityMetadataFactory<Boolean, Byte> SNEAKING = EntityMetadataFactory.metaFactoryBuilder().baseIndex(0).type((Type)((Object)Byte.class)).inputConverter(value -> (byte)(value != false ? 2 : 0)).addRelatedMetadata(EntityMetadataFactory.metaFactoryBuilder().baseIndex(6).type((Type)((Object)EntityPose.class)).inputConverter(value -> value != false ? EntityPose.CROUCHING : EntityPose.STANDING).availabilityChecker(versionAccessor -> versionAccessor.atLeast(1, 14, 0)).build()).build();
    public static final EntityMetadataFactory<Boolean, Integer> SHAKING = EntityMetadataFactory.metaFactoryBuilder().baseIndex(7).type((Type)((Object)Integer.class)).inputConverter(value -> value != false ? 250 : 0).availabilityChecker(versionAccessor -> versionAccessor.atLeast(1, 17, 0)).build();
    public static final EntityMetadataFactory<Boolean, Byte> USING_ITEM = EntityMetadataFactory.metaFactoryBuilder().baseIndex(5).type((Type)((Object)Byte.class)).indexShiftVersions(10, 14, 17).inputConverter(value -> (byte)(value != false ? 1 : 0)).availabilityChecker(versionAccessor -> versionAccessor.atLeast(1, 9, 0)).build();
    public static final EntityMetadataFactory<Integer, Integer> ARROW_COUNT = EntityMetadataFactory.metaFactoryBuilder().baseIndex(9).type((Type)((Object)Integer.class)).indexShiftVersions(10, 14, 17).inputConverter(value -> Math.max(0, value)).build();
    public static final EntityMetadataFactory<Boolean, Byte> SKIN_LAYERS = EntityMetadataFactory.metaFactoryBuilder().baseIndex(10).type((Type)((Object)Byte.class)).indexShiftVersions(9, 9, 10, 14, 14, 15, 17).inputConverter(value -> (byte)(value != false ? 255 : 0)).build();
}

