/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api.util;

import java.util.concurrent.Callable;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class Util {
    private Util() {
        throw new UnsupportedOperationException();
    }

    public static int floor(double in) {
        int casted = (int)in;
        return in < (double)casted ? casted - 1 : casted;
    }

    @NotNull
    public static <T> Supplier<T> callableToSupplier(@NotNull Callable<T> callable) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        };
    }

    public static <T> boolean equals(@NotNull Class<T> expectedType, @Nullable Object original, @Nullable Object compare, @NotNull BiPredicate<T, T> checker) {
        if (original == null || compare == null) {
            return original == null && compare == null;
        }
        if (original == compare) {
            return true;
        }
        if (!expectedType.isAssignableFrom(original.getClass()) || !expectedType.isAssignableFrom(compare.getClass())) {
            return false;
        }
        return checker.test(original, compare);
    }
}

