/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.common;

import com.github.juliarn.npclib.api.Npc;
import com.github.juliarn.npclib.api.NpcTracker;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class CommonNpcTracker<W, P, I, E>
implements NpcTracker<W, P, I, E> {
    protected final Set<Npc<W, P, I, E>> trackedNpcs = Collections.synchronizedSet(new HashSet());

    @NotNull
    public static <W, P, I, E> CommonNpcTracker<W, P, I, E> newNpcTracker() {
        return new CommonNpcTracker<W, P, I, E>();
    }

    @Override
    @Nullable
    public Npc<W, P, I, E> npcById(int entityId) {
        for (Npc<W, P, I, E> trackedNpc : this.trackedNpcs) {
            if (trackedNpc.entityId() != entityId) continue;
            return trackedNpc;
        }
        return null;
    }

    @Override
    @Nullable
    public Npc<W, P, I, E> npcByUniqueId(@NotNull UUID uniqueId) {
        for (Npc<W, P, I, E> trackedNpc : this.trackedNpcs) {
            if (!trackedNpc.profile().uniqueId().equals(uniqueId)) continue;
            return trackedNpc;
        }
        return null;
    }

    @Override
    public void trackNpc(@NotNull Npc<W, P, I, E> npc) {
        this.trackedNpcs.add(npc);
    }

    @Override
    public void stopTrackingNpc(@NotNull Npc<W, P, I, E> npc) {
        this.trackedNpcs.remove(npc);
    }

    @Override
    public @UnmodifiableView @NotNull Collection<Npc<W, P, I, E>> trackedNpcs() {
        return Collections.unmodifiableCollection(this.trackedNpcs);
    }
}

