/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.fabric;

import com.github.juliarn.npclib.api.PlatformVersionAccessor;
import net.minecraft.class_155;
import org.jetbrains.annotations.NotNull;

public final class FabricVersionAccessor {
    private static int[] extractServerVersionParts() {
        String[] parts = class_155.method_16673().comp_4025().split("\\.");
        if (parts.length == 2 || parts.length == 3) {
            try {
                int major = Integer.parseInt(parts[0]);
                int minor = Integer.parseInt(parts[1]);
                int patch = parts.length == 3 ? Integer.parseInt(parts[2]) : 0;
                return new int[]{major, minor, patch};
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new int[0];
    }

    @NotNull
    public static PlatformVersionAccessor versionNameBased() {
        return FabricVersionNameAccessor.INSTANCE;
    }

    private static final class FabricVersionNameAccessor
    implements PlatformVersionAccessor {
        private static final int[] VERSION_NUMBER_PARTS = FabricVersionAccessor.extractServerVersionParts();
        private static final FabricVersionNameAccessor INSTANCE = new FabricVersionNameAccessor();

        private FabricVersionNameAccessor() {
        }

        private static int safeGetPart(int index, int def) {
            return VERSION_NUMBER_PARTS.length > index ? VERSION_NUMBER_PARTS[index] : def;
        }

        @Override
        public int major() {
            return FabricVersionNameAccessor.safeGetPart(0, 1);
        }

        @Override
        public int minor() {
            return FabricVersionNameAccessor.safeGetPart(1, 0);
        }

        @Override
        public int patch() {
            return FabricVersionNameAccessor.safeGetPart(2, 0);
        }

        @Override
        public boolean atLeast(int major, int minor, int patch) {
            return this.major() >= major && this.minor() >= major && this.patch() >= patch;
        }
    }
}

