/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.fabric.controller;

import com.github.juliarn.npclib.api.Npc;
import com.github.juliarn.npclib.api.NpcActionController;
import com.github.juliarn.npclib.api.NpcTracker;
import com.github.juliarn.npclib.api.Position;
import com.github.juliarn.npclib.api.event.ShowNpcEvent;
import com.github.juliarn.npclib.api.event.manager.NpcEventManager;
import com.github.juliarn.npclib.api.flag.NpcFlag;
import com.github.juliarn.npclib.api.protocol.enums.EntityAnimation;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadataFactory;
import com.github.juliarn.npclib.common.CommonNpcActionController;
import com.github.juliarn.npclib.common.flag.CommonNpcFlaggedBuilder;
import com.github.juliarn.npclib.fabric.controller.FabricActionControllerEvents;
import com.github.juliarn.npclib.fabric.util.FabricUtil;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FabricActionController
extends CommonNpcActionController {
    private final NpcTracker<class_3218, class_3222, class_1799, Object> npcTracker;
    private final int spawnDistance;
    private final int imitateDistance;

    public FabricActionController(@NotNull Map<NpcFlag<?>, Optional<?>> flags, @NotNull NpcEventManager eventManager, @NotNull NpcTracker<class_3218, class_3222, class_1799, Object> tracker) {
        super(flags);
        this.npcTracker = tracker;
        Integer spawnDistance = (Integer)this.flagValueOrDefault(SPAWN_DISTANCE);
        this.spawnDistance = spawnDistance * spawnDistance;
        Integer imitateDistance = (Integer)this.flagValueOrDefault(IMITATE_DISTANCE);
        this.imitateDistance = imitateDistance * imitateDistance;
        if (this.flagValueOrDefault(NpcActionController.AUTO_SYNC_POSITION_ON_SPAWN).booleanValue()) {
            eventManager.registerEventHandler(ShowNpcEvent.Post.class, event -> {
                class_3222 player = (class_3222)event.player();
                class_243 pos = player.method_73189();
                class_241 rot = player.method_5802();
                class_3218 level = player.method_51469();
                double distance = FabricUtil.distance(event.npc(), pos);
                if (distance <= (double)this.imitateDistance && event.npc().flagValueOrDefault(Npc.LOOK_AT_PLAYER).booleanValue()) {
                    Position playerPos = FabricUtil.positionFromPosAndRot(level, pos, rot);
                    event.npc().lookAt(playerPos).schedule(player);
                }
            });
        }
        FabricActionControllerEvents.SERVER_PLAYER_MOVE.register(this::handleMove);
        FabricActionControllerEvents.SERVER_PLAYER_DISCONNECT.register(this::handleQuit);
        FabricActionControllerEvents.SERVER_PLAYER_TOGGLE_SNEAK.register(this::handleToggleSneak);
        FabricActionControllerEvents.SERVER_PLAYER_HAND_SWING.register(this::handlePlayerHandSwing);
        FabricActionControllerEvents.SERVER_PLAYER_LEVEL_CHANGE.register(this::handleLevelChange);
    }

    @NotNull
    public static NpcActionController.Builder actionControllerBuilder(@NotNull NpcEventManager eventManager, @NotNull NpcTracker<class_3218, class_3222, class_1799, Object> npcTracker) {
        Objects.requireNonNull(eventManager, "eventManager");
        Objects.requireNonNull(npcTracker, "npcTracker");
        return new FabricActionControllerBuilder(eventManager, npcTracker);
    }

    private void handleMove(@NotNull class_3222 player, @Nullable class_243 pos, @Nullable class_241 rot) {
        for (Npc<class_3218, class_3222, class_1799, Object> npc : this.npcTracker.trackedNpcs()) {
            Position npcPos = npc.position();
            class_3218 level = player.method_51469();
            if (!npc.world().equals(level) || !npc.world().method_8393(npcPos.chunkX(), npcPos.chunkZ())) {
                npc.stopTrackingPlayer(player);
                continue;
            }
            class_243 playerPos = Objects.requireNonNullElse(pos, player.method_73189());
            double distance = FabricUtil.distance(npc, playerPos);
            if (distance > (double)this.spawnDistance) {
                npc.stopTrackingPlayer(player);
                continue;
            }
            npc.trackPlayer(player);
            if (rot == null || !npc.tracksPlayer(player) || !(distance <= (double)this.imitateDistance) || !npc.flagValueOrDefault(Npc.LOOK_AT_PLAYER).booleanValue()) continue;
            Position playerPosition = FabricUtil.positionFromPosAndRot(level, playerPos, rot);
            npc.lookAt(playerPosition).schedule(player);
        }
    }

    private void handleLevelChange(@NotNull class_3222 player, @Nullable class_3218 oldLevel, @NotNull class_3218 newLevel) {
        for (Npc<class_3218, class_3222, class_1799, Object> npc : this.npcTracker.trackedNpcs()) {
            if (!npc.world().equals(player.method_51469())) {
                npc.stopTrackingPlayer(player);
                continue;
            }
            double distance = FabricUtil.distance(npc, player.method_73189());
            if (!((double)this.spawnDistance >= distance)) continue;
            npc.trackPlayer(player);
        }
    }

    private void handleToggleSneak(@NotNull class_3222 player, boolean sneaking) {
        for (Npc<class_3218, class_3222, class_1799, Object> npc : this.npcTracker.trackedNpcs()) {
            double distance = FabricUtil.distance(npc, player.method_73189());
            if (!npc.world().equals(player.method_51469()) || !npc.tracksPlayer(player) || !(distance <= (double)this.imitateDistance) || !npc.flagValueOrDefault(Npc.SNEAK_WHEN_PLAYER_SNEAKS).booleanValue()) continue;
            npc.platform().packetFactory().createEntityMetaPacket(EntityMetadataFactory.sneakingMetaFactory(), sneaking).schedule(player, npc);
        }
    }

    private void handlePlayerHandSwing(@NotNull class_3222 player) {
        for (Npc<class_3218, class_3222, class_1799, Object> npc : this.npcTracker.trackedNpcs()) {
            double distance = FabricUtil.distance(npc, player.method_73189());
            if (!npc.world().equals(player.method_51469()) || !npc.tracksPlayer(player) || !(distance <= (double)this.imitateDistance) || !npc.flagValueOrDefault(Npc.HIT_WHEN_PLAYER_HITS).booleanValue()) continue;
            npc.platform().packetFactory().createAnimationPacket(EntityAnimation.SWING_MAIN_ARM).schedule(player, npc);
        }
    }

    private void handleQuit(@NotNull class_3222 player) {
        for (Npc<class_3218, class_3222, class_1799, Object> npc : this.npcTracker.trackedNpcs()) {
            npc.stopTrackingPlayer(player);
        }
    }

    private static final class FabricActionControllerBuilder
    extends CommonNpcFlaggedBuilder<NpcActionController.Builder>
    implements NpcActionController.Builder {
        private final NpcEventManager eventManager;
        private final NpcTracker<class_3218, class_3222, class_1799, Object> npcTracker;

        public FabricActionControllerBuilder(@NotNull NpcEventManager eventManager, @NotNull NpcTracker<class_3218, class_3222, class_1799, Object> npcTracker) {
            this.eventManager = eventManager;
            this.npcTracker = npcTracker;
        }

        @Override
        @NotNull
        public NpcActionController build() {
            return new FabricActionController(this.flags, this.eventManager, this.npcTracker);
        }
    }
}

